/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.association;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import javax.swing.JOptionPane;
import net.maizegenetics.analysis.association.CompressedDoubleMatrix;
import net.maizegenetics.analysis.association.MLMPlugin;
import net.maizegenetics.analysis.data.ExportPlugin;
import net.maizegenetics.dna.snp.GeneticMap;
import net.maizegenetics.matrixalgebra.Matrix.DoubleMatrix;
import net.maizegenetics.matrixalgebra.Matrix.DoubleMatrixFactory;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.stats.EMMA.EMMAforDoubleMatrix;
import net.maizegenetics.stats.linearmodels.FactorModelEffect;
import net.maizegenetics.stats.linearmodels.LinearModelUtils;
import net.maizegenetics.stats.linearmodels.ModelEffectUtils;
import net.maizegenetics.stats.linearmodels.SweepFast;
import net.maizegenetics.stats.linearmodels.SymmetricMatrixInverterDM;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListBuilder;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.taxa.distance.DistanceMatrix;
import net.maizegenetics.taxa.tree.UPGMATree;
import net.maizegenetics.trait.MarkerPhenotype;
import net.maizegenetics.trait.MarkerPhenotypeAdapter;
import net.maizegenetics.trait.MarkerPhenotypeAdapterUtils;
import net.maizegenetics.trait.Phenotype;
import net.maizegenetics.trait.SimplePhenotype;
import net.maizegenetics.trait.Trait;
import net.maizegenetics.util.SimpleTableReport;
import org.apache.log4j.Logger;

public class CompressedMLMusingDoubleMatrix {
    private static final Logger myLogger = Logger.getLogger(CompressedMLMusingDoubleMatrix.class);
    private final boolean useCompression;
    private final boolean useP3D;
    private final double compression;
    private boolean outputResiduals = true;
    private final MarkerPhenotypeAdapter theAdapter;
    private final MLMPlugin parentPlugin;
    private final DistanceMatrix kinshipMatrix;
    private double resvar;
    private double genvar;
    private double lnlk;
    private boolean testMarkers = true;
    private final ArrayList<Object[]> compressionResults = new ArrayList();
    private final ArrayList<Object[]> resultsMain = new ArrayList();
    private final ArrayList<Object[]> resultsAlleles = new ArrayList();
    private final ArrayList<Object[]> resultsBlups = new ArrayList();
    private boolean[] prevMissing = null;
    private SymmetricMatrixInverterDM Vminus = null;
    private String datasetName;
    private final String[] headerMain;
    private final String[] headerAlleles;
    private final String[] headerBlups = new String[0];
    private final String[] headerCompression = new String[]{"Trait", "# groups", "Compression", "-2LnLk", "Var_genetic", "Var_error"};
    private GeneticMap myGeneticMap;

    public CompressedMLMusingDoubleMatrix(MLMPlugin parentPlugin, Datum dataset, DistanceMatrix kinshipMatrix, boolean useCompression, boolean useP3D, double compression, GeneticMap map) {
        this.parentPlugin = parentPlugin;
        this.theAdapter = dataset.getData().getClass().equals(MarkerPhenotype.class) ? new MarkerPhenotypeAdapter((MarkerPhenotype)dataset.getData()) : (dataset.getData() instanceof Phenotype ? new MarkerPhenotypeAdapter((Phenotype)dataset.getData()) : null);
        this.kinshipMatrix = kinshipMatrix;
        this.useCompression = useCompression;
        this.useP3D = useP3D;
        this.compression = compression;
        this.datasetName = dataset.getName();
        this.myGeneticMap = map;
        if (this.myGeneticMap == null) {
            this.headerMain = new String[]{"Trait", "Marker", "Locus", "Site", "df", "F", "p", "errordf", "markerR2", "Genetic Var", "Residual Var", "-2LnLikelihood"};
            this.headerAlleles = new String[]{"Trait", "Marker", "Locus", "Site", "Allele", "Effect", "Obs"};
        } else {
            this.headerMain = new String[]{"Trait", "Marker", "Chr", "Pos", "Locus", "Site", "df", "F", "p", "errordf", "markerR2", "Genetic Var", "Residual Var", "-2LnLikelihood"};
            this.headerAlleles = new String[]{"Trait", "Marker", "Chr", "Pos", "Locus", "Site", "Allele", "Effect", "Obs"};
        }
    }

    public List<Datum> solve() {
        LinkedList<Datum> results = new LinkedList<Datum>();
        int numberOfMarkers = this.theAdapter.getNumberOfMarkers();
        int numberOfPhenotypes = this.theAdapter.getNumberOfPhenotypes();
        int expectedIterations = numberOfPhenotypes * numberOfMarkers;
        int iterationsSofar = 0;
        BufferedWriter mainOutputWriter = null;
        BufferedWriter alleleOutputWriter = null;
        Object blupOutputWriter = null;
        if (this.parentPlugin.isWriteOutputToFile()) {
            String outputbase = this.parentPlugin.getOutputName();
            if (outputbase.endsWith(".txt")) {
                int index = outputbase.lastIndexOf(".");
                outputbase = outputbase.substring(0, index);
            }
            String datasetNameNoSpace = this.datasetName.trim().replaceAll("\\ ", "_");
            File mainFile = new File(outputbase + "_" + datasetNameNoSpace + "_stats.txt");
            File alleleFile = new File(outputbase + "_" + datasetNameNoSpace + "_effects.txt");
            File blupFile = new File(outputbase + "_" + datasetNameNoSpace + "_blups.txt");
            try {
                mainOutputWriter = new BufferedWriter(new FileWriter(mainFile));
                mainOutputWriter.write(this.getTabbedStringFromArray(this.headerMain));
                mainOutputWriter.newLine();
                alleleOutputWriter = new BufferedWriter(new FileWriter(alleleFile));
                alleleOutputWriter.write(this.getTabbedStringFromArray(this.headerAlleles));
                alleleOutputWriter.newLine();
            }
            catch (IOException e) {
                myLogger.error((Object)"Failed to open file for output.");
                myLogger.error((Object)e);
                return null;
            }
        }
        for (int ph = 0; ph < numberOfPhenotypes; ++ph) {
            double[] phenotypeData = this.theAdapter.getPhenotypeValues(ph);
            Taxon[] theTaxa = this.theAdapter.getTaxa(ph);
            boolean[] missing = this.theAdapter.getMissingPhenotypes(ph);
            ArrayList<String[]> factorList = MarkerPhenotypeAdapterUtils.getFactorList(this.theAdapter, ph, missing);
            ArrayList<double[]> covariateList = MarkerPhenotypeAdapterUtils.getCovariateList(this.theAdapter, ph, missing);
            TaxaList nonmissingIds = this.updateMissingWithKinship(missing, theTaxa);
            DistanceMatrix kin = new DistanceMatrix(this.kinshipMatrix, nonmissingIds);
            int totalObs = missing.length;
            int nonMissingObs = 0;
            for (boolean m : missing) {
                if (m) continue;
                ++nonMissingObs;
            }
            int count = 0;
            DoubleMatrix y = DoubleMatrixFactory.DEFAULT.make(nonMissingObs, 1);
            Taxon[] nonmissingTaxa = new Taxon[nonMissingObs];
            for (int i = 0; i < totalObs; ++i) {
                if (missing[i]) continue;
                y.set(count, 0, phenotypeData[i]);
                nonmissingTaxa[count] = theTaxa[i];
                ++count;
            }
            count = 0;
            DoubleMatrix Z = DoubleMatrixFactory.DEFAULT.make(nonMissingObs, kin.numberOfTaxa());
            for (int i = 0; i < totalObs; ++i) {
                if (missing[i]) continue;
                Z.set(count++, kin.whichIdNumber(theTaxa[i]), 1.0);
            }
            DoubleMatrix fixed = LinearModelUtils.createFixedEffectsArray(factorList, covariateList, missing);
            DoubleMatrix[] zk = this.computeZKZ(y, fixed, Z, kin, this.theAdapter.getPhenotypeName(ph));
            EMMAforDoubleMatrix emlm = new EMMAforDoubleMatrix(y, fixed, zk[1], zk[0], 0, Double.NaN);
            emlm.solve();
            this.genvar = emlm.getVarRan();
            this.resvar = emlm.getVarRes();
            this.lnlk = emlm.getLnLikelihood();
            int baseModeldf = emlm.getDfModel();
            if (this.outputResiduals) {
                Datum residuals = this.createResPhenotype(emlm, nonmissingIds, new Trait(this.theAdapter.getPhenotypeName(ph), false, "data"));
                results.add(residuals);
                if (this.parentPlugin.isWriteOutputToFile()) {
                    ExportPlugin exporter = new ExportPlugin(null, false);
                    String outfile = this.parentPlugin.getOutputName() + "_" + residuals.getName() + "_residuals.txt";
                    exporter.setSaveFile(outfile);
                    exporter.performFunction(new DataSet(residuals, (Plugin)this.parentPlugin));
                }
            }
            Object[] tableRow = this.myGeneticMap != null ? new Object[]{this.theAdapter.getPhenotypeName(ph), "None", "", "", "", "", new Integer(0), new Double(Double.NaN), new Double(Double.NaN), new Double(nonMissingObs - baseModeldf), new Double(Double.NaN), new Double(this.genvar), new Double(this.resvar), new Double(-2.0 * this.lnlk)} : new Object[]{this.theAdapter.getPhenotypeName(ph), "None", "", "", new Integer(0), new Double(Double.NaN), new Double(Double.NaN), new Double(nonMissingObs - baseModeldf), new Double(Double.NaN), new Double(this.genvar), new Double(this.resvar), new Double(-2.0 * this.lnlk)};
            if (this.parentPlugin.isWriteOutputToFile()) {
                if (!this.writeObjectToFile(mainOutputWriter, tableRow)) {
                    return null;
                }
            } else {
                this.resultsMain.add(tableRow);
            }
            if (this.useP3D) {
                DoubleMatrix ZKZ = zk[0].mult(zk[1]).tcrossproduct(zk[0]);
                this.Vminus = new SymmetricMatrixInverterDM(this.calculateV(ZKZ, this.genvar, this.resvar));
            }
            if (!this.testMarkers) continue;
            for (int m = 0; m < numberOfMarkers; ++m) {
                int markerdf;
                int nAlleles;
                DoubleMatrix X;
                int i;
                int n;
                Object[] markerData = this.theAdapter.getMarkerValue(ph, m);
                boolean[] missingMarkers = this.theAdapter.getMissingMarkers(ph, m);
                boolean[] finalMissing = new boolean[missing.length];
                System.arraycopy(missing, 0, finalMissing, 0, missing.length);
                MarkerPhenotypeAdapterUtils.updateMissing(finalMissing, missingMarkers);
                boolean[] additionalMissing = new boolean[nonMissingObs];
                int missingCount = 0;
                for (int i2 = 0; i2 < totalObs; ++i2) {
                    if (missing[i2]) continue;
                    additionalMissing[missingCount] = finalMissing[i2];
                    ++missingCount;
                }
                int numberOfRowsKept = 0;
                for (boolean miss : additionalMissing) {
                    if (miss) continue;
                    ++numberOfRowsKept;
                }
                int[] keepIndex = new int[numberOfRowsKept];
                count = 0;
                for (int i3 = 0; i3 < nonMissingObs; ++i3) {
                    if (additionalMissing[i3]) continue;
                    keepIndex[count++] = i3;
                }
                DoubleMatrix ymarker = y.getSelection(keepIndex, null);
                count = 0;
                for (int i4 = 0; i4 < totalObs; ++i4) {
                    if (finalMissing[i4]) continue;
                    ymarker.set(count++, 0, phenotypeData[i4]);
                }
                DoubleMatrix fixed2 = fixed.getSelection(keepIndex, null);
                ArrayList markerIds = new ArrayList();
                boolean markerIsDiscrete = this.theAdapter.isMarkerDiscrete(m);
                int[] alleleCounts = null;
                if (markerIsDiscrete) {
                    Object[] finalMarkerData = new Object[numberOfRowsKept];
                    count = 0;
                    n = markerData.length;
                    for (i = 0; i < n; ++i) {
                        if (finalMissing[i]) continue;
                        finalMarkerData[count++] = markerData[i];
                    }
                    FactorModelEffect markerEffect = new FactorModelEffect(ModelEffectUtils.getIntegerLevels(finalMarkerData, markerIds), true);
                    X = fixed2.concatenate(markerEffect.getX(), false);
                    nAlleles = markerEffect.getNumberOfLevels();
                    alleleCounts = markerEffect.getLevelCounts();
                    markerdf = nAlleles - 1;
                } else {
                    double[] finalMarkerValues = new double[numberOfRowsKept];
                    count = 0;
                    n = markerData.length;
                    for (i = 0; i < n; ++i) {
                        if (finalMissing[i]) continue;
                        finalMarkerValues[count++] = (Double)markerData[i];
                    }
                    X = fixed2.concatenate(DoubleMatrixFactory.DEFAULT.make(numberOfRowsKept, 1, finalMarkerValues), false);
                    nAlleles = 1;
                    alleleCounts = new int[]{numberOfRowsKept};
                    markerdf = 1;
                }
                CompressedMLMResult result = new CompressedMLMResult();
                if (this.useP3D) {
                    this.testMarkerUsingP3D(result, ymarker, X, this.Vminus.getInverse(additionalMissing), markerdf);
                } else {
                    DoubleMatrix Zsel = zk[0].getSelection(keepIndex, null);
                    this.testMarkerUsingEMMA(result, ymarker, X, zk[1], Zsel, nAlleles);
                    markerdf = result.modeldf - baseModeldf;
                }
                boolean recordTheseResults = true;
                if (this.parentPlugin.isFilterOutput() && result.p > this.parentPlugin.getMaxp()) {
                    recordTheseResults = false;
                }
                if (recordTheseResults) {
                    int ndx;
                    String markername = this.theAdapter.getMarkerName(m);
                    String chr = "";
                    String pos = "";
                    String locus = this.theAdapter.getLocusName(m);
                    String site = Integer.toString(this.theAdapter.getLocusPosition(m));
                    if (this.myGeneticMap != null && (ndx = this.myGeneticMap.getMarkerIndex(markername)) >= 0) {
                        chr = this.myGeneticMap.getChromosome(ndx);
                        pos = Double.toString(this.myGeneticMap.getGeneticPosition(ndx));
                    }
                    double errordf = ymarker.numberOfRows() - result.modeldf;
                    tableRow = this.myGeneticMap != null ? new Object[]{this.theAdapter.getPhenotypeName(ph), markername, chr, pos, locus, site, new Integer(markerdf), new Double(result.F), new Double(result.p), new Double(errordf), new Double(result.r2), new Double(this.genvar), new Double(this.resvar), new Double(-2.0 * this.lnlk)} : new Object[]{this.theAdapter.getPhenotypeName(ph), markername, locus, site, new Integer(markerdf), new Double(result.F), new Double(result.p), new Double(errordf), new Double(result.r2), new Double(this.genvar), new Double(this.resvar), new Double(-2.0 * this.lnlk)};
                    if (this.parentPlugin.isWriteOutputToFile()) {
                        if (!this.writeObjectToFile(mainOutputWriter, tableRow)) {
                            return null;
                        }
                    } else {
                        this.resultsMain.add(tableRow);
                    }
                    if (!markerIsDiscrete) {
                        tableRow = this.myGeneticMap != null ? new Object[]{this.theAdapter.getPhenotypeName(ph), markername, chr, pos, locus, site, "", result.beta.get(result.beta.numberOfRows() - 1, 0), numberOfRowsKept} : new Object[]{this.theAdapter.getPhenotypeName(ph), markername, locus, site, "", result.beta.get(result.beta.numberOfRows() - 1, 0), numberOfRowsKept};
                        if (this.parentPlugin.isWriteOutputToFile()) {
                            if (!this.writeObjectToFile(alleleOutputWriter, tableRow)) {
                                return null;
                            }
                        } else {
                            this.resultsAlleles.add(tableRow);
                        }
                    } else if (nAlleles > 1) {
                        for (int a = 0; a < nAlleles; ++a) {
                            Double estimate = a < nAlleles - 1 ? Double.valueOf(result.beta.get(result.beta.numberOfRows() - nAlleles + 1 + a, 0)) : Double.valueOf(0.0);
                            tableRow = this.myGeneticMap != null ? new Object[]{this.theAdapter.getPhenotypeName(ph), markername, chr, pos, locus, site, markerIds.get(a), estimate, alleleCounts[a]} : new Object[]{this.theAdapter.getPhenotypeName(ph), markername, locus, site, markerIds.get(a), estimate, alleleCounts[a]};
                            if (this.parentPlugin.isWriteOutputToFile()) {
                                if (this.writeObjectToFile(alleleOutputWriter, tableRow)) continue;
                                return null;
                            }
                            this.resultsAlleles.add(tableRow);
                        }
                    }
                }
                int progress = (int)((double)(++iterationsSofar) / (double)expectedIterations * 100.0);
                this.parentPlugin.updateProgress(progress);
            }
        }
        this.parentPlugin.updateProgress(0);
        if (this.parentPlugin.isWriteOutputToFile()) {
            try {
                mainOutputWriter.close();
                alleleOutputWriter.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (this.parentPlugin.isWriteOutputToFile()) {
            if (this.useCompression) {
                this.writeCompressionResultsToFile();
            }
            return null;
        }
        results.addAll(this.formatResults());
        return results;
    }

    private String getTabbedStringFromArray(Object[] array) {
        StringBuffer sb = new StringBuffer();
        sb.append(array[0]);
        int n = array.length;
        for (int i = 1; i < n; ++i) {
            sb.append("\t").append(array[i]);
        }
        return sb.toString();
    }

    private boolean writeObjectToFile(BufferedWriter bw, Object[] row) {
        try {
            bw.write(this.getTabbedStringFromArray(row));
            bw.newLine();
        }
        catch (IOException e) {
            String msg = "Unable to write main output to file in MLM. Application ending.";
            myLogger.error((Object)msg);
            e.printStackTrace();
            if (this.parentPlugin.isInteractive()) {
                JOptionPane.showInternalMessageDialog(this.parentPlugin.getParentFrame(), msg, "IO Error", 0);
            }
            return false;
        }
        return true;
    }

    public List<Datum> formatResults() {
        SimpleTableReport str;
        StringBuilder comment;
        String reportName;
        LinkedList<Datum> output = new LinkedList<Datum>();
        StringBuilder options = new StringBuilder();
        options.append("Compression = ").append(this.useCompression);
        options.append("Compression = ").append(this.useCompression);
        if (this.useCompression) {
            options.append(", compression level = ").append(this.compression).append("\n");
        }
        if (this.useP3D) {
            options.append("P3D = ").append(this.useP3D).append(". Variance components were estimated only for the model without any markers.\n");
        } else {
            options.append("P3D = ").append(this.useP3D).append(". Variance components were estimated for each marker.\n");
        }
        StringBuilder model = new StringBuilder();
        model.append("Model: trait = mean + ");
        int nFactors = this.theAdapter.getNumberOfFactors();
        for (int f = 0; f < nFactors; ++f) {
            model.append(this.theAdapter.getFactorName(f)).append(" + ");
        }
        int nCovar = this.theAdapter.getNumberOfCovariates();
        for (int c = 0; c < nCovar; ++c) {
            model.append(this.theAdapter.getCovariateName(c)).append(" + ");
        }
        model.append("marker\n");
        if (this.resultsMain.size() > 0) {
            Object[][] theTable = new Object[this.resultsMain.size()][];
            this.resultsMain.toArray((T[])theTable);
            reportName = "MLM_statistics_for_" + this.datasetName;
            comment = new StringBuilder();
            comment.append("MLM statistics for compressed MLM\n");
            comment.append("Dataset: ").append(this.datasetName).append("\n");
            comment.append((CharSequence)options).append((CharSequence)model);
            str = new SimpleTableReport(reportName, this.headerMain, theTable);
            output.add(new Datum(reportName, str, comment.toString()));
        }
        if (this.resultsAlleles.size() > 0) {
            Object[][] theTable = new Object[this.resultsAlleles.size()][];
            this.resultsAlleles.toArray((T[])theTable);
            reportName = "MLM_effects_for_" + this.datasetName;
            comment = new StringBuilder();
            comment.append("MLM SNP effect estimates\n");
            comment.append("Dataset: ").append(this.datasetName).append("\n");
            comment.append((CharSequence)options).append((CharSequence)model);
            str = new SimpleTableReport(reportName, this.headerAlleles, theTable);
            output.add(new Datum(reportName, str, comment.toString()));
        }
        if (this.resultsBlups.size() > 0) {
            Object[][] theTable = new Object[this.resultsBlups.size()][];
            this.resultsBlups.toArray((T[])theTable);
            reportName = "MLM_BLUPs_for_" + this.datasetName;
            comment = new StringBuilder();
            comment.append("MLM BLUPs\n");
            comment.append("Dataset: ").append(this.datasetName).append("\n");
            comment.append((CharSequence)options).append((CharSequence)model);
            str = new SimpleTableReport(reportName, this.headerBlups, theTable);
            output.add(new Datum(reportName, str, comment.toString()));
        }
        if (this.compressionResults.size() > 0) {
            Object[][] theTable = new Object[this.compressionResults.size()][];
            this.compressionResults.toArray((T[])theTable);
            reportName = "MLM_compression_for_" + this.datasetName;
            comment = new StringBuilder();
            comment.append("MLM compression report\n");
            comment.append("Dataset: ").append(this.datasetName).append("\n");
            comment.append((CharSequence)options).append((CharSequence)model);
            str = new SimpleTableReport(reportName, this.headerCompression, theTable);
            output.add(new Datum(reportName, str, comment.toString()));
        }
        return output;
    }

    public boolean writeCompressionResultsToFile() {
        try {
            String outputbase = this.parentPlugin.getOutputName();
            if (outputbase.endsWith(".txt")) {
                int index = outputbase.lastIndexOf(".");
                outputbase = outputbase.substring(0, index);
            }
            String datasetNameNoSpace = this.datasetName.trim().replaceAll("\\ ", "_");
            BufferedWriter bw = new BufferedWriter(new FileWriter(outputbase + "_" + datasetNameNoSpace + "_compression.txt"));
            bw.write(this.getTabbedStringFromArray(this.headerCompression));
            bw.newLine();
            for (Object[] row : this.compressionResults) {
                bw.write(this.getTabbedStringFromArray(row));
                bw.newLine();
            }
            bw.close();
        }
        catch (IOException e) {
            String msg = "Unable to write compression results to file in MLM.";
            myLogger.error((Object)msg);
            e.printStackTrace();
            if (this.parentPlugin.isInteractive()) {
                JOptionPane.showInternalMessageDialog(this.parentPlugin.getParentFrame(), msg, "IO Error", 0);
            }
            return false;
        }
        return true;
    }

    public DoubleMatrix[] computeZKZ(DoubleMatrix data, DoubleMatrix X, DoubleMatrix Z, DistanceMatrix kin, String traitname) {
        int nkin;
        int nrow;
        DoubleMatrix[] zkMatrices = new DoubleMatrix[2];
        CompressedDoubleMatrix.kinshipMethod kinmethod = CompressedDoubleMatrix.kinshipMethod.avg;
        int ncol = nrow = (nkin = kin.getSize());
        DoubleMatrix K = DoubleMatrixFactory.DEFAULT.make(nrow, ncol);
        for (int r = 0; r < nrow; ++r) {
            for (int c = 0; c < ncol; ++c) {
                K.set(r, c, kin.getDistance(r, c));
            }
        }
        if (!this.useCompression) {
            zkMatrices[0] = Z;
            zkMatrices[1] = K;
        } else if (Double.isNaN(this.compression)) {
            int n = Z.numberOfColumns();
            int count = 0;
            boolean taxaReplicated = false;
            while (count < n && !taxaReplicated) {
                int n2 = count++;
                if (!(Z.columnSum(n2) > 1.5)) continue;
                taxaReplicated = true;
            }
            DistanceMatrix distance = this.calculateDistanceFromKin(kin);
            CompressedDoubleMatrix cm = new CompressedDoubleMatrix(kin, new UPGMATree(distance));
            EMMAforDoubleMatrix emlm = new EMMAforDoubleMatrix(data, X, K, Z, 0, Double.NaN);
            emlm.solve();
            double bestlnlk = emlm.getLnLikelihood();
            int bestCompression = nkin;
            double exponent = 1.0;
            double base = 0.98;
            double maxexponent = Math.log(1.0 / (double)nkin) / Math.log(base);
            this.parentPlugin.updateProgress((int)(exponent * 100.0 / maxexponent));
            int g = nkin;
            while (g > 1 || g == 1 && taxaReplicated) {
                cm.setNumberOfGroups(g);
                DoubleMatrix compressedZ = cm.getCompressedZ(Z);
                DoubleMatrix compressedK = cm.getCompressedMatrix(kinmethod);
                try {
                    emlm = new EMMAforDoubleMatrix(data, X, compressedK, compressedZ, 0, Double.NaN);
                    emlm.solve();
                    this.compressionResults.add(new Object[]{traitname, g, (double)nkin / (double)g, -2.0 * emlm.getLnLikelihood(), emlm.getVarRan(), emlm.getVarRes()});
                    if (Double.isNaN(bestlnlk) || emlm.getLnLikelihood() > bestlnlk) {
                        bestlnlk = emlm.getLnLikelihood();
                        bestCompression = g;
                        this.resvar = emlm.getVarRes();
                        this.genvar = emlm.getVarRan();
                    }
                }
                catch (Exception e) {
                    System.out.println("Compression failed for g = " + g);
                }
                int prev = g;
                while (g == prev) {
                    int prog = (int)((exponent += 1.0) * 100.0 / maxexponent);
                    prog = Math.min(prog, 100);
                    this.parentPlugin.updateProgress(prog);
                    g = (int)((double)nkin * Math.pow(base, exponent));
                }
            }
            if (!taxaReplicated) {
                SweepFast sweep = new SweepFast(X, data);
                sweep.XTXSweepSetDmin();
                n = X.numberOfColumns();
                double ssres = sweep.getResidualSS();
                double errordf = data.numberOfRows() - n;
                double errvar = ssres / errordf;
                double lnlk = errordf * Math.log(Math.PI * 2 * errvar) + errordf;
                this.compressionResults.add(new Object[]{traitname, g, (double)nkin / (double)g, lnlk, new Double(0.0), errvar});
                if (Double.isNaN(bestlnlk) || emlm.getLnLikelihood() > bestlnlk) {
                    bestlnlk = emlm.getLnLikelihood();
                    bestCompression = g;
                    this.resvar = emlm.getVarRes();
                    this.genvar = 0.0;
                }
            }
            cm.setNumberOfGroups(bestCompression);
            zkMatrices[0] = cm.getCompressedZ(Z);
            zkMatrices[1] = cm.getCompressedMatrix(kinmethod);
            this.parentPlugin.updateProgress(0);
        } else {
            DistanceMatrix distance = this.calculateDistanceFromKin(kin);
            CompressedDoubleMatrix cm = new CompressedDoubleMatrix(kin, new UPGMATree(distance));
            int g = (int)Math.round((double)nkin / this.compression);
            cm.setNumberOfGroups(g);
            zkMatrices[0] = cm.getCompressedZ(Z);
            zkMatrices[1] = cm.getCompressedMatrix(kinmethod);
        }
        return zkMatrices;
    }

    public void testMarkerUsingEMMA(CompressedMLMResult result, DoubleMatrix y, DoubleMatrix X, DoubleMatrix K, DoubleMatrix Z, int nAlleles) {
        EMMAforDoubleMatrix emlm = new EMMAforDoubleMatrix(y, X, K, Z, nAlleles, Double.NaN);
        emlm.solve();
        result.beta = emlm.getBeta();
        double[] Fp = emlm.getMarkerFp();
        result.F = Fp[0];
        result.p = Fp[1];
        result.modeldf = emlm.getDfModel();
        this.genvar = emlm.getVarRan();
        this.resvar = emlm.getVarRes();
        this.lnlk = emlm.getLnLikelihood();
        this.calculateRsquare(X, y, emlm.getInvH(), result, nAlleles - 1);
    }

    public void testMarkerUsingP3D(CompressedMLMResult result, DoubleMatrix y, DoubleMatrix X, DoubleMatrix invV, int markerdf) {
        DoubleMatrix invXVX = X.crossproduct(invV).mult(X);
        invXVX.invert();
        result.beta = invXVX.mult(X.crossproduct(invV.mult(y)));
        if (markerdf == 0) {
            result.F = Double.NaN;
            result.p = Double.NaN;
            result.r2 = 0.0;
        } else {
            int nparm = result.beta.numberOfRows();
            DoubleMatrix M = DoubleMatrixFactory.DEFAULT.make(markerdf, nparm, 0.0);
            for (int i = 0; i < markerdf; ++i) {
                M.set(i, nparm - markerdf + i, 1.0);
            }
            DoubleMatrix Mb = M.mult(result.beta);
            DoubleMatrix invMiM = M.mult(invXVX.tcrossproduct(M));
            try {
                invMiM.invert();
                result.F = Mb.crossproduct(invMiM.mult(Mb)).get(0, 0) / (double)markerdf;
            }
            catch (Exception ex) {
                result.F = Double.NaN;
            }
            try {
                result.p = LinearModelUtils.Ftest(result.F, markerdf, y.numberOfRows() - nparm);
            }
            catch (Exception e) {
                result.p = Double.NaN;
            }
            this.calculateRsquare(X, y, invV, result, markerdf);
        }
    }

    private void calculateRsquare(DoubleMatrix X, DoubleMatrix y, DoubleMatrix invV, CompressedMLMResult result, int markerdf) {
        int dimX = X.numberOfColumns();
        int dimXreduced = dimX - markerdf;
        int[] colsToKeep = new int[dimXreduced];
        for (int i = 0; i < dimXreduced; ++i) {
            colsToKeep[i] = i;
        }
        DoubleMatrix Xreduced = X.getSelection(null, colsToKeep);
        DoubleMatrix invXVX = Xreduced.crossproduct(invV).mult(Xreduced);
        invXVX.invert();
        DoubleMatrix betaReduced = invXVX.mult(Xreduced.crossproduct(invV.mult(y)));
        DoubleMatrix yhat = X.mult(result.beta);
        DoubleMatrix yhatReduced = Xreduced.mult(betaReduced);
        yhat.minusEquals(yhatReduced);
        double sum = 0.0;
        int n = y.numberOfRows();
        for (int i = 0; i < n; ++i) {
            sum += y.get(i, 0);
        }
        double mean = sum / (double)n;
        DoubleMatrix ydev = y.scalarAdd(-mean);
        double numerator = yhat.crossproduct(invV).mult(yhat).get(0, 0);
        double denominator = ydev.crossproduct(invV).mult(ydev).get(0, 0);
        result.r2 = numerator / denominator;
    }

    public DoubleMatrix calculateV(DoubleMatrix ZKZ, double genvar, double resvar) {
        DoubleMatrix V = ZKZ.scalarMult(genvar);
        int n = V.numberOfRows();
        for (int i = 0; i < n; ++i) {
            V.set(i, i, V.get(i, i) + resvar);
        }
        return V;
    }

    public DistanceMatrix calculateDistanceFromKin(DistanceMatrix kin) {
        int n = kin.getSize();
        double max = kin.getDistance(0, 0);
        for (int i = 0; i < n; ++i) {
            max = Math.max(max, kin.getDistance(i, i));
        }
        double constant = max > 2.0 ? max : (max > 1.0 ? 2.0 : 1.0);
        DistanceMatrix distanceMatrix = new DistanceMatrix(kin);
        for (int r = 0; r < n; ++r) {
            distanceMatrix.setDistance(r, r, constant - kin.getDistance(r, r));
            for (int c = r + 1; c < n; ++c) {
                double newval = constant - kin.getDistance(r, c);
                distanceMatrix.setDistance(r, c, newval);
                distanceMatrix.setDistance(c, r, newval);
            }
        }
        return distanceMatrix;
    }

    public TaxaList updateMissingWithKinship(boolean[] missing, Taxon[] phenotypeTaxa) {
        int n = missing.length;
        TreeSet<Taxon> kinSet = new TreeSet<Taxon>();
        for (int i = 0; i < n; ++i) {
            TaxaList kinshipTaxa = this.kinshipMatrix.getTaxaList();
            int thisTaxon = kinshipTaxa.indexOf(phenotypeTaxa[i]);
            if (missing[i]) continue;
            if (thisTaxon < 0) {
                missing[i] = true;
                continue;
            }
            kinSet.add(phenotypeTaxa[i]);
        }
        Taxon[] taxa = new Taxon[kinSet.size()];
        kinSet.toArray(taxa);
        return new TaxaListBuilder().addAll(taxa).build();
    }

    public Datum createResPhenotype(EMMAforDoubleMatrix emma, TaxaList taxaIds, Trait trait) {
        String resReportName = "Residuals_for_" + trait.getName() + "_" + this.datasetName;
        String resComments = "Residuals for taxa, trait = " + trait.getName();
        LinkedList<Trait> traits = new LinkedList<Trait>();
        traits.add(trait);
        emma.calculateBlupsPredictedResiduals();
        DoubleMatrix res = emma.getRes();
        int nres = res.numberOfRows();
        double[][] resarray = new double[nres][1];
        for (int i = 0; i < nres; ++i) {
            resarray[i][0] = res.get(i, 0);
        }
        SimplePhenotype resPheno = new SimplePhenotype(taxaIds, traits, resarray);
        String name = String.format("Residuals for %s.", trait.getName());
        String comment = "";
        Datum output = new Datum(name, resPheno, comment);
        return output;
    }

    public void setTestMarkers(boolean testMarkers) {
        this.testMarkers = testMarkers;
    }

    public void setMyGeneticMap(GeneticMap myGeneticMap) {
        this.myGeneticMap = myGeneticMap;
    }

    class CompressedMLMResult {
        DoubleMatrix beta = null;
        double F = Double.NaN;
        double p = Double.NaN;
        double r2 = Double.NaN;
        int modeldf;
        int ngroups;

        CompressedMLMResult() {
        }
    }
}

