/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.association;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import net.maizegenetics.dna.snp.GeneticMap;
import net.maizegenetics.gui.ReportDestinationDialog;
import net.maizegenetics.matrixalgebra.Matrix.DoubleMatrix;
import net.maizegenetics.matrixalgebra.Matrix.DoubleMatrixFactory;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.stats.linearmodels.CovariateModelEffect;
import net.maizegenetics.stats.linearmodels.FactorModelEffect;
import net.maizegenetics.stats.linearmodels.LinearModelUtils;
import net.maizegenetics.stats.linearmodels.ModelEffect;
import net.maizegenetics.stats.linearmodels.ModelEffectUtils;
import net.maizegenetics.stats.linearmodels.SweepFastLinearModel;
import net.maizegenetics.stats.linearmodels.SweepFastNestedModel;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListBuilder;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.trait.MarkerPhenotype;
import net.maizegenetics.trait.MarkerPhenotypeAdapter;
import net.maizegenetics.trait.MarkerPhenotypeAdapterUtils;
import net.maizegenetics.trait.Phenotype;
import net.maizegenetics.trait.SimplePhenotype;
import net.maizegenetics.trait.Trait;
import net.maizegenetics.util.SimpleTableReport;
import org.apache.log4j.Logger;

public class FixedEffectLMPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(FixedEffectLMPlugin.class);
    private GeneticMap myMap;
    private boolean hasMap;
    private boolean writeOutputToFile = false;
    private String outputName = null;
    private boolean filterOutput = false;
    private double maxp = 1.0;
    private boolean reportBLUEs = true;
    private boolean permute = false;
    private int numberOfPermutations = 1000;
    private double[][] minP;
    private boolean reportAdditive;
    private Random randomizer = new Random();

    public FixedEffectLMPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSet performFunction(DataSet input) {
        try {
            List<Datum> maps = input.getDataOfType(GeneticMap.class);
            if (maps.size() > 0) {
                this.myMap = (GeneticMap)maps.get(0).getData();
                this.hasMap = true;
            } else {
                this.myMap = null;
                this.hasMap = false;
            }
            List<Datum> datasets = input.getDataOfType(new Class[]{Phenotype.class, MarkerPhenotype.class});
            if (datasets.size() < 1) {
                String msg = "Error in performFunction: No appropriate dataset selected.";
                myLogger.error((Object)msg);
                if (this.isInteractive()) {
                    JOptionPane.showMessageDialog(this.getParentFrame(), msg, "Error in GLM", 0);
                }
                DataSet dataSet = null;
                return dataSet;
            }
            if (this.isInteractive()) {
                GLMOptionsDialog options = new GLMOptionsDialog(this.getParentFrame());
                this.permute = options.permute();
                this.numberOfPermutations = options.getPermutationNumber();
                options.dispose();
                ReportDestinationDialog rdd = new ReportDestinationDialog();
                rdd.setLocationRelativeTo(this.getParentFrame());
                rdd.setVisible(true);
                if (!rdd.isOkayChecked()) {
                    DataSet dataSet = null;
                    return dataSet;
                }
                this.writeOutputToFile = rdd.wasUseFileChecked();
                if (this.writeOutputToFile) {
                    this.outputName = rdd.getOutputFileName();
                }
                this.filterOutput = rdd.wasRestrictOutputChecked();
                if (this.filterOutput) {
                    this.maxp = rdd.getMaxP();
                }
                rdd.dispose();
            }
            LinkedList<Datum> results = new LinkedList<Datum>();
            for (Datum dataset : datasets) {
                LinkedList<Datum> result;
                block17: {
                    result = null;
                    try {
                        result = this.processDatum(dataset);
                    }
                    catch (Exception e) {
                        myLogger.error((Object)e.toString());
                        e.printStackTrace();
                        if (!this.isInteractive()) break block17;
                        JOptionPane.showMessageDialog(this.getParentFrame(), e.toString(), "Error in GLM", 0);
                    }
                }
                if (result != null) {
                    results.addAll(result);
                }
                this.fireDataSetReturned(new DataSet(result, (Plugin)this));
            }
            DataSet dataSet = new DataSet(results, (Plugin)this);
            return dataSet;
        }
        finally {
            this.fireProgress(100);
        }
    }

    private LinkedList<Datum> processDatum(Datum dataset) {
        int i;
        int i2;
        int i3;
        ArrayList<Object[]> markerTestResults = new ArrayList<Object[]>();
        ArrayList<Object[]> alleleEstimateResults = new ArrayList<Object[]>();
        boolean hasAlleleNames = false;
        String blank = new String("");
        MarkerPhenotypeAdapter theAdapter = dataset.getDataType().equals(MarkerPhenotype.class) ? new MarkerPhenotypeAdapter((MarkerPhenotype)dataset.getData()) : new MarkerPhenotypeAdapter((Phenotype)dataset.getData());
        int numberOfMarkers = theAdapter.getNumberOfMarkers();
        if (numberOfMarkers == 0) {
            return this.calculateBLUEsFromPhenotypes(theAdapter, dataset.getName());
        }
        this.reportAdditive = theAdapter.isMarkerDiscrete(0);
        int numberOfCovariates = theAdapter.getNumberOfCovariates();
        int numberOfFactors = theAdapter.getNumberOfFactors();
        int numberOfPhenotypes = theAdapter.getNumberOfPhenotypes();
        int expectedIterations = numberOfPhenotypes * numberOfMarkers;
        int iterationsSofar = 0;
        int percentFinished = 0;
        File tempFile = null;
        File ftestFile = null;
        File blueFile = null;
        BufferedWriter ftestWriter = null;
        BufferedWriter BLUEWriter = null;
        String ftestHeader = "Trait\tMarker\tLocus\tLocus_pos\tChr\tChr_pos\tmarker_F\tmarker_p\tperm_p\tmarkerR2\tmarkerDF\tmarkerMS\terrorDF\terrorMS\tmodelDF\tmodelMS";
        String ftestAdditiveHeader = ftestHeader + "\tadditive_F\tadditive_p\tadditiveDF\tdom_F\tdom_p\tdomDF";
        String BLUEHeader = "Trait\tMarker\tObs\tLocus\tLocus_pos\tChr\tChr_pos\tAllele\tEstimate";
        if (this.writeOutputToFile) {
            String outputbase = this.outputName;
            if (outputbase.endsWith(".txt")) {
                int index = outputbase.lastIndexOf(".");
                outputbase = outputbase.substring(0, index);
            }
            String datasetNameNoSpace = dataset.getName().trim().replaceAll("\\ ", "_");
            ftestFile = new File(outputbase + "_" + datasetNameNoSpace + "_ftest.txt");
            int count = 0;
            while (ftestFile.exists()) {
                ftestFile = new File(outputbase + "_" + datasetNameNoSpace + "_ftest" + ++count + ".txt");
            }
            blueFile = new File(outputbase + "_" + datasetNameNoSpace + "_BLUEs.txt");
            count = 0;
            while (blueFile.exists()) {
                blueFile = new File(outputbase + "_" + datasetNameNoSpace + "_BLUEs" + ++count + ".txt");
            }
            tempFile = new File(outputbase + "_" + datasetNameNoSpace + "_ftest.tmp");
            try {
                if (this.permute) {
                    ftestWriter = new BufferedWriter(new FileWriter(tempFile));
                    if (this.reportAdditive) {
                        ftestWriter.write(ftestAdditiveHeader);
                    } else {
                        ftestWriter.write(ftestHeader);
                    }
                    ftestWriter.newLine();
                } else {
                    ftestWriter = new BufferedWriter(new FileWriter(ftestFile));
                    if (this.reportAdditive) {
                        ftestWriter.write(ftestAdditiveHeader);
                    } else {
                        ftestWriter.write(ftestHeader);
                    }
                    ftestWriter.newLine();
                }
                if (this.reportBLUEs) {
                    BLUEWriter = new BufferedWriter(new FileWriter(blueFile));
                    BLUEWriter.write(BLUEHeader);
                    BLUEWriter.newLine();
                }
            }
            catch (IOException e) {
                myLogger.error((Object)"Failed to open file for output");
                myLogger.error((Object)e);
                return null;
            }
        }
        if (this.permute) {
            this.minP = new double[numberOfPhenotypes][this.numberOfPermutations];
            for (int i4 = 0; i4 < this.numberOfPermutations; ++i4) {
                for (int j = 0; j < numberOfPhenotypes; ++j) {
                    this.minP[j][i4] = 1.0;
                }
            }
        }
        for (int ph = 0; ph < numberOfPhenotypes; ++ph) {
            double[] phenotypeData = theAdapter.getPhenotypeValues(ph);
            boolean[] missing = theAdapter.getMissingPhenotypes(ph);
            ArrayList<String[]> factorList = MarkerPhenotypeAdapterUtils.getFactorList(theAdapter, ph, missing);
            ArrayList<double[]> covariateList = MarkerPhenotypeAdapterUtils.getCovariateList(theAdapter, ph, missing);
            double[][] permutedData = null;
            if (this.permute) {
                permutedData = this.permuteData(phenotypeData, missing, factorList, covariateList, theAdapter);
            }
            for (int m = 0; m < numberOfMarkers; ++m) {
                int tmpPercent;
                double p;
                double F;
                ModelEffect markerEffect;
                int i5;
                Object[] markerData = theAdapter.getMarkerValue(ph, m);
                boolean[] finalMissing = new boolean[missing.length];
                System.arraycopy(missing, 0, finalMissing, 0, missing.length);
                MarkerPhenotypeAdapterUtils.updateMissing(finalMissing, theAdapter.getMissingMarkers(ph, m));
                int[] nonmissingRows = MarkerPhenotypeAdapterUtils.getNonMissingIndex(finalMissing);
                int numberOfObs = nonmissingRows.length;
                double[] y = new double[numberOfObs];
                for (int i6 = 0; i6 < numberOfObs; ++i6) {
                    y[i6] = phenotypeData[nonmissingRows[i6]];
                }
                int firstMarkerAlleleEstimate = 1;
                ArrayList<ModelEffect> modelEffects = new ArrayList<ModelEffect>();
                ArrayList<ModelEffect> modelAdditiveEffects = new ArrayList<ModelEffect>();
                FactorModelEffect meanEffect = new FactorModelEffect(new int[numberOfObs], false);
                meanEffect.setID("mean");
                modelEffects.add(meanEffect);
                modelAdditiveEffects.add(meanEffect);
                if (numberOfFactors > 0) {
                    for (int f = 0; f < numberOfFactors; ++f) {
                        String[] afactor = factorList.get(f);
                        Object[] factorLabels = new String[numberOfObs];
                        for (int i7 = 0; i7 < numberOfObs; ++i7) {
                            factorLabels[i7] = afactor[nonmissingRows[i7]];
                        }
                        FactorModelEffect fme = new FactorModelEffect(ModelEffectUtils.getIntegerLevels(factorLabels), true, theAdapter.getFactorName(f));
                        modelEffects.add(fme);
                        modelAdditiveEffects.add(fme);
                        firstMarkerAlleleEstimate += fme.getNumberOfLevels() - 1;
                    }
                }
                if (numberOfCovariates > 0) {
                    for (int c = 0; c < numberOfCovariates; ++c) {
                        double[] covar = new double[numberOfObs];
                        double[] covariateData = covariateList.get(c);
                        for (int i8 = 0; i8 < numberOfObs; ++i8) {
                            covar[i8] = covariateData[nonmissingRows[i8]];
                        }
                        modelEffects.add(new CovariateModelEffect(covar, theAdapter.getCovariateName(c)));
                        modelAdditiveEffects.add(new CovariateModelEffect(covar, theAdapter.getCovariateName(c)));
                        ++firstMarkerAlleleEstimate;
                    }
                }
                boolean markerIsDiscrete = theAdapter.isMarkerDiscrete(m);
                ArrayList alleleNames = new ArrayList();
                if (markerIsDiscrete) {
                    Object[] markers = new Object[numberOfObs];
                    for (i5 = 0; i5 < numberOfObs; ++i5) {
                        markers[i5] = markerData[nonmissingRows[i5]];
                    }
                    int[] markerLevels = ModelEffectUtils.getIntegerLevels(markers, alleleNames);
                    markerEffect = new FactorModelEffect(markerLevels, true, theAdapter.getMarkerName(m));
                    hasAlleleNames = true;
                    String additiveAllele = ((String)markers[0]).substring(0, 1);
                    double[] markerValues = ModelEffectUtils.getNumericCodingForAdditiveModel(markers, additiveAllele);
                    CovariateModelEffect additiveMarkerEffect = new CovariateModelEffect(markerValues, new String[]{theAdapter.getMarkerName(m), additiveAllele});
                    modelAdditiveEffects.add(additiveMarkerEffect);
                } else {
                    double[] markerdbl = new double[numberOfObs];
                    for (i5 = 0; i5 < numberOfObs; ++i5) {
                        markerdbl[i5] = (Double)markerData[nonmissingRows[i5]];
                    }
                    markerEffect = new CovariateModelEffect(markerdbl, theAdapter.getMarkerName(m));
                }
                int[] alleleCounts = markerEffect.getLevelCounts();
                modelEffects.add(markerEffect);
                int markerEffectNumber = modelEffects.size() - 1;
                Object[] taxaSublist = new Taxon[numberOfObs];
                Taxon[] taxa = theAdapter.getTaxa(ph);
                for (int i9 = 0; i9 < numberOfObs; ++i9) {
                    taxaSublist[i9] = taxa[nonmissingRows[i9]];
                }
                boolean areTaxaReplicated = this.containsDuplicates((Taxon[])taxaSublist);
                double[] markerSSdf = null;
                double[] errorSSdf = null;
                double[] modelSSdf = null;
                double[] markerAddSSdf = null;
                double[] errorAddSSdf = null;
                double[] modelAddSSdf = null;
                double[] markerDomSSdf = null;
                double FAdd = Double.NaN;
                double pAdd = Double.NaN;
                double FDom = Double.NaN;
                double pDom = Double.NaN;
                double[] beta = null;
                if (areTaxaReplicated && markerIsDiscrete) {
                    FactorModelEffect taxaEffect = new FactorModelEffect(ModelEffectUtils.getIntegerLevels(taxaSublist), true);
                    modelEffects.add(taxaEffect);
                    SweepFastNestedModel sfnm = new SweepFastNestedModel(modelEffects, y);
                    double[] taxaSSdf = sfnm.getTaxaInMarkerSSdf();
                    markerSSdf = sfnm.getMarkerSSdf();
                    errorSSdf = sfnm.getErrorSSdf();
                    modelSSdf = sfnm.getModelcfmSSdf();
                    F = markerSSdf[0] / markerSSdf[1] / taxaSSdf[0] * taxaSSdf[1];
                    try {
                        p = LinearModelUtils.Ftest(F, markerSSdf[1], taxaSSdf[1]);
                    }
                    catch (Exception e) {
                        p = Double.NaN;
                    }
                    beta = sfnm.getBeta();
                    int markerdf = (int)markerSSdf[1];
                    if (this.permute && markerdf > 0) {
                        this.updatePermutationPValues(ph, permutedData, this.nonMissingIndex(missing, finalMissing), this.getXfromModelEffects(modelEffects), sfnm.getInverseOfXtX(), markerdf);
                    }
                    modelAdditiveEffects.add(taxaEffect);
                    SweepFastNestedModel sfnmAddOnly = new SweepFastNestedModel(modelAdditiveEffects, y);
                    double[] taxaAddSSdf = sfnmAddOnly.getTaxaInMarkerSSdf();
                    markerAddSSdf = sfnmAddOnly.getMarkerSSdf();
                    errorAddSSdf = sfnmAddOnly.getErrorSSdf();
                    modelAddSSdf = sfnmAddOnly.getModelcfmSSdf();
                    FAdd = markerAddSSdf[0] / markerAddSSdf[1] / taxaSSdf[0] * taxaSSdf[1];
                    try {
                        pAdd = LinearModelUtils.Ftest(FAdd, markerAddSSdf[1], taxaSSdf[1]);
                    }
                    catch (Exception e) {
                        pAdd = Double.NaN;
                    }
                    markerDomSSdf = new double[]{errorAddSSdf[0] - errorSSdf[0], errorAddSSdf[1] - errorSSdf[1]};
                    FDom = markerDomSSdf[0] / markerDomSSdf[1] / taxaSSdf[0] * taxaSSdf[1];
                    try {
                        pDom = LinearModelUtils.Ftest(FDom, markerDomSSdf[1], taxaSSdf[1]);
                    }
                    catch (Exception e) {
                        pDom = Double.NaN;
                    }
                } else {
                    SweepFastLinearModel sflm = new SweepFastLinearModel(modelEffects, y);
                    modelSSdf = sflm.getModelcfmSSdf();
                    markerSSdf = sflm.getMarginalSSdf(markerEffectNumber);
                    errorSSdf = sflm.getResidualSSdf();
                    F = markerSSdf[0] / markerSSdf[1] / errorSSdf[0] * errorSSdf[1];
                    try {
                        p = LinearModelUtils.Ftest(F, markerSSdf[1], errorSSdf[1]);
                    }
                    catch (Exception e) {
                        p = Double.NaN;
                    }
                    beta = sflm.getBeta();
                    int markerdf = (int)markerSSdf[1];
                    if (this.permute && markerdf > 0) {
                        this.updatePermutationPValues(ph, permutedData, this.nonMissingIndex(missing, finalMissing), this.getXfromModelEffects(modelEffects), sflm.getInverseOfXtX(), markerdf);
                    }
                    if (this.reportAdditive) {
                        SweepFastNestedModel sfnmAddOnly = new SweepFastNestedModel(modelAdditiveEffects, y);
                        markerAddSSdf = sfnmAddOnly.getMarkerSSdf();
                        errorAddSSdf = sfnmAddOnly.getErrorSSdf();
                        modelAddSSdf = sfnmAddOnly.getModelcfmSSdf();
                        FAdd = markerAddSSdf[0] / markerAddSSdf[1] / errorSSdf[0] * errorSSdf[1];
                        try {
                            pAdd = LinearModelUtils.Ftest(FAdd, markerAddSSdf[1], errorSSdf[1]);
                        }
                        catch (Exception e) {
                            pAdd = Double.NaN;
                        }
                        markerDomSSdf = new double[]{errorAddSSdf[0] - errorSSdf[0], errorAddSSdf[1] - errorSSdf[1]};
                        FDom = markerDomSSdf[0] / markerDomSSdf[1] / errorSSdf[0] * errorSSdf[1];
                        try {
                            pDom = LinearModelUtils.Ftest(FDom, markerDomSSdf[1], errorSSdf[1]);
                        }
                        catch (Exception e) {
                            pDom = Double.NaN;
                        }
                    }
                }
                if (!this.filterOutput || p < this.maxp) {
                    int i10;
                    String marker;
                    String traitname = theAdapter.getPhenotypeName(ph);
                    if (traitname == null) {
                        traitname = blank;
                    }
                    if ((marker = theAdapter.getMarkerName(m)) == null) {
                        marker = blank;
                    }
                    String locus = theAdapter.getLocusName(m);
                    Integer site = new Integer(theAdapter.getLocusPosition(m));
                    String chrname = "";
                    Double chrpos = Double.NaN;
                    if (this.hasMap) {
                        int ndx = -1;
                        ndx = this.myMap.getMarkerIndex(marker);
                        if (ndx > -1) {
                            chrname = this.myMap.getChromosome(ndx);
                            chrpos = this.myMap.getGeneticPosition(ndx);
                        }
                    }
                    Object[] result = this.reportAdditive ? new Object[22] : new Object[16];
                    int col = 0;
                    result[col++] = traitname;
                    result[col++] = marker;
                    result[col++] = locus;
                    result[col++] = site;
                    result[col++] = chrname;
                    result[col++] = chrpos;
                    result[col++] = new Double(F);
                    result[col++] = new Double(p);
                    result[col++] = Double.NaN;
                    result[col++] = new Double(markerSSdf[0] / (modelSSdf[0] + errorSSdf[0]));
                    result[col++] = new Double(markerSSdf[1]);
                    result[col++] = new Double(markerSSdf[0] / markerSSdf[1]);
                    result[col++] = new Double(errorSSdf[1]);
                    result[col++] = new Double(errorSSdf[0] / errorSSdf[1]);
                    result[col++] = new Double(modelSSdf[1]);
                    result[col++] = new Double(modelSSdf[0] / modelSSdf[1]);
                    if (this.reportAdditive) {
                        result[col++] = new Double(FAdd);
                        result[col++] = new Double(pAdd);
                        result[col++] = new Double(markerAddSSdf[1]);
                        result[col++] = new Double(FDom);
                        result[col++] = new Double(pDom);
                        result[col++] = new Double(markerDomSSdf[1]);
                    }
                    if (this.writeOutputToFile) {
                        StringBuilder sb = new StringBuilder();
                        sb.append(result[0]);
                        for (i10 = 1; i10 < 16; ++i10) {
                            sb.append("\t").append(result[i10]);
                        }
                        try {
                            ftestWriter.write(sb.toString());
                            ftestWriter.newLine();
                        }
                        catch (IOException e) {
                            myLogger.error((Object)"Failed to write output to ftest file. Ending prematurely");
                            try {
                                ftestWriter.flush();
                                BLUEWriter.flush();
                            }
                            catch (Exception e1) {
                                // empty catch block
                            }
                            myLogger.error((Object)e);
                            return null;
                        }
                    }
                    markerTestResults.add(result);
                    int numberOfMarkerAlleles = alleleNames.size();
                    if (numberOfMarkerAlleles == 0) {
                        ++numberOfMarkerAlleles;
                    }
                    for (i10 = 0; i10 < numberOfMarkerAlleles; ++i10) {
                        result = new Object[]{traitname, marker, new Integer(alleleCounts[i10]), locus, site, chrname, chrpos, numberOfMarkerAlleles == 1 ? "" : alleleNames.get(i10), i10 == numberOfMarkerAlleles - 1 ? Double.valueOf(0.0) : Double.valueOf(beta[firstMarkerAlleleEstimate + i10])};
                        if (this.writeOutputToFile) {
                            StringBuilder sb = new StringBuilder();
                            sb.append(result[0]);
                            for (int j = 1; j < 9; ++j) {
                                sb.append("\t").append(result[j]);
                            }
                            try {
                                BLUEWriter.write(sb.toString());
                                BLUEWriter.newLine();
                                continue;
                            }
                            catch (IOException e) {
                                myLogger.error((Object)"Failed to write output to ftest file. Ending prematurely");
                                try {
                                    ftestWriter.flush();
                                    BLUEWriter.flush();
                                }
                                catch (Exception e1) {
                                    // empty catch block
                                }
                                myLogger.error((Object)e);
                                return null;
                            }
                        }
                        alleleEstimateResults.add(result);
                    }
                }
                if ((tmpPercent = ++iterationsSofar * 100 / expectedIterations) <= percentFinished) continue;
                percentFinished = tmpPercent;
                this.fireProgress(percentFinished);
            }
        }
        this.fireProgress(0);
        if (this.writeOutputToFile) {
            try {
                ftestWriter.close();
                BLUEWriter.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        HashMap<String, Integer> traitnameMap = new HashMap<String, Integer>();
        if (this.permute) {
            for (int ph = 0; ph < numberOfPhenotypes; ++ph) {
                Arrays.sort(this.minP[ph]);
                traitnameMap.put(theAdapter.getPhenotypeName(ph), ph);
            }
            if (this.writeOutputToFile) {
                try {
                    String input;
                    BufferedReader tempReader = new BufferedReader(new FileReader(tempFile));
                    ftestWriter = new BufferedWriter(new FileWriter(ftestFile));
                    ftestWriter.write(tempReader.readLine());
                    ftestWriter.newLine();
                    Pattern tab = Pattern.compile("\t");
                    while ((input = tempReader.readLine()) != null) {
                        String[] data = tab.split(input);
                        String trait = data[0];
                        double pval = Double.parseDouble(data[7]);
                        int ph = (Integer)traitnameMap.get(trait);
                        int ndx = Arrays.binarySearch(this.minP[ph], pval);
                        if (ndx < 0) {
                            ndx = -ndx - 1;
                        }
                        if (ndx == 0) {
                            ndx = 1;
                        }
                        data[8] = Double.toString((double)ndx / (double)this.numberOfPermutations);
                        ftestWriter.write(data[0]);
                        for (int i11 = 1; i11 < data.length; ++i11) {
                            ftestWriter.write("\t");
                            ftestWriter.write(data[i11]);
                        }
                        ftestWriter.newLine();
                    }
                    tempReader.close();
                    ftestWriter.close();
                    tempFile.delete();
                }
                catch (IOException e) {
                    myLogger.error((Object)e);
                }
            } else {
                for (Object[] result : markerTestResults) {
                    String trait = result[0].toString();
                    double pval = (Double)result[7];
                    int ph = (Integer)traitnameMap.get(trait);
                    int ndx = Arrays.binarySearch(this.minP[ph], pval);
                    if (ndx < 0) {
                        ndx = -ndx - 1;
                    }
                    if (ndx == 0) {
                        ndx = 1;
                    }
                    result[8] = new Double((double)ndx / (double)this.numberOfPermutations);
                }
            }
        }
        String[] columnLabels = new String[]{"Trait", "Marker", "Locus", "Locus_pos", "Chr", "Chr_pos", "marker_F", "marker_p", "perm_p", "markerR2", "markerDF", "markerMS", "errorDF", "errorMS", "modelDF", "modelMS", "add_F", "add_p", "addDF", "dom_F", "dom_p", "domDF"};
        boolean hasMarkerNames = theAdapter.hasMarkerNames();
        LinkedList<Integer> outputList = new LinkedList<Integer>();
        outputList.add(0);
        if (hasMarkerNames) {
            outputList.add(1);
        }
        outputList.add(2);
        outputList.add(3);
        if (this.hasMap) {
            outputList.add(4);
            outputList.add(5);
        }
        outputList.add(6);
        outputList.add(7);
        if (this.permute) {
            outputList.add(8);
        }
        for (i3 = 9; i3 < 16; ++i3) {
            outputList.add(i3);
        }
        if (this.reportAdditive) {
            for (i3 = 16; i3 < 22; ++i3) {
                outputList.add(i3);
            }
        }
        LinkedList<Datum> resultset = new LinkedList<Datum>();
        int nrows = markerTestResults.size();
        Object[][] table = new Object[nrows][];
        int numberOfColumns = outputList.size();
        Object[] colnames = new String[numberOfColumns];
        int count = 0;
        for (Integer ndx : outputList) {
            colnames[count++] = columnLabels[ndx];
        }
        for (int i12 = 0; i12 < nrows; ++i12) {
            table[i12] = new Object[numberOfColumns];
            Object[] result = (Object[])markerTestResults.get(i12);
            count = 0;
            for (Integer ndx : outputList) {
                table[i12][count++] = result[ndx];
            }
        }
        StringBuilder tableName = new StringBuilder("GLM_marker_test_");
        tableName.append(dataset.getName());
        StringBuilder comments = new StringBuilder("Tests of Marker-Phenotype Association");
        comments.append("GLM: fixed effect linear model\n");
        comments.append("Data set: ").append(dataset.getName());
        comments.append("\nmodel: trait = mean");
        for (i2 = 0; i2 < theAdapter.getNumberOfFactors(); ++i2) {
            comments.append(" + ");
            comments.append(theAdapter.getFactorName(i2));
        }
        for (i2 = 0; i2 < theAdapter.getNumberOfCovariates(); ++i2) {
            comments.append(" + ");
            comments.append(theAdapter.getCovariateName(i2));
        }
        comments.append(" + marker");
        if (this.writeOutputToFile) {
            comments.append("\nOutput written to " + ftestFile.getPath());
        }
        SimpleTableReport markerTestReport = new SimpleTableReport("Marker Test", colnames, table);
        resultset.add(new Datum(tableName.toString(), markerTestReport, comments.toString()));
        columnLabels = new String[]{"Trait", "Marker", "Obs", "Locus", "Locus_pos", "Chr", "Chr_pos", "Allele", "Estimate"};
        int[] outputIndex = hasAlleleNames ? (hasMarkerNames && this.hasMap ? new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8} : (hasMarkerNames ? new int[]{0, 1, 2, 3, 4, 7, 8} : (this.hasMap ? new int[]{0, 2, 3, 4, 5, 6, 7, 8} : new int[]{0, 2, 3, 4, 7, 8}))) : (hasMarkerNames && this.hasMap ? new int[]{0, 1, 2, 3, 4, 5, 6, 8} : (hasMarkerNames ? new int[]{0, 1, 2, 3, 4, 8} : (this.hasMap ? new int[]{0, 2, 3, 4, 5, 6, 8} : new int[]{0, 2, 3, 4, 8})));
        nrows = alleleEstimateResults.size();
        table = new Object[nrows][];
        numberOfColumns = outputIndex.length;
        colnames = new String[numberOfColumns];
        for (int j = 0; j < numberOfColumns; ++j) {
            colnames[j] = columnLabels[outputIndex[j]];
        }
        for (i = 0; i < nrows; ++i) {
            table[i] = new Object[numberOfColumns];
            Object[] result = (Object[])alleleEstimateResults.get(i);
            for (int j = 0; j < numberOfColumns; ++j) {
                table[i][j] = result[outputIndex[j]];
            }
        }
        tableName = new StringBuilder("GLM allele estimates for ");
        tableName.append(dataset.getName());
        comments = new StringBuilder("Marker allele effect estimates\n");
        comments.append("GLM: fixed effect linear model\n");
        comments.append("Data set: ").append(dataset.getName());
        comments.append("\nmodel: trait = mean");
        for (i = 0; i < theAdapter.getNumberOfFactors(); ++i) {
            comments.append(" + ");
            comments.append(theAdapter.getFactorName(i));
        }
        for (i = 0; i < theAdapter.getNumberOfCovariates(); ++i) {
            comments.append(" + ");
            comments.append(theAdapter.getCovariateName(i));
        }
        comments.append(" + marker");
        if (this.writeOutputToFile) {
            comments.append("\nOutput written to " + blueFile.getPath());
        }
        SimpleTableReport alleleEstimateReport = new SimpleTableReport("Allele Estimates", colnames, table);
        resultset.add(new Datum(tableName.toString(), alleleEstimateReport, comments.toString()));
        this.fireProgress(0);
        return resultset;
    }

    private void updatePermutationPValues(int phenotype, double[][] permutedData, int[] nonMissingIndex, DoubleMatrix X, DoubleMatrix G, int markerdf) {
        int nobs = nonMissingIndex.length;
        int rX = X.numberOfColumns();
        double dferror = nobs - rX;
        DoubleMatrix L = DoubleMatrixFactory.DEFAULT.make(rX, markerdf, 0.0);
        for (int i = 0; i < markerdf; ++i) {
            L.set(rX - markerdf + i, i, 1.0);
        }
        for (int p = 0; p < this.numberOfPermutations; ++p) {
            double pval;
            DoubleMatrix y = DoubleMatrixFactory.DEFAULT.make(nobs, 1);
            for (int i = 0; i < nobs; ++i) {
                y.set(i, 0, permutedData[p][nonMissingIndex[i]]);
            }
            DoubleMatrix yty = y.crossproduct(y);
            DoubleMatrix Xty = X.crossproduct(y);
            DoubleMatrix beta = G.mult(Xty);
            double errorSS = yty.minus(Xty.crossproduct(beta)).get(0, 0);
            DoubleMatrix Ltbeta = L.crossproduct(beta);
            DoubleMatrix invLtGL = L.crossproduct(G.mult(L));
            invLtGL.invert();
            double dfL = L.numberOfColumns();
            double F = Ltbeta.crossproduct(invLtGL.mult(Ltbeta)).get(0, 0) / errorSS / dfL * dferror;
            try {
                pval = LinearModelUtils.Ftest(F, dfL, dferror);
            }
            catch (Exception e) {
                pval = 1.0;
            }
            this.minP[phenotype][p] = Math.min(this.minP[phenotype][p], pval);
        }
    }

    private double[][] permuteData(double[] phenotypeData, boolean[] missing, ArrayList<String[]> factorList, ArrayList<double[]> covariateList, MarkerPhenotypeAdapter theAdapter) {
        int[] nonMissingIndex = MarkerPhenotypeAdapterUtils.getNonMissingIndex(missing);
        int nobs = nonMissingIndex.length;
        double[][] permutedData = new double[this.numberOfPermutations][nobs];
        double[] y = new double[nobs];
        for (int i = 0; i < nobs; ++i) {
            y[i] = phenotypeData[nonMissingIndex[i]];
        }
        ArrayList<ModelEffect> modelEffects = new ArrayList<ModelEffect>();
        FactorModelEffect meanEffect = new FactorModelEffect(new int[nobs], false);
        meanEffect.setID("mean");
        modelEffects.add(meanEffect);
        int numberOfFactors = 0;
        if (factorList != null) {
            numberOfFactors = factorList.size();
        }
        if (numberOfFactors > 0) {
            for (int f = 0; f < numberOfFactors; ++f) {
                String[] afactor = factorList.get(f);
                Object[] factorLabels = new String[nobs];
                for (int i = 0; i < nobs; ++i) {
                    factorLabels[i] = afactor[nonMissingIndex[i]];
                }
                FactorModelEffect fme = new FactorModelEffect(ModelEffectUtils.getIntegerLevels(factorLabels), true, theAdapter.getFactorName(f));
                modelEffects.add(fme);
            }
        }
        int numberOfCovariates = 0;
        if (covariateList != null) {
            numberOfCovariates = covariateList.size();
        }
        if (numberOfCovariates > 0) {
            for (int c = 0; c < numberOfCovariates; ++c) {
                double[] covar = new double[nobs];
                double[] covariateData = covariateList.get(c);
                for (int i = 0; i < nobs; ++i) {
                    covar[i] = covariateData[nonMissingIndex[i]];
                }
                modelEffects.add(new CovariateModelEffect(covar, theAdapter.getCovariateName(c)));
            }
        }
        SweepFastLinearModel theModel = new SweepFastLinearModel(modelEffects, y);
        DoubleMatrix yhat = theModel.getPredictedValues();
        DoubleMatrix r = theModel.getResiduals();
        int nrows = r.numberOfRows();
        double[] res = new double[nrows];
        for (int i = 0; i < nrows; ++i) {
            res[i] = r.get(i, 0);
        }
        permutedData = new double[this.numberOfPermutations][nobs];
        for (int p = 0; p < this.numberOfPermutations; ++p) {
            LinearModelUtils.shuffle(res, this.randomizer);
            for (int i = 0; i < nobs; ++i) {
                permutedData[p][i] = yhat.get(i, 0) + res[i];
            }
        }
        return permutedData;
    }

    private DoubleMatrix getXfromModelEffects(ArrayList<ModelEffect> someEffects) {
        int n = someEffects.size();
        DoubleMatrix[][] mats = new DoubleMatrix[1][n];
        for (int i = 0; i < n; ++i) {
            mats[0][i] = someEffects.get(i).getX();
        }
        return DoubleMatrixFactory.DEFAULT.compose(mats);
    }

    private int[] nonMissingIndex(boolean[] originalMissing, boolean[] finalMissing) {
        int finalCount = 0;
        for (boolean miss : finalMissing) {
            if (miss) continue;
            ++finalCount;
        }
        int[] index = new int[finalCount];
        int n = originalMissing.length;
        int count = 0;
        finalCount = 0;
        for (int i = 0; i < n; ++i) {
            if (!finalMissing[i]) {
                index[finalCount++] = count;
            }
            if (originalMissing[i]) continue;
            ++count;
        }
        return index;
    }

    /*
     * WARNING - void declaration
     */
    private LinkedList<Datum> calculateBLUEsFromPhenotypes(MarkerPhenotypeAdapter mpa, String datasetName) {
        void var20_33;
        int i;
        Object y;
        if (this.isInteractive()) {
            String msg = "The data set you have selected does not contain any marker data. Do you want to calculate BLUEs (best linear unbiased estimates) of the phenotypes?";
            String title = "Calculate BLUEs";
            int action = JOptionPane.showConfirmDialog(this.getParentFrame(), msg, title, 0);
            if (action != 0) {
                return null;
            }
        }
        LinkedList<Datum> theResults = new LinkedList<Datum>();
        LinkedList<Object[]> anovaResults = new LinkedList<Object[]>();
        LinkedList<double[]> blueList = new LinkedList<double[]>();
        ArrayList taxaListList = new ArrayList();
        int numberOfCovariates = mpa.getNumberOfCovariates();
        int numberOfFactors = mpa.getNumberOfFactors();
        int numberOfPhenotypes = mpa.getNumberOfPhenotypes();
        for (int ph = 0; ph < numberOfPhenotypes; ++ph) {
            double p;
            double[] phenotypeData = mpa.getPhenotypeValues(ph);
            boolean[] missing = mpa.getMissingPhenotypes(ph);
            ArrayList<String[]> factorList = MarkerPhenotypeAdapterUtils.getFactorList(mpa, ph, missing);
            ArrayList<double[]> covariateList = MarkerPhenotypeAdapterUtils.getCovariateList(mpa, ph, missing);
            int[] nonmissingRows = MarkerPhenotypeAdapterUtils.getNonMissingIndex(missing);
            int numberOfObs = nonmissingRows.length;
            y = new double[numberOfObs];
            for (int i2 = 0; i2 < numberOfObs; ++i2) {
                y[i2] = phenotypeData[nonmissingRows[i2]];
            }
            ArrayList<ModelEffect> modelEffects = new ArrayList<ModelEffect>();
            Iterator meanEffect = new FactorModelEffect(new int[numberOfObs], false);
            ((FactorModelEffect)((Object)meanEffect)).setID("mean");
            modelEffects.add((ModelEffect)((Object)meanEffect));
            Taxon[] taxonArray = mpa.getTaxa(ph);
            Taxon[] taxa = new Taxon[numberOfObs];
            ArrayList taxaIds = new ArrayList();
            for (int i3 = 0; i3 < numberOfObs; ++i3) {
                taxa[i3] = taxonArray[nonmissingRows[i3]];
            }
            int[] taxaLevels = ModelEffectUtils.getIntegerLevels(taxa, taxaIds);
            taxaListList.add(taxaIds);
            FactorModelEffect taxaEffect = new FactorModelEffect(taxaLevels, true, "Taxa");
            modelEffects.add(taxaEffect);
            if (numberOfFactors > 0) {
                for (int f = 0; f < numberOfFactors; ++f) {
                    String[] afactor = factorList.get(f);
                    Object[] factorLabels = new String[numberOfObs];
                    for (int i4 = 0; i4 < numberOfObs; ++i4) {
                        factorLabels[i4] = afactor[nonmissingRows[i4]];
                    }
                    FactorModelEffect fme = new FactorModelEffect(ModelEffectUtils.getIntegerLevels(factorLabels), true, mpa.getFactorName(f));
                    modelEffects.add(fme);
                }
            }
            if (numberOfCovariates > 0) {
                for (int c = 0; c < numberOfCovariates; ++c) {
                    double[] covar = new double[numberOfObs];
                    double[] covariateData = covariateList.get(c);
                    for (int i5 = 0; i5 < numberOfObs; ++i5) {
                        covar[i5] = covariateData[nonmissingRows[i5]];
                    }
                    modelEffects.add(new CovariateModelEffect(covar, mpa.getCovariateName(c)));
                }
            }
            SweepFastLinearModel sflm = new SweepFastLinearModel(modelEffects, (double[])y);
            double[] taxaSSdf = sflm.getMarginalSSdf(1);
            double[] modelSSdf = sflm.getFullModelSSdf();
            double[] errorSSdf = sflm.getResidualSSdf();
            double[] beta = sflm.getBeta();
            double F = taxaSSdf[0] / taxaSSdf[1] / errorSSdf[0] * errorSSdf[1];
            try {
                p = LinearModelUtils.Ftest(F, taxaSSdf[1], errorSSdf[1]);
            }
            catch (Exception e) {
                p = Double.NaN;
            }
            Object[] result = new Object[]{mpa.getPhenotypeName(ph), new Double(F), new Double(p), new Double(taxaSSdf[1]), new Double(taxaSSdf[0] / taxaSSdf[1]), new Double(errorSSdf[1]), new Double(errorSSdf[0] / errorSSdf[1]), new Double(modelSSdf[1]), new Double(modelSSdf[0] / modelSSdf[1])};
            anovaResults.add(result);
            double overallMean = beta[0];
            int nEffects = modelEffects.size();
            int start = 0;
            for (int i6 = 1; i6 < nEffects; ++i6) {
                ModelEffect me = modelEffects.get(i6);
                if (me instanceof FactorModelEffect && !me.getID().equals("Taxa")) {
                    FactorModelEffect fme = (FactorModelEffect)me;
                    int nLevels = fme.getNumberOfLevels();
                    int nEstimates = fme.getRestricted() ? nLevels - 1 : nLevels;
                    double factorMean = 0.0;
                    for (int j = 0; j < nEstimates; ++j) {
                        factorMean += beta[j + start];
                    }
                    overallMean += (factorMean /= (double)nLevels);
                    start += nEstimates;
                    continue;
                }
                start += me.getNumberOfLevels();
            }
            int n = taxaIds.size();
            double[] blues = new double[n];
            for (int i7 = 0; i7 < n - 1; ++i7) {
                blues[i7] = beta[i7 + 1] + overallMean;
            }
            blues[n - 1] = overallMean;
            blueList.add(blues);
            taxaListList.add(taxaIds);
        }
        Object[] anovaColumnLabels = new String[]{"Trait", "F", "p", "taxaDF", "taxaMS", "errorDF", "errorMS", "modelDF", "modelMS"};
        Object[][] table = new Object[anovaResults.size()][];
        anovaResults.toArray((T[])table);
        String datumName = "Phenotype ANOVA from " + datasetName;
        StringBuilder datumComments = new StringBuilder("ANOVA for Phenotypes using GLM\n");
        datumComments.append("Data set: ").append(datasetName);
        datumComments.append("\nmodel: trait = mean + taxa");
        for (i = 0; i < mpa.getNumberOfFactors(); ++i) {
            datumComments.append(" + ");
            datumComments.append(mpa.getFactorName(i));
        }
        for (i = 0; i < mpa.getNumberOfCovariates(); ++i) {
            datumComments.append(" + ");
            datumComments.append(mpa.getCovariateName(i));
        }
        SimpleTableReport str = new SimpleTableReport(datumName, anovaColumnLabels, table);
        Datum theAnova = new Datum(datumName, str, datumComments.toString());
        theResults.add(theAnova);
        TreeSet<Taxon> taxaSet = new TreeSet<Taxon>();
        y = taxaListList.iterator();
        while (y.hasNext()) {
            ArrayList list = (ArrayList)y.next();
            for (Object e : list) {
                taxaSet.add((Taxon)e);
            }
        }
        HashMap<Taxon, Integer> taxaMap = new HashMap<Taxon, Integer>();
        int count = 0;
        for (Taxon taxon : taxaSet) {
            taxaMap.put(taxon, count++);
        }
        String[] blueColumnLabels = new String[numberOfPhenotypes + 1];
        blueColumnLabels[0] = "Taxa";
        boolean bl = false;
        while (var20_33 < numberOfPhenotypes) {
            blueColumnLabels[var20_33 + true] = mpa.getPhenotypeName((int)var20_33);
            ++var20_33;
        }
        int n = taxaSet.size();
        double[][] blues = new double[n][numberOfPhenotypes];
        for (int r = 0; r < n; ++r) {
            for (int c = 0; c < numberOfPhenotypes; ++c) {
                blues[r][c] = Double.NaN;
            }
        }
        LinkedList<Trait> traitList = new LinkedList<Trait>();
        for (int c = 0; c < numberOfPhenotypes; ++c) {
            traitList.add(new Trait(mpa.getPhenotypeName(c), false, "data"));
            double[] pheno = (double[])blueList.get(c);
            int n2 = pheno.length;
            ArrayList taxaList = (ArrayList)taxaListList.get(c);
            for (int i9 = 0; i9 < n2; ++i9) {
                int ndx = (Integer)taxaMap.get(taxaList.get(i9));
                if (ndx <= -1) continue;
                blues[ndx][c] = pheno[i9];
            }
        }
        TaxaList tL = new TaxaListBuilder().addAll(taxaSet).build();
        SimplePhenotype thePhenotype = new SimplePhenotype(tL, traitList, blues);
        theResults.add(new Datum("BLUEs_" + datasetName, thePhenotype, "BLUEs calculated from " + datasetName));
        return theResults;
    }

    @Override
    public String getButtonName() {
        return "GLM";
    }

    @Override
    public ImageIcon getIcon() {
        URL imageURL = FixedEffectLMPlugin.class.getResource("/net/maizegenetics/analysis/images/LinearAssociation.gif");
        if (imageURL == null) {
            return null;
        }
        return new ImageIcon(imageURL);
    }

    @Override
    public String getToolTipText() {
        return "Use fixed effect model to test associations";
    }

    private boolean containsDuplicates(Taxon[] ids) {
        HashSet<Taxon> idSet = new HashSet<Taxon>();
        for (Taxon id : ids) {
            idSet.add(id);
        }
        return idSet.size() < ids.length;
    }

    public void setOutputFile(String filename) {
        this.writeOutputToFile = true;
        this.outputName = filename;
    }

    public void setRestrictOutput(boolean restrict) {
        this.filterOutput = restrict;
    }

    public void setMaxP(double value) {
        this.filterOutput = true;
        this.maxp = value;
    }

    public void setPermute(boolean permute) {
        this.permute = permute;
    }

    public void setNumberOfPermutations(int numberOfPermutations) {
        this.numberOfPermutations = numberOfPermutations;
    }

    public void setRandomizer(long seed) {
        this.randomizer.setSeed(seed);
    }

    class GLMOptionsDialog
    extends JDialog {
        JCheckBox chkPermute;
        JTextField txtPermutationNumber;

        GLMOptionsDialog(Frame parentFrame) {
            super(parentFrame);
            this.chkPermute = new JCheckBox("Use permutation test for markers", false);
            this.txtPermutationNumber = new JTextField(8);
            this.setLocationRelativeTo(parentFrame);
            Container content = this.getContentPane();
            content.setLayout(new GridBagLayout());
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            this.setTitle("GLM Options");
            this.txtPermutationNumber.setText("1000");
            this.txtPermutationNumber.setEnabled(false);
            JLabel lblPermNumber = new JLabel("Number of Permutations: ");
            JButton btnOK = new JButton("OK");
            btnOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    GLMOptionsDialog.this.setVisible(false);
                }
            });
            this.chkPermute.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (GLMOptionsDialog.this.chkPermute.isSelected()) {
                        GLMOptionsDialog.this.txtPermutationNumber.setEnabled(true);
                    } else {
                        GLMOptionsDialog.this.txtPermutationNumber.setEnabled(false);
                    }
                }
            });
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 2;
            gbc.anchor = 17;
            gbc.insets = new Insets(10, 8, 5, 8);
            content.add((Component)this.chkPermute, gbc);
            ++gbc.gridy;
            gbc.gridwidth = 1;
            content.add((Component)lblPermNumber, gbc);
            ++gbc.gridx;
            content.add((Component)this.txtPermutationNumber, gbc);
            gbc.gridx = 0;
            ++gbc.gridy;
            gbc.gridwidth = 2;
            gbc.anchor = 10;
            content.add((Component)btnOK, gbc);
            this.pack();
            this.setVisible(true);
        }

        int getPermutationNumber() {
            return Integer.parseInt(this.txtPermutationNumber.getText());
        }

        boolean permute() {
            return this.chkPermute.isSelected();
        }
    }
}

