/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.chart;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.prefs.TasselPrefs;
import net.maizegenetics.util.BasicFileFilter;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.jfree.chart.ChartPanel;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public abstract class AbstractDisplayPlugin
extends AbstractPlugin {
    private File mySaveFile;
    private int myImageWidth = 500;
    private int myImageHeight = 500;
    private Outformat myOutformat = Outformat.svg;

    public AbstractDisplayPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    protected void saveDataToFile(BufferedImage img, Outformat format, File saveFile) {
        if (saveFile == null) {
            return;
        }
        try {
            switch (format) {
                case jpg: {
                    ImageIO.write((RenderedImage)img, "JPEG", saveFile);
                    break;
                }
                case gif: {
                    ImageIO.write((RenderedImage)img, "GIF", saveFile);
                    break;
                }
                case bmp: {
                    ImageIO.write((RenderedImage)img, "BMP", saveFile);
                    break;
                }
                case wbmp: {
                    ImageIO.write((RenderedImage)img, "WBMP", saveFile);
                    break;
                }
                case png: {
                    ImageIO.write((RenderedImage)img, "PNG", saveFile);
                    break;
                }
            }
        }
        catch (Exception ee) {
            System.out.println("saveDataToFile:" + ee);
        }
    }

    public void saveDataToFile(Component comp) {
        this.saveDataToFile(comp, this.getSaveFileByChooser());
    }

    public void saveDataToFile(Component comp, File saveFile) {
        try {
            int d_width = comp.getWidth();
            int d_height = comp.getHeight();
            if (d_width == 0) {
                d_width = this.myImageWidth;
                d_height = this.myImageHeight;
                comp.setSize(d_width, d_height);
            }
            if (this.myOutformat == Outformat.svg) {
                DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();
                Document document = domImpl.createDocument(null, "svg", null);
                SVGGraphics2D svgGenerator = new SVGGraphics2D(document);
                if (comp instanceof ChartPanel) {
                    ChartPanel cp = (ChartPanel)comp;
                    cp.getChart().draw((Graphics2D)svgGenerator, (Rectangle2D)new Rectangle(d_width, d_height));
                } else {
                    comp.paint((Graphics)svgGenerator);
                }
                FileOutputStream fos = new FileOutputStream(saveFile);
                OutputStreamWriter out = new OutputStreamWriter((OutputStream)fos, "UTF-8");
                svgGenerator.stream((Writer)out, true);
                fos.flush();
                fos.close();
            } else {
                BufferedImage img = new BufferedImage(d_width, d_height, 1);
                Graphics gbox = img.getGraphics();
                comp.paint(gbox);
                this.saveDataToFile(img, this.myOutformat, saveFile);
            }
        }
        catch (Exception ee) {
            System.out.println("saveDataToFile(JPanel pnl, Outformat format, File saveFile):" + ee);
        }
    }

    private File getSaveFileByChooser() {
        File tempFile = new File(TasselPrefs.getSaveDir());
        JFileChooser filerSave = new JFileChooser(tempFile);
        filerSave.resetChoosableFileFilters();
        filerSave.removeChoosableFileFilter(null);
        for (Outformat p : Outformat.values()) {
            filerSave.addChoosableFileFilter(new BasicFileFilter(p.toString()));
        }
        FileFilter[] ff = filerSave.getChoosableFileFilters();
        filerSave.setFileFilter(ff[1]);
        filerSave.setMultiSelectionEnabled(false);
        File saveFile = null;
        int returnVal = filerSave.showSaveDialog(null);
        if (returnVal == 1 || returnVal == 0) {
            saveFile = filerSave.getSelectedFile();
            TasselPrefs.putSaveDir(filerSave.getCurrentDirectory().getPath());
            String fileType = ((BasicFileFilter)filerSave.getFileFilter()).getExtension();
            if (!filerSave.isAcceptAllFileFilterUsed()) {
                fileType = ((BasicFileFilter)filerSave.getFileFilter()).getExtension();
            }
            this.myOutformat = Outformat.valueOf(fileType);
            if (!saveFile.getName().contains(fileType)) {
                saveFile = new File(saveFile.getParent(), saveFile.getName() + "." + fileType);
            }
        }
        return saveFile;
    }

    protected File getSaveFileByChooser(String[] fileExtensions) {
        return this.getSaveFileByChooser(fileExtensions, this.getParentFrame());
    }

    protected File getSaveFileByChooser(String[] fileExtensions, Component parent) {
        JFileChooser fileChooser = new JFileChooser(new File(TasselPrefs.getSaveDir()));
        for (int i = 0; i < fileExtensions.length; ++i) {
            BasicFileFilter current = new BasicFileFilter(fileExtensions[i]);
            fileChooser.addChoosableFileFilter(current);
            if (i != 0) continue;
            fileChooser.setFileFilter(current);
        }
        fileChooser.setMultiSelectionEnabled(false);
        File saveFile = null;
        int returnVal = fileChooser.showSaveDialog(parent);
        if (returnVal == 1 || returnVal == 0) {
            saveFile = fileChooser.getSelectedFile();
            TasselPrefs.putSaveDir(fileChooser.getCurrentDirectory().getPath());
            try {
                String fileType = ((BasicFileFilter)fileChooser.getFileFilter()).getExtension();
                if (!saveFile.getName().endsWith("." + fileType)) {
                    saveFile = new File(saveFile.getParent(), saveFile.getName() + "." + fileType);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return saveFile;
    }

    public static String[] getPossibleGraphicOutFormats() {
        String[] s = new String[Outformat.values().length];
        int i = 0;
        for (Outformat p : Outformat.values()) {
            s[i] = "" + (Object)((Object)p);
            ++i;
        }
        return s;
    }

    public int getImageWidth() {
        return this.myImageWidth;
    }

    public int getImageHeight() {
        return this.myImageHeight;
    }

    public void setImageSize(int width, int height) {
        this.myImageWidth = width;
        this.myImageHeight = height;
    }

    public Outformat getOutformat() {
        return this.myOutformat;
    }

    public void setOutformat(Outformat theOutformat) {
        this.myOutformat = theOutformat;
    }

    public File getSaveFile() {
        return this.mySaveFile;
    }

    public void setSaveFile(File theSaveFile) {
        this.mySaveFile = theSaveFile;
    }

    public void setSaveFile(String theSaveFile) {
        this.mySaveFile = new File(theSaveFile);
    }

    public static enum Outformat {
        svg,
        jpg,
        gif,
        bmp,
        wbmp,
        png,
        printer;

    }
}

