/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.chart;

import java.awt.Frame;
import java.net.URL;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import net.maizegenetics.analysis.chart.AbstractDisplayPlugin;
import net.maizegenetics.analysis.chart.BarChartPanel;
import net.maizegenetics.analysis.chart.BasicChartPanel;
import net.maizegenetics.analysis.chart.BasicGraphFrame;
import net.maizegenetics.analysis.chart.HistogramPanel;
import net.maizegenetics.analysis.chart.PieChartPanel;
import net.maizegenetics.analysis.chart.XYScatterPanel;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.util.TableReport;

public class ChartDisplayPlugin
extends AbstractDisplayPlugin {
    ChartType chartMode = ChartType.Histogram;
    int series1 = -1;
    int series2 = -1;
    int series3 = -1;
    int bins = 5;
    boolean isRegression = false;
    boolean isBoxWhisker = false;
    boolean isBar = true;
    boolean errBar = false;

    public ChartDisplayPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSet performFunction(DataSet input) {
        try {
            List<Datum> tableInList = input.getDataOfType(TableReport.class);
            if (tableInList.size() != 1) {
                String message = "Invalid selection.  Please select one table result.";
                if (this.isInteractive()) {
                    JOptionPane.showMessageDialog(this.getParentFrame(), message);
                } else {
                    System.out.println(message);
                }
                DataSet dataSet = null;
                return dataSet;
            }
            TableReport theTR = (TableReport)tableInList.get(0).getData();
            if (this.isInteractive()) {
                BasicGraphFrame myDialog = new BasicGraphFrame(this, theTR);
                myDialog.setLocationRelativeTo(this.getParentFrame());
                myDialog.setVisible(true);
            } else if (this.getSaveFile() != null) {
                BasicChartPanel chartPanel = null;
                switch (this.chartMode) {
                    case Histogram: {
                        chartPanel = new HistogramPanel(theTR, this.series1, this.series2, this.bins);
                        break;
                    }
                    case XYScatter: {
                        chartPanel = new XYScatterPanel(theTR, this.series1, this.series2, this.series3, this.isRegression);
                        break;
                    }
                    case BarChart: {
                        chartPanel = new BarChartPanel(theTR, this.series1, this.series2, this.series3, this.isBoxWhisker, this.isBar, this.errBar);
                        break;
                    }
                    case PieChart: {
                        chartPanel = new PieChartPanel(theTR);
                    }
                }
                this.saveDataToFile(chartPanel.getMainComponent(), this.getSaveFile());
            }
            DataSet dataSet = null;
            return dataSet;
        }
        finally {
            this.fireProgress(100);
        }
    }

    public ChartType getChartMode() {
        return this.chartMode;
    }

    public void setChartMode(ChartType chartMode) {
        this.chartMode = chartMode;
    }

    public int getSeries1() {
        return this.series1;
    }

    public void setSeries1(int series1) {
        this.series1 = series1;
    }

    public int getSeries2() {
        return this.series2;
    }

    public void setSeries2(int series2) {
        this.series2 = series2;
    }

    public int getSeries3() {
        return this.series3;
    }

    public void setSeries3(int series3) {
        this.series3 = series3;
    }

    public int getBins() {
        return this.bins;
    }

    public void setBins(int bins) {
        this.bins = bins;
    }

    public boolean isRegression() {
        return this.isRegression;
    }

    public void setRegression(boolean regression) {
        this.isRegression = regression;
    }

    public boolean isBoxWhisker() {
        return this.isBoxWhisker;
    }

    public void setBoxWhisker(boolean boxWhisker) {
        this.isBoxWhisker = boxWhisker;
    }

    public boolean isBar() {
        return this.isBar;
    }

    public void setBar(boolean bar) {
        this.isBar = bar;
    }

    public boolean isErrBar() {
        return this.errBar;
    }

    public void setErrBar(boolean errBar) {
        this.errBar = errBar;
    }

    public static String[] getPossibleCharts() {
        String[] s = new String[ChartType.values().length];
        int i = 0;
        for (ChartType p : ChartType.values()) {
            s[i] = "" + (Object)((Object)p);
            ++i;
        }
        return s;
    }

    @Override
    public ImageIcon getIcon() {
        URL imageURL = ChartDisplayPlugin.class.getResource("BarChart.gif");
        if (imageURL == null) {
            return null;
        }
        return new ImageIcon(imageURL);
    }

    @Override
    public String getButtonName() {
        return "Chart";
    }

    @Override
    public String getToolTipText() {
        return "Charting Tools";
    }

    public static enum ChartType {
        Histogram,
        XYScatter,
        BarChart,
        PieChart;

    }
}

