/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.chart;

import ext.swing.ZDialog;
import ext.swing.ZTableModel;
import ext.swing.ZToolBar;
import ext.util.ZDoubleUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import net.maizegenetics.analysis.chart.Grid2dDisplayPlugin;
import net.maizegenetics.util.StringNumberComparator;
import net.maizegenetics.util.TableReport;

class Grid2DDialog
extends JDialog {
    private int selectedRow = 0;
    private int selectedColumn = 0;
    private int selectedZ = 0;
    Grid2dDisplayPlugin theGrid2dDisplayPlugin;
    private Object[] tableHeader;
    private TableReport tableData;
    private boolean rowLabels = true;
    private boolean colLabels = true;
    private Vector headerVector;
    private String[] numericHeader = null;
    private double[][] matrix = null;
    private String[][] modelMatrix = null;
    private String[] rowHeader = null;
    private String[] columnHeader = null;
    private int curCellSize = 20;
    private Color fgColor = new Color(255, 255, 204);
    private Color bgColor = Color.blue;
    private Color color1 = new Color(0, 0, 0);
    private Color color2 = new Color(128, 128, 128);
    private Color color3 = new Color(196, 196, 196);
    private Color color4 = new Color(255, 255, 255);
    private float min = 0.0f;
    private float max = 0.0f;
    private float range = 0.0f;
    private float cutoff = 0.0f;
    private MyRenderer rdr = new MyRenderer();
    private JPanel pHelp = new pValueHelp();
    private JFileChooser fc = new JFileChooser();
    private JPanel panel = new JPanel();
    private BorderLayout borderLayout1 = new BorderLayout();
    private JScrollPane LP_chart = new JScrollPane();
    private JLabel statusBar = new JLabel();
    private JTable chart = new JTable();
    private JPanel P_toolBar = new JPanel();
    private ZToolBar toolBar = new ZToolBar();
    private JPanel rightToolPanel = new JPanel();
    private JComboBox CB_cellSize = new JComboBox();
    private JPanel cutoffBar = new JPanel();
    private JLabel L_cutoff = new JLabel();
    private JLabel L_cellSize = new JLabel();
    private JColorChooser cc = new JColorChooser();
    private JTextField TF_cutoff = new JTextField();
    private JSlider S_cutoff = new JSlider();
    private JCheckBox C_pValueData = new JCheckBox();
    private JCheckBox C_upperTriangle = new JCheckBox();
    BorderLayout borderLayout2 = new BorderLayout();
    JPanel dataPanel = new JPanel();
    JComboBox columnComboBox = new JComboBox();
    JLabel jLabel1 = new JLabel();
    JComboBox rowComboBox = new JComboBox();
    JLabel jLabel2 = new JLabel();
    JComboBox valueComboBox = new JComboBox();
    JLabel jLabel3 = new JLabel();
    JCheckBox rowLabelCheckBox = new JCheckBox();
    JCheckBox colLabelCheckBox = new JCheckBox();
    JButton svgButton = new JButton();
    GridBagLayout gridBagLayout1 = new GridBagLayout();

    public Grid2DDialog(Grid2dDisplayPlugin gdp, TableReport theTable) {
        super(gdp.getParentFrame(), "Plot Stuff", false);
        this.theGrid2dDisplayPlugin = gdp;
        try {
            this.jbInit();
            this.tableHeader = theTable.getTableColumnNames();
            this.headerVector = new Vector();
            this.tableData = theTable;
            this.setSize(new Dimension(600, 510));
            String[] newHeader = new String[theTable.getTableColumnNames().length];
            for (int i = 0; i < newHeader.length; ++i) {
                newHeader[i] = (String)this.tableHeader[i];
                this.headerVector.add(this.tableHeader[i]);
            }
            this.setComboBoxes(newHeader, theTable);
            this.showAtCenter();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean isNumericData(String[] header, TableReport data) {
        int j;
        long numRows = data.getRowCount();
        if (header.length <= 1) {
            return false;
        }
        if (numRows < 1L) {
            return false;
        }
        if (data.getColumnCount() != header.length) {
            return false;
        }
        String[] tempColumnHeader = new String[header.length];
        int[] badDataCount = new int[header.length];
        try {
            for (long i = 0L; i < numRows; ++i) {
                Object[] currentRow = data.getRow(i);
                for (int j2 = 0; j2 < header.length; ++j2) {
                    tempColumnHeader[j2] = header[j2];
                    try {
                        double d = Double.valueOf(currentRow[j2].toString());
                        continue;
                    }
                    catch (NumberFormatException ex) {
                        int n = j2;
                        badDataCount[n] = badDataCount[n] + 1;
                    }
                }
            }
        }
        catch (NumberFormatException ex) {
            return false;
        }
        int goodCol = 0;
        for (j = 0; j < header.length; ++j) {
            if (!((double)badDataCount[j] < (double)numRows * 0.9)) continue;
            ++goodCol;
        }
        this.numericHeader = new String[goodCol];
        goodCol = 0;
        for (j = 0; j < header.length; ++j) {
            if ((long)badDataCount[j] >= numRows / 2L) continue;
            this.numericHeader[goodCol] = tempColumnHeader[j];
            ++goodCol;
        }
        return true;
    }

    public void setComboBoxes(String[] header, TableReport data) throws Exception {
        int i;
        if (!this.isNumericData(header, data)) {
            throw new Exception("Invalid data for 1-D plotting");
        }
        this.rowComboBox.setEnabled(false);
        this.rowComboBox.removeAllItems();
        for (i = 0; i < header.length; ++i) {
            this.rowComboBox.addItem(header[i]);
        }
        this.rowComboBox.setEnabled(true);
        this.rowComboBox.setSelectedIndex(0);
        this.columnComboBox.setEnabled(false);
        this.columnComboBox.removeAllItems();
        for (i = 0; i < header.length; ++i) {
            this.columnComboBox.addItem(header[i]);
        }
        this.columnComboBox.setEnabled(true);
        this.columnComboBox.setSelectedIndex(0);
        this.valueComboBox.setEnabled(false);
        this.valueComboBox.removeAllItems();
        for (i = 0; i < this.numericHeader.length; ++i) {
            this.valueComboBox.addItem(this.numericHeader[i]);
        }
        this.valueComboBox.setEnabled(true);
        this.valueComboBox.setSelectedIndex(0);
    }

    public boolean processAndSetData(Object[] header, TableReport data) {
        int i;
        if (this.selectedRow == this.selectedZ || this.selectedColumn == this.selectedZ || this.selectedColumn == this.selectedRow) {
            return false;
        }
        Vector<Object> rowVec = new Vector<Object>();
        Vector<Object> colVec = new Vector<Object>();
        int i2 = 0;
        while ((long)i2 < data.getRowCount()) {
            Object current = data.getValueAt(i2, this.selectedRow);
            if (!rowVec.contains(current)) {
                rowVec.add(current);
            }
            if (!colVec.contains(current = data.getValueAt(i2, this.selectedColumn))) {
                colVec.add(current);
            }
            ++i2;
        }
        Collections.sort(rowVec, new StringNumberComparator());
        Collections.sort(colVec, new StringNumberComparator());
        int extraCol = this.rowLabels ? 1 : 0;
        this.columnHeader = new String[colVec.size() + extraCol];
        this.rowHeader = new String[rowVec.size()];
        this.matrix = new double[this.rowHeader.length][this.columnHeader.length];
        this.modelMatrix = new String[this.rowHeader.length][this.columnHeader.length];
        for (i = 0; i < rowVec.size(); ++i) {
            for (int j = 0; j < colVec.size() + extraCol; ++j) {
                this.modelMatrix[i][j] = "0.0";
            }
        }
        for (i = 0; i < rowVec.size(); ++i) {
            this.rowHeader[i] = (String)rowVec.get(i);
        }
        if (this.rowLabels) {
            this.columnHeader[0] = (String)this.tableHeader[this.selectedZ];
            for (i = 0; i < rowVec.size(); ++i) {
                this.modelMatrix[i][0] = (String)rowVec.get(i);
            }
        }
        for (int j = 0; j < colVec.size(); ++j) {
            this.columnHeader[j + extraCol] = (String)colVec.get(j);
        }
        i = 0;
        while ((long)i < data.getRowCount()) {
            Object current = data.getValueAt(i, this.selectedZ);
            double d = current.toString().equals("NaN") ? Double.NaN : Double.valueOf(current.toString());
            Object currentRow = data.getValueAt(i, this.selectedRow);
            Object currentColumn = data.getValueAt(i, this.selectedColumn);
            this.matrix[rowVec.indexOf((Object)currentRow)][colVec.indexOf((Object)currentColumn) + extraCol] = d;
            this.modelMatrix[rowVec.indexOf((Object)currentRow)][colVec.indexOf((Object)currentColumn) + extraCol] = current.toString();
            ++i;
        }
        this.min = (float)ZDoubleUtil.min((double[][])this.matrix);
        this.max = (float)ZDoubleUtil.max((double[][])this.matrix);
        this.range = this.max - this.min;
        this.S_cutoff.setValue(5000);
        this.LP_chart.getViewport().remove(this.chart);
        this.chart.setModel((TableModel)new ZTableModel((Object[][])this.modelMatrix, this.columnHeader));
        TableColumnModel cm = this.chart.getColumnModel();
        if (this.colLabels) {
            JTableHeader th = new JTableHeader(cm);
            this.chart.setAutoResizeMode(4);
            this.chart.setTableHeader(th);
        } else {
            this.chart.setAutoResizeMode(0);
            this.chart.setTableHeader(null);
        }
        for (int i3 = 0; i3 < this.columnHeader.length; ++i3) {
            TableColumn c = cm.getColumn(i3);
            c.setCellRenderer(this.rdr);
            if (this.colLabels) {
                c.setResizable(true);
            } else {
                c.setResizable(false);
            }
            c.setMinWidth(1);
        }
        this.LP_chart.getViewport().add(this.chart);
        this.CB_cellSize.setSelectedIndex(5);
        this.setStatusBar();
        return true;
    }

    private void setCellSize(int cSize) {
        this.curCellSize = cSize;
        this.redraw();
    }

    private void redraw() {
        try {
            this.chart.setRowHeight(this.curCellSize);
            this.cutoff = Float.valueOf(this.TF_cutoff.getText()).floatValue();
            TableColumnModel cm = this.chart.getColumnModel();
            for (int i = 0; i < this.columnHeader.length; ++i) {
                TableColumn c = cm.getColumn(i);
                c.setPreferredWidth(this.curCellSize);
                if (!this.rowLabels || i != 0) continue;
                c.setPreferredWidth(80);
            }
            this.chart.repaint();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void setStatusBar() {
        float minimum = (float)ZDoubleUtil.min((double[][])this.matrix);
        float maximum = (float)ZDoubleUtil.max((double[][])this.matrix);
        float mean = (float)ZDoubleUtil.mean((double[][])this.matrix);
        float sd = (float)ZDoubleUtil.sd((double[][])this.matrix);
        this.statusBar.setText("Statistics - Min: " + minimum + "  Max: " + maximum + "  Mean: " + mean + " SD: " + sd);
    }

    private void chooseBackground() {
        Color c = JColorChooser.showDialog(this, "Choose backgroud", this.chart.getBackground());
        if (c == null) {
            return;
        }
        if (!c.equals(this.chart.getBackground())) {
            this.bgColor = c;
            this.redraw();
        }
    }

    private void chooseForeground() {
        Color c = JColorChooser.showDialog(this, "Choose foregroud", this.chart.getForeground());
        if (c == null) {
            return;
        }
        if (!c.equals(this.chart.getForeground())) {
            this.fgColor = c;
            this.redraw();
        }
    }

    public void showAtCenter() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension thisSize = this.getSize();
        if (thisSize.height > screenSize.height) {
            thisSize.height = screenSize.height;
        }
        if (thisSize.width > screenSize.width) {
            thisSize.width = screenSize.width;
        }
        this.setLocation((screenSize.width - thisSize.width) / 2, (screenSize.height - thisSize.height) / 2);
        this.setVisible(true);
        this.redraw();
    }

    private void jbInit() throws Exception {
        this.setTitle("2-D chart");
        this.panel.setLayout(this.borderLayout1);
        this.statusBar.setBorder(BorderFactory.createLoweredBevelBorder());
        this.statusBar.setToolTipText("");
        this.statusBar.setText("    Statistics - ");
        this.P_toolBar.setLayout(this.borderLayout2);
        this.toolBar.setAlignmentX(0.0f);
        this.cutoffBar.setAlignmentX(0.0f);
        this.cutoffBar.setLayout(this.gridBagLayout1);
        this.L_cutoff.setText(" Cutoff  ");
        this.L_cellSize.setText(" Cell size  ");
        this.chart.setBackground(Color.white);
        this.chart.setToolTipText("");
        this.chart.setIntercellSpacing(new Dimension(0, 0));
        this.TF_cutoff.setMaximumSize(new Dimension(80, 21));
        this.TF_cutoff.setMinimumSize(new Dimension(80, 21));
        this.TF_cutoff.setPreferredSize(new Dimension(80, 21));
        this.TF_cutoff.setToolTipText("");
        this.TF_cutoff.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Grid2DDialog.this.TF_cutoff_actionPerformed(e);
            }
        });
        this.S_cutoff.setMinorTickSpacing(2000);
        this.S_cutoff.setMajorTickSpacing(10000);
        this.S_cutoff.setPaintTicks(true);
        this.S_cutoff.setMaximum(100000);
        this.S_cutoff.setToolTipText("Drag the slide to set cutoff!");
        this.S_cutoff.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Grid2DDialog.this.S_cutoff_stateChanged(e);
            }
        });
        this.C_pValueData.setText("P-Value");
        this.C_pValueData.setToolTipText("");
        this.C_pValueData.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Grid2DDialog.this.C_pValueData_actionPerformed(e);
            }
        });
        this.C_upperTriangle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Grid2DDialog.this.C_upperTriangle_actionPerformed(e);
            }
        });
        this.C_upperTriangle.setToolTipText("");
        this.C_upperTriangle.setText("only upper triangle");
        this.jLabel1.setText("Column:");
        this.jLabel2.setText("Row:");
        this.jLabel3.setText("Value:");
        this.rowComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Grid2DDialog.this.rowComboBox_actionPerformed(e);
            }
        });
        this.columnComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Grid2DDialog.this.columnComboBox_actionPerformed(e);
            }
        });
        this.valueComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Grid2DDialog.this.valueComboBox_actionPerformed(e);
            }
        });
        this.rowLabelCheckBox.setToolTipText("Show Row Labels");
        this.rowLabelCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Grid2DDialog.this.rowLabelCheckBox_actionPerformed(e);
            }
        });
        this.colLabelCheckBox.setToolTipText("Show Column Labels");
        this.colLabelCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Grid2DDialog.this.colLabelCheckBox_actionPerformed(e);
            }
        });
        this.svgButton.setMargin(new Insets(2, 2, 2, 2));
        this.svgButton.setText("Save");
        this.svgButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Grid2DDialog.this.svgButton_actionPerformed(e);
            }
        });
        this.getContentPane().add((Component)this.panel, "Center");
        this.panel.add((Component)this.LP_chart, "Center");
        this.LP_chart.getViewport().add(this.chart);
        this.panel.add((Component)this.statusBar, "South");
        this.panel.add((Component)this.P_toolBar, "North");
        this.P_toolBar.add((Component)this.toolBar, "North");
        this.P_toolBar.add((Component)this.cutoffBar, "South");
        this.toolBar.addButton("exit", "", "exit");
        this.toolBar.getButton("exit").addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Grid2DDialog.this.dispose();
            }
        });
        this.toolBar.addButton("foreground", "", "choose foreground");
        this.toolBar.getButton("foreground").addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Grid2DDialog.this.chooseForeground();
            }
        });
        this.toolBar.addButton("background", "", "choose background");
        this.toolBar.getButton("background").addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Grid2DDialog.this.chooseBackground();
            }
        });
        this.toolBar.addSep();
        this.toolBar.add((Component)this.L_cellSize, null);
        for (int i = 2; i < 20; ++i) {
            this.CB_cellSize.addItem(new Integer(i * 2));
        }
        this.CB_cellSize.setPreferredSize(new Dimension(40, 21));
        this.CB_cellSize.setMinimumSize(new Dimension(40, 21));
        this.CB_cellSize.setMaximumSize(new Dimension(40, 21));
        this.CB_cellSize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object obj = Grid2DDialog.this.CB_cellSize.getSelectedItem();
                if (obj == null) {
                    return;
                }
                Integer iobj = (Integer)obj;
                Grid2DDialog.this.setCellSize(iobj);
            }
        });
        this.toolBar.addSep();
        this.toolBar.add((Component)this.CB_cellSize);
        this.rightToolPanel.add(this.C_upperTriangle);
        this.rightToolPanel.add(this.C_pValueData);
        this.rightToolPanel.add(this.svgButton);
        this.toolBar.addButton("help", "", "cutoff for pValue data");
        this.toolBar.getButton("help").addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Grid2DDialog.this.showHelp();
            }
        });
        this.toolBar.add((Component)this.rightToolPanel);
        this.toolBar.getButton("help").setEnabled(false);
        this.cutoffBar.add((Component)this.L_cutoff, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(9, 0, 8, 0), 0, 0));
        this.cutoffBar.add((Component)this.TF_cutoff, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(6, 0, 0, 0), 0, 0));
        this.cutoffBar.add((Component)this.S_cutoff, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 20, 0));
        this.P_toolBar.add((Component)this.dataPanel, "Center");
        this.dataPanel.add((Component)this.jLabel2, null);
        this.dataPanel.add((Component)this.rowLabelCheckBox, null);
        this.rowLabelCheckBox.setSelected(true);
        this.dataPanel.add((Component)this.rowComboBox, null);
        this.dataPanel.add((Component)this.jLabel1, null);
        this.dataPanel.add((Component)this.colLabelCheckBox, null);
        this.colLabelCheckBox.setSelected(true);
        this.dataPanel.add((Component)this.columnComboBox, null);
        this.dataPanel.add((Component)this.jLabel3, null);
        this.dataPanel.add((Component)this.valueComboBox, null);
        this.C_pValueData.setSelected(true);
        this.C_pValueData_actionPerformed(null);
    }

    private void S_cutoff_stateChanged(ChangeEvent e) {
        this.redraw();
        float currentValue = this.S_cutoff.getValue();
        String str = String.valueOf(this.min + currentValue * this.range / 100000.0f);
        this.TF_cutoff.setText(str);
    }

    private void TF_cutoff_actionPerformed(ActionEvent e) {
        String currentValue = this.TF_cutoff.getText();
        try {
            float f = Float.valueOf(currentValue).floatValue();
            if (f < this.min) {
                f = this.min;
            }
            if (f > this.max) {
                f = this.max;
            }
            this.S_cutoff.setValue((int)((f - this.min) * 100000.0f / this.range));
        }
        catch (NumberFormatException ex) {
            float c = this.S_cutoff.getValue();
            this.TF_cutoff.setText(String.valueOf(this.min + c * this.range / 100000.0f));
        }
    }

    private void C_pValueData_actionPerformed(ActionEvent e) {
        if (this.C_pValueData.isSelected()) {
            this.S_cutoff.setEnabled(false);
            this.TF_cutoff.setEnabled(false);
            this.toolBar.getButton("help").setEnabled(true);
        } else {
            this.S_cutoff.setEnabled(true);
            this.TF_cutoff.setEnabled(true);
            this.toolBar.getButton("help").setEnabled(false);
        }
        this.redraw();
    }

    private void C_upperTriangle_actionPerformed(ActionEvent e) {
        this.redraw();
    }

    private void showHelp() {
        ZDialog d = new ZDialog();
        d.getContentPane().add(this.pHelp);
        d.pack();
        d.showAtCenter();
    }

    void setRowComboBox(String s) {
        this.rowComboBox.setSelectedItem(s);
        this.rowComboBox_actionPerformed(null);
    }

    void rowComboBox_actionPerformed(ActionEvent e) {
        if (this.rowComboBox.getSelectedIndex() == -1) {
            return;
        }
        this.selectedRow = this.headerVector.indexOf(this.rowComboBox.getSelectedItem());
        this.processAndSetData(this.tableHeader, this.tableData);
    }

    void setColumnComboBox(String s) {
        this.columnComboBox.setSelectedItem(s);
        this.columnComboBox_actionPerformed(null);
    }

    void columnComboBox_actionPerformed(ActionEvent e) {
        if (this.columnComboBox.getSelectedIndex() == -1) {
            return;
        }
        this.selectedColumn = this.headerVector.indexOf(this.columnComboBox.getSelectedItem());
        this.processAndSetData(this.tableHeader, this.tableData);
    }

    void setValueComboBox(String s) {
        this.valueComboBox.setSelectedItem(s);
        this.valueComboBox_actionPerformed(null);
    }

    void valueComboBox_actionPerformed(ActionEvent e) {
        if (this.valueComboBox.getSelectedIndex() == -1) {
            return;
        }
        this.selectedZ = this.headerVector.indexOf(this.valueComboBox.getSelectedItem());
        this.processAndSetData(this.tableHeader, this.tableData);
    }

    void rowLabelCheckBox_actionPerformed(ActionEvent e) {
        this.rowLabels = this.rowLabelCheckBox.isSelected();
        this.processAndSetData(this.tableHeader, this.tableData);
    }

    void colLabelCheckBox_actionPerformed(ActionEvent e) {
        this.colLabels = this.colLabelCheckBox.isSelected();
        this.processAndSetData(this.tableHeader, this.tableData);
    }

    void svgButton_actionPerformed(ActionEvent e) {
        this.theGrid2dDisplayPlugin.saveDataToFile(this.LP_chart);
    }

    Component getChart() {
        this.redraw();
        return this.LP_chart;
    }

    private class pValueHelp
    extends JPanel {
        public pValueHelp() {
            this.setLayout(new GridLayout(4, 1));
            JPanel p1 = new JPanel();
            DefaultTableCellRenderer label1 = new DefaultTableCellRenderer();
            label1.setPreferredSize(new Dimension(18, 18));
            ((JComponent)label1).setBackground(Grid2DDialog.this.color1);
            p1.add(label1);
            p1.add(new JLabel(" < 0.001"));
            p1.setLayout(new FlowLayout(0));
            this.add(p1);
            JPanel p2 = new JPanel();
            DefaultTableCellRenderer label2 = new DefaultTableCellRenderer();
            label2.setPreferredSize(new Dimension(18, 18));
            ((JComponent)label2).setBackground(Grid2DDialog.this.color2);
            p2.add(label2);
            p2.add(new JLabel(" 0.001 - 0.01"));
            p2.setLayout(new FlowLayout(0));
            this.add(p2);
            JPanel p3 = new JPanel();
            DefaultTableCellRenderer label3 = new DefaultTableCellRenderer();
            label3.setPreferredSize(new Dimension(18, 18));
            ((JComponent)label3).setBackground(Grid2DDialog.this.color3);
            p3.add(label3);
            p3.add(new JLabel(" 0.01 - 0.05"));
            p3.setLayout(new FlowLayout(0));
            this.add(p3);
            JPanel p4 = new JPanel();
            DefaultTableCellRenderer label4 = new DefaultTableCellRenderer();
            label4.setPreferredSize(new Dimension(18, 18));
            ((JComponent)label4).setBackground(Grid2DDialog.this.color4);
            p4.add(label4);
            p4.add(new JLabel(" > 0.05"));
            p4.setLayout(new FlowLayout(0));
            this.add(p4);
        }
    }

    private class MyRenderer
    extends DefaultTableCellRenderer {
        private Border border1 = new LineBorder(new Color(214, 214, 214), 1);
        private Border border2 = new LineBorder(Color.white, 1);

        private MyRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setBorder(this.border1);
            this.setToolTipText(Grid2DDialog.this.rowHeader[row] + ":" + Grid2DDialog.this.columnHeader[column] + "(" + value.toString() + ")");
            if (Grid2DDialog.this.rowLabels && column == 0) {
                this.setText(value.toString());
                this.setBackground(Color.white);
                return this;
            }
            this.setText("");
            if (Grid2DDialog.this.C_upperTriangle.isSelected() && row > column) {
                this.setBorder(this.border2);
                this.setBackground(Color.white);
                return this;
            }
            if (Double.isNaN(Grid2DDialog.this.matrix[row][column])) {
                this.setBackground(Color.lightGray);
                return this;
            }
            if (!Grid2DDialog.this.C_pValueData.isSelected()) {
                if (Grid2DDialog.this.matrix[row][column] >= (double)Grid2DDialog.this.cutoff) {
                    this.setBackground(Grid2DDialog.this.fgColor);
                } else {
                    this.setBackground(Grid2DDialog.this.bgColor);
                }
            } else if (Grid2DDialog.this.matrix[row][column] <= 0.001) {
                this.setBackground(Grid2DDialog.this.color1);
            } else if (Grid2DDialog.this.matrix[row][column] <= 0.01) {
                this.setBackground(Grid2DDialog.this.color2);
            } else if (Grid2DDialog.this.matrix[row][column] <= 0.05) {
                this.setBackground(Grid2DDialog.this.color3);
            } else {
                this.setBackground(Grid2DDialog.this.color4);
            }
            return this;
        }
    }
}

