/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.chart;

import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import java.net.URL;
import java.util.List;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.chart.AbstractDisplayPlugin;
import net.maizegenetics.analysis.chart.Grid2DDialog;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.util.TableReport;

public class Grid2dDisplayPlugin
extends AbstractDisplayPlugin {
    String defaultRow = "Site";
    String defaultCol = "Environment";
    String defaultValue = "PermuteP";

    public Grid2dDisplayPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    public DataSet performFunction(DataSet input) {
        List<Datum> tableInList = input.getDataOfType(TableReport.class);
        for (int i = 0; i < tableInList.size(); ++i) {
            Grid2DDialog myDialog;
            TableReport theTableReport = (TableReport)tableInList.get(i).getData();
            if (this.isInteractive()) {
                myDialog = new Grid2DDialog(this, theTableReport);
                myDialog.setRowComboBox(this.defaultRow);
                myDialog.setColumnComboBox(this.defaultCol);
                myDialog.setValueComboBox(this.defaultValue);
                myDialog.setLocationRelativeTo(this.getParentFrame());
                myDialog.setVisible(true);
                continue;
            }
            if (this.getSaveFile() == null) continue;
            System.out.println("Grid2dDisplayPlugin not fully functional");
            myDialog = new Grid2DDialog(this, theTableReport);
            myDialog.setRowComboBox(this.defaultRow);
            myDialog.setColumnComboBox(this.defaultCol);
            myDialog.setValueComboBox(this.defaultValue);
            myDialog.setLocationRelativeTo(this.getParentFrame());
            myDialog.setVisible(true);
            Component c = myDialog.getChart();
            c.setSize(this.getImageWidth(), this.getImageHeight());
            File tempFile = this.getSaveFile();
            if (tableInList.size() > 1) {
                tempFile = new File(this.getSaveFile().getParent(), i + "_" + this.getSaveFile().getName());
            }
            this.saveDataToFile(c, tempFile);
        }
        return null;
    }

    public String getDefaultRow() {
        return this.defaultRow;
    }

    public void setDefaultRow(String defaultRow) {
        this.defaultRow = defaultRow;
    }

    public String getDefaultCol() {
        return this.defaultCol;
    }

    public void setDefaultCol(String defaultCol) {
        this.defaultCol = defaultCol;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public ImageIcon getIcon() {
        URL imageURL = Grid2dDisplayPlugin.class.getResource("/net/maizegenetics/analysis/images/2DPlot.gif");
        if (imageURL == null) {
            return null;
        }
        return new ImageIcon(imageURL);
    }

    @Override
    public String getButtonName() {
        return "2D Plot";
    }

    @Override
    public String getToolTipText() {
        return "Display a 2-D Plot of Table Data";
    }
}

