/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.chart;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import net.maizegenetics.analysis.chart.BasicChartPanel;
import net.maizegenetics.util.TableReport;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.statistics.HistogramDataset;
import org.jfree.data.statistics.HistogramType;
import org.jfree.data.xy.IntervalXYDataset;

public class HistogramPanel
extends BasicChartPanel {
    BorderLayout borderLayout1 = new BorderLayout();
    IntervalXYDataset dataset;
    ChartPanel chartPanel;
    TableReport theTable;
    JPanel controlPanel = new JPanel();
    JComboBox series1ComboBox;
    JComboBox series2ComboBox;
    JLabel jLabel1 = new JLabel();
    JLabel jLabel2 = new JLabel();
    JTextField binsTextField = new JTextField();
    JLabel jLabel3 = new JLabel();
    String[] columnNames;
    int bins = 5;
    GridBagLayout gridBagLayout1 = new GridBagLayout();

    public HistogramPanel(TableReport theTable) {
        this.theTable = theTable;
        try {
            Object[] colNames = theTable.getTableColumnNames();
            this.columnNames = new String[colNames.length + 1];
            this.columnNames[0] = "None";
            for (int i = 1; i < this.columnNames.length; ++i) {
                this.columnNames[i] = (String)colNames[i - 1];
            }
            this.dataset = null;
            this.chart = this.createChart(this.dataset);
            this.chartPanel = new ChartPanel(this.chart);
            this.chartPanel.setPreferredSize(new Dimension(500, 270));
            this.chartPanel.setMouseZoomable(true, false);
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public HistogramPanel(TableReport theTable, int series1, int series2, int bins) {
        this.theTable = theTable;
        try {
            this.bins = bins;
            this.dataset = this.createDataset(series1, series2);
            this.chart = this.createChart(this.dataset);
            this.chartPanel = new ChartPanel(this.chart);
            this.chartPanel.setPreferredSize(new Dimension(500, 270));
            this.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.controlPanel.setLayout(this.gridBagLayout1);
        this.jLabel1.setText("Series 2");
        this.jLabel2.setText("Series 1");
        this.series1ComboBox = new JComboBox<String>(this.columnNames);
        this.series2ComboBox = new JComboBox<String>(this.columnNames);
        this.binsTextField.setText("" + this.bins);
        this.binsTextField.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                HistogramPanel.this.binsTextField_caretUpdate(e);
            }
        });
        this.binsTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HistogramPanel.this.binsTextField_actionPerformed(e);
            }
        });
        this.jLabel3.setText("Bins");
        this.series1ComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HistogramPanel.this.series1ComboBox_actionPerformed(e);
            }
        });
        this.series2ComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HistogramPanel.this.series2ComboBox_actionPerformed(e);
            }
        });
        this.add((Component)this.chartPanel, "Center");
        this.add((Component)this.controlPanel, "North");
        this.controlPanel.add((Component)this.jLabel2, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 3, -4));
        this.controlPanel.add((Component)this.binsTextField, new GridBagConstraints(5, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 4), 23, 0));
        this.controlPanel.add((Component)this.jLabel3, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 6, -1));
        this.controlPanel.add((Component)this.series1ComboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 84, 0));
        this.controlPanel.add((Component)this.series2ComboBox, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 80, 0));
        this.controlPanel.add((Component)this.jLabel1, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 3, -4));
    }

    IntervalXYDataset createDataset(int series1Column, int series2Column) {
        double[] series2Data;
        double[] series1Data;
        HistogramDataset dataset = new HistogramDataset();
        dataset.setType(HistogramType.FREQUENCY);
        Object[] theNames = this.theTable.getTableColumnNames();
        if (series1Column >= 0 && (series1Data = this.getFilteredNumericData(series1Column)).length > 0) {
            dataset.addSeries((Comparable)((Object)((String)theNames[series1Column])), series1Data, this.bins);
        }
        if (series2Column >= 0 && (series2Data = this.getFilteredNumericData(series2Column)).length > 0) {
            dataset.addSeries((Comparable)((Object)((String)theNames[series2Column])), series2Data, this.bins);
        }
        return dataset;
    }

    double[] getFilteredNumericData(int column) {
        int countGood = 0;
        int numRows = (int)this.theTable.getRowCount();
        double[] tempData = new double[numRows];
        for (int i = 0; i < numRows; ++i) {
            try {
                double d = Double.valueOf(this.theTable.getValueAt(i, column).toString());
                if (Double.isNaN(d)) continue;
                tempData[countGood] = d;
                ++countGood;
                continue;
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        double[] theGoodData = new double[countGood];
        for (int i = 0; i < countGood; ++i) {
            theGoodData[i] = tempData[i];
        }
        return theGoodData;
    }

    JFreeChart createChart(IntervalXYDataset dataset) {
        String name = "Non-numeric choice";
        if (dataset == null) {
            name = "Non-numeric choice";
        } else if (dataset.getSeriesCount() == 1) {
            name = dataset.getSeriesKey(0) + " Distribution";
        } else if (dataset.getSeriesCount() == 2) {
            name = dataset.getSeriesKey(0) + " & " + dataset.getSeriesKey(1) + " Distribution";
        }
        JFreeChart chart = ChartFactory.createHistogram((String)name, null, null, (IntervalXYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        chart.getXYPlot().setForegroundAlpha(0.75f);
        return chart;
    }

    void updateChart() {
        int series1 = this.series1ComboBox.getSelectedIndex() - 1;
        int series2 = this.series2ComboBox.getSelectedIndex() - 1;
        this.dataset = this.createDataset(series1, series2);
        this.chart = this.createChart(this.dataset);
        this.chartPanel.setChart(this.chart);
    }

    void series1ComboBox_actionPerformed(ActionEvent e) {
        this.updateChart();
    }

    void series2ComboBox_actionPerformed(ActionEvent e) {
        this.updateChart();
    }

    void binsTextField_actionPerformed(ActionEvent e) {
        try {
            int newbin;
            this.bins = newbin = Integer.parseInt(this.binsTextField.getText());
            this.updateChart();
        }
        catch (NumberFormatException ex) {
            this.binsTextField.setText("" + this.bins);
        }
    }

    void binsTextField_caretUpdate(CaretEvent e) {
        this.binsTextField_actionPerformed(null);
    }

    @Override
    public JComponent getMainComponent() {
        return this.chartPanel;
    }
}

