/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.chart;

import java.util.ArrayList;
import java.util.Vector;
import net.maizegenetics.util.TableReport;
import org.jfree.data.statistics.DefaultStatisticalCategoryDataset;
import org.jfree.data.statistics.Statistics;

public class TableReportStatCategoryDataset
extends DefaultStatisticalCategoryDataset {
    String[] seriesNames;
    boolean useStderr = false;

    public TableReportStatCategoryDataset(TableReport theTable, int seriesCategory, int[] seriesY) {
        this.setTableReport(theTable, seriesCategory, seriesY);
    }

    public TableReportStatCategoryDataset(TableReport theTable, int seriesCategory, int[] seriesY, boolean stderr) {
        this.useStderr = stderr;
        this.setTableReport(theTable, seriesCategory, seriesY);
    }

    public boolean setTableReport(TableReport theTable, int seriesCategory, int[] seriesY) {
        int i;
        Vector<Object> theCategories = new Vector<Object>();
        this.seriesNames = new String[seriesY.length];
        Object[] theSN = theTable.getTableColumnNames();
        for (int x = 0; x < seriesY.length; ++x) {
            this.seriesNames[x] = theSN[seriesY[x]].toString();
        }
        int i2 = 0;
        while ((long)i2 < theTable.getRowCount()) {
            Object current = theTable.getValueAt(i2, seriesCategory);
            if (!theCategories.contains(current)) {
                theCategories.add(current);
            }
            ++i2;
        }
        ArrayList[][] catData = new ArrayList[theCategories.size()][seriesY.length];
        for (i = 0; i < theCategories.size(); ++i) {
            for (int x = 0; x < seriesY.length; ++x) {
                catData[i][x] = new ArrayList();
            }
        }
        i = 0;
        while ((long)i < theTable.getRowCount()) {
            Object[] currentRow = theTable.getRow(i);
            int cat = theCategories.indexOf(currentRow[seriesCategory]);
            for (int x = 0; x < seriesY.length; ++x) {
                try {
                    Double d = new Double(currentRow[seriesY[x]].toString());
                    if (d.isNaN()) continue;
                    catData[cat][x].add(d);
                    continue;
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
            }
            ++i;
        }
        for (i = 0; i < theCategories.size(); ++i) {
            for (int x = 0; x < seriesY.length; ++x) {
                Number[] d = new Double[catData[i][x].size()];
                for (int di = 0; di < d.length; ++di) {
                    d[di] = (Double)catData[i][x].get(di);
                }
                double mean = Statistics.calculateMean((Number[])d);
                double stdev = Statistics.getStdDev((Number[])d);
                double stderr = stdev / Math.sqrt(d.length);
                if (Double.isNaN(mean) || Double.isNaN(stdev)) continue;
                if (this.useStderr) {
                    this.add(mean, stderr, (Comparable)((Object)this.seriesNames[x]), (Comparable)((Object)theCategories.get(i).toString()));
                    continue;
                }
                this.add(mean, stdev, (Comparable)((Object)this.seriesNames[x]), (Comparable)((Object)theCategories.get(i).toString()));
            }
        }
        return true;
    }
}

