/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.chart;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import net.maizegenetics.analysis.chart.BasicChartPanel;
import net.maizegenetics.analysis.chart.QQDisplayPlugin;
import net.maizegenetics.analysis.chart.TableReportQQDataset;
import net.maizegenetics.analysis.chart.XYAndLineToolTipGenerator;
import net.maizegenetics.util.TableReport;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.function.Function2D;
import org.jfree.data.function.LineFunction2D;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.data.xy.XYDataset;

public class XYScatterAndLinePanel
extends BasicChartPanel {
    QQDisplayPlugin myQQDisplayPlugin;
    ChartPanel myChartPanel;
    JButton saveButton = new JButton("save...");
    TableReportQQDataset[] datasets;
    TableReport myTableReport;

    public XYScatterAndLinePanel(QQDisplayPlugin plugin, TableReport table, int countToDisplay, ArrayList<Integer> tableIndices, int[] indices) {
        int i;
        this.myQQDisplayPlugin = plugin;
        this.myTableReport = table;
        this.datasets = new TableReportQQDataset[indices.length];
        for (i = 0; i < this.datasets.length; ++i) {
            this.datasets[i] = new TableReportQQDataset(table, tableIndices.get(indices[i] * 2), tableIndices.get(indices[i] * 2 + 1), countToDisplay);
        }
        try {
            this.chart = this.createChart(this.datasets[0]);
            this.myChartPanel = new ChartPanel(this.chart);
            this.myChartPanel.setPreferredSize(new Dimension(900, 500));
            for (i = 1; i < this.datasets.length; ++i) {
                this.addSeries(this.chart.getXYPlot(), (XYDataset)this.datasets[i], i);
            }
            this.createLine(this.chart.getXYPlot(), (XYDataset)this.datasets[0], 0, Color.BLACK);
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new BoxLayout(this, 3));
        this.add((Component)this.myChartPanel);
        this.saveButton.setAlignmentX(1.0f);
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XYScatterAndLinePanel.this.saveButton_actionPerformed(e);
            }
        });
        this.add(this.saveButton);
    }

    private void saveButton_actionPerformed(ActionEvent e) {
        this.myQQDisplayPlugin.saveDataToFile((Component)this.myChartPanel);
    }

    public JFreeChart createChart(TableReportQQDataset dataset) {
        String name = "Please select numeric variables";
        String xName = "X";
        String y1Name = "Y";
        String y2Name = "Y2";
        if (dataset != null) {
            xName = dataset.getXName();
            y1Name = "-Log10(P-Value)";
            name = xName + " vs. " + y1Name;
            if (dataset.getSeriesCount() == 2) {
                y2Name = dataset.getSeriesName(1);
                name = name + " and " + y2Name;
            }
        }
        this.chart = ChartFactory.createScatterPlot((String)name, (String)xName, (String)y1Name, (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        this.chart.getXYPlot().setForegroundAlpha(0.75f);
        this.chart.getXYPlot().getRenderer().setToolTipGenerator((XYToolTipGenerator)new XYAndLineToolTipGenerator());
        return this.chart;
    }

    private void createLine(XYPlot plot, XYDataset data, int series, Color theColor) {
        LineFunction2D curve = new LineFunction2D(0.0, 1.0);
        double max = DatasetUtilities.findMaximumDomainValue((XYDataset)data).doubleValue();
        double min = DatasetUtilities.findMinimumDomainValue((XYDataset)data).doubleValue();
        XYDataset regressionData = DatasetUtilities.sampleFunction2D((Function2D)curve, (double)min, (double)max, (int)2, (Comparable)((Object)"Expected Values"));
        int datasetCount = plot.getDatasetCount();
        plot.setDataset(datasetCount, regressionData);
        StandardXYItemRenderer renderer2 = new StandardXYItemRenderer(2);
        renderer2.setSeriesPaint(0, (Paint)theColor);
        plot.setRenderer(datasetCount, (XYItemRenderer)renderer2);
        this.setAxis(plot, max, min);
    }

    private void addSeries(XYPlot plot, XYDataset data, int index) {
        plot.setDataset(index, data);
        XYLineAndShapeRenderer renderer2 = new XYLineAndShapeRenderer();
        renderer2.setBaseShapesVisible(true);
        renderer2.setBaseLinesVisible(false);
        renderer2.setToolTipGenerator((XYToolTipGenerator)new XYAndLineToolTipGenerator());
        plot.setRenderer(index, (XYItemRenderer)renderer2);
    }

    private void setAxis(XYPlot plot, double domainMax, double domainMin) {
        ValueAxis xAxis = plot.getDomainAxis();
        ValueAxis yAxis = plot.getRangeAxis();
        double xMax = domainMax;
        double xMin = domainMin;
        double yMax = yAxis.getUpperBound();
        double yMin = yAxis.getLowerBound();
        xAxis.setRange(0.0, xMax);
        yAxis.setRange(0.0, yMax);
        plot.setDomainAxis(xAxis);
        plot.setRangeAxis(yAxis);
    }

    @Override
    public JComponent getMainComponent() {
        return this.myChartPanel;
    }

    public ArrayList<Integer> splitTable(TableReport table) {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        int numRows = (int)table.getRowCount();
        String previousTrait = "";
        for (int i = 0; i < numRows; ++i) {
            if (previousTrait.equals((String)table.getValueAt(i, 0))) continue;
            if (!((String)table.getValueAt(i, 1)).equals("None")) {
                indexes.add(new Integer(i));
                previousTrait = (String)table.getValueAt(i, 0);
                if (i <= 1) continue;
                indexes.add(new Integer(i));
                continue;
            }
            if (i == 0) continue;
            indexes.add(new Integer(i));
            indexes.add(new Integer(i + 1));
            previousTrait = (String)table.getValueAt(i + 1, 0);
        }
        indexes.add(new Integer(numRows));
        return indexes;
    }
}

