/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.clustering;

import net.maizegenetics.dna.snp.GenotypeTableUtils;
import net.maizegenetics.dna.snp.NucleotideAlignmentConstants;

public class Haplotype
implements Comparable<Haplotype> {
    private static byte AC = NucleotideAlignmentConstants.getNucleotideDiploidByte("AC");
    private static byte AG = NucleotideAlignmentConstants.getNucleotideDiploidByte("AG");
    private static byte AT = NucleotideAlignmentConstants.getNucleotideDiploidByte("AT");
    private static byte CG = NucleotideAlignmentConstants.getNucleotideDiploidByte("CG");
    private static byte CT = NucleotideAlignmentConstants.getNucleotideDiploidByte("CT");
    private static byte GT = NucleotideAlignmentConstants.getNucleotideDiploidByte("GT");
    private static byte CA = NucleotideAlignmentConstants.getNucleotideDiploidByte("CA");
    private static byte GA = NucleotideAlignmentConstants.getNucleotideDiploidByte("GA");
    private static byte TA = NucleotideAlignmentConstants.getNucleotideDiploidByte("TA");
    private static byte GC = NucleotideAlignmentConstants.getNucleotideDiploidByte("GC");
    private static byte TC = NucleotideAlignmentConstants.getNucleotideDiploidByte("TC");
    private static byte TG = NucleotideAlignmentConstants.getNucleotideDiploidByte("TG");
    public byte[] seq;
    public int notMissingCount;
    public int seqlen;
    public static final byte N = NucleotideAlignmentConstants.getNucleotideDiploidByte("N");
    public int taxonIndex;

    public Haplotype(byte[] hap, int taxon) {
        this.seq = this.makeHetsConsistent(hap);
        this.seqlen = this.seq.length;
        this.countNotMissing();
        this.taxonIndex = taxon;
    }

    public Haplotype(byte[] hap) {
        this(hap, -1);
    }

    public byte[] makeHetsConsistent(byte[] seqIn) {
        int n = seqIn.length;
        byte[] seqOut = new byte[n];
        for (int i = 0; i < n; ++i) {
            byte val = seqIn[i];
            if (val == CA) {
                val = AC;
            } else if (val == GA) {
                val = AG;
            } else if (val == TA) {
                val = AT;
            } else if (val == GC) {
                val = CG;
            } else if (val == TC) {
                val = CT;
            } else if (val == TG) {
                val = GT;
            }
            seqOut[i] = val;
        }
        return seqOut;
    }

    public void countNotMissing() {
        this.notMissingCount = 0;
        for (byte b : this.seq) {
            if (b == N) continue;
            ++this.notMissingCount;
        }
    }

    @Override
    public int compareTo(Haplotype arg0) {
        if (this.notMissingCount > arg0.notMissingCount) {
            return -1;
        }
        if (this.notMissingCount < arg0.notMissingCount) {
            return 1;
        }
        return 0;
    }

    public int distanceFrom(Haplotype h0) {
        return Haplotype.getDistance(this.seq, h0.seq);
    }

    public static int getDistance(Haplotype hap0, Haplotype hap1) {
        return hap0.distanceFrom(hap1);
    }

    public static int getDistance(byte[] hap0, byte[] hap1) {
        int d = 0;
        int n = hap0.length;
        for (int s = 0; s < n; ++s) {
            byte b0 = hap0[s];
            byte b1 = hap1[s];
            if (b0 == b1 || b0 == N || b1 == N) continue;
            if (GenotypeTableUtils.isHeterozygous(b0)) {
                if (GenotypeTableUtils.isHeterozygous(b1)) continue;
                ++d;
                continue;
            }
            if (GenotypeTableUtils.isHeterozygous(b1)) {
                ++d;
                continue;
            }
            d += 2;
        }
        return d;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (byte b : this.seq) {
            sb.append(NucleotideAlignmentConstants.getNucleotideIUPAC(b));
        }
        return sb.toString();
    }
}

