/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.data;

import ch.systemsx.cisd.hdf5.HDF5Factory;
import ch.systemsx.cisd.hdf5.IHDF5Reader;
import java.awt.Component;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import net.maizegenetics.analysis.data.FileLoadPluginDialog;
import net.maizegenetics.analysis.data.MigrateHDF5FromT4T5;
import net.maizegenetics.analysis.data.PlinkLoadPlugin;
import net.maizegenetics.analysis.data.ProjectionLoadPlugin;
import net.maizegenetics.dna.map.TOPMUtils;
import net.maizegenetics.dna.snp.ImportUtils;
import net.maizegenetics.dna.snp.ReadPolymorphismUtils;
import net.maizegenetics.dna.snp.ReadSequenceAlignmentUtils;
import net.maizegenetics.gui.DialogUtils;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginEvent;
import net.maizegenetics.prefs.TasselPrefs;
import net.maizegenetics.taxa.distance.ReadDistanceMatrix;
import net.maizegenetics.trait.ReadPhenotypeUtils;
import net.maizegenetics.util.ExceptionUtils;
import net.maizegenetics.util.HDF5TableReport;
import net.maizegenetics.util.HDF5Utils;
import net.maizegenetics.util.Report;
import net.maizegenetics.util.TableReportUtils;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;

public class FileLoadPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(FileLoadPlugin.class);
    private String[] myOpenFiles = null;
    private TasselFileType myFileType = TasselFileType.Unknown;
    private PlinkLoadPlugin myPlinkLoadPlugin = null;
    private ProjectionLoadPlugin myProjectionLoadPlugin = null;
    private JFileChooser myOpenFileChooser = new JFileChooser(TasselPrefs.getOpenDir());
    public static final String FILE_EXT_HAPMAP = ".hmp.txt";
    public static final String FILE_EXT_HAPMAP_GZ = ".hmp.txt.gz";
    public static final String FILE_EXT_PLINK_MAP = ".plk.map";
    public static final String FILE_EXT_PLINK_PED = ".plk.ped";
    public static final String FILE_EXT_SERIAL_GZ = ".serial.gz";
    public static final String FILE_EXT_HDF5 = ".h5";
    public static final String FILE_EXT_VCF = ".vcf";
    public static final String FILE_EXT_TOPM = ".topm";
    public static final String FILE_EXT_TOPM_H5 = ".topm.h5";
    public static final String FILE_EXT_FASTA = ".fasta";

    public FileLoadPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    public FileLoadPlugin(Frame parentFrame, boolean isInteractive, PlinkLoadPlugin plinkLoadPlugin, ProjectionLoadPlugin projectionLoadPlugin) {
        super(parentFrame, isInteractive);
        this.myPlinkLoadPlugin = plinkLoadPlugin;
        this.myProjectionLoadPlugin = projectionLoadPlugin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSet performFunction(DataSet input) {
        try {
            FileLoadPluginDialog theDialog;
            if (this.isInteractive()) {
                theDialog = new FileLoadPluginDialog();
                theDialog.setLocationRelativeTo(this.getParentFrame());
                theDialog.setVisible(true);
                if (theDialog.isCancel()) {
                    DataSet dataSet = null;
                    return dataSet;
                }
                this.myFileType = theDialog.getTasselFileType();
                if (this.myFileType == TasselFileType.Plink) {
                    DataSet dataSet = this.myPlinkLoadPlugin.performFunction(null);
                    return dataSet;
                }
                if (this.myFileType == TasselFileType.ProjectionAlignment) {
                    DataSet dataSet = this.myProjectionLoadPlugin.performFunction(input);
                    return dataSet;
                }
                this.setOpenFiles(this.getOpenFilesByChooser());
                theDialog.dispose();
            }
            if (this.myOpenFiles == null || this.myOpenFiles.length == 0) {
                theDialog = null;
                return theDialog;
            }
            ArrayList<DataSet> result = new ArrayList<DataSet>();
            ArrayList<String> alreadyLoaded = new ArrayList<String>();
            for (int i = 0; i < this.myOpenFiles.length; ++i) {
                if (alreadyLoaded.contains(this.myOpenFiles[i])) continue;
                DataSet tds = null;
                try {
                    if (this.myFileType == TasselFileType.Unknown) {
                        if (this.myOpenFiles[i].endsWith(FILE_EXT_HAPMAP) || this.myOpenFiles[i].endsWith(FILE_EXT_HAPMAP_GZ)) {
                            myLogger.info((Object)("guessAtUnknowns: type: " + (Object)((Object)TasselFileType.Hapmap)));
                            alreadyLoaded.add(this.myOpenFiles[i]);
                            tds = this.processDatum(this.myOpenFiles[i], TasselFileType.Hapmap);
                        } else if (this.myOpenFiles[i].endsWith(FILE_EXT_TOPM_H5) || this.myOpenFiles[i].endsWith(FILE_EXT_TOPM)) {
                            myLogger.info((Object)("guessAtUnknowns: type: " + (Object)((Object)TasselFileType.TOPM)));
                            alreadyLoaded.add(this.myOpenFiles[i]);
                            tds = this.processDatum(this.myOpenFiles[i], TasselFileType.TOPM);
                        } else if (this.myOpenFiles[i].endsWith(FILE_EXT_PLINK_PED)) {
                            myLogger.info((Object)("guessAtUnknowns: type: " + (Object)((Object)TasselFileType.Plink)));
                            String theMapFile = this.myOpenFiles[i].replaceFirst(FILE_EXT_PLINK_PED, FILE_EXT_PLINK_MAP);
                            alreadyLoaded.add(this.myOpenFiles[i]);
                            alreadyLoaded.add(theMapFile);
                            this.myPlinkLoadPlugin.loadFile(this.myOpenFiles[i], theMapFile, null);
                        } else if (this.myOpenFiles[i].endsWith(FILE_EXT_PLINK_MAP)) {
                            myLogger.info((Object)("guessAtUnknowns: type: " + (Object)((Object)TasselFileType.Plink)));
                            String thePedFile = this.myOpenFiles[i].replaceFirst(FILE_EXT_PLINK_MAP, FILE_EXT_PLINK_PED);
                            alreadyLoaded.add(this.myOpenFiles[i]);
                            alreadyLoaded.add(thePedFile);
                            this.myPlinkLoadPlugin.loadFile(thePedFile, this.myOpenFiles[i], null);
                        } else if (this.myOpenFiles[i].endsWith(FILE_EXT_SERIAL_GZ)) {
                            myLogger.info((Object)("guessAtUnknowns: type: " + (Object)((Object)TasselFileType.Serial)));
                            alreadyLoaded.add(this.myOpenFiles[i]);
                            tds = this.processDatum(this.myOpenFiles[i], TasselFileType.Serial);
                        } else if (this.myOpenFiles[i].endsWith(FILE_EXT_HDF5)) {
                            myLogger.info((Object)("guessAtUnknowns: type: " + (Object)((Object)TasselFileType.HDF5)));
                            alreadyLoaded.add(this.myOpenFiles[i]);
                            tds = this.processDatum(this.myOpenFiles[i], TasselFileType.HDF5);
                        } else if (this.myOpenFiles[i].endsWith(FILE_EXT_VCF) || this.myOpenFiles[i].endsWith(".vcf.gz")) {
                            myLogger.info((Object)("guessAtUnknowns: type: " + (Object)((Object)TasselFileType.VCF)));
                            alreadyLoaded.add(this.myOpenFiles[i]);
                            tds = this.processDatum(this.myOpenFiles[i], TasselFileType.VCF);
                        } else if (this.myOpenFiles[i].endsWith(FILE_EXT_FASTA) || this.myOpenFiles[i].endsWith(".fasta.gz")) {
                            myLogger.info((Object)("guessAtUnknowns: type: " + (Object)((Object)TasselFileType.Fasta)));
                            alreadyLoaded.add(this.myOpenFiles[i]);
                            tds = this.processDatum(this.myOpenFiles[i], TasselFileType.Fasta);
                        } else {
                            alreadyLoaded.add(this.myOpenFiles[i]);
                            tds = this.guessAtUnknowns(this.myOpenFiles[i]);
                        }
                    } else {
                        alreadyLoaded.add(this.myOpenFiles[i]);
                        tds = this.processDatum(this.myOpenFiles[i], this.myFileType);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    StringBuilder builder = new StringBuilder();
                    builder.append("Error loading: ");
                    builder.append(this.myOpenFiles[i]);
                    builder.append("\n");
                    builder.append(Utils.shortenStrLineLen(ExceptionUtils.getExceptionCauses(e), 50));
                    String str = builder.toString();
                    if (this.isInteractive()) {
                        DialogUtils.showError(str, (Component)this.getParentFrame());
                    }
                    myLogger.error((Object)str);
                }
                if (tds == null) continue;
                result.add(tds);
                this.fireDataSetReturned(new PluginEvent(tds, FileLoadPlugin.class));
            }
            DataSet dataSet = DataSet.getDataSet(result, this);
            return dataSet;
        }
        finally {
            this.fireProgress(100);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DataSet guessAtUnknowns(String filename) {
        TasselFileType guess = TasselFileType.Sequence;
        DataSet tds = null;
        try {
            BufferedReader br;
            block29: {
                String[] sval2;
                String[] sval1;
                String line1;
                block23: {
                    boolean isMap;
                    boolean isNumeric;
                    boolean isMarker;
                    boolean isTrait;
                    block26: {
                        Pattern tagPattern;
                        block24: {
                            String[] info2;
                            block28: {
                                block27: {
                                    block25: {
                                        br = null;
                                        if (filename.startsWith("http")) {
                                            URL url = new URL(filename);
                                            br = new BufferedReader(new InputStreamReader(url.openStream()));
                                        } else {
                                            br = new BufferedReader(new FileReader(filename));
                                        }
                                        line1 = br.readLine().trim();
                                        sval1 = line1.split("\\s");
                                        String line2 = br.readLine().trim();
                                        sval2 = line2.split("\\s");
                                        if (!line1.startsWith("<") && !line1.startsWith("#")) break block23;
                                        isTrait = false;
                                        isMarker = false;
                                        isNumeric = false;
                                        isMap = false;
                                        tagPattern = Pattern.compile("[<>\\s]+");
                                        String[] info1 = tagPattern.split(line1);
                                        info2 = tagPattern.split(line2);
                                        if (info1.length > 1) {
                                            if (info1[1].toUpperCase().startsWith("MARKER")) {
                                                isMarker = true;
                                            } else if (info1[1].toUpperCase().startsWith("TRAIT")) {
                                                isTrait = true;
                                            } else if (info1[1].toUpperCase().startsWith("NUMER")) {
                                                isNumeric = true;
                                            } else if (info1[1].toUpperCase().startsWith("MAP")) {
                                                isMap = true;
                                            }
                                        }
                                        if (info2.length <= 1) break block24;
                                        if (!info2[1].toUpperCase().startsWith("MARKER")) break block25;
                                        isMarker = true;
                                        break block26;
                                    }
                                    if (!info2[1].toUpperCase().startsWith("TRAIT")) break block27;
                                    isTrait = true;
                                    break block26;
                                }
                                if (!info2[1].toUpperCase().startsWith("NUMER")) break block28;
                                isNumeric = true;
                                break block26;
                            }
                            if (!info2[1].toUpperCase().startsWith("MAP")) break block26;
                            isMap = true;
                            break block26;
                        }
                        guess = null;
                        String inline = br.readLine();
                        while (guess == null && inline != null && (inline.startsWith("#") || inline.startsWith("<"))) {
                            if (!inline.startsWith("<")) continue;
                            String[] info = tagPattern.split(inline);
                            if (info[1].toUpperCase().startsWith("MARKER")) {
                                isMarker = true;
                                continue;
                            }
                            if (info[1].toUpperCase().startsWith("TRAIT")) {
                                isTrait = true;
                                continue;
                            }
                            if (info[1].toUpperCase().startsWith("NUMER")) {
                                isNumeric = true;
                                continue;
                            }
                            if (!info[1].toUpperCase().startsWith("MAP")) continue;
                            isMap = true;
                        }
                    }
                    if (isTrait || isMarker && isNumeric) {
                        guess = TasselFileType.Phenotype;
                    } else {
                        if (!isMap) throw new IOException("Improperly formatted header. Data will not be imported.");
                        guess = TasselFileType.GeneticMap;
                    }
                    break block29;
                }
                if (line1.startsWith(">") || line1.startsWith(";")) {
                    guess = TasselFileType.Fasta;
                } else if (sval1.length == 1) {
                    guess = TasselFileType.SqrMatrix;
                } else if (line1.startsWith("#Nexus") || line1.startsWith("#NEXUS") || line1.startsWith("CLUSTAL") || sval1.length == 2 && sval2.length == 2) {
                    guess = TasselFileType.Sequence;
                }
            }
            myLogger.info((Object)("guessAtUnknowns: type: " + (Object)((Object)guess)));
            tds = this.processDatum(filename, guess);
            br.close();
            return tds;
        }
        catch (Exception e) {
            // empty catch block
        }
        return tds;
    }

    private DataSet processDatum(String inFile, TasselFileType theFT) {
        Object result = null;
        String suffix = null;
        try {
            switch (theFT) {
                case Hapmap: {
                    suffix = FILE_EXT_HAPMAP;
                    if (inFile.endsWith(".gz")) {
                        suffix = FILE_EXT_HAPMAP_GZ;
                    }
                    result = ImportUtils.readFromHapmap(inFile, this);
                    break;
                }
                case HDF5: {
                    IHDF5Reader reader = HDF5Factory.openForReading((String)inFile);
                    boolean t4HDF5 = HDF5Utils.isTASSEL4HDF5Format(HDF5Factory.openForReading((String)inFile));
                    reader.close();
                    if (t4HDF5) {
                        DialogUtils.showError("This file is TASSEL4 HDF5 format. It will be converted to TASSEL5 HDF5 format with the t5.h5 suffix added.  This may take a few minutes.", (Component)this.getParentFrame());
                        String newInfile = inFile.replace(FILE_EXT_HDF5, ".t5.h5");
                        MigrateHDF5FromT4T5.copyGenotypes(inFile, newInfile);
                        inFile = newInfile;
                    }
                    suffix = FILE_EXT_HDF5;
                    result = ImportUtils.readGuessFormat(inFile);
                    break;
                }
                case HDF5Schema: {
                    suffix = "";
                    result = new HDF5TableReport(inFile);
                    break;
                }
                case VCF: {
                    suffix = FILE_EXT_VCF;
                    if (inFile.endsWith(".gz")) {
                        suffix = ".vcf.gz";
                    }
                    result = ImportUtils.readFromVCF(inFile, this);
                    break;
                }
                case Sequence: {
                    result = ReadSequenceAlignmentUtils.readBasicAlignments(inFile, 40);
                    break;
                }
                case Fasta: {
                    result = ImportUtils.readFasta(inFile);
                    break;
                }
                case SqrMatrix: {
                    result = ReadDistanceMatrix.readDistanceMatrix(inFile);
                    break;
                }
                case Phenotype: {
                    result = ReadPhenotypeUtils.readGenericFile(inFile);
                    break;
                }
                case GeneticMap: {
                    result = ReadPolymorphismUtils.readGeneticMapFile(inFile);
                    break;
                }
                case Table: {
                    result = TableReportUtils.readDelimitedTableReport(inFile, "\t");
                    break;
                }
                case TOPM: {
                    result = TOPMUtils.readTOPM(inFile);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            StringBuilder builder = new StringBuilder();
            builder.append("Error loading: ");
            builder.append(inFile);
            builder.append("\n");
            builder.append(Utils.shortenStrLineLen(ExceptionUtils.getExceptionCauses(e), 50));
            String str = builder.toString();
            if (this.isInteractive()) {
                DialogUtils.showError(str, (Component)this.getParentFrame());
            }
            myLogger.error((Object)str);
        }
        if (result != null) {
            String theComment = "";
            if (result instanceof Report) {
                StringWriter sw = new StringWriter();
                ((Report)result).report(new PrintWriter(sw));
                theComment = sw.toString();
            }
            String name = Utils.getFilename(inFile, suffix);
            Datum td = new Datum(name, result, theComment);
            DataSet tds = new DataSet(td, (Plugin)this);
            return tds;
        }
        return null;
    }

    private File[] getOpenFilesByChooser() {
        this.myOpenFileChooser.setMultiSelectionEnabled(true);
        File[] lopenFiles = null;
        this.myOpenFileChooser.setVisible(true);
        int returnVal = this.myOpenFileChooser.showOpenDialog(this.getParentFrame());
        if (returnVal == 0 || returnVal == 0) {
            lopenFiles = this.myOpenFileChooser.getSelectedFiles();
            TasselPrefs.putOpenDir(this.myOpenFileChooser.getCurrentDirectory().getPath());
        }
        return lopenFiles;
    }

    public String[] getOpenFiles() {
        return this.myOpenFiles;
    }

    public void setOpenFiles(File[] openFiles) {
        if (openFiles == null || openFiles.length == 0) {
            this.myOpenFiles = null;
            return;
        }
        this.myOpenFiles = new String[openFiles.length];
        for (int i = 0; i < openFiles.length; ++i) {
            this.myOpenFiles[i] = openFiles[i].getPath();
        }
    }

    public void setOpenFiles(String[] openFiles) {
        this.myOpenFiles = openFiles == null || openFiles.length == 0 ? null : openFiles;
    }

    public TasselFileType getTheFileType() {
        return this.myFileType;
    }

    public void setTheFileType(TasselFileType theFileType) {
        this.myFileType = theFileType;
    }

    @Override
    public ImageIcon getIcon() {
        URL imageURL = FileLoadPlugin.class.getResource("/net/maizegenetics/analysis/images/LoadFile.gif");
        if (imageURL == null) {
            return null;
        }
        return new ImageIcon(imageURL);
    }

    @Override
    public String getButtonName() {
        return "Load";
    }

    @Override
    public String getToolTipText() {
        return "Load data from files on your computer.";
    }

    public static enum TasselFileType {
        SqrMatrix,
        Sequence,
        Unknown,
        Fasta,
        Hapmap,
        Plink,
        Phenotype,
        ProjectionAlignment,
        Phylip_Seq,
        Phylip_Inter,
        GeneticMap,
        Table,
        Serial,
        HapmapDiploid,
        Text,
        VCF,
        HDF5,
        TOPM,
        HDF5Schema;

    }
}

