/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.data;

import java.awt.Frame;
import java.net.URL;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import org.apache.log4j.Logger;

public class GetPositionListPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(GetPositionListPlugin.class);

    public GetPositionListPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSet processData(DataSet input) {
        try {
            DataSet output;
            List<Datum> alignInList = input.getDataOfType(GenotypeTable.class);
            if (alignInList.size() != 1) {
                String gpMessage = "Invalid selection.  Please select one genotype alignment.";
                if (this.isInteractive()) {
                    JOptionPane.showMessageDialog(this.getParentFrame(), gpMessage);
                } else {
                    myLogger.error((Object)gpMessage);
                }
                DataSet dataSet = null;
                return dataSet;
            }
            Datum current = alignInList.get(0);
            GenotypeTable genotypeTable = (GenotypeTable)current.getData();
            String name = current.getName();
            Datum outputDatum = new Datum(name + "_PositionList", genotypeTable.positions(), "Position List from " + name);
            DataSet dataSet = output = new DataSet(outputDatum, (Plugin)this);
            return dataSet;
        }
        finally {
            this.fireProgress(100);
        }
    }

    @Override
    public String getToolTipText() {
        return "Get Position List";
    }

    @Override
    public ImageIcon getIcon() {
        URL imageURL = GetPositionListPlugin.class.getResource("/net/maizegenetics/analysis/images/lists.gif");
        if (imageURL == null) {
            return null;
        }
        return new ImageIcon(imageURL);
    }

    @Override
    public String getButtonName() {
        return "Get Position List";
    }
}

