/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.data;

import ch.systemsx.cisd.hdf5.HDF5Factory;
import ch.systemsx.cisd.hdf5.HDF5LinkInformation;
import ch.systemsx.cisd.hdf5.IHDF5Reader;
import ch.systemsx.cisd.hdf5.IHDF5Writer;
import java.util.List;
import net.maizegenetics.dna.snp.NucleotideAlignmentConstants;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.util.HDF5Utils;
import net.maizegenetics.util.Tassel5HDF5Constants;

public class MigrateHDF5FromT4T5 {
    public static void copyGenotypes(String t4File, String newT5File) {
        IHDF5Reader reader = HDF5Factory.openForReading((String)t4File);
        IHDF5Writer writer = HDF5Factory.open((String)newT5File);
        writer.createGroup("Genotypes");
        HDF5Utils.unlockHDF5GenotypeModule(writer);
        HDF5Utils.createHDF5TaxaModule(writer);
        HDF5Utils.unlockHDF5TaxaModule(writer);
        int numTaxa = 0;
        HDF5Utils.writeHDF5GenotypesAlleleStates(writer, NucleotideAlignmentConstants.NUCLEOTIDE_ALLELES);
        HDF5Utils.writeHDF5GenotypesMaxNumAlleles(writer, 6);
        HDF5Utils.writeHDF5GenotypesRetainRareAlleles(writer, false);
        List fields = reader.getAllGroupMemberInformation("Genotypes", true);
        for (HDF5LinkInformation is : fields) {
            if (!is.isDataSet()) continue;
            String taxonName = is.getName();
            System.out.println(taxonName);
            reader.copy("Genotypes/" + taxonName, writer, "Genotypes/" + taxonName + "/");
            writer.move("Genotypes/" + taxonName + "/" + taxonName, Tassel5HDF5Constants.getGenotypesCallsPath(taxonName));
            if (reader.exists("Depth/" + taxonName)) {
                reader.copy("Depth/" + taxonName, writer, "Genotypes/" + taxonName + "/");
                writer.move("Genotypes/" + taxonName + "/" + taxonName, Tassel5HDF5Constants.getGenotypesDepthPath(taxonName));
            }
            HDF5Utils.addTaxon(writer, new Taxon(taxonName));
            ++numTaxa;
        }
        HDF5Utils.writeHDF5GenotypesNumTaxa(writer, numTaxa);
        HDF5Utils.writeHDF5TaxaNumTaxa(writer, numTaxa);
        writer.createGroup("Positions");
        int numSites = reader.getIntAttribute("/", "numSites");
        HDF5Utils.writeHDF5PositionNumSite(writer, numSites);
        System.out.println(reader.exists("Positions"));
        reader.copy("Positions", writer, "Positions/Positions");
        reader.copy("SeqRegion", writer, "Positions/Chromosomes");
        reader.copy("SeqRegionIndices", writer, "Positions/ChromosomeIndices");
        reader.copy("SnpIds", writer, "Positions/SnpIds");
        writer.createGroup("Genotypes/_Descriptors/");
        reader.copy("SiteDesc/AlleleCnt", writer, "Genotypes/_Descriptors/AlleleCnt");
        reader.copy("SiteDesc/MAF", writer, "Genotypes/_Descriptors/MAF");
        reader.copy("SiteDesc/SiteCoverage", writer, "Genotypes/_Descriptors/SiteCoverage");
        reader.copy("SiteDesc/AlleleFreqOrder", writer, "Genotypes/_Descriptors/AlleleFreqOrder");
        reader.copy("TaxaDesc/TaxaCoverage", writer, "Genotypes/_Descriptors/TaxaCoverage");
        reader.copy("TaxaDesc/TaxaHet", writer, "Genotypes/_Descriptors/TaxaHet");
        HDF5Utils.lockHDF5GenotypeModule(writer);
        HDF5Utils.lockHDF5TaxaModule(writer);
        reader.close();
        writer.close();
    }
}

