/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.data;

import java.awt.Frame;
import java.util.List;
import javax.swing.ImageIcon;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.io.ProjectionGenotypeIO;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginEvent;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;

public class ProjectionLoadPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(ProjectionLoadPlugin.class);
    private PluginParameter<String> myRecombinationBreakpoints = new PluginParameter.Builder<String>("recombinationBreakpoints", null, String.class).required(true).inFile().description("").build();
    private GenotypeTable myHighDensityMarkersGenotypeTable = null;

    public ProjectionLoadPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    protected void preProcessParameters(DataSet input) {
        if (input == null) {
            throw new IllegalArgumentException("ProjectionLoadPlugin: preProcessParameters: Please select one Genotype Table.");
        }
        List<Datum> genotypeTables = input.getDataOfType(GenotypeTable.class);
        if (genotypeTables.size() != 1) {
            throw new IllegalArgumentException("ProjectionLoadPlugin: preProcessParameters: Please select one Genotype Table.");
        }
        this.myHighDensityMarkersGenotypeTable = (GenotypeTable)genotypeTables.get(0).getData();
    }

    @Override
    public DataSet processData(DataSet input) {
        try {
            DataSet dataSet = this.loadFile(this.myRecombinationBreakpoints.value(), this.myHighDensityMarkersGenotypeTable);
            return dataSet;
        }
        catch (Exception e) {
            throw new IllegalStateException("ProjectionLoadPlugin: processData: Problem loading: " + this.myRecombinationBreakpoints.value() + "\n" + e.getMessage());
        }
        finally {
            this.fireProgress(100);
        }
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return "Load Projection Alignment";
    }

    @Override
    public String getToolTipText() {
        return "Load Projection Alignments";
    }

    private DataSet loadFile(String theRecombinationBreakpoints, GenotypeTable theHighDensityMarkers) {
        GenotypeTable theAlignmentForGenotype = null;
        try {
            theAlignmentForGenotype = ProjectionGenotypeIO.getInstance(theRecombinationBreakpoints, theHighDensityMarkers);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        Datum td = new Datum(Utils.getFilename(theRecombinationBreakpoints, ".hmp.txt"), theAlignmentForGenotype, null);
        DataSet tds = new DataSet(td, (Plugin)this);
        this.fireDataSetReturned(new PluginEvent(tds, ProjectionLoadPlugin.class));
        return tds;
    }

    public GenotypeTable runPlugin(DataSet input) {
        return (GenotypeTable)this.performFunction(input).getData(0).getData();
    }

    public String recombinationBreakpoints() {
        return this.myRecombinationBreakpoints.value();
    }

    public ProjectionLoadPlugin recombinationBreakpoints(String value) {
        this.myRecombinationBreakpoints = new PluginParameter<String>(this.myRecombinationBreakpoints, value);
        return this;
    }
}

