/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.data;

import java.awt.Frame;
import java.net.URL;
import javax.activation.UnsupportedDataTypeException;
import javax.swing.ImageIcon;
import net.maizegenetics.dna.snp.ExportUtils;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.io.BuilderFromHapMap;
import net.maizegenetics.dna.snp.io.BuilderFromVCF;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.GeneratePluginCode;
import net.maizegenetics.plugindef.PluginParameter;

public class SortGenotypeFilePlugin
extends AbstractPlugin {
    private PluginParameter<String> infile = new PluginParameter.Builder<String>("inputFile", null, String.class).required(true).inFile().guiName("Input file").description("Input file").build();
    private PluginParameter<String> outfile = new PluginParameter.Builder<String>("outputFile", null, String.class).required(true).outFile().guiName("Output file").description("Output file").build();
    private PluginParameter<SupportedFileTypes> fileType = new PluginParameter.Builder<SupportedFileTypes>("fileType", null, SupportedFileTypes.class).required(false).guiName("File type").description("Input/output file type (if not obvious from file name)").build();

    public SortGenotypeFilePlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    public DataSet processData(DataSet input) {
        try {
            switch (this.fileType()) {
                case Hapmap: {
                    GenotypeTable myHapmap = BuilderFromHapMap.getBuilder(this.inputFile(), null).sortPositions().build();
                    ExportUtils.writeToHapmap(myHapmap, this.outputFile());
                    break;
                }
                case VCF: {
                    GenotypeTable myVCF = BuilderFromVCF.getBuilder(this.inputFile()).keepDepth().buildAndSortInMemory();
                    ExportUtils.writeToVCF(myVCF, this.outputFile(), true);
                    break;
                }
                default: {
                    throw new UnsupportedDataTypeException("SortGenotypeFilePlugin: Identified data type does not conform to known types (Hapmap, VCF)");
                }
            }
        }
        catch (UnsupportedDataTypeException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public String pluginDescription() {
        return "This plugin takes a Hapmap or VCF genotype file and sorts it according to TASSEL's conventions, which rely on the position, locus (chromosome), strand, and SNP name (to facilitate searching).";
    }

    @Override
    protected void postProcessParameters() {
        if (this.fileType() == null) {
            if (this.inputFile().toLowerCase().endsWith(".hmp.txt") || this.inputFile().toLowerCase().endsWith(".hmp.txt.gz")) {
                this.fileType(SupportedFileTypes.Hapmap);
            } else if (this.inputFile().toLowerCase().endsWith(".vcf") || this.inputFile().toLowerCase().endsWith(".vcf.gz")) {
                this.fileType(SupportedFileTypes.VCF);
            } else {
                throw new UnsupportedOperationException("Unable to guess file type from input file name. Please rename to end in .hmp.txt, .hmp.txt.gz, .vcf, or .vcf.gz");
            }
        }
    }

    @Override
    public ImageIcon getIcon() {
        URL imageURL = SortGenotypeFilePlugin.class.getResource("/net/maizegenetics/analysis/images/sort.gif");
        if (imageURL == null) {
            return null;
        }
        return new ImageIcon(imageURL);
    }

    @Override
    public String getButtonName() {
        return "Sort Genotype File";
    }

    @Override
    public String getToolTipText() {
        return "Sort Genotype File";
    }

    public static void main(String[] args) {
        GeneratePluginCode.generate(SortGenotypeFilePlugin.class);
    }

    public String inputFile() {
        return this.infile.value();
    }

    public SortGenotypeFilePlugin inputFile(String value) {
        this.infile = new PluginParameter<String>(this.infile, value);
        return this;
    }

    public String outputFile() {
        return this.outfile.value();
    }

    public SortGenotypeFilePlugin outputFile(String value) {
        this.outfile = new PluginParameter<String>(this.outfile, value);
        return this;
    }

    public SupportedFileTypes fileType() {
        return this.fileType.value();
    }

    public SortGenotypeFilePlugin fileType(SupportedFileTypes value) {
        this.fileType = new PluginParameter<SupportedFileTypes>(this.fileType, value);
        return this;
    }

    private static enum SupportedFileTypes {
        Hapmap,
        VCF;

    }
}

