/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.data;

import java.awt.Frame;
import javax.swing.ImageIcon;
import net.maizegenetics.dna.map.Chromosome;
import net.maizegenetics.dna.snp.ExportUtils;
import net.maizegenetics.dna.snp.FilterGenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.ImportUtils;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.util.ArgsEngine;
import org.apache.log4j.Logger;

public class SplitHDF5ByChromosomePlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(SplitHDF5ByChromosomePlugin.class);
    private PluginParameter<String> myInputGenotypes = new PluginParameter.Builder<String>("i", null, String.class).guiName("Input HDF5 Genotype File").required(true).inFile().description("Input HDF5 genotype (*.h5) file to be split by chromosome. The output files will be named *_chr#.h5 (where # = chromosome number)").build();
    private PluginParameter<Boolean> myIgnoreDepth = new PluginParameter.Builder<Boolean>("iD", false, Boolean.class).guiName("Ignore Depth").required(false).description("If genotypic depth information is present in the input file, ignore it (i.e., do not write depth information to the output files). Default: keep depth.").build();
    private ArgsEngine myArgsEngine = null;
    private String inHDF5FileName = null;
    private boolean keepDepth = true;

    public SplitHDF5ByChromosomePlugin() {
        super(null, false);
    }

    public SplitHDF5ByChromosomePlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, false);
    }

    @Override
    public DataSet processData(DataSet input) {
        String message = this.splitHDF5GenoTableByChr();
        if (message != null) {
            myLogger.error((Object)message);
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new IllegalStateException(message);
        }
        this.fireProgress(100);
        return null;
    }

    private String splitHDF5GenoTableByChr() {
        Chromosome[] chrs;
        System.out.println("\n\nSplitHDF5ByChromosomePlugin:\nSplitting the following input file by chromosome:");
        System.out.println("  " + this.inputHDF5GenotypeFile() + "\n\n");
        GenotypeTable inGenos = ImportUtils.readGuessFormat(this.inputHDF5GenotypeFile());
        for (Chromosome chr : chrs = inGenos.chromosomes()) {
            FilterGenotypeTable genosForChr = FilterGenotypeTable.getInstance(inGenos, chr);
            String outFileName = this.ignoreDepth() != false ? this.inputHDF5GenotypeFile().replaceFirst("\\.h5$", "_noDepth_chr" + chr.getChromosomeNumber() + ".h5") : this.inputHDF5GenotypeFile().replaceFirst("\\.h5$", "_chr" + chr.getChromosomeNumber() + ".h5");
            ExportUtils.writeGenotypeHDF5(genosForChr, outFileName, this.ignoreDepth() == false);
            System.out.println("    Genotypes from chromosome " + chr.getChromosomeNumber() + " written to file");
            System.out.println("        " + outFileName);
        }
        System.out.println("\n\nSplitHDF5ByChromosomePlugin: Finished splitting chromosomes.\n\n");
        return null;
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return "Split chromosomes from HDF5 genotype file";
    }

    @Override
    public String getToolTipText() {
        return "Split chromosomes from HDF5 genotype file";
    }

    public String inputHDF5GenotypeFile() {
        return this.myInputGenotypes.value();
    }

    public SplitHDF5ByChromosomePlugin inputHDF5GenotypeFile(String value) {
        this.myInputGenotypes = new PluginParameter<String>(this.myInputGenotypes, value);
        return this;
    }

    public Boolean ignoreDepth() {
        return this.myIgnoreDepth.value();
    }

    public SplitHDF5ByChromosomePlugin ignoreDepth(Boolean value) {
        this.myIgnoreDepth = new PluginParameter<Boolean>(this.myIgnoreDepth, value);
        return this;
    }
}

