/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.data;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.Collator;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableModel;
import net.maizegenetics.gui.TableReportNoPagingTableModel;
import net.maizegenetics.taxa.IdentifierSynonymizer;

class SynonymizerDialog
extends JDialog {
    private JPanel jPanel1 = new JPanel();
    private JTextField ThresholdTextField = new JTextField();
    private JButton setThresholdButton = new JButton();
    private JButton CancelButton = new JButton();
    private Frame theFrame;
    private double threshold = 1.0;
    boolean isCanceled;
    JButton okButton = new JButton();
    JList matchList = new JList();
    JScrollPane newRealNameScrollPane1 = new JScrollPane();
    JTable synTable = new JTable();
    JButton selectSynButton = new JButton();
    JButton setNoSynButton = new JButton();
    JLabel jLabel1 = new JLabel();
    JPanel jPanel2 = new JPanel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JScrollPane theATP;
    JTable theNameTable;
    IdentifierSynonymizer theTS;
    JCheckBox cbxSortAlphabetically = new JCheckBox();

    public SynonymizerDialog(IdentifierSynonymizer ts, Frame theFrame) {
        super(theFrame, true);
        this.theFrame = theFrame;
        this.theTS = ts;
        try {
            this.theNameTable = new JTable(new TableReportNoPagingTableModel(this.theTS));
            this.theNameTable.setAutoCreateRowSorter(true);
            this.theNameTable.setCellEditor(null);
            this.theNameTable.setSelectionMode(0);
            this.matchList.setAutoscrolls(true);
            this.theATP = new JScrollPane(this.theNameTable);
            this.jbInit();
            this.pack();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public SynonymizerDialog() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.jPanel1.setLayout(this.gridBagLayout1);
        this.setThresholdButton.setText("Apply threshold");
        this.setThresholdButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SynonymizerDialog.this.setThresholdButton_actionPerformed(e);
            }
        });
        this.CancelButton.setText("Cancel");
        this.CancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SynonymizerDialog.this.CancelButton_actionPerformed(e);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SynonymizerDialog.this.okButton_actionPerformed(e);
            }
        });
        this.ThresholdTextField.setPreferredSize(new Dimension(30, 30));
        this.selectSynButton.setFont(new Font("Dialog", 1, 14));
        this.selectSynButton.setToolTipText("Set synonym to selected taxon");
        this.selectSynButton.setText("<");
        this.selectSynButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SynonymizerDialog.this.selectSynButton_actionPerformed(e);
            }
        });
        this.setNoSynButton.setToolTipText("Set selected taxon to no synonym");
        this.setNoSynButton.setText("No Synonym");
        this.setNoSynButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SynonymizerDialog.this.setNoSynButton_actionPerformed(e);
            }
        });
        this.theNameTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SynonymizerDialog.this.synTable_mouseClicked(e);
            }
        });
        this.jLabel1.setFont(new Font("Dialog", 1, 14));
        this.jLabel1.setText("Synonymizer");
        this.newRealNameScrollPane1.setVerticalScrollBarPolicy(22);
        this.cbxSortAlphabetically.setActionCommand("jCheckBox1");
        this.cbxSortAlphabetically.setHorizontalAlignment(0);
        this.cbxSortAlphabetically.setHorizontalTextPosition(11);
        this.cbxSortAlphabetically.setSelectedIcon(null);
        this.cbxSortAlphabetically.setText("Sort Alphabetically");
        this.cbxSortAlphabetically.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SynonymizerDialog.this.cbxSortAlphabetically_actionPerformed(e);
            }
        });
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.jPanel2.add(this.theATP);
        this.newRealNameScrollPane1.getViewport().add(this.matchList);
        this.jPanel1.add((Component)this.ThresholdTextField, new GridBagConstraints(1, 2, 1, 2, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 50, 0));
        this.jPanel1.add((Component)this.setThresholdButton, new GridBagConstraints(2, 3, 3, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 37, 7));
        this.jPanel1.add((Component)this.newRealNameScrollPane1, new GridBagConstraints(2, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 100, 300));
        this.jPanel1.add((Component)this.selectSynButton, new GridBagConstraints(1, 1, 1, 1, 0.5, 0.5, 10, 0, new Insets(0, 0, 0, 0), 10, 4));
        this.jPanel1.add((Component)this.setNoSynButton, new GridBagConstraints(0, 2, 1, 2, 0.5, 0.5, 10, 0, new Insets(0, 0, 0, 0), 10, 4));
        this.jPanel1.add((Component)this.CancelButton, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(19, 0, 10, 25), 15, 7));
        this.jPanel1.add((Component)this.jLabel1, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 17, 0, new Insets(8, 20, 0, 0), 184, 5));
        this.jPanel1.add((Component)this.theATP, new GridBagConstraints(0, 1, 1, 1, 2.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 200, 300));
        this.jPanel1.add((Component)this.okButton, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(19, 69, 10, 49), 33, 10));
        this.jPanel1.add((Component)this.cbxSortAlphabetically, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 16, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.setSize(800, 600);
        this.setTitle(" Threshold for synonymizer ");
    }

    public IdentifierSynonymizer getIdentifierSynonymizer() {
        return this.theTS;
    }

    void deleteByThreshold(double threshold) {
        TableModel dm = this.theNameTable.getModel();
        for (int i = 0; i < dm.getRowCount(); ++i) {
            String realName;
            String synName = (String)dm.getValueAt(i, 0);
            double score = IdentifierSynonymizer.scoreMatch(synName, realName = (String)dm.getValueAt(i, 1), true, false, false);
            if (!(score < threshold)) continue;
            dm.setValueAt("", i, 1);
            dm.setValueAt("-1", i, 2);
        }
    }

    void setThresholdButton_actionPerformed(ActionEvent e) {
        this.threshold = this.getMatchThreshold();
        this.deleteByThreshold(this.threshold);
    }

    void CancelButton_actionPerformed(ActionEvent e) {
        this.isCanceled = true;
        this.setVisible(false);
    }

    double getMatchThreshold() {
        double th = this.threshold;
        try {
            th = Double.parseDouble(this.ThresholdTextField.getText().trim());
            if (th < 0.0 || th > 1.0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException nfe) {
            JOptionPane.showMessageDialog(this.theFrame, "Please enter an double between 0 and 1.");
        }
        return th;
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    void selectSynButton_actionPerformed(ActionEvent e) {
        try {
            String newRealName = (String)this.matchList.getSelectedValue();
            int theRow = this.theNameTable.getSelectedRow();
            this.theNameTable.getModel().setValueAt(newRealName, theRow, 1);
            this.theNameTable.getModel().setValueAt("" + this.theTS.getPreferredIndex(newRealName), theRow, 2);
        }
        catch (Exception ex) {
            System.out.println("Make sure both a row and a new name are selected");
        }
    }

    void setNoSynButton_actionPerformed(ActionEvent e) {
        try {
            int theRow = this.theNameTable.getSelectedRow();
            this.theNameTable.getModel().setValueAt("", theRow, 1);
            this.theNameTable.getModel().setValueAt("-1", theRow, 2);
        }
        catch (Exception ex) {
            System.out.println("Make sure a row is selected");
        }
    }

    void synTable_mouseClicked(MouseEvent e) {
        if (this.cbxSortAlphabetically.isSelected()) {
            this.sortListAlphabetically();
        } else {
            this.sortListByMatchScore();
        }
    }

    void okButton_actionPerformed(ActionEvent e) {
        TableModel dm = this.theNameTable.getModel();
        for (int i = 0; i < dm.getRowCount(); ++i) {
            String synName = (String)dm.getValueAt(i, 0);
            int newID = Integer.parseInt((String)dm.getValueAt(i, 2));
            if (this.theTS.getPreferredIndex(synName) == newID) continue;
            System.out.println("synName=" + synName + "  " + this.theTS.getPreferredName(synName));
            this.theTS.setRealID(synName, newID);
            System.out.println("synName=" + synName + "  " + this.theTS.getPreferredName(synName));
        }
        this.isCanceled = false;
        this.setVisible(false);
    }

    void sortListByMatchScore() {
        Object theSynonym = this.theNameTable.getModel().getValueAt(this.theNameTable.getSelectedRow(), 0);
        ArrayList<String> findOrderedMatches = this.theTS.findOrderedMatches((String)theSynonym, 4);
        DefaultListModel<Object> dlm = new DefaultListModel<Object>();
        Object[] a = findOrderedMatches.toArray();
        for (int i = 0; i < a.length; ++i) {
            dlm.insertElementAt(a[i], i);
        }
        this.matchList.setModel(dlm);
    }

    private void cbxSortAlphabetically_actionPerformed(ActionEvent e) {
        if (this.cbxSortAlphabetically.isSelected()) {
            this.sortListAlphabetically();
        } else {
            this.sortListByMatchScore();
        }
    }

    private void sortListAlphabetically() {
        DefaultListModel listModel = (DefaultListModel)this.matchList.getModel();
        int itemCount = listModel.getSize();
        Object[] a = new String[itemCount];
        listModel.copyInto(a);
        this.sortArray(Collator.getInstance(), (String[])a);
        for (int i = 0; i < itemCount; ++i) {
            listModel.setElementAt(a[i], i);
        }
    }

    private void sortArray(Collator collator, String[] strArray) {
        if (strArray.length == 1) {
            return;
        }
        for (int i = 0; i < strArray.length; ++i) {
            for (int j = i + 1; j < strArray.length; ++j) {
                if (collator.compare(strArray[i], strArray[j]) <= 0) continue;
                String tmp = strArray[i];
                strArray[i] = strArray[j];
                strArray[j] = tmp;
            }
        }
    }
}

