/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.distance;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import net.maizegenetics.dna.WHICH_ALLELE;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.taxa.distance.DistanceMatrix;
import net.maizegenetics.util.BitSet;
import net.maizegenetics.util.BitUtil;
import net.maizegenetics.util.ProgressListener;

public class IBSDistanceMatrix
extends DistanceMatrix {
    private ProgressListener myListener = null;
    private int numSeqs;
    private GenotypeTable theTBA = null;
    private double avgTotalSites;
    private int minSitesComp = 0;
    private boolean isTrueIBS = false;

    public IBSDistanceMatrix(GenotypeTable theAlignment) {
        this(theAlignment, 0, null);
    }

    public IBSDistanceMatrix(GenotypeTable theAlignment, ProgressListener listener) {
        this(theAlignment, 0, listener);
    }

    public IBSDistanceMatrix(GenotypeTable theAlignment, int minSiteComp, ProgressListener listener) {
        this(theAlignment, minSiteComp, false, listener);
    }

    public IBSDistanceMatrix(GenotypeTable theAlignment, int minSiteComp, boolean trueIBS, ProgressListener listener) {
        this.minSitesComp = minSiteComp;
        this.isTrueIBS = trueIBS;
        this.myListener = listener;
        this.numSeqs = theAlignment.numberOfTaxa();
        this.theTBA = theAlignment;
        this.setIdGroup(theAlignment.taxa());
        this.computeHetBitDistances();
    }

    private void computeHetBitDistances() {
        this.avgTotalSites = 0.0;
        int count = 0;
        double[][] distance = new double[this.numSeqs][this.numSeqs];
        for (int i = 0; i < this.numSeqs; ++i) {
            long[] iMj = this.theTBA.allelePresenceForAllSites(i, WHICH_ALLELE.Major).getBits();
            long[] iMn = this.theTBA.allelePresenceForAllSites(i, WHICH_ALLELE.Minor).getBits();
            for (int j = i; j < this.numSeqs; ++j) {
                if (j == i && !this.isTrueIBS) {
                    distance[i][i] = 0.0;
                    continue;
                }
                long[] jMj = this.theTBA.allelePresenceForAllSites(j, WHICH_ALLELE.Major).getBits();
                long[] jMn = this.theTBA.allelePresenceForAllSites(j, WHICH_ALLELE.Minor).getBits();
                double[] result = IBSDistanceMatrix.computeHetBitDistances(iMj, iMn, jMj, jMn, this.minSitesComp);
                double d = result[0];
                distance[j][i] = d;
                distance[i][j] = d;
                this.avgTotalSites += result[1];
                ++count;
            }
            this.fireProgress((int)((double)(i + 1) / (double)this.numSeqs * 100.0));
        }
        this.setDistances(distance);
        this.avgTotalSites /= (double)count;
    }

    public static double[] computeHetBitDistances(GenotypeTable theTBA, int taxon1, int taxon2) {
        return IBSDistanceMatrix.computeHetBitDistances(theTBA, taxon1, taxon2, 0, false);
    }

    public static double[] computeHetBitDistances(GenotypeTable theTBA, int taxon1, int taxon2, int minSitesCompared, boolean isTrueIBS) {
        long[] iMj = theTBA.allelePresenceForAllSites(taxon1, WHICH_ALLELE.Major).getBits();
        long[] iMn = theTBA.allelePresenceForAllSites(taxon1, WHICH_ALLELE.Minor).getBits();
        long[] jMj = theTBA.allelePresenceForAllSites(taxon2, WHICH_ALLELE.Major).getBits();
        long[] jMn = theTBA.allelePresenceForAllSites(taxon2, WHICH_ALLELE.Minor).getBits();
        return IBSDistanceMatrix.computeHetBitDistances(iMj, iMn, jMj, jMn, minSitesCompared, 0, iMj.length - 1);
    }

    public static double[] computeHetBitDistances(GenotypeTable theTBA, int taxon1, int taxon2, int minSitesCompared, int firstWord, int lastWord, BitSet maskBadSet) {
        long[] iMj = theTBA.allelePresenceForAllSites(taxon1, WHICH_ALLELE.Major).getBits();
        long[] iMn = theTBA.allelePresenceForAllSites(taxon1, WHICH_ALLELE.Minor).getBits();
        if (maskBadSet != null) {
            int i;
            long[] maskBad = maskBadSet.getBits();
            for (i = 0; i < iMj.length; ++i) {
                iMj[i] = iMj[i] & maskBad[i];
            }
            for (i = 0; i < iMn.length; ++i) {
                iMn[i] = iMn[i] & maskBad[i];
            }
        }
        long[] jMj = theTBA.allelePresenceForAllSites(taxon2, WHICH_ALLELE.Major).getBits();
        long[] jMn = theTBA.allelePresenceForAllSites(taxon2, WHICH_ALLELE.Minor).getBits();
        return IBSDistanceMatrix.computeHetBitDistances(iMj, iMn, jMj, jMn, minSitesCompared, firstWord, lastWord);
    }

    public static double[] computeHetBitDistances(long[] iMj, long[] iMn, long[] jMj, long[] jMn, int minSitesCompared) {
        return IBSDistanceMatrix.computeHetBitDistances(iMj, iMn, jMj, jMn, minSitesCompared, 0, iMj.length - 1);
    }

    public static double[] computeHetBitDistances(long[] iMj, long[] iMn, long[] jMj, long[] jMn, int minSitesCompared, int firstWord, int lastWord) {
        int sameCnt = 0;
        int diffCnt = 0;
        int hetCnt = 0;
        for (int x = firstWord; x <= lastWord; ++x) {
            long same = iMj[x] & jMj[x] | iMn[x] & jMn[x];
            long diff = iMj[x] & jMn[x] | iMn[x] & jMj[x];
            long hets = same & diff;
            sameCnt += BitUtil.pop(same);
            diffCnt += BitUtil.pop(diff);
            hetCnt += BitUtil.pop(hets);
        }
        int sites = sameCnt + diffCnt - hetCnt;
        double identity = ((double)sameCnt - 0.5 * (double)hetCnt) / (double)sites;
        double dist = 1.0 - identity;
        if (sites > minSitesCompared) {
            return new double[]{dist, sites};
        }
        return new double[]{Double.NaN, sites};
    }

    public double getAverageTotalSites() {
        return this.avgTotalSites;
    }

    public String toString(int d) {
        double[][] distance = this.getDistances();
        String newln = System.getProperty("line.separator");
        String outPut = new String();
        String num = new String();
        DecimalFormat nf = new DecimalFormat();
        ((NumberFormat)nf).setMaximumFractionDigits(5);
        for (int i = 0; i < distance.length; ++i) {
            for (int j = 0; j < distance[i].length; ++j) {
                num = nf.format(d);
                outPut = outPut + num + '\t';
            }
            outPut = outPut + newln;
        }
        return outPut;
    }

    @Override
    public String toString() {
        return this.toString(6);
    }

    protected void fireProgress(int percent) {
        if (this.myListener != null) {
            this.myListener.progress(percent, null);
        }
    }

    public boolean isTrueIBS() {
        return this.isTrueIBS;
    }
}

