/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.distance;

import java.awt.Frame;
import java.util.ArrayList;
import net.maizegenetics.analysis.distance.IBSDistanceMatrix;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTableUtils;
import net.maizegenetics.matrixalgebra.Matrix.DoubleMatrix;
import net.maizegenetics.matrixalgebra.Matrix.DoubleMatrixFactory;
import net.maizegenetics.taxa.distance.DistanceMatrix;
import net.maizegenetics.trait.SimplePhenotype;

public class Kinship
extends DistanceMatrix {
    Frame parentFrame;
    DistanceMatrix dm;
    GenotypeTable mar;
    SimplePhenotype ped;
    int[][] parents;
    private double kMin = 99999.0;
    private double kMax = -99999.0;
    private double kAvg = 0.0;
    private double kSD = 0.0;
    private double cutOff = 2.0;
    private int numSeqs;
    private KINSHIP_TYPE kinshipType = KINSHIP_TYPE.IBS;
    public static double matrixMultiplier = 2.0;

    public Kinship(GenotypeTable mar) {
        this(mar, false, true);
    }

    public Kinship(GenotypeTable mar, boolean areHetsRelated, boolean rescaleKinship) {
        this.mar = mar;
        this.numSeqs = this.mar.numberOfTaxa();
        this.buildFromMarker();
    }

    public Kinship(GenotypeTable mar, KINSHIP_TYPE kinshipType) {
        this.mar = mar;
        this.kinshipType = kinshipType;
        this.numSeqs = this.mar.numberOfTaxa();
        System.out.println("Starting Kinship.buildFromMarker.");
        long start = System.currentTimeMillis();
        this.buildFromMarker();
        System.out.printf("Built Kinship in %d millisec.\n", System.currentTimeMillis() - start);
    }

    public Kinship(SimplePhenotype ped) {
        this.ped = ped;
        this.buildFromPhenotype();
    }

    public Kinship(DistanceMatrix dm) {
        this.dm = dm;
    }

    public void buildFromMarker() {
        if (this.kinshipType == KINSHIP_TYPE.Endelman) {
            this.calculateKinshipFromMarkers();
        } else {
            IBSDistanceMatrix adm = new IBSDistanceMatrix(this.mar, 0, true, null);
            this.dm = new DistanceMatrix(adm.getDistances(), this.mar.taxa());
            this.toSimilarity();
            this.getKStatistics();
            this.rescale();
            System.out.println("Kinship was built from markers");
        }
    }

    public void buildFromPhenotype() {
        int ntraits = this.ped.getNumberOfTraits();
        if (ntraits > 2) {
            this.calculateRelationshipKinshipFromPhenotype();
        } else {
            this.buildFromPed();
        }
    }

    public void buildFromPed() {
        System.out.println("Building Kinship From pedigree");
        this.parents = new int[this.ped.getNumberOfTaxa()][this.ped.getNumberOfTraits()];
        try {
            for (int row = 0; row < this.ped.getNumberOfTaxa(); ++row) {
                for (int col = 0; col < this.ped.getNumberOfTraits(); ++col) {
                    this.parents[row][col] = (int)this.ped.getData(row, col);
                }
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        this.dm = new DistanceMatrix(Kinship.kinshipRelation(this.parents), this.ped.getTaxa());
        System.out.println("Kinship was build from pedigree");
    }

    public static double[][] kinshipRelation(int[][] ped) {
        int j;
        int i;
        int n = ped.length;
        double[][] aMatrix = new double[n][n];
        for (i = 0; i < n; ++i) {
            aMatrix[i][i] = 1.0;
            for (j = i + 1; j < n; ++j) {
                aMatrix[i][j] = 0.0;
                aMatrix[j][i] = 0.0;
            }
        }
        System.out.println("initial: diagonal 1, 0 otherwise");
        for (i = 0; i < n; ++i) {
            int femaleParent = ped[i][1];
            int maleParent = ped[i][2];
            if (femaleParent > 0 && maleParent > 0) {
                aMatrix[i][i] = aMatrix[i][i] + 0.5 * aMatrix[maleParent - 1][femaleParent - 1];
            }
            for (j = i + 1; j < n; ++j) {
                femaleParent = ped[j][1];
                maleParent = ped[j][2];
                if (femaleParent > 0 && maleParent > 0) {
                    aMatrix[i][j] = 0.5 * (aMatrix[i][femaleParent - 1] + aMatrix[i][maleParent - 1]);
                } else if (maleParent > 0) {
                    aMatrix[i][j] = 0.5 * aMatrix[i][maleParent - 1];
                } else if (femaleParent > 0) {
                    aMatrix[i][j] = 0.5 * aMatrix[i][femaleParent - 1];
                }
                aMatrix[j][i] = aMatrix[i][j];
            }
        }
        System.out.println("A matrix finished");
        return aMatrix;
    }

    public void toSimilarity() {
        System.out.println("toSimilarity " + this.numSeqs);
        for (int i = 0; i < this.numSeqs; ++i) {
            for (int j = i; j < this.numSeqs; ++j) {
                double s = this.cutOff - this.dm.getDistance(i, j);
                this.dm.setDistance(i, j, s);
                this.dm.setDistance(j, i, s);
            }
        }
        System.out.println("toSimilarity finish" + this.numSeqs);
    }

    public void getKStatistics() {
        double total = 0.0;
        double totalsq = 0.0;
        double nk = this.numSeqs * (this.numSeqs - 1) / 2;
        for (int i = 0; i < this.numSeqs - 1; ++i) {
            for (int j = i + 1; j < this.numSeqs; ++j) {
                total += this.dm.getDistance(i, j);
                totalsq += this.dm.getDistance(i, j) * this.dm.getDistance(i, j);
                if (this.dm.getDistance(i, j) < this.kMin) {
                    this.kMin = this.dm.getDistance(i, j);
                }
                if (!(this.dm.getDistance(i, j) > this.kMax)) continue;
                this.kMax = this.dm.getDistance(i, j);
            }
        }
        this.kAvg = total / nk;
        this.kSD = Math.sqrt((totalsq - nk * this.kAvg * this.kAvg) / (nk - 1.0));
        System.out.println(this.kAvg);
    }

    public void pullBackExtrem() {
        for (int i = 0; i < this.numSeqs - 1; ++i) {
            for (int j = i + 1; j < this.numSeqs; ++j) {
                if (!(this.dm.getDistance(i, j) < this.kAvg - this.cutOff * this.kSD)) continue;
                this.dm.setDistance(i, j, this.kAvg - this.cutOff * this.kSD);
                this.kMin = this.dm.getDistance(i, j);
            }
        }
        System.out.println("values beyond 3 sd from mean were pulled back");
    }

    public void cutOff() {
        for (int i = 0; i < this.numSeqs; ++i) {
            for (int j = i + 0; j < this.numSeqs; ++j) {
                if (!(this.dm.getDistance(i, j) < this.kAvg)) continue;
                this.dm.setDistance(i, j, this.kAvg);
            }
        }
        this.kMin = this.kAvg;
    }

    public void rescale() {
        for (int i = 0; i < this.numSeqs; ++i) {
            for (int j = i; j < this.numSeqs; ++j) {
                double s = (this.dm.getDistance(i, j) - this.kMin) * this.cutOff / (this.cutOff - this.kMin);
                this.dm.setDistance(i, j, s);
                this.dm.setDistance(j, i, s);
            }
        }
        System.out.println("K rescaled");
    }

    public void calculateKinshipFromMarkers() {
        byte missingAllele = 15;
        int ntaxa = this.mar.numberOfTaxa();
        int nsites = this.mar.numberOfSites();
        double[][] distance = new double[ntaxa][ntaxa];
        DoubleMatrix dmDistance = DoubleMatrixFactory.DEFAULT.make(ntaxa, ntaxa, 0.0);
        ArrayList<Double> piList = new ArrayList<Double>();
        for (int s = 0; s < nsites; ++s) {
            int[][] alleleFreq = this.mar.allelesSortedByFrequency(s);
            int nalleles = alleleFreq[0].length;
            int totalAlleleCount = this.mar.totalGametesNonMissingForSite(s);
            for (int a = 0; a < nalleles - 1; ++a) {
                double pi = (double)alleleFreq[1][a] / (double)totalAlleleCount;
                double pix2 = 2.0 * pi;
                piList.add(pi);
                DoubleMatrix scores = DoubleMatrixFactory.DEFAULT.make(ntaxa, 1, 0.0);
                for (int t = 0; t < ntaxa; ++t) {
                    byte[] geno = GenotypeTableUtils.getDiploidValues(this.mar.genotype(t, s));
                    double thisScore = 0.0;
                    if (geno[0] != missingAllele) {
                        if (geno[0] == alleleFreq[0][a]) {
                            thisScore += 1.0;
                        }
                        if (geno[1] == alleleFreq[0][a]) {
                            thisScore += 1.0;
                        }
                        thisScore -= pix2;
                    }
                    scores.set(t, 0, thisScore);
                }
                for (int r = 0; r < ntaxa; ++r) {
                    double rowval = scores.get(r, 0);
                    double val = dmDistance.get(r, r) + rowval * rowval;
                    dmDistance.set(r, r, val);
                    for (int c = r + 1; c < ntaxa; ++c) {
                        val = dmDistance.get(r, c) + rowval * scores.get(c, 0);
                        dmDistance.set(r, c, val);
                    }
                }
            }
        }
        double sumpk = 0.0;
        for (Double p : piList) {
            sumpk += p * (1.0 - p);
        }
        sumpk *= 2.0;
        for (int r = 0; r < ntaxa; ++r) {
            distance[r][r] = dmDistance.get(r, r) / sumpk;
            for (int c = r + 1; c < ntaxa; ++c) {
                double d = dmDistance.get(r, c) / sumpk;
                distance[c][r] = d;
                distance[r][c] = d;
            }
        }
        double maxsim = 0.0;
        double[][] dArray = distance;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            double[] row;
            for (double val : row = dArray[i]) {
                maxsim = Math.max(maxsim, val);
            }
        }
        this.dm = new DistanceMatrix(distance, this.mar.taxa());
    }

    public void calculateRelationshipKinshipFromPhenotype() {
        double[][] W = this.ped.getData();
        int ncol = W[0].length;
        int nrow = W.length;
        for (int r = 0; r < nrow; ++r) {
            int c = 0;
            while (c < ncol) {
                double[] dArray = W[r];
                int n = c++;
                dArray[n] = dArray[n] * matrixMultiplier;
            }
        }
        double sumpq = 0.0;
        for (int c = 0; c < ncol; ++c) {
            double colTotal = 0.0;
            int colCount = 0;
            for (int r = 0; r < nrow; ++r) {
                if (Double.isNaN(W[r][c])) continue;
                colTotal += W[r][c];
                ++colCount;
            }
            double pi = colTotal / (double)colCount / 2.0;
            double pix2 = pi * 2.0;
            sumpq += pi * (1.0 - pi);
            for (int r = 0; r < nrow; ++r) {
                if (Double.isNaN(W[r][c])) {
                    W[r][c] = 0.0;
                    continue;
                }
                double[] dArray = W[r];
                int n = c;
                dArray[n] = dArray[n] - pix2;
            }
        }
        DoubleMatrix WWt = DoubleMatrixFactory.DEFAULT.make(W).tcrossproduct();
        double[][] scaledIBS = new double[nrow][nrow];
        for (int r = 0; r < nrow; ++r) {
            for (int c = 0; c < nrow; ++c) {
                scaledIBS[r][c] = WWt.get(r, c) / sumpq / 2.0;
            }
        }
        this.dm = new DistanceMatrix(scaledIBS, this.ped.getTaxa());
    }

    public DistanceMatrix getDm() {
        return this.dm;
    }

    public static enum KINSHIP_TYPE {
        Endelman,
        IBS;

    }
}

