/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.filter;

import java.awt.Frame;
import java.net.URL;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import net.maizegenetics.dna.snp.FilterGenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.gui.SelectFromAvailableDialog;
import net.maizegenetics.gui.TaxaAvailableListModel;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginEvent;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListBuilder;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.trait.FilterPhenotype;
import net.maizegenetics.trait.Phenotype;
import org.apache.log4j.Logger;

public class FilterTaxaAlignmentPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(FilterTaxaAlignmentPlugin.class);
    private TaxaList myIdsToKeep = null;
    private TaxaList myIdsToRemove = null;

    public FilterTaxaAlignmentPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSet performFunction(DataSet input) {
        try {
            List inputData = input.getDataSet();
            if (inputData.size() != 1) {
                if (this.isInteractive()) {
                    JOptionPane.showMessageDialog(this.getParentFrame(), "Invalid selection. Please select a single sequence or phenotype.");
                } else {
                    myLogger.error((Object)"performFunction: Please input a single sequence or phenotype.");
                }
                DataSet dataSet = null;
                return dataSet;
            }
            Datum inputDatum = (Datum)inputData.get(0);
            if (!(inputDatum.getData() instanceof GenotypeTable) && !(inputDatum.getData() instanceof Phenotype)) {
                if (this.isInteractive()) {
                    JOptionPane.showMessageDialog(this.getParentFrame(), "Invalid selection. Please select a single sequence or phenotype.");
                } else {
                    myLogger.error((Object)"performFunction: Please input a single sequence or phenotype.");
                }
                DataSet dataSet = null;
                return dataSet;
            }
            Datum td = this.processDatum(inputDatum, this.isInteractive());
            if (td == null) {
                DataSet dataSet = null;
                return dataSet;
            }
            DataSet output = new DataSet(td, (Plugin)this);
            this.fireDataSetReturned(new PluginEvent(output, FilterTaxaAlignmentPlugin.class));
            DataSet dataSet = output;
            return dataSet;
        }
        finally {
            this.fireProgress(100);
        }
    }

    private Datum processDatum(Datum inDatum, boolean isInteractive) {
        Object theData = inDatum.getData();
        if (isInteractive) {
            TaxaAvailableListModel listModel;
            TaxaList taxaList = null;
            SelectFromAvailableDialog dialog = null;
            if (theData instanceof GenotypeTable) {
                GenotypeTable alignment = (GenotypeTable)theData;
                taxaList = alignment.taxa();
                listModel = new TaxaAvailableListModel(taxaList);
                dialog = new SelectFromAvailableDialog(this.getParentFrame(), "Taxa Filter", listModel);
            } else if (theData instanceof Phenotype) {
                Phenotype phenotype = (Phenotype)theData;
                taxaList = phenotype.getTaxa();
                listModel = new TaxaAvailableListModel(taxaList);
                dialog = new SelectFromAvailableDialog(this.getParentFrame(), "Taxa Filter", listModel);
            } else {
                JOptionPane.showMessageDialog(this.getParentFrame(), "Invalid selection. Please select a single sequence or phenotype.");
                return null;
            }
            dialog.setLocationRelativeTo(this.getParentFrame());
            dialog.setVisible(true);
            if (dialog.isCanceled()) {
                return null;
            }
            int[] indicesToKeep = dialog.getDesiredIndices();
            Taxon[] ids = new Taxon[indicesToKeep.length];
            for (int i = 0; i < indicesToKeep.length; ++i) {
                ids[i] = (Taxon)taxaList.get(indicesToKeep[i]);
            }
            this.myIdsToKeep = new TaxaListBuilder().addAll(ids).build();
            dialog.dispose();
        }
        if (!(this.myIdsToKeep != null && this.myIdsToKeep.numberOfTaxa() != 0 || this.myIdsToRemove != null && this.myIdsToRemove.numberOfTaxa() != 0)) {
            return null;
        }
        Object result = null;
        long count = 0L;
        if (theData instanceof GenotypeTable) {
            if (this.myIdsToKeep != null) {
                result = FilterGenotypeTable.getInstance((GenotypeTable)theData, this.myIdsToKeep, false);
            } else if (this.myIdsToRemove != null) {
                result = FilterGenotypeTable.getInstanceRemoveIDs((GenotypeTable)theData, this.myIdsToRemove);
            }
            count = ((GenotypeTable)result).numberOfTaxa();
        } else if (theData instanceof Phenotype) {
            if (this.myIdsToKeep != null) {
                result = FilterPhenotype.getInstance((Phenotype)theData, this.myIdsToKeep, null);
            } else if (this.myIdsToRemove != null) {
                result = FilterPhenotype.getInstanceRemoveIDs((Phenotype)theData, this.myIdsToRemove);
            }
            count = ((FilterPhenotype)result).getRowCount();
        } else {
            myLogger.error((Object)("processDatum: Please input a single sequence or phenotype.  Unknown data type: " + theData.getClass().getName()));
            return null;
        }
        String theName = inDatum.getName() + "_" + count + " Rows";
        String theComment = "Subset of " + count + " Taxa\n" + inDatum.getComment();
        return new Datum(theName, result, theComment);
    }

    public TaxaList getIdsToKeep() {
        return this.myIdsToKeep;
    }

    public void setIdsToKeep(TaxaList idsToKeep) {
        this.myIdsToKeep = idsToKeep;
    }

    public void setIdsToRemove(TaxaList idsToRemove) {
        this.myIdsToRemove = idsToRemove;
    }

    @Override
    public ImageIcon getIcon() {
        URL imageURL = FilterTaxaAlignmentPlugin.class.getResource("/net/maizegenetics/analysis/images/Filter_horizontal.gif");
        if (imageURL == null) {
            return null;
        }
        return new ImageIcon(imageURL);
    }

    @Override
    public String getButtonName() {
        return "Taxa Names";
    }

    @Override
    public String getToolTipText() {
        return "Select Taxa Within Dataset";
    }
}

