/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.filter;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import net.maizegenetics.analysis.filter.TraitTableModel;
import net.maizegenetics.trait.Phenotype;

public class FilterTraitsDialog
extends JDialog
implements ActionListener,
TableModelListener {
    private Phenotype myPhenotype;
    private TraitTableModel traitModel;
    private JScrollPane jsp;
    private JTable traitTable;
    private boolean clickedOK = false;
    public static final String CMD_EXCLUDE = "exclude";
    public static final String CMD_INCLUDE = "include";
    public static final String CMD_EXCLUDE_ALL = "excludeall";
    public static final String CMD_INCLUDE_ALL = "includeall";
    public static final String CMD_OK = "ok";
    public static final String CMD_CANCEL = "cancel";
    public static final String CMD_CHANGE_DATA = "change2data";
    public static final String CMD_CHANGE_MARKER = "change2marker";
    public static final String CMD_CHANGE_COV = "change2cov";

    public FilterTraitsDialog(Frame parent, Phenotype aPhenotype) {
        super(parent);
        this.myPhenotype = aPhenotype;
        this.traitModel = new TraitTableModel(this.myPhenotype);
        this.init();
    }

    private void init() {
        this.setTitle("Filter Traits / Modify Trait Properties");
        this.setSize(new Dimension(600, 800));
        this.setModal(true);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        this.traitModel = new TraitTableModel(this.myPhenotype);
        this.traitTable = new JTable(this.traitModel);
        this.jsp = new JScrollPane(this.traitTable);
        JComboBox<String> comboType = new JComboBox<String>();
        comboType.addItem("data");
        comboType.addItem("covariate");
        comboType.addItem("factor");
        comboType.addItem("marker");
        int typeColNumber = this.traitModel.getTypeColumnNumber();
        TableColumn typeColumn = this.traitTable.getColumnModel().getColumn(typeColNumber);
        typeColumn.setCellEditor(new DefaultCellEditor(comboType));
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridheight = 1;
        gbc.gridwidth = 2;
        contentPane.add((Component)this.jsp, gbc);
        JButton btnExclude = new JButton("Exclude Selected");
        btnExclude.setActionCommand(CMD_EXCLUDE);
        btnExclude.addActionListener(this);
        JButton btnInclude = new JButton("Include Selected");
        btnInclude.setActionCommand(CMD_INCLUDE);
        btnInclude.addActionListener(this);
        JButton btnExcludeAll = new JButton("Exclude All");
        btnExcludeAll.setActionCommand(CMD_EXCLUDE_ALL);
        btnExcludeAll.addActionListener(this);
        JButton btnIncludeAll = new JButton("Include All");
        btnIncludeAll.setActionCommand(CMD_INCLUDE_ALL);
        btnIncludeAll.addActionListener(this);
        JButton btnChangeData = new JButton("Change Selected Type to Data");
        btnChangeData.setActionCommand(CMD_CHANGE_DATA);
        btnChangeData.addActionListener(this);
        JButton btnChangeCov = new JButton("Change Selected Type to Covariate");
        btnChangeCov.setActionCommand(CMD_CHANGE_COV);
        btnChangeCov.addActionListener(this);
        JButton btnChangeMarker = new JButton("Change Selected Type to Marker");
        btnChangeMarker.setActionCommand(CMD_CHANGE_MARKER);
        btnChangeMarker.addActionListener(this);
        JButton btnOK = new JButton("OK");
        btnOK.setActionCommand(CMD_OK);
        btnOK.addActionListener(this);
        JButton btnCancel = new JButton("Cancel");
        btnCancel.setActionCommand(CMD_CANCEL);
        btnCancel.addActionListener(this);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.anchor = 13;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(5, 5, 5, 5);
        contentPane.add((Component)btnExclude, gbc);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 17;
        contentPane.add((Component)btnInclude, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 13;
        contentPane.add((Component)btnExcludeAll, gbc);
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 17;
        contentPane.add((Component)btnIncludeAll, gbc);
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(15, 5, 5, 5);
        gbc.anchor = 10;
        contentPane.add((Component)btnChangeData, gbc);
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 10;
        contentPane.add((Component)btnChangeCov, gbc);
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.insets = new Insets(5, 5, 15, 5);
        gbc.anchor = 10;
        contentPane.add((Component)btnChangeMarker, gbc);
        gbc.gridx = 0;
        gbc.gridy = 6;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 13;
        contentPane.add((Component)btnOK, gbc);
        gbc.gridx = 1;
        gbc.gridy = 6;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 17;
        contentPane.add((Component)btnCancel, gbc);
    }

    public int[] getIncludedTraits() {
        if (!this.clickedOK) {
            return null;
        }
        Boolean[] isIncluded = this.traitModel.include;
        int howmany = 0;
        for (Boolean include : isIncluded) {
            if (!include.booleanValue()) continue;
            ++howmany;
        }
        int[] includedTrait = new int[howmany];
        int traitCount = 0;
        int includedCount = 0;
        for (Boolean include : isIncluded) {
            if (include.booleanValue()) {
                includedTrait[includedCount++] = traitCount;
            }
            ++traitCount;
        }
        return includedTrait;
    }

    public String[] getTraitTypes() {
        int n = this.traitModel.traitList.size();
        String[] types = new String[n];
        for (int i = 0; i < n; ++i) {
            types[i] = this.traitModel.traitList.get(i).getType();
        }
        return types;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals(CMD_EXCLUDE)) {
            this.traitModel.excludeSome(this.traitTable.getSelectedRows());
        } else if (e.getActionCommand().equals(CMD_INCLUDE)) {
            this.traitModel.includeSome(this.traitTable.getSelectedRows());
        } else if (e.getActionCommand().equals(CMD_EXCLUDE_ALL)) {
            this.traitModel.excludeAll();
        } else if (e.getActionCommand().equals(CMD_INCLUDE_ALL)) {
            this.traitModel.includeAll();
        } else if (e.getActionCommand().equals(CMD_OK)) {
            this.setVisible(false);
            this.clickedOK = true;
        } else if (e.getActionCommand().equals(CMD_CANCEL)) {
            this.setVisible(false);
            this.clickedOK = false;
        } else if (e.getActionCommand().equals(CMD_CHANGE_DATA)) {
            this.changeSelectedType("data");
        } else if (e.getActionCommand().equals(CMD_CHANGE_COV)) {
            this.changeSelectedType("covariate");
        } else if (e.getActionCommand().equals(CMD_CHANGE_MARKER)) {
            this.changeSelectedType("marker");
        }
    }

    private void changeSelectedType(String toNewType) {
        for (int i : this.traitTable.getSelectedRows()) {
            this.traitModel.setValueAt(toNewType, i, this.traitModel.getTypeColumnNumber());
        }
        this.traitModel.fireTableDataChanged();
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        System.out.println("table model changed");
    }

    public boolean getClickedOK() {
        return this.clickedOK;
    }
}

