/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs;

import java.util.Arrays;
import net.maizegenetics.dna.BaseEncoder;

public class Barcode
implements Comparable<Barcode> {
    String barcodeS;
    String[] overhangS;
    String taxaName;
    String flowcell;
    String lane;
    long[] barOverLong;
    int barOverLength;
    int barLength;
    int taxaIndex;

    public Barcode(String barcodeS, String[] overhangSunsort, String taxa, int globalTaxaIndex, String flowcell, String lane) {
        this.barcodeS = barcodeS;
        Arrays.sort(overhangSunsort);
        this.overhangS = overhangSunsort;
        this.flowcell = flowcell;
        this.lane = lane;
        this.taxaName = taxa;
        this.taxaIndex = globalTaxaIndex;
        this.barOverLong = new long[this.overhangS.length];
        for (int i = 0; i < this.overhangS.length; ++i) {
            this.barOverLong[i] = BaseEncoder.getLongFromSeq(barcodeS + this.overhangS[i]);
        }
        this.barOverLength = barcodeS.length() + this.overhangS[0].length();
        this.barLength = barcodeS.length();
    }

    public int compareSequence(long queryLong, int maxDivCheck) {
        int div = this.barOverLength;
        for (long targetLong : this.barOverLong) {
            byte c = BaseEncoder.seqDifferencesForSubset(targetLong, queryLong, this.barOverLength, maxDivCheck);
            if (c >= div) continue;
            div = c;
        }
        return div;
    }

    @Override
    public int compareTo(Barcode anotherBarcode) {
        if (this.barOverLong[0] < anotherBarcode.barOverLong[0]) {
            return -1;
        }
        if (this.barOverLong[0] > anotherBarcode.barOverLong[0]) {
            return 1;
        }
        return 0;
    }

    public String getTaxaName() {
        return this.taxaName;
    }
}

