/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs;

import java.awt.Frame;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.gbs.ProcessFastQFile;
import net.maizegenetics.analysis.gbs.TagDistributionMap;
import net.maizegenetics.dna.tag.Tag;
import net.maizegenetics.dna.tag.TaxaDistribution;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.GeneratePluginCode;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListIOUtils;
import net.maizegenetics.util.DirectoryCrawler;
import org.apache.log4j.Logger;

public class DiscoveryTBTPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(DiscoveryTBTPlugin.class);
    private PluginParameter<String> myInputDir = new PluginParameter.Builder<String>("i", null, String.class).guiName("Input Directory").required(true).inDir().description("Input directory containing FASTQ files in text or gzipped text.\n     NOTE: Directory will be searched recursively and should\n     be written WITHOUT a slash after its name.").build();
    private PluginParameter<String> myKeyFile = new PluginParameter.Builder<String>("k", null, String.class).guiName("Key File").required(true).inFile().description("Key file listing barcodes distinguishing the samples").build();
    private PluginParameter<String> myEnzyme = new PluginParameter.Builder<String>("e", null, String.class).guiName("Enzyme").required(true).description("Enzyme used to create the GBS library, if it differs from the one listed in the key file").build();
    private PluginParameter<Integer> myMinTagCount = new PluginParameter.Builder<Integer>("c", 10, Integer.class).guiName("Min Tag Count").description("Minimum tag count").build();
    private PluginParameter<String> myOutputFile = new PluginParameter.Builder<String>("o", null, String.class).guiName("Output TBT File").required(true).outFile().description("Output TBT file").build();
    private PluginParameter<Integer> myMinQualScore = new PluginParameter.Builder<Integer>("mnQS", 0, Integer.class).guiName("Minimum quality score").required(false).description("Minimum quality score within the barcode and read length to be accepted").build();
    private PluginParameter<Integer> myMaxMapMemoryInMb = new PluginParameter.Builder<Integer>("mxMapMem", 8000, Integer.class).guiName("Maximum Map Memory in Mb").required(false).description("Maximum size for the tag distribution map in Mb").build();
    private int maxMapSize = 20000000;
    private TagDistributionMap tagCntMap;
    private static final String inputFileGlob = "glob:*{.fq,fq.gz,fastq,fastq.txt,fastq.gz,fastq.txt.gz,_sequence.txt,_sequence.txt.gz}";
    private static final int keyFileTaxaNameIndex = 3;
    private static final int keyFilePrepIDIndex = 7;
    static final String sampleNameField = "FullSampleName";

    public DiscoveryTBTPlugin() {
        super(null, false);
    }

    public DiscoveryTBTPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    public DataSet processData(DataSet input) {
        this.tagCntMap = new TagDistributionMap(this.maxMapSize, (long)this.myMaxMapMemoryInMb.value().intValue() * 1000000L);
        try {
            Path keyPath = Paths.get(this.keyFile(), new String[0]).toAbsolutePath();
            List<Path> inputSeqFiles = DirectoryCrawler.listPaths(inputFileGlob, Paths.get(this.myInputDir.value(), new String[0]).toAbsolutePath());
            if (inputSeqFiles.isEmpty()) {
                myLogger.warn((Object)"No files matching:glob:*{.fq,fq.gz,fastq,fastq.txt,fastq.gz,fastq.txt.gz,_sequence.txt,_sequence.txt.gz}");
                return null;
            }
            TaxaList masterTaxaList = TaxaListIOUtils.readTaxaAnnotationFile(this.keyFile(), sampleNameField, new HashMap<String, String>(), true);
            int numThreads = Runtime.getRuntime().availableProcessors();
            ExecutorService pool = Executors.newFixedThreadPool(numThreads - 1);
            for (Path inputSeqFile : inputSeqFiles) {
                System.out.println("Using File:" + inputSeqFile.toString());
                ProcessFastQFile pb = new ProcessFastQFile(masterTaxaList, keyPath, inputSeqFile, this.enzyme(), this.minimumQualityScore(), this.tagCntMap);
                pool.execute(pb);
                System.out.println("tagCntMap.size()=" + this.tagCntMap.size());
            }
            pool.shutdown();
            if (!pool.awaitTermination(60L, TimeUnit.SECONDS)) {
                throw new IllegalStateException("BuilderFromHapMap: processing threads timed out.");
            }
            System.out.println("tagCntMap.size()=" + this.tagCntMap.size());
            System.out.println("Memory Size" + this.tagCntMap.estimateMapMemorySize());
            this.tagCntMap.removeTagByCount(0);
            System.out.println("tagCntMap.size()=" + this.tagCntMap.size());
            System.out.println("Memory Size" + this.tagCntMap.estimateMapMemorySize());
            int cnt = 0;
            int totalmatch = 0;
            for (Map.Entry entry : this.tagCntMap.entrySet()) {
                if (cnt < 50) {
                    System.out.println(((Tag)entry.getKey()).toString() + ":" + ((TaxaDistribution)entry.getValue()).toString());
                }
                ++cnt;
                totalmatch += ((TaxaDistribution)entry.getValue()).totalDepth();
            }
            System.out.println("totalmatch = " + totalmatch);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new DataSet(new Datum("TagMap", this.tagCntMap, ""), (Plugin)this);
    }

    public static void main(String[] args) {
        GeneratePluginCode.generate(DiscoveryTBTPlugin.class);
    }

    public String inputDirectory() {
        return this.myInputDir.value();
    }

    public DiscoveryTBTPlugin inputDirectory(String value) {
        this.myInputDir = new PluginParameter<String>(this.myInputDir, value);
        return this;
    }

    public String keyFile() {
        return this.myKeyFile.value();
    }

    public DiscoveryTBTPlugin keyFile(String value) {
        this.myKeyFile = new PluginParameter<String>(this.myKeyFile, value);
        return this;
    }

    public String enzyme() {
        return this.myEnzyme.value();
    }

    public DiscoveryTBTPlugin enzyme(String value) {
        this.myEnzyme = new PluginParameter<String>(this.myEnzyme, value);
        return this;
    }

    public Integer minTagCount() {
        return this.myMinTagCount.value();
    }

    public DiscoveryTBTPlugin minTagCount(Integer value) {
        this.myMinTagCount = new PluginParameter<Integer>(this.myMinTagCount, value);
        return this;
    }

    public String outputFile() {
        return this.myOutputFile.value();
    }

    public DiscoveryTBTPlugin outputFile(String value) {
        this.myOutputFile = new PluginParameter<String>(this.myOutputFile, value);
        return this;
    }

    public Integer minimumQualityScore() {
        return this.myMinQualScore.value();
    }

    public DiscoveryTBTPlugin minimumQualityScore(Integer value) {
        this.myMinQualScore = new PluginParameter<Integer>(this.myMinQualScore, value);
        return this;
    }

    public Integer maximumMapMemoryInMb() {
        return this.myMaxMapMemoryInMb.value();
    }

    public DiscoveryTBTPlugin maximumMapMemoryInMb(Integer value) {
        this.myMaxMapMemoryInMb = new PluginParameter<Integer>(this.myMaxMapMemoryInMb, value);
        return this;
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return "Discovery Tags By Taxa";
    }

    @Override
    public String getToolTipText() {
        return "Discovery Tags By Taxa";
    }
}

