/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs;

import java.awt.Frame;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.gbs.AlignmentFilterByGBSUtils;
import net.maizegenetics.analysis.gbs.DiscoverySNPCallerPlugin;
import net.maizegenetics.analysis.gbs.SNPLogging;
import net.maizegenetics.dna.snp.ExportUtils;
import net.maizegenetics.dna.snp.FilterGenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.ImportUtils;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.util.ArgsEngine;
import org.apache.log4j.Logger;

public class GBSHapMapFiltersPlugin
extends AbstractPlugin {
    private int startChromosome = 1;
    private int endChromosome = 10;
    private ArgsEngine myArgsEngine = null;
    private static final Logger myLogger = Logger.getLogger(GBSHapMapFiltersPlugin.class);
    private String snpLogFileName;
    private SNPLogging snpLogging = null;
    private String suppliedInputFileName;
    private String suppliedOutputFileName;
    private String infile;
    private String outfile;
    private double minF = -2.0;
    private double minMAF = 0.0;
    private double maxMAF = 1.0;
    private double minPresence = 0.0;
    private boolean usePedigree = false;
    private HashMap<String, Double> taxaFs = null;
    private boolean hLD = false;
    private double minR2 = 0.01;
    private double minBonP = 0.01;
    private String[] lowCoverageTaxa = null;
    private INPUT_FORMAT inputFormat = INPUT_FORMAT.hapmap;
    private int myMaxNumAlleles = 3;

    public GBSHapMapFiltersPlugin() {
        super(null, false);
    }

    public GBSHapMapFiltersPlugin(Frame parentFrame) {
        super(parentFrame, false);
    }

    @Override
    public DataSet performFunction(DataSet input) {
        for (int chr = this.startChromosome; chr <= this.endChromosome; ++chr) {
            int[] goodLowHetSites;
            GenotypeTable a;
            block13: {
                this.infile = this.suppliedInputFileName.replace("+", "" + chr);
                this.outfile = this.suppliedOutputFileName.replace("+", "" + chr);
                myLogger.info((Object)("Reading: " + this.infile));
                if (this.inputFormat == INPUT_FORMAT.hapmap) {
                    try {
                        a = ImportUtils.readFromHapmap(this.infile, this);
                        break block13;
                    }
                    catch (Exception e) {
                        myLogger.info((Object)("Could not read input hapmap file for chr" + chr + ":\n\t" + this.infile + "\n\tSkipping..."));
                        continue;
                    }
                }
                if (this.inputFormat == INPUT_FORMAT.vcf) {
                    try {
                        a = ImportUtils.readFromVCF(this.infile, this, true);
                        break block13;
                    }
                    catch (Exception e) {
                        myLogger.info((Object)("Could not read input vcf file for chr" + chr + ":\n\t" + this.infile + "\n\tSkipping..."));
                        continue;
                    }
                }
                throw new IllegalArgumentException("File format " + (Object)((Object)this.inputFormat) + " is not recognized!");
            }
            myLogger.info((Object)("Original Alignment  Taxa:" + a.numberOfTaxa() + " Sites:" + a.numberOfSites()));
            if (a.numberOfSites() == 0) continue;
            double realDist = AlignmentFilterByGBSUtils.getErrorRateForDuplicatedTaxa(a, true, false, false);
            double randomDist = AlignmentFilterByGBSUtils.getErrorRateForDuplicatedTaxa(a, true, true, false);
            AlignmentFilterByGBSUtils.getCoverage_MAF_F_Dist(a, false);
            myLogger.info((Object)("Ratio of RandomToReal:" + randomDist / realDist));
            if (this.myArgsEngine.getBoolean("-mnTCov")) {
                double tCov = Double.parseDouble(this.myArgsEngine.getString("-mnTCov"));
                if (this.lowCoverageTaxa == null) {
                    this.lowCoverageTaxa = GBSHapMapFiltersPlugin.getLowCoverageLines(a, tCov);
                }
                TaxaList keepTaxa = AlignmentFilterByGBSUtils.getFilteredIdGroupByName(a.taxa(), this.lowCoverageTaxa, false);
                a = FilterGenotypeTable.getInstance(a, keepTaxa);
                myLogger.info((Object)("TaxaFiltered Alignment  Taxa:" + a.numberOfTaxa() + " Sites:" + a.numberOfSites()));
                if (a.numberOfSites() == 0) continue;
            }
            realDist = AlignmentFilterByGBSUtils.getErrorRateForDuplicatedTaxa(a, true, false, false);
            randomDist = AlignmentFilterByGBSUtils.getErrorRateForDuplicatedTaxa(a, true, true, false);
            AlignmentFilterByGBSUtils.getCoverage_MAF_F_Dist(a, false);
            myLogger.info((Object)("Ratio of RandomToReal:" + randomDist / realDist));
            int minCount = (int)Math.round((double)a.numberOfTaxa() * this.minPresence);
            if (this.usePedigree) {
                goodLowHetSites = AlignmentFilterByGBSUtils.getLowHetSNPs(a, false, -2.0, minCount, this.minMAF, this.maxMAF, this.snpLogging, "Filter the sites for minCount, minMAF and maxMAF (but not minF) based on all of the taxa");
                a = FilterGenotypeTable.getInstance(a, goodLowHetSites);
                String[] highExpectedFTaxa = this.getHighExpectedFTaxa(a);
                TaxaList highExpectedFTaxaIDGroup = AlignmentFilterByGBSUtils.getFilteredIdGroupByName(a.taxa(), highExpectedFTaxa, true);
                GenotypeTable inbredGenos = FilterGenotypeTable.getInstance(a, highExpectedFTaxaIDGroup);
                int[] goodLowFSites = AlignmentFilterByGBSUtils.getLowHetSNPs(inbredGenos, false, this.minF, 0, -0.1, 2.0, this.snpLogging, "Filter the sites for minF only based only on the taxa with expectedF >= minF");
                inbredGenos = null;
                System.gc();
                a = FilterGenotypeTable.getInstance(a, goodLowFSites);
            } else {
                goodLowHetSites = AlignmentFilterByGBSUtils.getLowHetSNPs(a, false, this.minF, minCount, this.minMAF, this.maxMAF, this.snpLogging, "Filter the sites");
                a = FilterGenotypeTable.getInstance(a, goodLowHetSites);
            }
            myLogger.info((Object)("SiteFiltered Alignment  Taxa:" + a.numberOfTaxa() + " Sites:" + a.numberOfSites()));
            if (a.numberOfSites() == 0) continue;
            realDist = AlignmentFilterByGBSUtils.getErrorRateForDuplicatedTaxa(a, true, false, true);
            randomDist = AlignmentFilterByGBSUtils.getErrorRateForDuplicatedTaxa(a, true, true, false);
            System.out.printf("%d %d %g %g %g %n", a.numberOfSites(), minCount, this.minF, this.minMAF, randomDist / realDist);
            AlignmentFilterByGBSUtils.getCoverage_MAF_F_Dist(a, false);
            if (this.inputFormat == INPUT_FORMAT.hapmap) {
                ExportUtils.writeToHapmap(a, false, this.outfile, '\t', null);
            } else {
                ExportUtils.writeToVCF(a, this.outfile, true);
            }
            myLogger.info((Object)("File written after basic filtering:" + this.outfile));
            if (!this.hLD) continue;
            a = ImportUtils.readFromHapmap(this.outfile, null);
            int[] gs = AlignmentFilterByGBSUtils.getGoodSitesByLD(a, this.minR2, this.minBonP, 128, 100, 20, false);
            a = FilterGenotypeTable.getInstance(a, gs);
            myLogger.info((Object)("LDFiltered Alignment  Taxa:" + a.numberOfTaxa() + " Sites:" + a.numberOfSites()));
            if (a.numberOfSites() == 0) continue;
            ExportUtils.writeToHapmap(a, false, this.outfile, '\t', null);
            myLogger.info((Object)("File written after basic & LD filtering:" + this.outfile));
        }
        this.snpLogging.close();
        return null;
    }

    private void printUsage() {
        myLogger.info((Object)("\n\n\nThe GBSHapMapFiltersPlugin accepts the following options:\n-hmp     Input HapMap file; use a plus sign (+) as a wild card character to \n           specify multiple chromosome numbers.\n-vcf     Input VCF file. Use a plus sign (+) as a wild card character to specify \n         multiple chromosome numbers. Options -hmp and -vcf are mutual exclusive.\n-o       Output HapMap file\n-mnTCov  Minimum taxa coverage (default: no filter)\n-mnSCov  Minimum presence (default: no filter)\n-mnF     Minimum F (inbreeding coefficient) (default -2.0 = no filter)\n-p       Pedigree file containing full sample names (or expected names after merging) & expected inbreeding\n         coefficient (F) for each.  Only taxa with expected F >= mnF used to calculate F = 1-Ho/He.\n         (default: use ALL taxa to calculate F)\n-mnMAF   Minimum minor allele frequency (default: 0.0 = no filter)\n-mxMAF   Maximum minor allele frequency (default: 1.0 = no filter)\n-hLD     Filter for high LD\n-mnR2    Minimum R-square value for the LD filter (default: " + this.minR2 + ")\n" + "-mnBonP  Minimum Bonferroni-corrected p-value for the LD filter (default: " + this.minBonP + ")\n" + "-sC      Start chromosome (default: 1).\n" + "-eC      End chromosome (default: 10).\n" + "-maxAlleleVCF   Maximum number of alleles allowed in vcf file.\n" + "-snpLog  SNPs Removed Log file name\n\n"));
    }

    @Override
    public void setParameters(String[] args) {
        if (args.length == 0) {
            this.printUsage();
            throw new IllegalArgumentException("\n\nPlease use the above arguments/options.\n\n");
        }
        if (this.myArgsEngine == null) {
            this.myArgsEngine = new ArgsEngine();
            this.myArgsEngine.add("-hmp", "-hmpFile", true);
            this.myArgsEngine.add("-vcf", "-vcfFile", true);
            this.myArgsEngine.add("-o", "--outFile", true);
            this.myArgsEngine.add("-mnTCov", "--minTaxaCov", true);
            this.myArgsEngine.add("-mnSCov", "--minSiteCov", true);
            this.myArgsEngine.add("-mnF", "--minFInbreeding", true);
            this.myArgsEngine.add("-p", "--pedigree-file", true);
            this.myArgsEngine.add("-mnMAF", "--minMinorAlleleFreq", true);
            this.myArgsEngine.add("-mxMAF", "--maxinorAlleleFreq", true);
            this.myArgsEngine.add("-hLD", "--highLD", false);
            this.myArgsEngine.add("-mnR2", "--minRSquare", true);
            this.myArgsEngine.add("-mnBonP", "--minBonferronPForLD", true);
            this.myArgsEngine.add("-sC", "--startChrom", true);
            this.myArgsEngine.add("-eC", "--endChrom", true);
            this.myArgsEngine.add("-maxAlleleVCF", "--maxAlleleVCF", true);
            this.myArgsEngine.add("-snpLog", "", true);
        }
        this.myArgsEngine.parse(args);
        if (!this.myArgsEngine.getBoolean("-sC")) {
            this.printUsage();
            throw new IllegalArgumentException("Please provide a start chromosome.\n");
        }
        this.startChromosome = Integer.parseInt(this.myArgsEngine.getString("-sC"));
        if (!this.myArgsEngine.getBoolean("-eC")) {
            this.printUsage();
            throw new IllegalArgumentException("Please provide an end chromosome.\n");
        }
        this.endChromosome = Integer.parseInt(this.myArgsEngine.getString("-eC"));
        if (this.myArgsEngine.getBoolean("-mnSCov")) {
            this.minPresence = Double.parseDouble(this.myArgsEngine.getString("-mnSCov"));
        }
        if (this.myArgsEngine.getBoolean("-mnF")) {
            this.minF = Double.parseDouble(this.myArgsEngine.getString("-mnF"));
        }
        if (this.myArgsEngine.getBoolean("-p")) {
            String pedigreeFileStr = this.myArgsEngine.getString("-p");
            File pedigreeFile = new File(pedigreeFileStr);
            if (!pedigreeFile.exists() || !pedigreeFile.isFile()) {
                this.printUsage();
                throw new IllegalArgumentException("Can't find the pedigree input file (-p option: " + pedigreeFileStr + ").");
            }
            this.taxaFs = DiscoverySNPCallerPlugin.readTaxaFsFromFile(pedigreeFile);
            if (this.taxaFs == null) {
                throw new IllegalArgumentException("Problem reading the pedigree file. Progam aborted.");
            }
            this.usePedigree = true;
        }
        if (this.myArgsEngine.getBoolean("-mnMAF")) {
            this.minMAF = Double.parseDouble(this.myArgsEngine.getString("-mnMAF"));
        }
        if (this.myArgsEngine.getBoolean("-mxMAF")) {
            this.maxMAF = Double.parseDouble(this.myArgsEngine.getString("-mxMAF"));
        }
        if (this.myArgsEngine.getBoolean("-hLD")) {
            this.hLD = true;
        }
        if (this.myArgsEngine.getBoolean("-mnR2")) {
            if (this.hLD) {
                this.minR2 = Double.parseDouble(this.myArgsEngine.getString("-mnR2"));
            } else {
                this.printUsage();
                throw new IllegalArgumentException("The -mnR2 option requires that the -hLD option is invoked\n");
            }
        }
        if (this.myArgsEngine.getBoolean("-mnBonP")) {
            if (this.hLD) {
                this.minBonP = Double.parseDouble(this.myArgsEngine.getString("-mnBonP"));
            } else {
                this.printUsage();
                throw new IllegalArgumentException("The -mnBonP option requires that the -hLD option is invoked\n");
            }
        }
        if (this.myArgsEngine.getBoolean("-hmp")) {
            if (this.myArgsEngine.getBoolean("-vcf")) {
                throw new IllegalArgumentException("-hmp and -vcf options are mutual exclusive!\n");
            }
            this.suppliedInputFileName = this.myArgsEngine.getString("-hmp");
            this.inputFormat = INPUT_FORMAT.hapmap;
        } else if (this.myArgsEngine.getBoolean("-vcf")) {
            this.suppliedInputFileName = this.myArgsEngine.getString("-vcf");
            this.inputFormat = INPUT_FORMAT.vcf;
        } else {
            this.printUsage();
            throw new IllegalArgumentException("Please specify a HapMap or VCF file to filter.\n");
        }
        if (!this.myArgsEngine.getBoolean("-o")) {
            this.printUsage();
            throw new IllegalArgumentException("Please specify an output file name.\n");
        }
        this.suppliedOutputFileName = this.myArgsEngine.getString("-o");
        if (this.myArgsEngine.getBoolean("-maxAlleleVCF")) {
            if (!this.myArgsEngine.getBoolean("-vcf")) {
                throw new IllegalArgumentException("-maxAlleleVCF option only works with -vcf input.\n");
            }
            this.myMaxNumAlleles = Integer.parseInt(this.myArgsEngine.getString("-maxAlleleVCF"));
        } else {
            this.myMaxNumAlleles = 3;
        }
        if (this.myArgsEngine.getBoolean("-snpLog")) {
            this.snpLogFileName = this.myArgsEngine.getString("-snpLog");
        }
        this.snpLogging = new SNPLogging(this.snpLogFileName, this.getClass());
    }

    public static String[] getLowCoverageLines(GenotypeTable a, double pCoverage) {
        ArrayList<String> lowLines = new ArrayList<String>();
        for (int i = 0; i < a.numberOfTaxa(); ++i) {
            int covered = 0;
            for (int j = 0; j < a.numberOfSites(); ++j) {
                if (a.genotype(i, j) == -1) continue;
                ++covered;
            }
            double propCovered = (double)covered / (double)a.numberOfSites();
            if (!(propCovered < pCoverage)) continue;
            lowLines.add(a.taxaName(i));
        }
        String[] lowL = lowLines.toArray(new String[0]);
        return lowL;
    }

    private String[] getHighExpectedFTaxa(GenotypeTable a) {
        ArrayList<String> highFLines = new ArrayList<String>();
        int nInbredTaxa = 0;
        for (int taxon = 0; taxon < a.numberOfTaxa(); ++taxon) {
            String fullTaxonName = a.taxaName(taxon);
            if (!this.taxaFs.containsKey(fullTaxonName) || !(this.taxaFs.get(fullTaxonName) >= this.minF)) continue;
            highFLines.add(fullTaxonName);
            ++nInbredTaxa;
        }
        myLogger.info((Object)(nInbredTaxa + " taxa with an Expected F >= the mnF of " + this.minF + " were found in the pedigree file (-p option)"));
        String[] highF = highFLines.toArray(new String[0]);
        return highF;
    }

    @Override
    public ImageIcon getIcon() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getButtonName() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getToolTipText() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private static enum INPUT_FORMAT {
        hapmap,
        vcf;

    }
}

