/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs;

import net.maizegenetics.analysis.gbs.ShortReadBarcodeResult;

public class PEReadBarcodeResult {
    long[] readF;
    short lengthF;
    long[] readB;
    short lengthB;
    String taxonName;

    public PEReadBarcodeResult(ShortReadBarcodeResult rF, ShortReadBarcodeResult rB) {
        this.taxonName = rF.taxonName;
        this.readF = rF.read;
        this.lengthF = rF.length;
        this.readB = rB.read;
        this.lengthB = rB.length;
        this.orderReadFReadB();
    }

    public short getLengthF() {
        return this.lengthF;
    }

    public short getLengthB() {
        return this.lengthB;
    }

    public long[] getReadF() {
        return this.readF;
    }

    public long[] getReadB() {
        return this.readB;
    }

    public String getTaxonName() {
        return this.taxonName;
    }

    public int getTagLengthInLong() {
        return this.readF.length;
    }

    private boolean orderReadFReadB() {
        if (this.compareReadFReadB() == 1) {
            this.switchReadFReadB();
            return true;
        }
        return false;
    }

    private void switchReadFReadB() {
        for (int i = 0; i < this.readF.length; ++i) {
            long temp = this.readF[i];
            this.readF[i] = this.readB[i];
            this.readB[i] = temp;
        }
        short tem = this.lengthF;
        this.lengthF = this.lengthB;
        this.lengthB = tem;
    }

    private int compareReadFReadB() {
        int tagLengthInLong = this.readF.length;
        for (int i = 0; i < tagLengthInLong; ++i) {
            if (this.readF[i] < this.readB[i]) {
                return -1;
            }
            if (this.readF[i] <= this.readB[i]) continue;
            return 1;
        }
        return 0;
    }
}

