/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs;

import com.google.common.collect.ImmutableMap;
import java.io.BufferedReader;
import java.nio.file.Path;
import java.util.Map;
import net.maizegenetics.analysis.gbs.DiscoveryTBTPlugin;
import net.maizegenetics.analysis.gbs.ParseBarcodeRead2;
import net.maizegenetics.analysis.gbs.ReadBarcodeResult;
import net.maizegenetics.dna.tag.Tag;
import net.maizegenetics.dna.tag.TagBuilder;
import net.maizegenetics.dna.tag.TaxaDistBuilder;
import net.maizegenetics.dna.tag.TaxaDistribution;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListIOUtils;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;

class ProcessFastQFile
implements Runnable {
    private static final Logger myLogger = Logger.getLogger(DiscoveryTBTPlugin.class);
    private final TaxaList masterTaxaList;
    private final Path keyPath;
    private final Path fastQPath;
    private final Map<Tag, TaxaDistribution> masterTagTaxaMap;
    private String enzyme;
    private final int minQuality;
    private final String sampleNameField = "FullSampleName";
    private final String enzymeField = "Enzyme";
    private final String flowcellField = "Flowcell";
    private final String laneField = "Lane";

    ProcessFastQFile(TaxaList masterTaxaList, Path keyPath, Path fastQPath, String enzyme, int minQuality, Map<Tag, TaxaDistribution> masterTagTaxaMap) {
        this.masterTaxaList = masterTaxaList;
        this.keyPath = keyPath;
        this.fastQPath = fastQPath;
        this.masterTagTaxaMap = masterTagTaxaMap;
        this.enzyme = enzyme;
        this.minQuality = minQuality;
    }

    @Override
    public void run() {
        TaxaList tl = this.getLaneAnnotatedTaxaList(this.keyPath, this.fastQPath);
        if (this.enzyme == null) {
            this.enzyme = ((Taxon)tl.get(0)).getTextAnnotation("Enzyme")[0];
        }
        ParseBarcodeRead2 thePBR = new ParseBarcodeRead2(tl, this.enzyme, this.masterTaxaList);
        this.processFastQ(this.fastQPath, thePBR);
    }

    private TaxaList getLaneAnnotatedTaxaList(Path keyPath, Path fastQpath) {
        TaxaList annoTL;
        String[] filenameField = fastQpath.getFileName().toString().split("_");
        if (filenameField.length == 3) {
            annoTL = TaxaListIOUtils.readTaxaAnnotationFile(keyPath.toAbsolutePath().toString(), "FullSampleName", (Map<String, String>)ImmutableMap.of((Object)"Flowcell", (Object)filenameField[0], (Object)"Lane", (Object)filenameField[1]), false);
        } else if (filenameField.length == 4) {
            annoTL = TaxaListIOUtils.readTaxaAnnotationFile(keyPath.toAbsolutePath().toString(), "FullSampleName", (Map<String, String>)ImmutableMap.of((Object)"Flowcell", (Object)filenameField[0], (Object)"Lane", (Object)filenameField[2]), false);
        } else if (filenameField.length == 5) {
            annoTL = TaxaListIOUtils.readTaxaAnnotationFile(keyPath.toAbsolutePath().toString(), "FullSampleName", (Map<String, String>)ImmutableMap.of((Object)"Flowcell", (Object)filenameField[1], (Object)"Lane", (Object)filenameField[3]), false);
        } else {
            myLogger.error((Object)("Error in parsing file name: " + fastQpath.toString()));
            myLogger.error((Object)"   The filename does not contain either 3, 4, or 5 underscore-delimited values.");
            myLogger.error((Object)"   Expect: flowcell_lane_fastq.txt.gz OR flowcell_s_lane_fastq.txt.gz OR code_flowcell_s_lane_fastq.txt.gz");
            return null;
        }
        return annoTL;
    }

    private void processFastQ(Path fastqFile, ParseBarcodeRead2 thePBR) {
        int goodBarcodedReads = 0;
        int maxTaxaNumber = this.masterTaxaList.size();
        try {
            BufferedReader br = Utils.getBufferedReader(fastqFile.toString(), 0x400000);
            int currLine = 0;
            long time = System.nanoTime();
            int allReads = 0;
            goodBarcodedReads = 0;
            String sequence = "";
            String qualityScore = "";
            String temp = br.readLine();
            while (temp != null) {
                if (++currLine % 0x100000 == 0) {
                    System.out.printf("File line %d processing rate %d ns/line  %n", currLine, (System.nanoTime() - time) / (long)currLine);
                }
                try {
                    if ((currLine + 2) % 4 == 0) {
                        sequence = temp;
                    } else if (currLine % 4 == 0) {
                        qualityScore = temp;
                        ++allReads;
                        ReadBarcodeResult rr = thePBR.parseReadIntoTagAndTaxa(sequence, qualityScore, true, this.minQuality);
                        if (rr != null) {
                            ++goodBarcodedReads;
                            Tag tg = TagBuilder.instance(rr.getRead(), (short)rr.getLength());
                            TaxaDistribution iC = this.masterTagTaxaMap.get(tg);
                            if (iC == null) {
                                this.masterTagTaxaMap.put(tg, TaxaDistBuilder.create(maxTaxaNumber, rr.getTaxonIndex()));
                            } else if (iC.totalDepth() == 1) {
                                this.masterTagTaxaMap.put(tg, TaxaDistBuilder.create(iC).increment(rr.getTaxonIndex()));
                            } else {
                                iC.increment(rr.getTaxonIndex());
                            }
                        }
                        if (allReads % 1000000 == 0) {
                            myLogger.info((Object)("Total Reads:" + allReads + " Reads with barcode and cut site overhang:" + goodBarcodedReads));
                        }
                    }
                }
                catch (NullPointerException e) {
                    e.printStackTrace();
                    myLogger.error((Object)("Unable to correctly parse the sequence and: " + sequence + " and quality score: " + qualityScore + " from fastq file.  Your fastq file may have been corrupted."));
                    System.exit(1);
                }
                temp = br.readLine();
            }
            myLogger.info((Object)("Total number of reads in lane=" + allReads));
            myLogger.info((Object)("Total number of good barcoded reads=" + goodBarcodedReads));
            myLogger.info((Object)"Timing process (sorting, collapsing, and writing TagCount to file).");
            long timePoint1 = System.currentTimeMillis();
            System.out.println("tagCntMap size" + this.masterTagTaxaMap.size());
            myLogger.info((Object)("Process took " + (System.currentTimeMillis() - timePoint1) + " milliseconds."));
            br.close();
        }
        catch (Exception e) {
            myLogger.error((Object)("Good Barcodes Read: " + goodBarcodedReads));
            e.printStackTrace();
        }
    }
}

