/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs;

import java.awt.Frame;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FilenameFilter;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.gbs.ProductionSNPCallerPlugin;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.util.DirectoryCrawler;
import net.maizegenetics.util.LoggingUtils;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;

public class ProductionPipeline
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(ProductionPipeline.class);
    private static final SimpleDateFormat LOGGING_DATE_FORMAT = new SimpleDateFormat("yyyyMMdd HH:mm:ss");
    private static final String READY_FILE_NAME = "ready.txt";
    private static final String LOCK_FILE_NAME = "lock.txt";
    private static final String SUMMARY_LOG_FILE = "ProductionPipeline.log";
    private PluginParameter<String> myInputDirectory = new PluginParameter.Builder<String>("inputDirectory", null, String.class).required(true).inDir().description("Input directory containing subdirectories with fastq AND/OR qseq files").build();
    private PluginParameter<String> myEnzyme = new PluginParameter.Builder<String>("enzyme", null, String.class).required(true).description("Enzyme used to create the GBS library").build();
    private PluginParameter<String> myProductionTOPM = new PluginParameter.Builder<String>("productionTOPM", null, String.class).required(true).inFile().description("Physical map file containing tags and corresponding variants (production TOPM)").build();
    private PluginParameter<String> myOutputGenotypeFile = new PluginParameter.Builder<String>("outputGenotypeFile", null, String.class).required(true).outFile().description("Output (target) HDF5 genotypes file to add new genotypes to (new file created if it doesn't exist)").build();
    private PluginParameter<String> myArchiveDirectory = new PluginParameter.Builder<String>("archiveDirectory", null, String.class).required(true).outDir().description("Archive directory where to move processed files").build();
    private String myOutputDirectory;
    private BufferedWriter mySummaryLogFile;

    public ProductionPipeline(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    public void postProcessParameters() {
        if (this.myOutputGenotypeFile.value() != null) {
            this.myOutputDirectory = Utils.getDirectory(this.myOutputGenotypeFile.value());
            this.setupLogfile();
        }
        myLogger.info((Object)ProductionPipeline.getTimeStamp());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSet processData(DataSet input) {
        String lockFilename = this.inputDirectory() + File.separator + LOCK_FILE_NAME;
        try {
            String[] directories;
            if (!new File(lockFilename).createNewFile()) {
                myLogger.warn((Object)("Production Pipeline already running.  File exists: " + lockFilename + "  Aborting..."));
                DataSet dataSet = null;
                return dataSet;
            }
            String logFilename = this.inputDirectory() + File.separator + SUMMARY_LOG_FILE;
            this.mySummaryLogFile = Utils.getBufferedWriter(logFilename, true);
            File inputDirectory = new File(this.inputDirectory());
            for (String current : directories = inputDirectory.list(new FilenameFilter(){

                @Override
                public boolean accept(File current, String name) {
                    return new File(current, name).isDirectory();
                }
            })) {
                String fullDirName = this.inputDirectory() + File.separator + current;
                try {
                    this.processSubDirectory(fullDirName);
                    File currentLocation = new File(fullDirName);
                    File newLocation = new File(this.archiveDirectory() + current);
                    currentLocation.renameTo(newLocation);
                    myLogger.info((Object)("Moved : " + currentLocation.getAbsolutePath() + " to: " + newLocation.getAbsolutePath()));
                    this.writeToSummaryLogFile("Moved : " + currentLocation.getAbsolutePath() + " to: " + newLocation.getAbsolutePath());
                }
                catch (Exception e) {
                    this.writeToSummaryLogFile("Production Pipeline Failed: " + fullDirName);
                    myLogger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            String[] stringArray = null;
            return stringArray;
        }
        catch (Exception ex) {
            this.writeToSummaryLogFile("Problem Running Production Pipeline: " + ex.getMessage());
            myLogger.error((Object)ex.getMessage(), (Throwable)ex);
            DataSet dataSet = null;
            return dataSet;
        }
        finally {
            LoggingUtils.closeLogfile();
            try {
                this.mySummaryLogFile.close();
            }
            catch (Exception e) {}
            new File(lockFilename).delete();
        }
    }

    private void processSubDirectory(String subDirectory) {
        this.writeToSummaryLogFile("----------- Production Pipeline Started: " + subDirectory);
        String readyFilename = subDirectory + File.separator + READY_FILE_NAME;
        File readyFile = new File(readyFilename);
        if (!readyFile.exists()) {
            myLogger.warn((Object)("This directory is not ready yet: " + subDirectory));
            this.writeToSummaryLogFile("Ready File not Found; " + readyFilename);
            return;
        }
        myLogger.info((Object)("Processing directory: " + subDirectory));
        readyFile.delete();
        String keyFile = subDirectory + File.separator + Utils.getFilename(subDirectory) + "_key.txt";
        if (!new File(keyFile).exists()) {
            myLogger.error((Object)("Keyfile doesn't exist: " + keyFile));
            this.writeToSummaryLogFile("Keyfile doesn't exist: " + keyFile);
            return;
        }
        Object[] rawSeqFileNames = DirectoryCrawler.listFileNames("(?i).*\\.fq$|.*\\.fq\\.gz$|.*\\.fastq$|.*_fastq\\.txt$|.*_fastq\\.gz$|.*_fastq\\.txt\\.gz$|.*_sequence\\.txt$|.*_sequence\\.txt\\.gz$|.*_qseq\\.txt$|.*_qseq\\.txt\\.gz$", subDirectory);
        if (rawSeqFileNames == null || rawSeqFileNames.length == 0) {
            myLogger.warn((Object)("No sequence files in directory: " + subDirectory));
            this.writeToSummaryLogFile("No sequence files in directory");
            return;
        }
        Object[] args = this.getPluginArgs(subDirectory, keyFile);
        myLogger.info((Object)("Raw Sequence Files: " + Arrays.deepToString(rawSeqFileNames)));
        myLogger.info((Object)("Parameters Passed to ProductionSNPCallerPlugin: " + Arrays.deepToString(args)));
        this.writeToSummaryLogFile("Raw Sequence Files: " + Arrays.deepToString(rawSeqFileNames));
        this.writeToSummaryLogFile("Parameters Passed to ProductionSNPCallerPlugin: " + Arrays.deepToString(args));
        ProductionSNPCallerPlugin plugin = new ProductionSNPCallerPlugin();
        plugin.setParameters((String[])args);
        this.printParameterValues();
        plugin.performFunction(null);
        this.writeToSummaryLogFile("Production Pipeline Finished: " + subDirectory);
    }

    private String[] getPluginArgs(String inputDir, String keyFile) {
        String[] args = new String[]{"-i", inputDir, "-k", keyFile, "-e", this.enzyme(), "-o", this.outputGenotypeFile(), "-m", this.productionTOPM(), "-ko"};
        return args;
    }

    private void setupLogfile() {
        String todayDate = new SimpleDateFormat("yyyyMMdd").format(new Date());
        String logFileName = todayDate + "_" + "ProductionPipeline" + ".log";
        logFileName = this.myOutputDirectory + "/" + logFileName;
        myLogger.info((Object)("Log File: " + logFileName));
        try {
            LoggingUtils.setupLogfile(logFileName);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("ProductionPipeline: setupLogfile: " + logFileName + " doesn't exist.");
        }
    }

    private void writeToSummaryLogFile(String str) {
        try {
            this.mySummaryLogFile.write(ProductionPipeline.getTimeStamp());
            this.mySummaryLogFile.write(str);
            this.mySummaryLogFile.write("\n");
        }
        catch (Exception e) {
            myLogger.error((Object)"writeToSummaryLogFile: Problem writing to Summary Log File.");
        }
    }

    private static String getTimeStamp() {
        return "Timestamp: " + LOGGING_DATE_FORMAT.format(new Date()) + ": ";
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return "Production Pipeline";
    }

    @Override
    public String getToolTipText() {
        return "Production Pipeline";
    }

    public String inputDirectory() {
        return this.myInputDirectory.value();
    }

    public ProductionPipeline inputDirectory(String value) {
        this.myInputDirectory = new PluginParameter<String>(this.myInputDirectory, value);
        return this;
    }

    public String enzyme() {
        return this.myEnzyme.value();
    }

    public ProductionPipeline enzyme(String value) {
        this.myEnzyme = new PluginParameter<String>(this.myEnzyme, value);
        return this;
    }

    public String productionTOPM() {
        return this.myProductionTOPM.value();
    }

    public ProductionPipeline productionTOPM(String value) {
        this.myProductionTOPM = new PluginParameter<String>(this.myProductionTOPM, value);
        return this;
    }

    public String outputGenotypeFile() {
        return this.myOutputGenotypeFile.value();
    }

    public ProductionPipeline outputGenotypeFile(String value) {
        this.myOutputGenotypeFile = new PluginParameter<String>(this.myOutputGenotypeFile, value);
        return this;
    }

    public String archiveDirectory() {
        return this.myArchiveDirectory.value();
    }

    public ProductionPipeline archiveDirectory(String value) {
        this.myArchiveDirectory = new PluginParameter<String>(this.myArchiveDirectory, value);
        return this;
    }
}

