/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.io.Files;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import javax.mail.MessagingException;
import net.maizegenetics.analysis.gbs.ProductionSNPCallerPlugin;
import net.maizegenetics.analysis.imputation.FILLINImputationPlugin;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.ImportUtils;
import net.maizegenetics.prefs.TasselPrefs;
import net.maizegenetics.util.CheckSum;
import net.maizegenetics.util.SMTPClient;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ProductionPipelineMain {
    private final Logger myLogger = Logger.getLogger(ProductionPipelineMain.class);
    private String applicationHost = "unknown";
    public static String applicationConfiguration = "production_pipeline.properties";
    private String runFileSuffix = ".run";
    private String emailHost = "appsmtp.mail.cornell.edu";
    private String[] emailAddresses = new String[]{"dek29@cornell.edu"};
    private String emailAddressDelimiters = ";";
    private String emailSubjectBase = "GPP ";
    private String runDirectory = "/SSD/prop_pipeline/run/";
    private String archiveDirectory = "/SSD/prop_pipeline/arcvtmp/";
    private String haplosDirectory = "/SSD/haplos/";
    private String todayDate = null;
    private String fileNameBase = null;
    private String anInputFolder = null;
    private String enzyme = null;
    private String topmFile = null;
    private String outputFolder = null;
    private String keyFile = null;
    private String hostName = "host unknown";
    private String expectedCheckSum = "10e75e612ade7979f210958933da4de9";
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd HH:mm:ss");
    private String propertiesFileContents = null;
    private String exampleAppConfigFile = "runFileSuffix=.run\nemailHost=appsmtp.mail.cornell.edu\nemailAddress=dek29@cornell.edu\nrunDirectory=/SSD/prop_pipeline/run/\narchiveDirectory=/SSD/prop_pipeline/arcvtmp/\nhaplosDirectory=/SSD/haplos/\n";
    private String exampleRunFile = "inputFolder=/workdir/tassel/tassel4-src/20130716test/raw_seq\nenzyme=ApeKI\ntopmFile=/workdir/tassel/tassel4-src/20130716test/topm/AllZeaGBSv2.6ProdTOPM_20130605.topm.h5\noutputFolder=/workdir/tassel/tassel4-src/20130716test/hap_maps\nkeyFile=/workdir/tassel/tassel4-src/20130716test/keyfile/MGP1_low_vol_2smallReps_key.txt";

    public ProductionPipelineMain(String appPropertiesFile, boolean runCheckSum, boolean runImputation, String testingCheckSum) {
        this.init();
        if (appPropertiesFile == null) {
            appPropertiesFile = applicationConfiguration;
        }
        this.propertiesFileContents = this.loadApplicationConfiguration(appPropertiesFile);
        this.loadRunFiles(this.runDirectory, runCheckSum, runImputation, testingCheckSum);
    }

    private void init() {
        try {
            this.applicationHost = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    private void loadRunFiles(String runDirectoryIn, boolean doCheckSum, boolean runImputation, String testingCheckSum) {
        File[] files;
        File dir = new File(runDirectoryIn);
        if (!dir.exists()) {
            System.out.println("Could not find the directory containing .run files: " + dir.getPath());
            System.out.println("Exiting program.");
            this.sendAlertNotification(this.emailSubjectBase + "- Error", "Could not find directory: " + dir.getAbsolutePath() + " on  server " + this.applicationHost);
            System.exit(1);
        }
        if ((files = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(ProductionPipelineMain.this.runFileSuffix);
            }
        })) == null) {
            System.out.println("************** Could not find a valid .run file ***************");
            System.out.println("************** Example .run file: ");
            System.out.println(this.exampleRunFile);
            this.sendAlertNotification(this.emailSubjectBase + "- No Files", "No .run files found on " + this.applicationHost);
        } else {
            StringBuffer sb = new StringBuffer();
            File[] fileArray = files;
            int n = fileArray.length;
            for (int i = 0; i < n; ++i) {
                File f = fileArray[i];
                sb.append(f + "\n");
            }
            sb.append("\nRunning on server: " + this.applicationHost + "\n");
            this.sendAlertNotification(this.emailSubjectBase + "- File Count: " + files.length, sb.toString());
        }
        for (File aFile : files) {
            String msgBody = "Starting to run " + aFile.getAbsolutePath() + " on server " + this.applicationHost;
            this.sendAlertNotification(this.emailSubjectBase + " File: " + aFile.getName(), msgBody);
            String runFileContents = this.loadRunConfiguration(aFile);
            SimpleDateFormat yyyyMMdd_format = new SimpleDateFormat("yyyyMMdd");
            this.todayDate = yyyyMMdd_format.format(new Date());
            String fileName = FilenameUtils.removeExtension((String)aFile.getName());
            this.fileNameBase = this.todayDate + "_" + fileName;
            String logFileName = this.fileNameBase + ".log";
            String contextLog = this.recordContext(new File(this.outputFolder), doCheckSum);
            String runFileMsg = this.getTimeStamp() + ": Contents of the .run file: ";
            File logFile = new File(this.outputFolder + "/" + logFileName);
            try {
                if (!logFile.exists()) {
                    logFile.createNewFile();
                }
                BufferedWriter bw = new BufferedWriter(new FileWriter(logFile.getAbsolutePath()));
                bw.write("Contents of the .properties file:\n" + this.propertiesFileContents);
                bw.write(runFileMsg + "\n" + runFileContents);
                bw.write(contextLog);
                bw.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            PrintStream ps = null;
            try {
                ps = new PrintStream(new BufferedOutputStream(new FileOutputStream(logFile.getAbsolutePath(), true)));
            }
            catch (FileNotFoundException fnfe) {
                fnfe.printStackTrace();
            }
            System.setOut(ps);
            System.setErr(ps);
            System.out.println(this.getTimeStamp() + " Initializing ProductionSNPCallerPlugin \n");
            Date start = new Date();
            String[] pluginArgs = this.getPipelinePluginArgs();
            StringBuilder builder = new StringBuilder();
            for (String s : pluginArgs) {
                builder.append(s + "\n");
            }
            System.out.println("Arguments passed to ProductionSNPCallerPlugin:\n" + builder.toString());
            ProductionSNPCallerPlugin pscp = new ProductionSNPCallerPlugin();
            System.out.println(this.getTimeStamp() + " Initialized ProductionSNPCallerPlugin \n");
            pscp.setParameters(pluginArgs);
            System.out.println(this.getTimeStamp() + " Done with ProductionSNPCallerPlugin.setParameters() \n");
            pscp.performFunction(null);
            System.out.println(this.getTimeStamp() + " Done with ProductionSNPCallerPlugin.performFunction() \n");
            if (runImputation) {
                String[] name = aFile.getName().split("\\.");
                String h5File = this.outputFolder + "/" + name[0] + ".hmp.h5";
                String haploDir = this.haplosDirectory + "/" + "AllZeaGBSv27.gX.hmp.txt.gz";
                String targetFile = this.outputFolder + "/" + name[0] + ".globalimp.hmp.h5";
                this.runImputation(h5File, haploDir, targetFile);
            }
            Date stop = new Date();
            long startTime = start.getTime();
            long stopTime = stop.getTime();
            long diff = stopTime - startTime;
            long elapsedSeconds = diff / 1000L;
            String emailSubject = this.emailSubjectBase + this.anInputFolder;
            String email = "Ran:\n " + this.anInputFolder + "\n\n  Tassel Pipeline Execution Time: " + elapsedSeconds + " seconds" + "\n\n Attachment:\n " + logFile.getAbsolutePath() + "\nRun on server: " + this.applicationHost;
            StringBuffer emailMsg = new StringBuffer(email);
            if (testingCheckSum != null) {
                String suffix = ".hmp.txt.gz";
                File outDir = new File(this.outputFolder);
                File[] hapMapFiles = outDir.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.endsWith(".hmp.txt.gz");
                    }
                });
                boolean passedTest = false;
                for (File f : hapMapFiles) {
                    String filename = f.getAbsolutePath();
                    String cksum = CheckSum.getChecksum(filename, "MD5");
                    if (cksum.equalsIgnoreCase(this.expectedCheckSum)) {
                        emailSubject = this.emailSubjectBase + "test passed";
                        passedTest = true;
                    }
                    emailMsg.append("\nFile: " + filename + "\tChecksum:" + cksum);
                }
                if (!passedTest) {
                    emailSubject = this.emailSubjectBase + "TEST FAILED!";
                }
            } else {
                emailSubject = this.emailSubjectBase + this.anInputFolder;
                File toFile = new File(this.archiveDirectory + "/" + aFile.getName());
                boolean movedFile = false;
                try {
                    Files.move((File)aFile, (File)toFile);
                    movedFile = true;
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                if (movedFile) {
                    System.out.println("Moved file " + aFile.getAbsolutePath() + " to " + toFile.getAbsolutePath());
                } else {
                    String msg = "******* COULD NOT MOVE FILE " + aFile.getAbsolutePath() + " TO " + toFile.getAbsolutePath() + " on server: " + this.applicationHost;
                    System.out.println(msg);
                    this.sendAlertNotification(this.emailSubjectBase + "- Error", msg);
                }
            }
            SMTPClient sc = new SMTPClient(this.emailHost, this.emailAddresses);
            try {
                sc.sendMessageWithAttachment(emailSubject, emailMsg.toString(), logFile.getAbsolutePath());
            }
            catch (MessagingException me) {
                // empty catch block
            }
        }
    }

    private String[] getPipelinePluginArgs() {
        String[] args = new String[]{"-i", this.anInputFolder, "-k", this.keyFile, "-e", this.enzyme, "-o", this.outputFolder, "-m", this.topmFile};
        return args;
    }

    private String loadApplicationConfiguration(String aFileIn) {
        boolean loaded = false;
        Properties props = new Properties();
        try {
            File propsFile = new File(aFileIn);
            System.out.println(propsFile.getAbsoluteFile());
            props.load(new FileInputStream(aFileIn));
            loaded = true;
        }
        catch (IOException ioe) {
            System.out.println("Problem loading application configuration file:" + aFileIn);
            System.out.println("************** Example .properties file: ");
            System.out.println(this.exampleAppConfigFile);
            ioe.printStackTrace();
        }
        if (!loaded) {
            this.sendAlertNotification(this.emailSubjectBase + "- Error", "Properties file could not be loaded: " + aFileIn + " on server " + this.applicationHost);
            System.exit(1);
        }
        String configurationElement = "runFileSuffix";
        this.runFileSuffix = props.getProperty(configurationElement);
        configurationElement = "emailHost";
        this.emailHost = props.getProperty(configurationElement);
        configurationElement = "emailAddress";
        String address = props.getProperty(configurationElement);
        if (address != null) {
            Iterable results = Splitter.on((String)this.emailAddressDelimiters).split((CharSequence)address);
            this.emailAddresses = (String[])Iterables.toArray((Iterable)results, String.class);
        }
        configurationElement = "runDirectory";
        this.runDirectory = props.getProperty(configurationElement);
        String response = this.testInputDirectory(aFileIn, this.runDirectory, configurationElement);
        if (response != null) {
            System.out.println(response);
        }
        configurationElement = "archiveDirectory";
        this.archiveDirectory = props.getProperty(configurationElement);
        response = this.testInputDirectory(aFileIn, this.archiveDirectory, configurationElement);
        if (response != null) {
            System.out.println(response);
        }
        configurationElement = "haplosDirectory";
        this.haplosDirectory = props.getProperty(configurationElement);
        response = this.testInputDirectory(aFileIn, this.haplosDirectory, configurationElement);
        if (response != null) {
            System.out.println(response);
        }
        BufferedReader br = null;
        StringBuffer sb = new StringBuffer();
        try {
            br = new BufferedReader(new FileReader(aFileIn));
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line + "\n");
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return sb.toString();
    }

    private String loadRunConfiguration(File aFileIn) {
        String usage = aFileIn.getName() + " is missing a run configuration element:  ";
        Properties props = new Properties();
        try {
            props.load(new FileInputStream(aFileIn));
        }
        catch (IOException ioe) {
            System.err.println("Issue loading run configuration file: " + aFileIn.getName());
            ioe.printStackTrace();
        }
        String configurationElement = "inputFolder";
        this.anInputFolder = props.getProperty(configurationElement);
        String response = this.testInputDirectory(aFileIn.getName(), this.anInputFolder, configurationElement);
        if (response != null) {
            System.out.println(response);
        }
        configurationElement = "enzyme";
        this.enzyme = props.getProperty(configurationElement);
        response = this.testInputDirectory(aFileIn.getName(), this.anInputFolder, configurationElement);
        if (response != null) {
            System.out.println(response);
        }
        configurationElement = "topmFile";
        this.topmFile = props.getProperty(configurationElement);
        response = this.testInputDirectory(aFileIn.getName(), this.anInputFolder, configurationElement);
        if (response != null) {
            System.out.println(response);
        }
        configurationElement = "outputFolder";
        this.outputFolder = props.getProperty(configurationElement);
        response = this.testInputDirectory(aFileIn.getName(), this.anInputFolder, configurationElement);
        if (response != null) {
            System.out.println(response);
        }
        configurationElement = "keyFile";
        this.keyFile = props.getProperty(configurationElement);
        response = this.testInputDirectory(aFileIn.getName(), this.anInputFolder, configurationElement);
        if (response != null) {
            System.out.println(response);
        }
        BufferedReader br = null;
        StringBuffer sb = new StringBuffer();
        try {
            br = new BufferedReader(new FileReader(aFileIn));
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line + "\n");
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return sb.toString();
    }

    private String testInputDirectory(String filename, String input, String configurationElement) {
        String response = null;
        if (input == null) {
            response = filename + " is missing a run configuration element:  " + configurationElement;
        } else {
            File aFileOrDir = new File(input);
            if (!aFileOrDir.exists()) {
                response = filename + "'s configuration element " + configurationElement + " does not exist.  Please confirm path and filename.";
            }
        }
        return response;
    }

    private String recordContext(File outputFolder, boolean calculateChecksum) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getTimeStamp() + "\n");
        String userMsg = "User Account Name: ";
        String user = System.getProperty("user.name");
        sb.append(userMsg + user + "\n");
        String hostNameMsg = "Name of Machine on which JVM is Running: ";
        try {
            this.hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        sb.append(hostNameMsg + this.hostName + "\n");
        String checkSumString = " md5sum: ";
        if (calculateChecksum) {
            sb.append(this.getTimeStamp() + checkSumString + this.keyFile + " " + CheckSum.getMD5Checksum(this.keyFile) + "\n");
            File inFldr = new File(this.anInputFolder);
            if (inFldr.isDirectory()) {
                File[] files;
                for (File f : files = inFldr.listFiles()) {
                    String fCheckSum = CheckSum.getMD5Checksum(f.getPath());
                    String msg = this.getTimeStamp() + checkSumString + f.getPath() + " " + fCheckSum + "\n";
                    sb.append(msg);
                }
            } else {
                sb.append(this.getTimeStamp() + CheckSum.getMD5Checksum(this.anInputFolder) + "\n");
            }
        } else {
            sb.append(this.getTimeStamp() + "MD5sum checking has been switched off using the --skipCheckSum argument");
        }
        return sb.toString();
    }

    private void runImputation(String unImpTargetFile, String donorFile, String impTargetFile) {
        String[] args2 = new String[]{"-hmp", unImpTargetFile, "-d", donorFile, "-o", impTargetFile, "-minMnCnt", "20", "-mxInbErr", "0.02", "-mxHybErr", "0.005", "-mnTestSite", "50", "-mxDonH", "10"};
        StringBuilder builder = new StringBuilder();
        for (String s : args2) {
            builder.append(s + "\n");
        }
        System.out.println("Arguments passed to MinorWindowViterbiImputationPlugin:\n" + builder.toString());
        System.out.println("TasselPrefs: " + TasselPrefs.getAlignmentRetainRareAlleles());
        TasselPrefs.putAlignmentRetainRareAlleles(false);
        FILLINImputationPlugin plugin = new FILLINImputationPlugin();
        plugin.setParameters(args2);
        plugin.performFunction(null);
    }

    public static String compareOriginalAgainstImputed(String originalFile, String imputedFile) {
        StringBuffer sb = new StringBuffer();
        GenotypeTable origAlignment = ImportUtils.readGuessFormat(originalFile);
        GenotypeTable impAlignment = ImportUtils.readGuessFormat(imputedFile);
        int siteCount = origAlignment.numberOfSites();
        int taxaCount = origAlignment.numberOfTaxa();
        int totalSiteCount = siteCount * taxaCount;
        int siteDelta = Math.abs(origAlignment.numberOfSites() - impAlignment.numberOfSites());
        int taxaDelta = Math.abs(origAlignment.numberOfTaxa() - impAlignment.numberOfTaxa());
        int origTotalSitesNotMissing = 0;
        int impTotalSitesNotMissing = 0;
        int totalSitesNotMissingDelta = 0;
        double origProportionNotMissing = 0.0;
        double impProportionNotMissing = 0.0;
        double proportionNotMissingDelta = 0.0;
        int origHetCount = 0;
        int impHetCount = 0;
        int hetCountDelta = 0;
        double origHetProportion = 0.0;
        double impHetProportion = 0.0;
        double hetProportionDelta = 0.0;
        int flipCount = 0;
        int allelicChangeCount = 0;
        if (siteDelta == 0) {
            for (int i = 0; i < siteCount; ++i) {
                double diff;
                byte impMajorAllele;
                hetCountDelta = (impHetCount += impAlignment.heterozygousCount(i)) - (origHetCount += origAlignment.heterozygousCount(i));
                origTotalSitesNotMissing += origAlignment.totalNonMissingForSite(i);
                impTotalSitesNotMissing += impAlignment.totalNonMissingForSite(i);
                byte origMajorAllele = origAlignment.majorAllele(i);
                if (origMajorAllele != (impMajorAllele = impAlignment.majorAllele(i))) {
                    ++flipCount;
                    diff = Math.abs(origAlignment.majorAlleleFrequency(i) - impAlignment.minorAlleleFrequency(i));
                    allelicChangeCount += (int)diff * taxaCount;
                    continue;
                }
                diff = Math.abs(origAlignment.majorAlleleFrequency(i) - impAlignment.majorAlleleFrequency(i));
                allelicChangeCount += (int)diff * taxaCount;
            }
            totalSitesNotMissingDelta = impTotalSitesNotMissing - origTotalSitesNotMissing;
            origProportionNotMissing = (double)origTotalSitesNotMissing / (double)totalSiteCount;
            impProportionNotMissing = (double)impTotalSitesNotMissing / (double)totalSiteCount;
            proportionNotMissingDelta = impProportionNotMissing - origProportionNotMissing;
            hetCountDelta = impHetCount - origHetCount;
            origHetProportion = (double)origHetCount / (double)totalSiteCount;
            impHetProportion = (double)impHetCount / (double)totalSiteCount;
            hetProportionDelta = impHetProportion - origHetProportion;
        }
        sb.append("\nSites: " + siteCount + "\tSite Delta: " + siteDelta);
        sb.append("\nTaxa: " + taxaCount + "\tTaxa Delta: " + taxaDelta);
        sb.append("\nTotal Sites: " + totalSiteCount);
        sb.append("\nSites Not Missing Original: " + origTotalSitesNotMissing + "\tSites Not Missing Imputed: " + impTotalSitesNotMissing + "\tSites Not Missing Delta: " + totalSitesNotMissingDelta);
        sb.append("\nProportion Not Missing Original: " + origProportionNotMissing + "\tProportion Not Missing Imputed: " + impProportionNotMissing + "\tProportion Not Missing Delta: " + proportionNotMissingDelta);
        sb.append("\nChange in Heterozygous Sites: " + hetCountDelta);
        sb.append("\nHeterozygous Sites Original: " + origHetCount + "\tHeterozygous Sites Imputed: " + impHetCount + "\tHet Delta: " + hetCountDelta);
        sb.append("\nHeterozygous Proportion Original: " + origHetProportion + "\tHeterozygous Proportion Imputed: " + impHetProportion + "\tHet Proportion Delta: " + hetProportionDelta);
        sb.append("\nTotal Alleles Changed: " + allelicChangeCount + "\tProportion of Alleles Changed: " + (double)allelicChangeCount / (double)totalSiteCount);
        sb.append("\nNumber of Sites Changing Major Allele: " + flipCount + "\tMajor <-> Minor Proportion: " + (double)flipCount / (double)totalSiteCount);
        return sb.toString();
    }

    private String getTimeStamp() {
        String label = "Timestamp: ";
        Date now = new Date();
        return label + this.dateFormat.format(now) + " ";
    }

    private void sendAlertNotification(String subject, String message) {
        SMTPClient sc = new SMTPClient(this.emailHost, this.emailAddresses);
        try {
            sc.sendMessage(subject, message);
        }
        catch (MessagingException me) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        String msg = "\n--skipCheckSum flag allows MD5sum checking to be skipped.\n--skipImputation flag allows imputation to be skipped\n--runTest flag is for use with a test data set and should be followed by the expected MD5Sum\n--propsFile should be followed by a fully-qualified path name without spaces\n";
        boolean doCheckSum = true;
        boolean doImputation = true;
        String expectedChksm = null;
        String propsFile = "propsFile";
        String propsFilePath = null;
        String skipCheckSum = "skipCheckSum";
        String skipImputation = "skipImputation";
        String runTest = "runTest";
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                if (StringUtils.containsIgnoreCase((String)args[i], (String)skipCheckSum)) {
                    doCheckSum = false;
                    System.out.println("Skipping Checksums");
                }
                if (StringUtils.containsIgnoreCase((String)args[i], (String)skipImputation)) {
                    doImputation = false;
                    System.out.println("Skipping Imputation");
                }
                if (StringUtils.containsIgnoreCase((String)args[i], (String)runTest)) {
                    if (args.length > i + 1) {
                        expectedChksm = args[i + 1];
                        ++i;
                        System.out.println("Running testing and expecting the following MD5Sum: " + expectedChksm);
                    } else {
                        System.out.println("No checksum following --" + runTest + " flag.\n");
                        System.out.println(msg);
                    }
                }
                if (!StringUtils.containsIgnoreCase((String)args[i], (String)propsFile)) continue;
                if (args.length > i + 1) {
                    propsFilePath = args[i + 1];
                    ++i;
                    System.out.println("--" + propsFile + "\tUsing this properties file: " + propsFilePath);
                    continue;
                }
                System.out.println("No path following --" + propsFile + " flag.\n" + "Will look for " + applicationConfiguration + " file in the current directory");
                System.out.println(msg);
            }
        } else {
            System.out.println(msg);
        }
        new ProductionPipelineMain(propsFilePath, doCheckSum, doImputation, expectedChksm);
    }
}

