/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs;

import cern.colt.list.IntArrayList;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.gbs.ParseBarcodeRead;
import net.maizegenetics.analysis.gbs.ReadBarcodeResult;
import net.maizegenetics.dna.map.TagsOnPhysicalMap;
import net.maizegenetics.dna.tag.TagCounts;
import net.maizegenetics.dna.tag.Tags;
import net.maizegenetics.dna.tag.TagsByTaxa;
import net.maizegenetics.dna.tag.TagsByTaxaByteHDF5TaxaGroups;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.util.DirectoryCrawler;
import net.maizegenetics.util.MultiMemberGZIPInputStream;
import org.apache.log4j.Logger;

public class SeqToTBTHDF5Plugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(SeqToTBTHDF5Plugin.class);
    private PluginParameter<String> myInputDir = new PluginParameter.Builder<String>("i", null, String.class).guiName("Input Directory").required(true).inDir().description("Input directory containing .fastq files").build();
    private PluginParameter<String> myKeyFile = new PluginParameter.Builder<String>("k", null, String.class).guiName("Key File").required(true).inFile().description("Barcode key file").build();
    private PluginParameter<String> myEnzyme = new PluginParameter.Builder<String>("e", null, String.class).guiName("Enzyme").description("Enzyme used to create the GBS library, if it differs from the one listed in the key file.").build();
    private PluginParameter<String> myOutputFile = new PluginParameter.Builder<String>("o", null, String.class).guiName("Output File").required(true).outFile().description("Output HDF5 file").build();
    private PluginParameter<Integer> myMaxGoodReads = new PluginParameter.Builder<Integer>("s", 500000000, Integer.class).guiName("Max Good Reads").description("Max good reads per lane.").build();
    private PluginParameter<String> myLogFile = new PluginParameter.Builder<String>("L", null, String.class).guiName("Log File").required(true).outFile().description("Output log file").build();
    private PluginParameter<String> myTagCountFile = new PluginParameter.Builder<String>("t", null, String.class).guiName("Tag Count File").inFile().description("Tag count file. (Only -t or -m allowed)").build();
    private PluginParameter<String> myPhysicalMapFile = new PluginParameter.Builder<String>("m", null, String.class).guiName("Physical Map File").inFile().description("Physical map file containing alignments. (Only -t or -m allowed)").build();
    private String[] myFastqFileS = null;
    private Tags myMasterTags = null;
    private IntArrayList[] myTaxaReads;
    private int[] readsPerSample;
    private int[] mappedReadsPerSample;
    private int goodBarcodedReads = 0;
    private int allReads = 0;
    private int goodMatched = 0;
    private HashMap<String, Integer> taxaNameToIndices;

    public SeqToTBTHDF5Plugin() {
        super(null, false);
    }

    public SeqToTBTHDF5Plugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    public DataSet processData(DataSet input) {
        File possibleFile = new File(this.outputFile());
        if (!possibleFile.exists()) {
            TagsByTaxaByteHDF5TaxaGroups tagsByTaxaByteHDF5TaxaGroups = new TagsByTaxaByteHDF5TaxaGroups(this.myMasterTags, this.outputFile());
        }
        this.matchTagsToTaxa(this.myFastqFileS, this.keyFile(), this.enzyme(), this.myMasterTags, this.outputFile(), this.logFile());
        return null;
    }

    @Override
    public void postProcessParameters() {
        String inputDirectory = this.inputDirectory();
        if (inputDirectory != null) {
            File fastqDirectory = new File(inputDirectory);
            if (!fastqDirectory.isDirectory()) {
                throw new IllegalArgumentException("setParameters: The input name you supplied is not a directory: " + inputDirectory);
            }
            this.myFastqFileS = DirectoryCrawler.listFileNames("(?i).*\\.fq$|.*\\.fq\\.gz$|.*\\.fastq$|.*_fastq\\.txt$|.*_fastq\\.gz$|.*_fastq\\.txt\\.gz$|.*_sequence\\.txt$|.*_sequence\\.txt\\.gz$|.*_qseq\\.txt$|.*_qseq\\.txt\\.gz$", fastqDirectory.getAbsolutePath());
            if (this.myFastqFileS.length == 0 || this.myFastqFileS == null) {
                throw new IllegalArgumentException("Couldn't find any files that end with \".fq\", \".fq.gz\", \".fastq\", \"_fastq.txt\", \"_fastq.gz\", \"_fastq.txt.gz\", \"_sequence.txt\", or \"_sequence.txt.gz\" in the supplied directory: " + inputDirectory);
            }
            myLogger.info((Object)"FastqToTBTPlugin: setParameters: Using the following fastq files:");
            for (String filename : this.myFastqFileS) {
                myLogger.info((Object)filename);
            }
        }
        if (this.enzyme() == null) {
            myLogger.warn((Object)"No enzyme specified.  Using enzyme listed in key file.");
        }
        if (this.tagCountFile() != null) {
            if (this.physicalMapFile() != null) {
                throw new IllegalArgumentException("Options -t and -m are mutually exclusive.");
            }
            this.myMasterTags = new TagCounts(this.tagCountFile(), TagsByTaxa.FilePacking.Byte);
        } else if (this.physicalMapFile() != null) {
            if (this.tagCountFile() != null) {
                throw new IllegalArgumentException("Options -t and -m are mutually exclusive.");
            }
            this.myMasterTags = new TagsOnPhysicalMap(this.physicalMapFile(), true);
        } else {
            throw new IllegalArgumentException("Please specify a tagCounts file (-t) *OR* a TagsOnPhysicalMap file (-m)");
        }
    }

    public void matchTagsToTaxa(String[] fastqFileS, String keyFileS, String enzyme, Tags theMasterTags, String outputTBT, String outputLog) {
        for (int laneNum = 0; laneNum < fastqFileS.length; ++laneNum) {
            this.goodMatched = 0;
            this.allReads = 0;
            this.goodBarcodedReads = 0;
            boolean isFastQ = true;
            if (fastqFileS[laneNum].substring(fastqFileS[laneNum].lastIndexOf(File.separator)).contains("qseq")) {
                isFastQ = false;
            }
            System.out.println("\nWorking on fastq file: " + fastqFileS[laneNum]);
            File fastqFile = new File(fastqFileS[laneNum]);
            ParseBarcodeRead thePBR = SeqToTBTHDF5Plugin.initParseBarcodeRead(keyFileS, enzyme, fastqFile);
            if (thePBR == null) continue;
            String[] taxaNames = new String[thePBR.getBarCodeCount()];
            this.myTaxaReads = new IntArrayList[thePBR.getBarCodeCount()];
            this.mappedReadsPerSample = new int[thePBR.getBarCodeCount()];
            this.readsPerSample = new int[thePBR.getBarCodeCount()];
            this.taxaNameToIndices = new HashMap();
            for (int i = 0; i < taxaNames.length; ++i) {
                taxaNames[i] = thePBR.getTheBarcodes(i).getTaxaName();
                this.myTaxaReads[i] = new IntArrayList(200000000 / taxaNames.length);
                this.taxaNameToIndices.put(taxaNames[i], i);
            }
            int currLine = 0;
            this.goodBarcodedReads = 0;
            this.allReads = 0;
            this.goodMatched = 0;
            try {
                String[] seqAndQual;
                BufferedReader br = SeqToTBTHDF5Plugin.getBufferedReader(fastqFileS[laneNum]);
                while ((seqAndQual = SeqToTBTHDF5Plugin.getNextSeq(br, isFastQ)) != null && this.goodBarcodedReads < this.maxGoodReads()) {
                    ++this.allReads;
                    ++currLine;
                    ReadBarcodeResult rr = thePBR.parseReadIntoTagAndTaxa(seqAndQual[0], seqAndQual[1], true, 0);
                    if (rr != null) {
                        ++this.goodBarcodedReads;
                        int t = this.taxaNameToIndices.get(rr.getTaxonName());
                        int h = theMasterTags.getTagIndex(rr.getRead());
                        int n = t;
                        this.readsPerSample[n] = this.readsPerSample[n] + 1;
                        if (h > -1) {
                            ++this.goodMatched;
                            int n2 = t;
                            this.mappedReadsPerSample[n2] = this.mappedReadsPerSample[n2] + 1;
                            this.myTaxaReads[t].add(h);
                        }
                    }
                    if (this.allReads % 1000000 != 0) continue;
                    System.out.println("Total Reads:" + this.allReads + " goodReads:" + this.goodBarcodedReads + " goodMatched:" + this.goodMatched);
                }
                br.close();
            }
            catch (Exception e) {
                System.out.println("Catch testBasicPipeline c=" + this.goodBarcodedReads + " e=" + e);
                e.printStackTrace();
            }
            System.out.println("Timing process (writing TagsByTaxa file)...");
            long timePoint1 = System.currentTimeMillis();
            this.writeReport(fastqFileS[laneNum], outputLog);
            this.writeTBT(outputTBT);
            System.out.println("...process (writing TagsByTaxa file) took " + (System.currentTimeMillis() - timePoint1) + " milliseconds.");
            System.out.println("Total number of reads in lane=" + this.allReads);
            System.out.println("Total number of good, barcoded reads=" + this.goodBarcodedReads);
            int filesDone = laneNum + 1;
            System.out.println("Finished reading " + filesDone + " of " + fastqFileS.length + " sequence files: " + fastqFileS[laneNum] + "\n");
        }
    }

    private synchronized boolean writeReport(String seqFile, String outputLog) {
        float goodPct = (float)this.goodBarcodedReads / (float)this.allReads;
        float goodMappedPct = (float)this.goodMatched / (float)this.allReads;
        try {
            DataOutputStream report = new DataOutputStream(new FileOutputStream(outputLog, true));
            report.writeBytes("File: " + seqFile + '\n' + "Total reads: " + this.allReads + '\n' + "Accepted reads (with barcode and cut site): " + this.goodBarcodedReads + "(" + goodPct + " of total)" + '\n' + "Accepted reads found in TOPM: " + this.goodMatched + "(" + goodMappedPct + " of total)" + '\n' + "name" + '\t' + "read count" + '\t' + "fraction of total" + '\t' + "mapped read count" + '\t' + "fraction mapped of total" + '\n');
            for (String name : this.taxaNameToIndices.keySet()) {
                int t = this.taxaNameToIndices.get(name);
                int count = this.readsPerSample[t];
                int mappedCount = this.mappedReadsPerSample[t];
                float pct = (float)count / (float)this.allReads;
                float mappedPct = (float)mappedCount / (float)count;
                report.writeBytes(name + '\t' + count + '\t' + pct + '\t' + mappedCount + '\t' + mappedPct + '\n');
            }
            report.close();
        }
        catch (Exception e) {
            myLogger.warn((Object)("Caught exception while writing report file for file " + seqFile + ": " + e));
            return false;
        }
        return true;
    }

    private synchronized boolean writeTBT(String outputTBT) {
        TagsByTaxaByteHDF5TaxaGroups theTBT = new TagsByTaxaByteHDF5TaxaGroups(outputTBT);
        for (String name : this.taxaNameToIndices.keySet()) {
            int t = this.taxaNameToIndices.get(name);
            byte[] tagByteDist = SeqToTBTHDF5Plugin.getTagsDistribution(theTBT.getTagCount(), this.myTaxaReads[t]);
            theTBT.addTaxon(name, tagByteDist);
            System.out.printf("Taxon %s written to %s %n", name, outputTBT);
        }
        theTBT.getFileReadyForClosing();
        theTBT = null;
        try {
            System.out.println("Sleeping thread" + Thread.currentThread().getName());
            Thread.sleep(5000L);
        }
        catch (InterruptedException ie) {
            System.err.println("Sleeping failed");
            return false;
        }
        return true;
    }

    private static String[] getNextSeq(BufferedReader br, boolean isFastQ) {
        String[] s = new String[2];
        try {
            if (isFastQ) {
                String temp = br.readLine();
                if (temp == null) {
                    return null;
                }
                while (temp.charAt(0) != '@') {
                    temp = br.readLine();
                    if (temp != null) continue;
                    return null;
                }
                s[0] = br.readLine();
                br.readLine();
                s[1] = br.readLine();
            } else {
                String temp = br.readLine();
                if (temp == null) {
                    return null;
                }
                String[] jj = temp.split("\\s");
                s[0] = jj[8];
                s[1] = jj[9];
            }
        }
        catch (IOException e) {
            System.out.println("File closing");
            return null;
        }
        return s;
    }

    private static BufferedReader getBufferedReader(String fileName) {
        BufferedReader br = null;
        try {
            br = fileName.endsWith(".gz") ? new BufferedReader(new InputStreamReader(new MultiMemberGZIPInputStream(new FileInputStream(fileName)))) : new BufferedReader(new FileReader(fileName), 65536);
        }
        catch (IOException e) {
            System.out.println("Failed to open file:" + fileName);
        }
        return br;
    }

    private static byte[] getTagsDistribution(int tagNumber, IntArrayList tagDist) {
        byte[] result = new byte[tagNumber];
        for (int i : tagDist.elements()) {
            if (result[i] >= 127) continue;
            int n = i;
            result[n] = (byte)(result[n] + 1);
        }
        return result;
    }

    private static ParseBarcodeRead initParseBarcodeRead(String keyFileS, String enzyme, File fastqFile) {
        ParseBarcodeRead thePBR = null;
        String[] np = fastqFile.getName().split("_");
        if (np.length == 3) {
            thePBR = new ParseBarcodeRead(keyFileS, enzyme, np[0], np[1]);
        } else if (np.length == 5) {
            thePBR = new ParseBarcodeRead(keyFileS, enzyme, np[1], np[3]);
        } else if (np.length == 4) {
            thePBR = new ParseBarcodeRead(keyFileS, enzyme, np[0], np[2]);
        } else if (np.length == 6) {
            thePBR = new ParseBarcodeRead(keyFileS, enzyme, np[1], np[3]);
        } else {
            System.out.println("Error in parsing file name:");
            System.out.println("   The filename does not contain either 3 or 5 underscore-delimited values.");
            System.out.println("   Expect: flowcell_lane_fastq.txt OR code_flowcell_s_lane_fastq.txt");
            System.out.println("   Filename: " + fastqFile.getName());
            return null;
        }
        System.out.println("Total barcodes found in lane:" + thePBR.getBarCodeCount());
        if (thePBR.getBarCodeCount() == 0) {
            System.out.println("No barcodes found.  Skipping this flowcell.");
            return null;
        }
        return thePBR;
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return "Seq to TBT HDF5";
    }

    @Override
    public String getToolTipText() {
        return "Seq to TBT HDF5";
    }

    public String inputDirectory() {
        return this.myInputDir.value();
    }

    public SeqToTBTHDF5Plugin inputDirectory(String value) {
        this.myInputDir = new PluginParameter<String>(this.myInputDir, value);
        return this;
    }

    public String keyFile() {
        return this.myKeyFile.value();
    }

    public SeqToTBTHDF5Plugin keyFile(String value) {
        this.myKeyFile = new PluginParameter<String>(this.myKeyFile, value);
        return this;
    }

    public String enzyme() {
        return this.myEnzyme.value();
    }

    public SeqToTBTHDF5Plugin enzyme(String value) {
        this.myEnzyme = new PluginParameter<String>(this.myEnzyme, value);
        return this;
    }

    public String outputFile() {
        return this.myOutputFile.value();
    }

    public SeqToTBTHDF5Plugin outputFile(String value) {
        this.myOutputFile = new PluginParameter<String>(this.myOutputFile, value);
        return this;
    }

    public Integer maxGoodReads() {
        return this.myMaxGoodReads.value();
    }

    public SeqToTBTHDF5Plugin maxGoodReads(Integer value) {
        this.myMaxGoodReads = new PluginParameter<Integer>(this.myMaxGoodReads, value);
        return this;
    }

    public String logFile() {
        return this.myLogFile.value();
    }

    public SeqToTBTHDF5Plugin logFile(String value) {
        this.myLogFile = new PluginParameter<String>(this.myLogFile, value);
        return this;
    }

    public String tagCountFile() {
        return this.myTagCountFile.value();
    }

    public SeqToTBTHDF5Plugin tagCountFile(String value) {
        this.myTagCountFile = new PluginParameter<String>(this.myTagCountFile, value);
        return this;
    }

    public String physicalMapFile() {
        return this.myPhysicalMapFile.value();
    }

    public SeqToTBTHDF5Plugin physicalMapFile(String value) {
        this.myPhysicalMapFile = new PluginParameter<String>(this.myPhysicalMapFile, value);
        return this;
    }
}

