/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import net.maizegenetics.dna.tag.Tag;
import net.maizegenetics.dna.tag.TaxaDistribution;

class TagDistributionMap
extends ConcurrentHashMap<Tag, TaxaDistribution> {
    private final long maxMemorySize;
    private int minDepthToRetainInMap = 1;
    private AtomicLong putCntSinceMemoryCheck = new AtomicLong(0L);
    private long checkFreq;

    TagDistributionMap(int initialCapacity, long maxMemorySize) {
        super(initialCapacity);
        this.maxMemorySize = maxMemorySize;
        this.checkFreq = maxMemorySize / 1000L;
    }

    @Override
    public TaxaDistribution put(Tag key, TaxaDistribution value) {
        if (this.putCntSinceMemoryCheck.incrementAndGet() > this.checkFreq) {
            this.checkMemoryAndReduceIfNeeded();
            this.putCntSinceMemoryCheck.set(0L);
        }
        return super.put(key, value);
    }

    public synchronized void checkMemoryAndReduceIfNeeded() {
        System.out.println("TagDistributionMap.checkMemoryAndReduceIfNeeded" + this.estimateMapMemorySize());
        while (this.estimateMapMemorySize() > this.maxMemorySize) {
            this.reduceMapSize();
        }
    }

    public synchronized void removeTagByCount(int minCnt) {
        for (Tag tag : this.keySet()) {
            if (((TaxaDistribution)this.get(tag)).totalDepth() >= minCnt) continue;
            this.remove(tag);
        }
    }

    private synchronized void reduceMapSize() {
        System.out.println("reduceMapSize()" + this.minDepthToRetainInMap);
        this.removeTagByCount(this.minDepthToRetainInMap);
        ++this.minDepthToRetainInMap;
    }

    public long estimateMapMemorySize() {
        long size = 0L;
        int cnt = 0;
        for (Map.Entry entry : this.entrySet()) {
            size += 25L;
            size += 16L;
            size += (long)((TaxaDistribution)entry.getValue()).memorySize();
            if (++cnt <= 10000) continue;
            break;
        }
        long estSize = (long)(this.size() / cnt) * size;
        return estSize;
    }
}

