/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs.pana;

import java.awt.Frame;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.TreeSet;
import javax.swing.ImageIcon;
import net.maizegenetics.dna.BaseEncoder;
import net.maizegenetics.dna.tag.TagCounts;
import net.maizegenetics.dna.tag.TagsByTaxa;
import net.maizegenetics.dna.tag.UTagCountMutable;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.util.ArgsEngine;
import net.maizegenetics.util.MultiMemberGZIPInputStream;
import org.apache.log4j.Logger;

public class PanAReadDigestPlugin
extends AbstractPlugin {
    static long timePoint1;
    private ArgsEngine engine = null;
    private Logger logger = Logger.getLogger(PanAReadDigestPlugin.class);
    String polyA = "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA";
    String rawSeqDirS = null;
    String keyFileS = null;
    String recSeq = "GCTG";
    int customTagLength = 0;
    String outDirS = null;
    int inputFormatValue;
    int tagLengthInLong;
    String reverseRecSeq = BaseEncoder.getReverseComplement(this.recSeq);
    String[] lanes = null;
    HashMap<String, String> laneTaxaMap = null;

    public PanAReadDigestPlugin() {
        super(null, false);
    }

    public PanAReadDigestPlugin(Frame parentFrame) {
        super(parentFrame, false);
    }

    private void printUsage() {
        this.logger.info((Object)"\n\nUsage is as follows:\n -i  input directory of Fastq or Qseq files\n -f  input format value.  0 = Fastq. 1 = Qseq\n -k  key file which links Fastq/Qseq file with samples\n -s  recognition sequence for digestion. Default: GCTG\n -l  customed tag length\n -o  output directory of tag count files\n");
    }

    @Override
    public DataSet performFunction(DataSet input) {
        this.getLaneTaxaInfo();
        if (this.inputFormatValue == 0) {
            this.processFastq();
        } else if (this.inputFormatValue == 1) {
            this.processQseq();
        }
        this.mergeTagCounts();
        return null;
    }

    private void mergeTagCounts() {
        Object[] tcFiles = new File(this.outDirS).listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith("cnt");
            }
        });
        Arrays.sort(tcFiles);
        TreeSet<String> taxaNameSet = new TreeSet<String>();
        for (int i = 0; i < tcFiles.length; ++i) {
            String[] temp = ((File)tcFiles[i]).getName().substring(0, ((File)tcFiles[i]).getName().length() - 4).split("_");
            String theTaxon = temp[temp.length - 1];
            taxaNameSet.add(theTaxon);
        }
        String[] taxaNames = taxaNameSet.toArray(new String[taxaNameSet.size()]);
        for (int i = 0; i < taxaNames.length; ++i) {
            System.out.println("Merging tagCount files for taxa " + taxaNames[i]);
            ArrayList<Object> fileList = new ArrayList<Object>();
            for (int j = 0; j < tcFiles.length; ++j) {
                String[] temp = ((File)tcFiles[j]).getName().substring(0, ((File)tcFiles[j]).getName().length() - 4).split("_");
                String theTaxon = temp[temp.length - 1];
                if (!taxaNames[i].equals(theTaxon)) continue;
                fileList.add(tcFiles[j]);
            }
            if (fileList.size() == 1) {
                File dest = new File(((File)fileList.get(0)).getParent(), taxaNames[i] + ".cnt");
                ((File)fileList.get(0)).renameTo(dest);
                System.out.println("File is renamed to " + dest.getAbsolutePath());
            } else if (fileList.size() > 1) {
                int j;
                File dest = new File(((File)fileList.get(0)).getParent(), taxaNames[i] + ".cnt");
                UTagCountMutable tcu = new UTagCountMutable(this.tagLengthInLong, 0);
                for (j = 0; j < fileList.size(); ++j) {
                    TagCounts tc = new TagCounts(((File)fileList.get(j)).getAbsolutePath(), TagsByTaxa.FilePacking.Byte);
                    for (int k = 0; k < tc.getTagCount(); ++k) {
                        long[] t = tc.getTag(k);
                        tcu.addReadCount(t, tc.getTagLength(k), tc.getReadCount(k));
                    }
                }
                tcu.toArray();
                tcu.collapseCounts();
                tcu.writeTagCountFile(dest.getAbsolutePath(), TagsByTaxa.FilePacking.Byte, 1);
                for (j = 0; j < fileList.size(); ++j) {
                    ((File)fileList.get(j)).delete();
                }
                System.out.println(String.valueOf(fileList.size()) + " files are merged into " + dest.getAbsolutePath());
            }
            System.out.println();
        }
    }

    private void processFastq() {
        for (int i = 0; i < this.lanes.length; ++i) {
            File infile = new File(this.rawSeqDirS, this.lanes[i]);
            if (!infile.exists()) {
                System.out.println(infile.getAbsolutePath() + " doesn't exist. Program stops");
                System.exit(1);
            }
            String infileS = infile.getAbsolutePath();
            try {
                String outfileS = new File(this.outDirS, this.lanes[i] + "_" + this.laneTaxaMap.get(this.lanes[i]) + ".cnt").getAbsolutePath();
                BufferedReader br = infileS.endsWith(".gz") ? new BufferedReader(new InputStreamReader(new MultiMemberGZIPInputStream(new FileInputStream(infile)))) : new BufferedReader(new FileReader(infile), 65536);
                System.out.println("Start reading " + infile.getAbsolutePath());
                String temp = br.readLine();
                temp = br.readLine();
                System.out.println("Sequence length is " + temp.length() + " bps in file " + infileS);
                int actualLength = temp.length();
                if (temp.length() < this.customTagLength) {
                    System.out.println("Custom tag length is longer than actual sequence length in file. Programs stops");
                    System.exit(0);
                }
                br.readLine();
                br.readLine();
                UTagCountMutable tcu = new UTagCountMutable(this.tagLengthInLong, 0);
                int indexCut = actualLength - this.customTagLength + 1;
                int indexCutReverse = this.customTagLength - this.reverseRecSeq.length() - 1;
                int polyALength = this.tagLengthInLong * 32 - this.customTagLength;
                String tag = null;
                String reverseTag = null;
                long tagCnt = 0L;
                long reverseTagCnt = 0L;
                long totalSeq = 0L;
                while ((temp = br.readLine()) != null) {
                    int startIndex;
                    temp = br.readLine();
                    int index = temp.indexOf(this.recSeq);
                    if (index > -1 && index < indexCut && !this.isBadSequence(tag = temp.substring(index, index + this.customTagLength) + this.polyA.substring(0, polyALength))) {
                        long[] t = BaseEncoder.getLongArrayFromSeq(tag);
                        tcu.addReadCount(t, this.customTagLength, 1);
                        ++tagCnt;
                    }
                    if ((index = temp.lastIndexOf(this.reverseRecSeq)) > -1 && index > indexCutReverse && !this.isBadSequence(reverseTag = temp.substring(startIndex = index + this.reverseRecSeq.length() - this.customTagLength, this.customTagLength + startIndex))) {
                        reverseTag = BaseEncoder.getReverseComplement(reverseTag) + this.polyA.substring(0, polyALength);
                        long[] t = BaseEncoder.getLongArrayFromSeq(reverseTag);
                        tcu.addReadCount(t, this.customTagLength, 1);
                        ++reverseTagCnt;
                    }
                    ++totalSeq;
                    br.readLine();
                    br.readLine();
                }
                br.close();
                tcu.toArray();
                tcu.collapseCounts();
                tcu.writeTagCountFile(outfileS, TagsByTaxa.FilePacking.Byte, 1);
                System.out.println(String.valueOf(tagCnt) + " tags from positive strain. " + String.valueOf((double)tagCnt / (double)totalSeq));
                System.out.println(String.valueOf(reverseTagCnt) + " tags from reverse complementary strain. " + String.valueOf((double)reverseTagCnt / (double)totalSeq));
                System.out.println();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
    }

    private void processQseq() {
        for (int i = 0; i < this.lanes.length; ++i) {
            File infile = new File(this.rawSeqDirS, this.lanes[i]);
            if (!infile.exists()) {
                System.out.println(infile.getAbsolutePath() + " doesn't exist. Program stops");
                System.exit(1);
            }
            String infileS = infile.getAbsolutePath();
            try {
                String outfileS = new File(this.outDirS, this.lanes[i] + "_" + this.laneTaxaMap.get(this.lanes[i]) + ".cnt").getAbsolutePath();
                BufferedReader br = infileS.endsWith(".gz") ? new BufferedReader(new InputStreamReader(new MultiMemberGZIPInputStream(new FileInputStream(infile)))) : new BufferedReader(new FileReader(infile), 65536);
                System.out.println("Start reading " + infile.getAbsolutePath());
                String temp = br.readLine();
                String[] tem = temp.split("\t");
                System.out.println("Sequence length is " + tem[8].length() + " bps in file " + infileS);
                int actualLength = tem[8].length();
                if (tem[8].length() < this.customTagLength) {
                    System.out.println("Custom tag length is longer than actual sequence length in file. Programs stops");
                    System.exit(0);
                }
                UTagCountMutable tcu = new UTagCountMutable(this.tagLengthInLong, 0);
                int indexCut = actualLength - this.customTagLength + 1;
                int indexCutReverse = this.customTagLength - this.reverseRecSeq.length() - 1;
                int polyALength = this.tagLengthInLong * 32 - this.customTagLength;
                String tag = null;
                String reverseTag = null;
                long tagCnt = 0L;
                long reverseTagCnt = 0L;
                long totalSeq = 0L;
                while ((temp = br.readLine()) != null) {
                    int startIndex;
                    tem = temp.split("\t");
                    int index = tem[8].indexOf(this.recSeq);
                    if (index > -1 && index < indexCut && !this.isBadSequence(tag = temp.substring(index, index + this.customTagLength) + this.polyA.substring(0, polyALength))) {
                        long[] t = BaseEncoder.getLongArrayFromSeq(tag);
                        tcu.addReadCount(t, this.customTagLength, 1);
                        ++tagCnt;
                    }
                    if ((index = temp.lastIndexOf(this.reverseRecSeq)) > -1 && index > indexCutReverse && !this.isBadSequence(reverseTag = temp.substring(startIndex = index + this.reverseRecSeq.length() - this.customTagLength, this.customTagLength + startIndex))) {
                        reverseTag = BaseEncoder.getReverseComplement(reverseTag) + this.polyA.substring(0, polyALength);
                        long[] t = BaseEncoder.getLongArrayFromSeq(reverseTag);
                        tcu.addReadCount(t, this.customTagLength, 1);
                        ++reverseTagCnt;
                    }
                    ++totalSeq;
                }
                br.close();
                tcu.toArray();
                tcu.collapseCounts();
                tcu.writeTagCountFile(outfileS, TagsByTaxa.FilePacking.Byte, 1);
                System.out.println(String.valueOf(tagCnt) + " tags from positive strain. " + String.valueOf((double)tagCnt / (double)totalSeq));
                System.out.println(String.valueOf(reverseTagCnt) + " tags from reverse complementary strain. " + String.valueOf((double)reverseTagCnt / (double)totalSeq));
                System.out.println();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
    }

    private boolean isBadSequence(String seq) {
        if (seq.indexOf("N") != -1) {
            return true;
        }
        return seq.indexOf(".") != -1;
    }

    private void getLaneTaxaInfo() {
        this.laneTaxaMap = new HashMap();
        ArrayList<String> laneList = new ArrayList<String>();
        try {
            BufferedReader br = new BufferedReader(new FileReader(this.keyFileS), 65536);
            String temp = br.readLine();
            while ((temp = br.readLine()) != null) {
                String[] tem = temp.split("\t");
                laneList.add(tem[0]);
                this.laneTaxaMap.put(tem[0], tem[1]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        this.lanes = laneList.toArray(new String[laneList.size()]);
    }

    @Override
    public void setParameters(String[] args) {
        if (args.length == 0) {
            this.printUsage();
            throw new IllegalArgumentException("\n\nPlease use the above arguments/options.\n\n");
        }
        if (this.engine == null) {
            this.engine = new ArgsEngine();
            this.engine.add("-i", "--input-DirS", true);
            this.engine.add("-f", "--input-format", true);
            this.engine.add("-k", "--key-file", true);
            this.engine.add("-s", "--recognition-sequence", true);
            this.engine.add("-l", "--costum-tagLength", true);
            this.engine.add("-o", "--output-DirS", true);
            this.engine.parse(args);
        }
        if (!this.engine.getBoolean("-i")) {
            this.printUsage();
            throw new IllegalArgumentException("\n\nPlease use the above arguments/options.\n\n");
        }
        this.rawSeqDirS = this.engine.getString("-i");
        if (this.engine.getBoolean("-f")) {
            this.inputFormatValue = Integer.valueOf(this.engine.getString("-f"));
            if (this.inputFormatValue != 0 && this.inputFormatValue != 1) {
                this.printUsage();
                throw new IllegalArgumentException("\n\nPlease double input format value.\n\n");
            }
        } else {
            this.printUsage();
            throw new IllegalArgumentException("\n\nPlease use the above arguments/options.\n\n");
        }
        if (!this.engine.getBoolean("-k")) {
            this.printUsage();
            throw new IllegalArgumentException("\n\nPlease use the above arguments/options.\n\n");
        }
        this.keyFileS = this.engine.getString("-k");
        if (this.engine.getBoolean("-s")) {
            this.recSeq = this.engine.getString("-s").toUpperCase();
            this.reverseRecSeq = BaseEncoder.getReverseComplement(this.recSeq);
        }
        if (this.engine.getBoolean("-l")) {
            this.customTagLength = Integer.valueOf(this.engine.getString("-l"));
            int base = this.customTagLength % 32;
            this.tagLengthInLong = base == 0 ? this.customTagLength / 32 : this.customTagLength / 32 + 1;
        } else {
            this.printUsage();
            throw new IllegalArgumentException("\n\nPlease use the above arguments/options.\n\n");
        }
        if (!this.engine.getBoolean("-o")) {
            this.printUsage();
            throw new IllegalArgumentException("\n\nPlease use the above arguments/options.\n\n");
        }
        this.outDirS = this.engine.getString("-o");
    }

    @Override
    public ImageIcon getIcon() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getButtonName() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getToolTipText() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

