/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs.pana;

import java.awt.Frame;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.gbs.AnnotateTOPM;
import net.maizegenetics.dna.map.TagGWASMap;
import net.maizegenetics.dna.map.TagsOnPhysicalMapV3;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.util.ArgsEngine;
import org.apache.log4j.Logger;

public class PanASamToMultiPositionTOPMPlugin
extends AbstractPlugin {
    static long timePoint1;
    private ArgsEngine engine = null;
    private Logger logger = Logger.getLogger(PanASamToMultiPositionTOPMPlugin.class);
    String samFileS = null;
    String tagGWASMapFileS = null;
    String topmV3FileS = null;
    int maxNumAlignment = 2;

    public PanASamToMultiPositionTOPMPlugin() {
        super(null, false);
    }

    public PanASamToMultiPositionTOPMPlugin(Frame parentFrame) {
        super(parentFrame, false);
    }

    private void printUsage() {
        this.logger.info((Object)"\n\nUsage is as follows:\n -i  bowtie2 alignemnt file in SAM format\n -t  TagGWASMap file\n -o  output multiple position TOPM file\n");
    }

    @Override
    public DataSet performFunction(DataSet input) {
        TagGWASMap tgm = new TagGWASMap(this.tagGWASMapFileS);
        TagsOnPhysicalMapV3.createFile(tgm, this.topmV3FileS);
        TagsOnPhysicalMapV3 topm = new TagsOnPhysicalMapV3(this.topmV3FileS);
        AnnotateTOPM anno = new AnnotateTOPM(topm);
        anno.annotateWithBowtie2(this.samFileS, this.maxNumAlignment);
        return null;
    }

    @Override
    public void setParameters(String[] args) {
        if (args.length == 0) {
            this.printUsage();
            throw new IllegalArgumentException("\n\nPlease use the above arguments/options.\n\n");
        }
        if (this.engine == null) {
            this.engine = new ArgsEngine();
            this.engine.add("-i", "--sam-file", true);
            this.engine.add("-t", "--tagGWASMap-file", true);
            this.engine.add("-o", "--topmV3-file", true);
            this.engine.parse(args);
        }
        if (!this.engine.getBoolean("-i")) {
            this.printUsage();
            throw new IllegalArgumentException("\n\nPlease use the above arguments/options.\n\n");
        }
        this.samFileS = this.engine.getString("-i");
        if (!this.engine.getBoolean("-t")) {
            this.printUsage();
            throw new IllegalArgumentException("\n\nPlease use the above arguments/options.\n\n");
        }
        this.tagGWASMapFileS = this.engine.getString("-t");
        if (!this.engine.getBoolean("-o")) {
            this.printUsage();
            throw new IllegalArgumentException("\n\nPlease use the above arguments/options.\n\n");
        }
        this.topmV3FileS = this.engine.getString("-o");
    }

    @Override
    public ImageIcon getIcon() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getButtonName() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getToolTipText() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

