/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.imputation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.TreeSet;
import net.maizegenetics.analysis.clustering.Haplotype;
import net.maizegenetics.analysis.clustering.HaplotypeClusterer;
import net.maizegenetics.analysis.imputation.NucleotideImputationUtils;
import net.maizegenetics.analysis.imputation.PopulationData;
import net.maizegenetics.analysis.popgen.LinkageDisequilibrium;
import net.maizegenetics.dna.map.Position;
import net.maizegenetics.dna.snp.FilterGenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTableBuilder;
import net.maizegenetics.dna.snp.GenotypeTableUtils;
import net.maizegenetics.dna.snp.NucleotideAlignmentConstants;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.util.OpenBitSet;
import org.apache.commons.math.stat.StatUtils;

public class BiparentalHaplotypeFinder {
    PopulationData myPopulationData;
    GenotypeTable initialGenotype;
    static final byte AA = NucleotideAlignmentConstants.getNucleotideDiploidByte("AA");
    static final byte CC = NucleotideAlignmentConstants.getNucleotideDiploidByte("CC");
    static final byte AC = NucleotideAlignmentConstants.getNucleotideDiploidByte("AC");
    static final byte CA = NucleotideAlignmentConstants.getNucleotideDiploidByte("CA");
    static final byte NN = -1;
    int window = 100;
    int overlap = 25;
    int minNotMissing = 20;
    int minClusterSize = 3;
    int maxDifferenceScore = 0;
    double minR2 = 0.2;
    double minMaf = 0.05;
    double minCoverage = 0.2;
    double maxHetDeviation = 5.0;

    public BiparentalHaplotypeFinder(PopulationData popdata) {
        this.myPopulationData = popdata;
        this.initialGenotype = popdata.original;
    }

    public void assignHaplotyes() {
        int s;
        ArrayList<Haplotype> myHaplotypes;
        HaplotypeClusterer myClusterMaker;
        int start;
        GenotypeTable filterGeno;
        int startIncr = this.window - this.overlap;
        int diff = this.maxDifferenceScore;
        this.myPopulationData.original = filterGeno = this.preFilterSites();
        int nsites = this.myPopulationData.original.numberOfSites();
        this.myPopulationData.alleleA = new byte[nsites];
        this.myPopulationData.alleleC = new byte[nsites];
        Arrays.fill(this.myPopulationData.alleleA, (byte)-1);
        Arrays.fill(this.myPopulationData.alleleC, (byte)-1);
        boolean exactlyTwo = false;
        int initialStart = 0;
        int maxStart = nsites - this.window;
        ArrayList<ArrayList<Haplotype>> parentHaplotypes = new ArrayList<ArrayList<Haplotype>>(2);
        parentHaplotypes.add(new ArrayList());
        parentHaplotypes.add(new ArrayList());
        Haplotype h0 = null;
        Haplotype h1 = null;
        while (!exactlyTwo & initialStart < maxStart) {
            HaplotypeClusterer myClusterMaker2 = this.clusterWindow(filterGeno, initialStart, this.window, diff, this.minNotMissing);
            myClusterMaker2.sortClusters();
            myClusterMaker2.moveAllHaplotypesToBiggestCluster(diff);
            myClusterMaker2.removeHeterozygousClusters(5);
            h0 = new Haplotype(myClusterMaker2.getClusterList().get(0).getMajorityHaplotype());
            h1 = new Haplotype(myClusterMaker2.getClusterList().get(1).getMajorityHaplotype());
            int cluster2Size = 0;
            if (myClusterMaker2.getClusterList().size() > 2) {
                cluster2Size = myClusterMaker2.getClusterList().get(2).getSize();
            }
            if (cluster2Size < this.minClusterSize && h0.distanceFrom(h1) >= 2 * this.window - 4) {
                exactlyTwo = true;
                parentHaplotypes.get(0).add(h0);
                parentHaplotypes.get(1).add(h1);
                continue;
            }
            initialStart += this.window;
        }
        if (!exactlyTwo) {
            throw new RuntimeException("Unable to find start window with only two haplotypes.");
        }
        ArrayList<Position> filterPositions = new ArrayList<Position>();
        for (int s2 = initialStart; s2 < initialStart + this.window; ++s2) {
            filterPositions.add((Position)filterGeno.positions().get(s2));
        }
        this.updatePopulationDataAlleles(parentHaplotypes, filterPositions, 0, this.window);
        for (start = initialStart + startIncr; start < nsites - this.overlap; start += startIncr) {
            int windowSize = this.window;
            if (start + this.window >= nsites) {
                windowSize = nsites - start;
            }
            int minNotMissingAdjusted = (int)Math.floor((double)this.minNotMissing * (double)windowSize / (double)this.window);
            myClusterMaker = this.clusterWindow(filterGeno, start, windowSize, diff, minNotMissingAdjusted);
            myClusterMaker.sortClusters();
            myClusterMaker.moveAllHaplotypesToBiggestCluster(diff);
            myClusterMaker.removeHeterozygousClusters(5);
            myHaplotypes = this.mergeMajorHaplotypes(myClusterMaker, this.minClusterSize);
            parentHaplotypes = BiparentalHaplotypeFinder.getParentHaplotypes(parentHaplotypes, myHaplotypes, this.overlap, true);
            filterPositions.clear();
            for (s = start; s < start + windowSize; ++s) {
                filterPositions.add((Position)filterGeno.positions().get(s));
            }
            this.updatePopulationDataAlleles(parentHaplotypes, filterPositions, this.overlap, windowSize - this.overlap);
        }
        parentHaplotypes.get(0).clear();
        parentHaplotypes.get(0).add(h0);
        parentHaplotypes.get(1).clear();
        parentHaplotypes.get(1).add(h1);
        for (start = initialStart - startIncr; start > -startIncr; start -= startIncr) {
            int end = start + this.window;
            if (start < 0) {
                start = 0;
            }
            int windowSize = end - start;
            myClusterMaker = this.clusterWindow(this.myPopulationData.original, start, windowSize, diff, this.minNotMissing);
            myClusterMaker.sortClusters();
            myClusterMaker.moveAllHaplotypesToBiggestCluster(diff);
            myClusterMaker.removeHeterozygousClusters(5);
            myHaplotypes = this.mergeMajorHaplotypes(myClusterMaker, this.minClusterSize);
            parentHaplotypes = BiparentalHaplotypeFinder.getParentHaplotypes(parentHaplotypes, myHaplotypes, this.overlap, false);
            filterPositions.clear();
            for (s = start; s < start + windowSize; ++s) {
                filterPositions.add((Position)filterGeno.positions().get(s));
            }
            this.updatePopulationDataAlleles(parentHaplotypes, filterPositions, 0, windowSize - this.overlap);
        }
    }

    public HaplotypeClusterer clusterWindow(GenotypeTable a, int start, int length, int maxdif, int minNotMissingPerHaplotype) {
        int ntaxa = a.numberOfTaxa();
        int end = start + length;
        ArrayList<Haplotype> haps = new ArrayList<Haplotype>();
        for (int t = 0; t < ntaxa; ++t) {
            Haplotype hap = new Haplotype(a.genotypeRange(t, start, end), t);
            if (hap.notMissingCount < minNotMissingPerHaplotype) continue;
            haps.add(hap);
        }
        HaplotypeClusterer hc = new HaplotypeClusterer(haps);
        hc.makeClusters();
        if (maxdif > 0) {
            hc.mergeClusters(maxdif);
        }
        return hc;
    }

    public void updatePopulationDataAlleles(ArrayList<ArrayList<Haplotype>> parentHaplotypes, ArrayList<Position> positions, int start, int length) {
        int nhap0 = parentHaplotypes.get(0).size();
        int nhap1 = parentHaplotypes.get(1).size();
        if (nhap0 == 0 || nhap1 == 0) {
            return;
        }
        if (nhap0 == 1 && nhap1 == 1) {
            byte[] seqA = parentHaplotypes.get((int)0).get((int)0).seq;
            byte[] seqC = parentHaplotypes.get((int)1).get((int)0).seq;
            for (int ptr = start; ptr < start + length; ++ptr) {
                int allelePtr = this.myPopulationData.original.positions().indexOf(positions.get(ptr));
                if (seqA[ptr] == seqC[ptr]) {
                    this.myPopulationData.alleleA[allelePtr] = -1;
                    this.myPopulationData.alleleC[allelePtr] = -1;
                    continue;
                }
                this.myPopulationData.alleleA[allelePtr] = GenotypeTableUtils.isHeterozygous(seqA[ptr]) ? -1 : seqA[ptr];
                this.myPopulationData.alleleC[allelePtr] = GenotypeTableUtils.isHeterozygous(seqC[ptr]) ? -1 : seqC[ptr];
            }
        } else {
            for (int ptr = start; ptr < start + length; ++ptr) {
                byte[] alleles;
                byte hapval;
                int allelePtr = this.myPopulationData.original.positions().indexOf(positions.get(ptr));
                TreeSet<Byte> p0alleles = new TreeSet<Byte>();
                TreeSet<Byte> p1alleles = new TreeSet<Byte>();
                for (Haplotype hap : parentHaplotypes.get(0)) {
                    hapval = hap.seq[ptr];
                    if (hapval == -1) continue;
                    alleles = GenotypeTableUtils.getDiploidValues(hapval);
                    p0alleles.add(alleles[0]);
                    p0alleles.add(alleles[1]);
                }
                for (Haplotype hap : parentHaplotypes.get(1)) {
                    hapval = hap.seq[ptr];
                    if (hapval == -1) continue;
                    alleles = GenotypeTableUtils.getDiploidValues(hapval);
                    p1alleles.add(alleles[0]);
                    p1alleles.add(alleles[1]);
                }
                if (p0alleles.size() == 0) {
                    this.myPopulationData.alleleA[allelePtr] = -1;
                    if (p1alleles.size() == 0) {
                        this.myPopulationData.alleleC[allelePtr] = -1;
                        continue;
                    }
                    if (p1alleles.size() == 1) {
                        byte allele = (Byte)p1alleles.first();
                        this.myPopulationData.alleleC[allelePtr] = GenotypeTableUtils.getDiploidValue(allele, allele);
                        continue;
                    }
                    this.myPopulationData.alleleC[allelePtr] = -1;
                    continue;
                }
                if (p0alleles.size() == 1) {
                    byte Aallele = (Byte)p0alleles.first();
                    if (p1alleles.size() == 0) {
                        this.myPopulationData.alleleA[allelePtr] = GenotypeTableUtils.getDiploidValue(Aallele, Aallele);
                        this.myPopulationData.alleleC[allelePtr] = -1;
                        continue;
                    }
                    if (p1alleles.size() == 1) {
                        byte Callele = (Byte)p1alleles.first();
                        if (Aallele == Callele) {
                            this.myPopulationData.alleleA[allelePtr] = -1;
                            this.myPopulationData.alleleC[allelePtr] = -1;
                            continue;
                        }
                        this.myPopulationData.alleleA[allelePtr] = GenotypeTableUtils.getDiploidValue(Aallele, Aallele);
                        this.myPopulationData.alleleC[allelePtr] = GenotypeTableUtils.getDiploidValue(Callele, Callele);
                        continue;
                    }
                    this.myPopulationData.alleleA[allelePtr] = -1;
                    this.myPopulationData.alleleC[allelePtr] = -1;
                    continue;
                }
                if (p1alleles.size() == 0) {
                    this.myPopulationData.alleleA[allelePtr] = -1;
                    this.myPopulationData.alleleC[allelePtr] = -1;
                    continue;
                }
                if (p1alleles.size() == 1) {
                    this.myPopulationData.alleleA[allelePtr] = -1;
                    this.myPopulationData.alleleC[allelePtr] = -1;
                    continue;
                }
                this.myPopulationData.alleleA[allelePtr] = -1;
                this.myPopulationData.alleleC[allelePtr] = -1;
            }
        }
    }

    public ArrayList<Haplotype> mergeMajorHaplotypes(HaplotypeClusterer clusterMaker, int minClusterSize) {
        int clusterCount;
        double maxMaf = 0.2;
        int maxMinorCount = 2;
        int maxDistance = 4;
        ArrayList<Haplotype> myHaplotypes = new ArrayList<Haplotype>();
        block0: for (clusterCount = 1; clusterCount < clusterMaker.getNumberOfClusters() && clusterMaker.getClusterList().get(clusterCount).getSize() >= minClusterSize; ++clusterCount) {
            Haplotype compHap = new Haplotype(clusterMaker.getClusterList().get(clusterCount).getCensoredMajorityHaplotype(maxMaf, maxMinorCount));
            for (int i = 0; i < clusterCount; ++i) {
                Haplotype headHap = new Haplotype(clusterMaker.getClusterList().get(i).getCensoredMajorityHaplotype(maxMaf, maxMinorCount));
                if (headHap.distanceFrom(compHap) > maxDistance) continue;
                clusterMaker.getClusterList().get(i).addAll(clusterMaker.getClusterList().get(clusterCount));
                clusterMaker.getClusterList().remove(clusterCount);
                --clusterCount;
                continue block0;
            }
        }
        for (int i = 0; i < clusterCount; ++i) {
            myHaplotypes.add(new Haplotype(clusterMaker.getClusterList().get(i).getCensoredMajorityHaplotype(maxMaf, maxMinorCount)));
        }
        return myHaplotypes;
    }

    public void convertGenotypesToParentCalls() {
        int ntaxa = this.myPopulationData.original.numberOfTaxa();
        int nsites = this.myPopulationData.original.numberOfSites();
        byte[] parentA = this.myPopulationData.alleleA;
        byte[] parentC = this.myPopulationData.alleleC;
        GenotypeTableBuilder genoBuilder = GenotypeTableBuilder.getTaxaIncremental(this.myPopulationData.original.positions());
        for (int t = 0; t < ntaxa; ++t) {
            byte[] taxongeno = this.myPopulationData.original.genotypeAllSites(t);
            for (int s = 0; s < nsites; ++s) {
                if (taxongeno[s] == -1) continue;
                taxongeno[s] = taxongeno[s] == parentA[s] ? AA : (taxongeno[s] == parentC[s] ? CC : (GenotypeTableUtils.isHeterozygous(taxongeno[s]) && parentA[s] != -1 && parentC[s] != -1 ? AC : (byte)-1));
            }
            genoBuilder.addTaxon((Taxon)this.myPopulationData.original.taxa().get(t), taxongeno);
        }
        this.myPopulationData.imputed = genoBuilder.build();
        this.myPopulationData.original = this.initialGenotype;
        int[] imputedPositions = this.myPopulationData.imputed.physicalPositions();
        int[] originalPositions = this.initialGenotype.physicalPositions();
        int numberOfOriginalPositions = originalPositions.length;
        int numberOfImputedPositions = imputedPositions.length;
        byte[] parentAgenotypes = new byte[numberOfOriginalPositions];
        byte[] parentCgenotypes = new byte[numberOfOriginalPositions];
        Arrays.fill(parentAgenotypes, (byte)-1);
        Arrays.fill(parentCgenotypes, (byte)-1);
        OpenBitSet snpNdx = new OpenBitSet(numberOfOriginalPositions);
        for (int i = 0; i < numberOfOriginalPositions; ++i) {
            int ndx = Arrays.binarySearch(imputedPositions, originalPositions[i]);
            if (ndx <= -1) continue;
            snpNdx.fastSet(i);
            parentAgenotypes[i] = parentA[ndx];
            parentCgenotypes[i] = parentC[ndx];
        }
        this.myPopulationData.snpIndex = snpNdx;
        this.myPopulationData.alleleA = parentAgenotypes;
        this.myPopulationData.alleleC = parentCgenotypes;
    }

    public GenotypeTable preFilterSites() {
        int ntaxa = this.myPopulationData.original.numberOfTaxa();
        GenotypeTable filterGeno = NucleotideImputationUtils.filterSnpsByTag(this.myPopulationData.original, this.minMaf, 1.0 - this.minCoverage, 1.0);
        int nsites = filterGeno.numberOfSites();
        double[] pHet = new double[nsites];
        for (int s = 0; s < nsites; ++s) {
            int notmiss = filterGeno.totalNonMissingForSite(s);
            int hetcount = filterGeno.heterozygousCount(s);
            pHet[s] = (double)hetcount / (double)notmiss;
        }
        double meanPhet = StatUtils.mean((double[])pHet);
        double sdPhet = Math.sqrt(StatUtils.variance((double[])pHet));
        double maxPhet = meanPhet + this.maxHetDeviation * sdPhet;
        boolean[] selected = new boolean[nsites];
        int numberFalse = 0;
        for (int s = 0; s < nsites; ++s) {
            int notmiss = filterGeno.totalNonMissingForSite(s);
            int hetcount = filterGeno.heterozygousCount(s);
            double fractionHet = (double)hetcount / (double)notmiss;
            if (fractionHet <= maxPhet) {
                selected[s] = true;
                continue;
            }
            selected[s] = false;
            ++numberFalse;
        }
        int numberNotBiallelic = 0;
        for (int s = 0; s < nsites; ++s) {
            int nalleles = filterGeno.alleles(s).length;
            if (nalleles == 2) continue;
            selected[s] = false;
            ++numberNotBiallelic;
        }
        if (this.minR2 > 0.0) {
            int ldwindow = 50;
            LinkageDisequilibrium myLD = new LinkageDisequilibrium(filterGeno, ldwindow, LinkageDisequilibrium.testDesign.SlidingWindow, -1, null, false, 0, null, LinkageDisequilibrium.HetTreatment.Homozygous);
            myLD.run();
            for (int s = 0; s < nsites; ++s) {
                if (!selected[s]) continue;
                int start = Math.max(0, s - this.window);
                int end = Math.min(nsites, s + this.window);
                double sum = 0.0;
                double count = 0.0;
                for (int i = start; i <= end; ++i) {
                    double r2 = myLD.getRSqr(s, i);
                    if (Double.isNaN(r2)) continue;
                    sum += (double)myLD.getRSqr(s, i);
                    count += 1.0;
                }
                double r2 = sum / count;
                if (!(r2 < this.minR2)) continue;
                selected[s] = false;
            }
        }
        int[] selectedSites = new int[nsites];
        int nSelectedSites = 0;
        for (int s = 0; s < nsites; ++s) {
            if (!selected[s]) continue;
            selectedSites[nSelectedSites++] = s;
        }
        selectedSites = Arrays.copyOf(selectedSites, nSelectedSites);
        System.out.printf("%d sites in filtered genotype set.\n", nSelectedSites);
        return FilterGenotypeTable.getInstance(filterGeno, selectedSites);
    }

    /*
     * Could not resolve type clashes
     */
    public static ArrayList<ArrayList<Haplotype>> getParentHaplotypesV1(ArrayList<ArrayList<Haplotype>> previousParents, ArrayList<Haplotype> candidates, int overlap, boolean forward) {
        ArrayList<ArrayList<Haplotype>> parentHaplotypes = new ArrayList<ArrayList<Haplotype>>(2);
        parentHaplotypes.add(new ArrayList());
        parentHaplotypes.add(new ArrayList());
        for (Haplotype hap : candidates) {
            Object parentHap2;
            boolean match = false;
            for (Object parentHap2 : previousParents.get(0)) {
                if (!BiparentalHaplotypeFinder.doesOverlapMatch((Haplotype)parentHap2, hap, overlap, forward)) continue;
                match = true;
                parentHaplotypes.get(0).add(hap);
                break;
            }
            if (!match) {
                for (Object parentHap2 : previousParents.get(1)) {
                    if (!BiparentalHaplotypeFinder.doesOverlapMatch((Haplotype)parentHap2, hap, overlap, forward)) continue;
                    match = true;
                    parentHaplotypes.get(1).add(hap);
                    break;
                }
            }
            if (match) continue;
            StringBuilder msgBuilder = new StringBuilder("No parent matching haplotype ");
            msgBuilder.append(hap).append(" for parents:\n");
            for (Haplotype h : previousParents.get(0)) {
                msgBuilder.append(h).append("\n");
            }
            parentHap2 = previousParents.get(1).iterator();
            while (parentHap2.hasNext()) {
                Haplotype h;
                h = parentHap2.next();
                msgBuilder.append(h).append("\n");
            }
            System.out.println(msgBuilder.toString());
            int haplen = hap.seqlen;
            Haplotype hapstart = new Haplotype(Arrays.copyOf(hap.seq, overlap));
            int par0dist = 1000000;
            for (Haplotype parentHap3 : previousParents.get(0)) {
                Haplotype parentEnd = new Haplotype(Arrays.copyOfRange(parentHap3.seq, haplen - overlap, haplen));
                int distFromParent = hapstart.distanceFrom(parentEnd);
                par0dist = Math.min(par0dist, distFromParent);
            }
            int par1dist = 1000000;
            for (Haplotype parentHap4 : previousParents.get(1)) {
                Haplotype parentEnd = new Haplotype(Arrays.copyOfRange(parentHap4.seq, haplen - overlap, haplen));
                int distFromParent = hapstart.distanceFrom(parentEnd);
                par1dist = Math.min(par1dist, distFromParent);
            }
            if (par0dist < par1dist) {
                parentHaplotypes.get(0).add(hap);
                continue;
            }
            if (par0dist > par1dist) {
                parentHaplotypes.get(1).add(hap);
                continue;
            }
            System.out.println("Haplotype not added because equi-distant from parents");
        }
        return parentHaplotypes;
    }

    public static ArrayList<ArrayList<Haplotype>> getParentHaplotypes(ArrayList<ArrayList<Haplotype>> previousParents, ArrayList<Haplotype> candidates, int overlap, boolean forward) {
        ArrayList<ArrayList<Haplotype>> parentHaplotypes = new ArrayList<ArrayList<Haplotype>>(2);
        parentHaplotypes.add(new ArrayList());
        parentHaplotypes.add(new ArrayList());
        int[] nPrev = new int[]{previousParents.get(0).size(), previousParents.get(1).size()};
        int maxNumber = Math.max(nPrev[0], nPrev[1]);
        for (Haplotype hap : candidates) {
            boolean match = false;
            for (int i = 0; i < maxNumber; ++i) {
                if (i < nPrev[0] && BiparentalHaplotypeFinder.doesOverlapMatch(previousParents.get(0).get(i), hap, overlap, forward)) {
                    match = true;
                    parentHaplotypes.get(0).add(hap);
                    break;
                }
                if (i >= nPrev[1] || !BiparentalHaplotypeFinder.doesOverlapMatch(previousParents.get(1).get(i), hap, overlap, forward)) continue;
                match = true;
                parentHaplotypes.get(1).add(hap);
                break;
            }
            if (match) continue;
            StringBuilder msgBuilder = new StringBuilder("No parent matching haplotype ");
            msgBuilder.append(hap).append(" for parents:\n");
            for (Haplotype h : previousParents.get(0)) {
                msgBuilder.append(h).append("\n");
            }
            for (Haplotype h : previousParents.get(1)) {
                msgBuilder.append(h).append("\n");
            }
            System.out.println(msgBuilder.toString());
            int haplen = hap.seqlen;
            Haplotype hapstart = forward ? new Haplotype(Arrays.copyOf(hap.seq, overlap)) : new Haplotype(Arrays.copyOfRange(hap.seq, haplen - overlap, haplen));
            int par0dist = 1000000;
            for (Haplotype parentHap : previousParents.get(0)) {
                int parentLen = parentHap.seqlen;
                byte[] matchSeq = forward ? Arrays.copyOfRange(parentHap.seq, parentLen - overlap, parentLen) : Arrays.copyOf(parentHap.seq, overlap);
                Haplotype parentEnd = new Haplotype(matchSeq);
                int distFromParent = hapstart.distanceFrom(parentEnd);
                par0dist = Math.min(par0dist, distFromParent);
            }
            int par1dist = 1000000;
            for (Haplotype parentHap : previousParents.get(1)) {
                int parentLen = parentHap.seqlen;
                byte[] matchSeq = forward ? Arrays.copyOfRange(parentHap.seq, parentLen - overlap, parentLen) : Arrays.copyOf(parentHap.seq, overlap);
                Haplotype parentEnd = new Haplotype(matchSeq);
                int distFromParent = hapstart.distanceFrom(parentEnd);
                par1dist = Math.min(par1dist, distFromParent);
            }
            if (par0dist < par1dist) {
                parentHaplotypes.get(0).add(hap);
                continue;
            }
            if (par0dist > par1dist) {
                parentHaplotypes.get(1).add(hap);
                continue;
            }
            System.out.println("Haplotype not added because equi-distant from parents");
        }
        return parentHaplotypes;
    }

    public static boolean doesOverlapMatch(Haplotype h0, Haplotype h1, int overlap, boolean forward) {
        String prev = forward ? h0.toString().substring(h0.seqlen - overlap, h0.seqlen) : h0.toString().substring(0, overlap);
        String next = !forward ? h1.toString().substring(h1.seqlen - overlap, h1.seqlen) : h1.toString().substring(0, overlap);
        boolean equals = true;
        int mismatches = 0;
        for (int i = 0; i < overlap; ++i) {
            int nextChar;
            int prevChar = prev.charAt(i);
            if (prevChar != 65 && prevChar != 67 && prevChar != 71 && prevChar != 84 && prevChar != 45 && prevChar != 43) {
                prevChar = 78;
            }
            if ((nextChar = next.charAt(i)) != 65 && nextChar != 67 && nextChar != 71 && nextChar != 84 && nextChar != 45 && nextChar != 43) {
                nextChar = 78;
            }
            if (prev.charAt(i) == next.charAt(i) || prevChar == 78 || nextChar == 78) continue;
            equals = false;
            ++mismatches;
        }
        return mismatches < 2;
    }
}

