/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.imputation;

import java.awt.Frame;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.distance.IBSDistanceMatrix;
import net.maizegenetics.dna.WHICH_ALLELE;
import net.maizegenetics.dna.map.Chromosome;
import net.maizegenetics.dna.snp.ExportUtils;
import net.maizegenetics.dna.snp.FilterGenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTableBuilder;
import net.maizegenetics.dna.snp.GenotypeTableUtils;
import net.maizegenetics.dna.snp.ImportUtils;
import net.maizegenetics.dna.snp.genotypecall.GenotypeCallTableBuilder;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListBuilder;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.util.BitSet;
import net.maizegenetics.util.BitUtil;
import net.maizegenetics.util.ExceptionUtils;
import net.maizegenetics.util.OpenBitSet;
import net.maizegenetics.util.Utils;

public class FILLINFindHaplotypesPlugin
extends AbstractPlugin {
    private PluginParameter<String> hmpFile = new PluginParameter.Builder<String>("hmp", null, String.class).guiName("Target file").inFile().required(true).description("Input genotypes to generate haplotypes from. Usually best to use all available samples from a species. Accepts all file types supported by TASSEL5.").build();
    private PluginParameter<String> outFileBase = new PluginParameter.Builder<String>("o", null, String.class).guiName("Donor dir/file basename").outDir().required(true).description("Output file directory name, or new directory path; Directory will be created, if doesn't exist. Outfiles will be placed in the directory and given the same name and appended with the substring '.gc#s#.hmp.txt' to denote chromosome and section").build();
    private PluginParameter<Double> maxDistFromFounder = new PluginParameter.Builder<Double>("mxDiv", 0.01, Double.class).guiName("Max divergence from founder").description("Maximum genetic divergence from founder haplotype to cluster sequences").build();
    private PluginParameter<Double> maxHetFreq = new PluginParameter.Builder<Double>("mxHet", 0.01, Double.class).guiName("Max heterozygosity of output haplotypes").description("Maximum heterozygosity of output haplotype. Heterozygosity results from clustering sequences that either have residual heterozygosity or clustering sequences that do not share all minor alleles.").build();
    private PluginParameter<Integer> minSitesForSectionComp = new PluginParameter.Builder<Integer>("minSites", 50, Integer.class).guiName("Min sites to cluster").description("The minimum number of sites present in two taxa to compare genetic distance to evaluate similarity for clustering").build();
    private PluginParameter<Double> maxErrorInCreatingConsensus = new PluginParameter.Builder<Double>("mxErr", 0.05, Double.class).guiName("Max combined error to impute two donors").description("The maximum genetic divergence allowable to cluster taxa").build();
    private PluginParameter<Integer> appoxSitesPerHaplotype = new PluginParameter.Builder<Integer>("hapSize", 8192, Integer.class).guiName("Preferred haplotype size").description("Preferred haplotype block size in sites (minimum 64); will use the closest multiple of 64 at or below the supplied value").build();
    private PluginParameter<Integer> minSitesPresentPerHap = new PluginParameter.Builder<Integer>("minPres", 500, Integer.class).guiName("Min sites to test match").description("Minimum number of present sites within input sequence to do the search").build();
    private PluginParameter<Integer> maxHaplotypes = new PluginParameter.Builder<Integer>("maxHap", 3000, Integer.class).guiName("Max haplotypes per segment").description("Maximum number of haplotypes per segment").build();
    private PluginParameter<Integer> minTaxaInGroup = new PluginParameter.Builder<Integer>("minTaxa", 2, Integer.class).guiName("Min taxa to generate a haplotype").description("Minimum number of taxa to generate a haplotype").build();
    private PluginParameter<Double> maximumMissing = new PluginParameter.Builder<Double>("maxOutMiss", 0.4, Double.class).guiName("Max frequency missing per haplotype").description("Maximum frequency of missing data in the output haplotype").build();
    private PluginParameter<Boolean> nonverboseOutput = new PluginParameter.Builder<Boolean>("nV", false, Boolean.class).guiName("Supress system out").description("Supress system out").build();
    private PluginParameter<Boolean> extendedOutput = new PluginParameter.Builder<Boolean>("extOut", false, Boolean.class).guiName("Detailed system out on haplotypes").description("Details of taxa included in each haplotype to system out").build();
    private boolean verboseOutput = true;
    private int startDiv = -1;
    private int endDiv = -1;
    private double minJointGapProb = 0.01;
    private boolean callGaps = false;
    private boolean anonymous = false;
    private double[] propMissing;
    private int[] siteErrors;
    private int[] siteCallCnt;
    private BitSet badMask = null;

    public FILLINFindHaplotypesPlugin() {
        super(null, false);
    }

    public FILLINFindHaplotypesPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    protected void postProcessParameters() {
        if (this.nonverboseOutput.value().booleanValue()) {
            this.verboseOutput = false;
        }
        try {
            if (new File(this.outFileBase.value()).exists()) {
                if (!new File(this.outFileBase.value()).isDirectory()) {
                    throw new IOException();
                }
            } else {
                new File(this.outFileBase.value()).mkdir();
                if (new File(this.outFileBase.value()).isFile()) {
                    new File(this.outFileBase.value()).delete();
                    throw new IOException();
                }
            }
        }
        catch (Exception e) {
            System.out.println("output directory must be an existing directory or new directory path");
        }
    }

    @Override
    public String getCitation() {
        return "Swarts K, Li H, Romero Navarro JA, Romay-Alvarez MC, Hearne S, Acharya C, Glaubitz JC, Mitchell S, Elshire RJ, Buckler ES, Bradbury PJ (2014) FSFHap (Full-Sib Family Haplotype Imputation) and FILLIN (Fast, Inbred Line Library ImputatioN) optimize genotypic imputation for low-coverage, next-generation sequence data in crop plants. Plant Genome (in review)";
    }

    @Override
    public DataSet processData(DataSet input) {
        System.out.println("Reading: " + this.hmpFile.value());
        GenotypeTable baseAlign = ImportUtils.readGuessFormat(this.hmpFile.value());
        int[][] divisions = FILLINFindHaplotypesPlugin.divideChromosome(baseAlign, this.appoxSitesPerHaplotype.value(), this.verboseOutput);
        System.out.printf("In taxa:%d sites:%d %n", baseAlign.numberOfTaxa(), baseAlign.numberOfSites());
        this.siteErrors = new int[baseAlign.numberOfSites()];
        this.siteCallCnt = new int[baseAlign.numberOfSites()];
        if (this.startDiv == -1) {
            this.startDiv = 0;
        }
        if (this.endDiv == -1) {
            this.endDiv = divisions.length - 1;
        }
        for (int i = this.startDiv; i <= this.endDiv; ++i) {
            GenotypeTable mna = this.createHaplotypeAlignment(divisions[i][0], divisions[i][1], baseAlign, this.minSitesPresentPerHap.value(), this.maxDistFromFounder.value());
            if (mna.taxa().isEmpty()) continue;
            String newExport = this.outFileBase.value() + "/" + new File(this.outFileBase.value()).getName() + ".gc" + mna.chromosomeName(0) + "s" + i + ".hmp.txt";
            ExportUtils.writeToHapmap(mna, false, newExport, '\t', null);
            if (this.outFileBase.value() != null) {
                this.exportBadSites(baseAlign, this.outFileBase.value(), 0.01);
            }
            mna = null;
            System.gc();
        }
        return null;
    }

    private GenotypeTable createHaplotypeAlignment(int startSite, int endSite, GenotypeTable baseAlign, int minSites, double maxDistance) {
        FilterGenotypeTable fa = FilterGenotypeTable.getInstance(baseAlign, startSite, endSite);
        GenotypeTable inAlign = GenotypeTableBuilder.getGenotypeCopyInstance(fa);
        int sites = inAlign.numberOfSites();
        if (this.verboseOutput) {
            System.out.printf("SubInAlign Locus:%s StartPos:%d taxa:%d sites:%d %n", inAlign.chromosome(0), inAlign.chromosomalPosition(0), inAlign.numberOfTaxa(), inAlign.numberOfSites());
        }
        this.propMissing = new double[inAlign.numberOfTaxa()];
        int startBlock = 0;
        int lastBlock = inAlign.allelePresenceForAllSites(0, WHICH_ALLELE.Major).getNumWords() - 1;
        TreeMap<Integer, Integer> presentRanking = this.createPresentRankingForWindow(inAlign, startBlock, lastBlock, minSites, this.maxHetFreq.value());
        if (this.verboseOutput) {
            System.out.printf("\tBlock %d Inbred and modest coverage:%d %n", startBlock, presentRanking.size());
        }
        if (this.verboseOutput) {
            System.out.printf("\tCurrent Site %d Current block %d EndBlock: %d %n", startSite, startBlock, lastBlock);
        }
        TreeMap<Integer, byte[][]> results = this.mergeWithinWindow(inAlign, presentRanking, startBlock, lastBlock, maxDistance, startSite);
        TaxaListBuilder tLB = new TaxaListBuilder();
        GenotypeCallTableBuilder gB = GenotypeCallTableBuilder.getInstance(results.size(), inAlign.numberOfSites());
        int index = 0;
        for (byte[][] calls : results.values()) {
            if (this.anonymous) {
                tLB.add(new Taxon("h" + index));
            } else {
                tLB.add(new Taxon("h" + index + new String(calls[1])));
            }
            gB.setBaseRangeForTaxon(index, 0, calls[0]);
            ++index;
        }
        return GenotypeTableBuilder.getInstance(gB.build(), inAlign.positions(), tLB.build());
    }

    public static int[][] divideChromosome(GenotypeTable a, int appoxSitesPerHaplotype, boolean verboseOutput) {
        Chromosome[] theL = a.chromosomes();
        ArrayList<int[]> allDivisions = new ArrayList<int[]>();
        for (Chromosome aL : theL) {
            System.out.println("");
            int[] startEnd = a.positions().startAndEndOfChromosome(aL);
            int locusSites = startEnd[1] - startEnd[0] + 1;
            int subAlignCnt = (int)Math.round((double)locusSites / (double)appoxSitesPerHaplotype);
            if (subAlignCnt == 0) {
                ++subAlignCnt;
            }
            int prefBlocks = locusSites / (subAlignCnt * 64);
            if (verboseOutput) {
                System.out.printf("Chr:%s Alignment Sites:%d subAlignCnt:%d RealSites:%d %n", aL.getName(), locusSites, subAlignCnt, prefBlocks * 64);
            }
            for (int i = 0; i < subAlignCnt; ++i) {
                int[] divs;
                divs = new int[]{i * prefBlocks * 64 + startEnd[0], divs[0] + prefBlocks * 64 - 1};
                if (i == subAlignCnt - 1) {
                    divs[1] = startEnd[1];
                }
                allDivisions.add(divs);
            }
        }
        int[][] result = new int[allDivisions.size()][2];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (int[])allDivisions.get(i);
            if (!verboseOutput) continue;
            System.out.printf("Chromosome Divisions: %s start:%d end:%d %n", a.chromosome(result[i][0]).getName(), result[i][0], result[i][1]);
        }
        return result;
    }

    private TreeMap<Integer, Integer> createPresentRankingForWindow(GenotypeTable inAlign, int startBlock, int endBlock, int minSites, double maxHetFreq) {
        int sites = 64 * (endBlock - startBlock + 1);
        TreeMap<Integer, Integer> presentRanking = new TreeMap<Integer, Integer>(Collections.reverseOrder());
        for (int i = 0; i < inAlign.numberOfTaxa(); ++i) {
            long[] mj = inAlign.allelePresenceForSitesBlock(i, WHICH_ALLELE.Major, startBlock, endBlock);
            long[] mn = inAlign.allelePresenceForSitesBlock(i, WHICH_ALLELE.Minor, startBlock, endBlock);
            int totalSitesNotMissing = 0;
            int hetCnt = 0;
            for (int j = 0; j < mj.length; ++j) {
                totalSitesNotMissing += BitUtil.pop(mj[j] | mn[j]);
                hetCnt += BitUtil.pop(mj[j] & mn[j]);
            }
            double hetFreq = (double)hetCnt / (double)totalSitesNotMissing;
            this.propMissing[i] = (double)(1 + sites - totalSitesNotMissing) / (double)sites;
            double propPresent = 1.0 - this.propMissing[i];
            if (hetFreq > maxHetFreq || totalSitesNotMissing < minSites) continue;
            int index = 1000000 * (int)(propPresent * 100.0) + i;
            presentRanking.put(index, i);
        }
        return presentRanking;
    }

    private void exportBadSites(GenotypeTable baseAlign, String exportMap, double errorThreshold) {
        BufferedWriter bw = null;
        try {
            String fullFileName = Utils.addSuffixIfNeeded(exportMap, ".txt", new String[]{".txt"});
            bw = Utils.getBufferedWriter(fullFileName);
            bw.write("<Map>\n");
            for (int i = 0; i < baseAlign.numberOfSites(); ++i) {
                double errorsRate = (double)this.siteErrors[i] / (double)this.siteCallCnt[i];
                if (errorsRate < errorThreshold) continue;
                bw.write(baseAlign.siteName(i) + "\t");
                bw.write(baseAlign.chromosomeName(i) + "\t");
                bw.write(i + "\t");
                bw.write(baseAlign.chromosomalPosition(i) + "\n");
            }
            bw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Error writing GeneticMap file: " + exportMap + ": " + ExceptionUtils.getExceptionCauses(e));
        }
    }

    private TreeMap<Integer, byte[][]> mergeWithinWindow(GenotypeTable inAlign, TreeMap<Integer, Integer> presentRanking, int firstBlock, int lastBlock, double maxDistance, int siteOffsetForError) {
        int startSite = firstBlock * 64;
        int endSite = 63 + lastBlock * 64;
        if (endSite >= inAlign.numberOfSites()) {
            endSite = inAlign.numberOfSites() - 1;
        }
        TreeMap mergeSets = new TreeMap();
        TreeMap<Integer, byte[][]> results = new TreeMap<Integer, byte[][]>(Collections.reverseOrder());
        TreeSet<Integer> unmatched = new TreeSet<Integer>(presentRanking.values());
        TaxaList inIDG = inAlign.taxa();
        for (Map.Entry<Integer, Integer> e : presentRanking.entrySet()) {
            int taxon1 = e.getValue();
            if (!unmatched.contains(taxon1)) continue;
            ArrayList<Integer> hits = new ArrayList<Integer>();
            unmatched.remove(taxon1);
            for (int taxon2 : unmatched) {
                double[] dist = IBSDistanceMatrix.computeHetBitDistances(inAlign, taxon1, taxon2, this.minSitesForSectionComp.value(), firstBlock, lastBlock, this.badMask);
                if (Double.isNaN(dist[0]) || !(dist[0] < maxDistance)) continue;
                hits.add(taxon2);
            }
            byte[] calls = inAlign.genotypeRange(taxon1, startSite, endSite + 1);
            int[] unkCnt = this.countUnknown(calls);
            double missingFreq = (double)unkCnt[0] / (double)inAlign.numberOfSites();
            if (hits.size() + 1 < this.minTaxaInGroup.value() && missingFreq > this.maximumMissing.value()) continue;
            if (hits.size() > 0) {
                ArrayList<String> mergeNames = new ArrayList<String>();
                mergeNames.add(inIDG.taxaName(taxon1));
                mergeSets.put(taxon1, hits);
                for (Integer taxon2 : hits) {
                    unmatched.remove(taxon2);
                    mergeNames.add(inIDG.taxaName(taxon2));
                }
                calls = this.consensusGameteCalls(inAlign, mergeNames, startSite, endSite, this.maxErrorInCreatingConsensus.value(), siteOffsetForError);
            } else {
                calls = inAlign.genotypeRange(taxon1, startSite, endSite + 1);
            }
            unkCnt = this.countUnknown(calls);
            missingFreq = (double)unkCnt[0] / (double)inAlign.numberOfSites();
            double hetFreq = (double)unkCnt[1] / (double)(inAlign.numberOfSites() - unkCnt[0]);
            if (missingFreq < this.maximumMissing.value() && hetFreq < this.maxHetFreq.value() && hits.size() >= this.minTaxaInGroup.value() - 1) {
                int index = hits.size() * 200000 + taxon1;
                if (this.verboseOutput && !this.extendedOutput.value().booleanValue()) {
                    System.out.printf("\t\tOutput %s plus %d missingF:%g hetF:%g index: %d %n", inIDG.taxaName(taxon1), hits.size(), missingFreq, hetFreq, index);
                }
                if (this.extendedOutput.value().booleanValue()) {
                    System.out.printf("\t\tChromosome: %s StartPos: %d EndPos: %d missingF:%g hetF:%g index: %d %n", inAlign.chromosomeName(startSite), inAlign.physicalPositions()[startSite], inAlign.physicalPositions()[endSite], missingFreq, hetFreq, index);
                    System.out.println("\t\t\t" + inIDG.taxaName(taxon1));
                    for (Integer taxon : hits) {
                        System.out.println("\t\t\t" + inIDG.taxaName(taxon));
                    }
                }
                byte[][] callPlusNames = new byte[2][];
                callPlusNames[0] = calls;
                String newName = inIDG.taxaName(taxon1) + ":d" + (hits.size() + 1);
                callPlusNames[1] = newName.getBytes();
                results.put(index, callPlusNames);
            }
            if (results.size() < this.maxHaplotypes.value()) continue;
            break;
        }
        return results;
    }

    private byte[] consensusGameteCalls(GenotypeTable a, List<String> taxa, int startSite, int endSite, double maxError, int siteOffsetForError) {
        int[] taxaIndex = new int[taxa.size()];
        for (int t = 0; t < taxaIndex.length; ++t) {
            taxaIndex[t] = a.taxa().indexOf(taxa.get(t));
        }
        byte[] calls = new byte[endSite - startSite + 1];
        Arrays.fill(calls, (byte)-1);
        for (int s = startSite; s <= endSite; ++s) {
            double errorRate;
            byte mjAllele = a.majorAllele(s);
            byte mnAllele = a.minorAllele(s);
            byte mj = GenotypeTableUtils.getUnphasedDiploidValue(mjAllele, mjAllele);
            byte mn = GenotypeTableUtils.getUnphasedDiploidValue(mnAllele, mnAllele);
            byte het = GenotypeTableUtils.getUnphasedDiploidValue(mjAllele, mnAllele);
            int mjCnt = 0;
            int mnCnt = 0;
            for (int t = 0; t < taxaIndex.length; ++t) {
                byte ob = a.genotype(taxaIndex[t], s);
                if (ob == -1) continue;
                if (ob == mj) {
                    ++mjCnt;
                    continue;
                }
                if (ob == mn) {
                    ++mnCnt;
                    continue;
                }
                if (!GenotypeTableUtils.isEqual(ob, het)) continue;
                ++mjCnt;
                ++mnCnt;
            }
            int totalCnt = mjCnt + mnCnt;
            if (totalCnt == 0) {
                double missingProp = 1.0;
                for (int t : taxaIndex) {
                    missingProp *= this.propMissing[t];
                }
                if (!(this.callGaps & missingProp < this.minJointGapProb)) continue;
                calls[s - startSite] = 85;
                continue;
            }
            if (totalCnt > 1) {
                int n = s + siteOffsetForError;
                this.siteCallCnt[n] = this.siteCallCnt[n] + totalCnt;
            }
            if (mjCnt < mnCnt) {
                errorRate = (double)mjCnt / (double)totalCnt;
                if (errorRate < maxError) {
                    calls[s - startSite] = mn;
                    continue;
                }
                int n = s + siteOffsetForError;
                this.siteErrors[n] = this.siteErrors[n] + mjCnt;
                continue;
            }
            errorRate = (double)mnCnt / (double)totalCnt;
            if (errorRate < maxError) {
                calls[s - startSite] = mj;
                continue;
            }
            int n = s + siteOffsetForError;
            this.siteErrors[n] = this.siteErrors[n] + mnCnt;
        }
        return calls;
    }

    public static ArrayList<Integer> maxMajorAllelesTaxa(GenotypeTable a, int numMaxTaxa, WHICH_ALLELE alleleNumber) {
        ArrayList<Integer> maxTaxa = new ArrayList<Integer>();
        OpenBitSet curMj = new OpenBitSet(a.numberOfSites());
        long maxMjCnt = curMj.cardinality();
        for (int i = 0; i < numMaxTaxa; ++i) {
            long bestCnt = 0L;
            int bestAddTaxa = -1;
            for (int t = 0; t < a.numberOfTaxa(); ++t) {
                OpenBitSet testMj = new OpenBitSet(a.allelePresenceForAllSites(t, alleleNumber));
                testMj.union(curMj);
                long cnt = testMj.cardinality();
                if (cnt <= bestCnt) continue;
                bestCnt = cnt;
                bestAddTaxa = t;
            }
            if (maxMjCnt == bestCnt) continue;
            curMj.union(a.allelePresenceForAllSites(bestAddTaxa, alleleNumber));
            maxMjCnt = curMj.cardinality();
            maxTaxa.add(bestAddTaxa);
            System.out.printf("Allele:%d Taxa: %s %d %n", new Object[]{alleleNumber, a.taxaName(bestAddTaxa), maxMjCnt});
        }
        return maxTaxa;
    }

    private int[] countUnknown(byte[] b) {
        int cnt = 0;
        int cntHet = 0;
        for (int i = 0; i < b.length; ++i) {
            if (b[i] == -1) {
                ++cnt;
                continue;
            }
            if (!GenotypeTableUtils.isHeterozygous(b[i])) continue;
            ++cntHet;
        }
        int[] result = new int[]{cnt, cntHet};
        return result;
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return "Extract Inbred Haplotypes by FILLIN";
    }

    @Override
    public String getToolTipText() {
        return "Creates haplotype alignments based on long IBD regions of inbred lines";
    }

    public Boolean runPlugin(DataSet input) {
        return (Boolean)this.performFunction(input).getData(0).getData();
    }

    public String targetFile() {
        return this.hmpFile.value();
    }

    public FILLINFindHaplotypesPlugin targetFile(String value) {
        this.hmpFile = new PluginParameter<String>(this.hmpFile, value);
        return this;
    }

    public String outputFilename() {
        return this.outFileBase.value();
    }

    public FILLINFindHaplotypesPlugin outputFilename(String value) {
        this.outFileBase = new PluginParameter<String>(this.outFileBase, value);
        return this;
    }

    public Double maxDivergenceFromFounder() {
        return this.maxDistFromFounder.value();
    }

    public FILLINFindHaplotypesPlugin maxDivergenceFromFounder(Double value) {
        this.maxDistFromFounder = new PluginParameter<Double>(this.maxDistFromFounder, value);
        return this;
    }

    public Double maxHeterozygosityOfOutputHaplotypes() {
        return this.maxHetFreq.value();
    }

    public FILLINFindHaplotypesPlugin maxHeterozygosityOfOutputHaplotypes(Double value) {
        this.maxHetFreq = new PluginParameter<Double>(this.maxHetFreq, value);
        return this;
    }

    public Integer minSitesToCluster() {
        return this.minSitesForSectionComp.value();
    }

    public FILLINFindHaplotypesPlugin minSitesToCluster(Integer value) {
        this.minSitesForSectionComp = new PluginParameter<Integer>(this.minSitesForSectionComp, value);
        return this;
    }

    public Double maxCombinedErrorToImputeTwoDonors() {
        return this.maxErrorInCreatingConsensus.value();
    }

    public FILLINFindHaplotypesPlugin maxCombinedErrorToImputeTwoDonors(Double value) {
        this.maxErrorInCreatingConsensus = new PluginParameter<Double>(this.maxErrorInCreatingConsensus, value);
        return this;
    }

    public Integer preferredHaplotypeSize() {
        return this.appoxSitesPerHaplotype.value();
    }

    public FILLINFindHaplotypesPlugin preferredHaplotypeSize(Integer value) {
        this.appoxSitesPerHaplotype = new PluginParameter<Integer>(this.appoxSitesPerHaplotype, value);
        return this;
    }

    public Integer minSitesToTestMatch() {
        return this.minSitesPresentPerHap.value();
    }

    public FILLINFindHaplotypesPlugin minSitesToTestMatch(Integer value) {
        this.minSitesPresentPerHap = new PluginParameter<Integer>(this.minSitesPresentPerHap, value);
        return this;
    }

    public Integer maxHaplotypesPerSegment() {
        return this.maxHaplotypes.value();
    }

    public FILLINFindHaplotypesPlugin maxHaplotypesPerSegment(Integer value) {
        this.maxHaplotypes = new PluginParameter<Integer>(this.maxHaplotypes, value);
        return this;
    }

    public Integer minTaxaToGenerateAHaplotype() {
        return this.minTaxaInGroup.value();
    }

    public FILLINFindHaplotypesPlugin minTaxaToGenerateAHaplotype(Integer value) {
        this.minTaxaInGroup = new PluginParameter<Integer>(this.minTaxaInGroup, value);
        return this;
    }

    public Double maxFrequencyMissingPerHaplotype() {
        return this.maximumMissing.value();
    }

    public FILLINFindHaplotypesPlugin maxFrequencyMissingPerHaplotype(Double value) {
        this.maximumMissing = new PluginParameter<Double>(this.maximumMissing, value);
        return this;
    }

    public Boolean supressSystemOut() {
        return this.nonverboseOutput.value();
    }

    public FILLINFindHaplotypesPlugin supressSystemOut(Boolean value) {
        this.nonverboseOutput = new PluginParameter<Boolean>(this.nonverboseOutput, value);
        return this;
    }

    public Boolean detailedSystemOutOnHaplotypes() {
        return this.extendedOutput.value();
    }

    public FILLINFindHaplotypesPlugin detailedSystemOutOnHaplotypes(Boolean value) {
        this.extendedOutput = new PluginParameter<Boolean>(this.extendedOutput, value);
        return this;
    }
}

