/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.imputation;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.MinMaxPriorityQueue;
import com.google.common.collect.Ordering;
import com.google.common.collect.TreeMultimap;
import com.google.common.primitives.Ints;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.maizegenetics.analysis.popgen.DonorHypoth;
import net.maizegenetics.dna.WHICH_ALLELE;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTableUtils;
import net.maizegenetics.util.BitSet;
import net.maizegenetics.util.BitUtil;

public class FILLINImputationUtils {
    public static byte[][][] calcAllelePresenceCountsBtwTargetAndDonors(BitSet[] modBitsOfTarget, GenotypeTable donorAlign) {
        int blocks = modBitsOfTarget[0].getNumWords();
        byte[][][] allDist = new byte[donorAlign.numberOfTaxa()][4][blocks];
        long[] iMj = modBitsOfTarget[0].getBits();
        long[] iMn = modBitsOfTarget[1].getBits();
        for (int donor1 = 0; donor1 < allDist.length; ++donor1) {
            long[] jMj = donorAlign.allelePresenceForAllSites(donor1, WHICH_ALLELE.Major).getBits();
            long[] jMn = donorAlign.allelePresenceForAllSites(donor1, WHICH_ALLELE.Minor).getBits();
            for (int i = 0; i < blocks; ++i) {
                long same = iMj[i] & jMj[i] | iMn[i] & jMn[i];
                long diff = iMj[i] & jMn[i] | iMn[i] & jMj[i];
                long hets = same & diff;
                int sameCnt = BitUtil.pop(same);
                int diffCnt = BitUtil.pop(diff);
                int hetCnt = BitUtil.pop(hets);
                int sites = sameCnt + diffCnt - hetCnt;
                allDist[donor1][2][i] = (byte)diffCnt;
                allDist[donor1][3][i] = (byte)hetCnt;
                allDist[donor1][0][i] = (byte)sites;
                allDist[donor1][1][i] = (byte)sameCnt;
            }
        }
        return allDist;
    }

    public static DonorHypoth[] findHomozygousDonorHypoth(int targetTaxon, int firstBlock, int lastBlock, int focusBlock, int[] donor1indices, byte[][][] targetToDonorDistances, int minTestSites, int maxDonorHypotheses) {
        MinMaxPriorityQueue bestDonors = MinMaxPriorityQueue.orderedBy(DonorHypoth.byErrorRateOrdering).maximumSize(maxDonorHypotheses).create();
        for (int d1 : donor1indices) {
            int sameCnt = 0;
            int diffCnt = 0;
            int hetCnt = 0;
            for (int i = firstBlock; i <= lastBlock; ++i) {
                sameCnt += targetToDonorDistances[d1][1][i];
                diffCnt += targetToDonorDistances[d1][2][i];
                hetCnt += targetToDonorDistances[d1][3][i];
            }
            int testSites = sameCnt + diffCnt - hetCnt;
            if (testSites < minTestSites) continue;
            int totalMendelianErrors = diffCnt - hetCnt / 2;
            DonorHypoth theDH = new DonorHypoth(targetTaxon, d1, d1, firstBlock, focusBlock, lastBlock, testSites, totalMendelianErrors);
            bestDonors.add((Object)theDH);
        }
        DonorHypoth[] result = (DonorHypoth[])bestDonors.toArray((Object[])new DonorHypoth[0]);
        Arrays.sort(result, DonorHypoth.byErrorRateOrdering);
        return result;
    }

    public static int[] mostFrequentDonorsAcrossFocusBlocks(DonorHypoth[][] allDH, int maxHypotheses) {
        HashMap<Integer, Integer> bd = new HashMap<Integer, Integer>();
        for (int i = 0; i < allDH.length; ++i) {
            int rank = allDH[i].length;
            for (DonorHypoth dh : allDH[i]) {
                if (dh == null) continue;
                if (bd.containsKey(dh.donor1Taxon)) {
                    bd.put(dh.donor1Taxon, (Integer)bd.get(dh.donor1Taxon) + rank);
                } else {
                    bd.put(dh.donor1Taxon, rank);
                }
                --rank;
            }
        }
        TreeMultimap rankings = TreeMultimap.create((Comparator)Ordering.natural().reverse(), (Comparator)Ordering.natural());
        for (Map.Entry dhs : bd.entrySet()) {
            rankings.put(dhs.getValue(), dhs.getKey());
        }
        int resultSize = rankings.size() < maxHypotheses ? rankings.size() : maxHypotheses;
        int[] result = new int[resultSize];
        Iterator iDH = rankings.values().iterator();
        for (int i = 0; i < resultSize; ++i) {
            result[i] = (Integer)iDH.next();
        }
        return result;
    }

    public static int[] bestDonorsAcrossEntireRegion(byte[][][] targetToDonorDistances, int minTestSites, int maxDonorHypotheses) {
        int[] donor1indices = FILLINImputationUtils.fillInc(0, targetToDonorDistances.length - 1);
        DonorHypoth[] bestDH = FILLINImputationUtils.findHomozygousDonorHypoth(-1, 0, targetToDonorDistances[0][0].length - 1, 0, donor1indices, targetToDonorDistances, minTestSites, maxDonorHypotheses);
        int resultSize = bestDH.length < maxDonorHypotheses ? bestDH.length : maxDonorHypotheses;
        int[] result = new int[resultSize];
        int i = 0;
        for (DonorHypoth donorHypoth : bestDH) {
            result[i++] = donorHypoth.donor1Taxon;
        }
        return result;
    }

    public static int sumOf(int ... integers) {
        int total = 0;
        int i = 0;
        while (i < integers.length) {
            total += integers[i++];
        }
        return total;
    }

    public static int sumOf(byte ... integers) {
        int total = 0;
        int i = 0;
        while (i < integers.length) {
            total += integers[i++];
        }
        return total;
    }

    public static int[] fillInc(int first, int last) {
        int[] total = new int[last - first + 1];
        for (int i = 0; i < total.length; ++i) {
            total[i] = first++;
        }
        return total;
    }

    public static DonorHypoth[] findHeterozygousDonorHypoth(int targetTaxon, long[] mjT, long[] mnT, int firstBlock, int lastBlock, int focusBlock, GenotypeTable donorAlign, int d1, int[] donor2Indices, int maxDonorHypotheses, int minTestSites) {
        MinMaxPriorityQueue bestDonors = MinMaxPriorityQueue.orderedBy(DonorHypoth.byErrorRateOrdering).maximumSize(maxDonorHypotheses).create();
        long[] mj1 = donorAlign.allelePresenceForSitesBlock(d1, WHICH_ALLELE.Major, firstBlock, lastBlock + 1);
        long[] mn1 = donorAlign.allelePresenceForSitesBlock(d1, WHICH_ALLELE.Minor, firstBlock, lastBlock + 1);
        for (int d2 : donor2Indices) {
            long[] mn2;
            long[] mj2 = donorAlign.allelePresenceForSitesBlock(d2, WHICH_ALLELE.Major, firstBlock, lastBlock + 1);
            int[] mendErr = FILLINImputationUtils.mendelErrorComparison(mjT, mnT, mj1, mn1, mj2, mn2 = donorAlign.allelePresenceForSitesBlock(d2, WHICH_ALLELE.Minor, firstBlock, lastBlock + 1));
            if (mendErr[1] < minTestSites) continue;
            DonorHypoth theDH = new DonorHypoth(targetTaxon, d1, d2, firstBlock, focusBlock, lastBlock, mendErr[1], mendErr[0]);
            bestDonors.add((Object)theDH);
        }
        DonorHypoth[] result = (DonorHypoth[])bestDonors.toArray((Object[])new DonorHypoth[0]);
        Arrays.sort(result, DonorHypoth.byErrorRateOrdering);
        return result;
    }

    public static DonorHypoth[] findHeterozygousDonorHypoth(int targetTaxon, long[] mjT, long[] mnT, int firstBlock, int lastBlock, int focusBlock, GenotypeTable donorAlign, int[] donor1Indices, int[] donor2Indices, int maxDonorHypotheses, int minTestSites) {
        HashMultimap tests = HashMultimap.create();
        for (int d1 : donor1Indices) {
            for (int d2 : donor2Indices) {
                if (d1 < d2) {
                    tests.put((Object)d1, (Object)d2);
                    continue;
                }
                tests.put((Object)d2, (Object)d1);
            }
        }
        MinMaxPriorityQueue bestDonors = MinMaxPriorityQueue.orderedBy(DonorHypoth.byErrorRateOrdering).maximumSize(maxDonorHypotheses).create();
        Iterator iterator = tests.keySet().iterator();
        while (iterator.hasNext()) {
            DonorHypoth[] oneDimenHypoth;
            int d1 = (Integer)iterator.next();
            int[] d2donors = Ints.toArray((Collection)tests.get((Object)d1));
            for (DonorHypoth donorHypoth : oneDimenHypoth = FILLINImputationUtils.findHeterozygousDonorHypoth(targetTaxon, mjT, mnT, firstBlock, lastBlock, focusBlock, donorAlign, d1, d2donors, maxDonorHypotheses, minTestSites)) {
                bestDonors.add((Object)donorHypoth);
            }
        }
        DonorHypoth[] result = (DonorHypoth[])bestDonors.toArray((Object[])new DonorHypoth[0]);
        Arrays.sort(result, DonorHypoth.byErrorRateOrdering);
        return result;
    }

    public static DonorHypoth[] combineDonorHypothArrays(int maxDonorHypotheses, DonorHypoth[] ... dhs) {
        MinMaxPriorityQueue bestDonors = MinMaxPriorityQueue.orderedBy(DonorHypoth.byErrorRateOrdering).maximumSize(maxDonorHypotheses).create();
        DonorHypoth[][] donorHypothArray = dhs;
        int n = donorHypothArray.length;
        for (int i = 0; i < n; ++i) {
            DonorHypoth[] aDHArray;
            for (DonorHypoth donorHypoth : aDHArray = donorHypothArray[i]) {
                bestDonors.add((Object)donorHypoth);
            }
        }
        DonorHypoth[] result = (DonorHypoth[])bestDonors.toArray((Object[])new DonorHypoth[0]);
        Arrays.sort(result, DonorHypoth.byErrorRateOrdering);
        return result;
    }

    public static int[] getBlockWithMinMinorCount(long[] mjT, long[] mnT, int focusBlock, int minMinorCnt, int minMajorCnt) {
        int blocks = mjT.length;
        int majorCnt = Long.bitCount(mjT[focusBlock]);
        int minorCnt = Long.bitCount(mnT[focusBlock]);
        int endBlock = focusBlock;
        int startBlock = focusBlock;
        while (minorCnt < minMinorCnt && majorCnt < minMajorCnt) {
            boolean preferMoveStart;
            boolean bl = preferMoveStart = focusBlock - startBlock < endBlock - focusBlock;
            if (startBlock == 0) {
                preferMoveStart = false;
            }
            if (endBlock == blocks - 1) {
                preferMoveStart = true;
            }
            if (startBlock == 0 && endBlock == blocks - 1) break;
            if (preferMoveStart) {
                minorCnt += Long.bitCount(mnT[--startBlock]);
                majorCnt += Long.bitCount(mjT[startBlock]);
                continue;
            }
            minorCnt += Long.bitCount(mnT[++endBlock]);
            majorCnt += Long.bitCount(mjT[startBlock]);
        }
        int[] result = new int[]{startBlock, focusBlock, endBlock};
        return result;
    }

    public static int[] mendelErrorComparison(long[] mjT, long[] mnT, long[] mj1, long[] mn1, long[] mj2, long[] mn2) {
        int mjUnmatched = 0;
        int mnUnmatched = 0;
        int testSites = 0;
        for (int i = 0; i < mjT.length; ++i) {
            long siteMask = (mjT[i] | mnT[i]) & (mj1[i] | mn1[i]) & (mj2[i] | mn2[i]);
            mjUnmatched += Long.bitCount(siteMask & mjT[i] & (mjT[i] ^ mj1[i]) & (mjT[i] ^ mj2[i]));
            mnUnmatched += Long.bitCount(siteMask & mnT[i] & (mnT[i] ^ mn1[i]) & (mnT[i] ^ mn2[i]));
            testSites += Long.bitCount(siteMask);
        }
        int totalMendelianErrors = mjUnmatched + mnUnmatched;
        return new int[]{totalMendelianErrors, testSites};
    }

    public static int[] countUnknownAndHeterozygotes(byte[] a) {
        int cnt = 0;
        int cntHets = 0;
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == -1) {
                ++cnt;
                continue;
            }
            if (!GenotypeTableUtils.isHeterozygous(a[i])) continue;
            ++cntHets;
        }
        return new int[]{cnt, cntHets};
    }
}

