/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.imputation;

import com.google.common.collect.Range;
import java.awt.Frame;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.imputation.CallParentAllelesPlugin;
import net.maizegenetics.analysis.imputation.ViterbiAlgorithmPlugin;
import net.maizegenetics.analysis.imputation.WritePopulationAlignmentPlugin;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.PluginParameter;

public class FSFHapImputationPlugin
extends AbstractPlugin {
    private PluginParameter<String> pedigreeFilename = new PluginParameter.Builder<String>("pedigrees", null, String.class).description("the pedigree file name").inFile().required(true).build();
    private PluginParameter<String> logFilename = new PluginParameter.Builder<String>("logfile", null, String.class).description("the name of a log file for runtime messages").outFile().build();
    private PluginParameter<Boolean> useClusterAlgorithm = new PluginParameter.Builder<Boolean>("cluster", false, Boolean.class).description("use the cluster algorithm").build();
    private PluginParameter<Boolean> useWindowLD = new PluginParameter.Builder<Boolean>("windowLD", false, Boolean.class).description("use the windowLD algorithm").build();
    private PluginParameter<Boolean> useBCFilter = new PluginParameter.Builder<Boolean>("bc", true, Boolean.class).description("use the single backcross algorithm").build();
    private PluginParameter<Boolean> useMultipleBCFilter = new PluginParameter.Builder<Boolean>("multbc", false, Boolean.class).description("use the multiple backcross algorithm").build();
    private PluginParameter<Double> minMinorAlleleFreq = new PluginParameter.Builder<Double>("minMaf", 0.1, Double.class).range((Range<Double>)Range.closed((Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(1.0))).description("filter out sites with less than minimumMinorAlleleFrequency").build();
    private PluginParameter<Integer> windowSize = new PluginParameter.Builder<Integer>("window", 50, Integer.class).description("filter out sites with less than minimumMinorAlleleFrequency").build();
    private PluginParameter<Double> minRforSnps = new PluginParameter.Builder<Double>("minR", 0.2, Double.class).range((Range<Double>)Range.closed((Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(1.0))).description("filter out sites not correlated with neighboring sites").build();
    private PluginParameter<Double> maxMissing = new PluginParameter.Builder<Double>("maxMissing", 0.8, Double.class).range((Range<Double>)Range.closed((Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(1.0))).description("filter out sites with proportion missing > maxMissing").build();
    private PluginParameter<Boolean> noHets = new PluginParameter.Builder<Boolean>("nohets", false, Boolean.class).description("delete heterozygous calls before imputing").build();
    private PluginParameter<Integer> maxDifference = new PluginParameter.Builder<Integer>("maxDiff", 0, Integer.class).description("use to decide if two haplotypes are equivalent").build();
    private PluginParameter<Integer> minHaplotypeCluster = new PluginParameter.Builder<Integer>("minHap", 5, Integer.class).description("haplotype must be observed at least this often").build();
    private PluginParameter<Integer> overlap = new PluginParameter.Builder<Integer>("overlap", 25, Integer.class).description("overlap between adjacent windows").build();
    private PluginParameter<Boolean> fillgaps = new PluginParameter.Builder<Boolean>("fillgaps", false, Boolean.class).description("replace missing values with flanking values if equal").build();
    private PluginParameter<Double> probHeterozygous = new PluginParameter.Builder<Double>("phet", 0.07, Double.class).range((Range<Double>)Range.closed((Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(1.0))).description("proportion of sites that are heterozygous").build();
    private PluginParameter<Boolean> mergeAlignments = new PluginParameter.Builder<Boolean>("merge", false, Boolean.class).description("merge families and chromosomes").build();
    private PluginParameter<Boolean> outParentCalls = new PluginParameter.Builder<Boolean>("outParents", true, Boolean.class).description("replace missing values with flanking values if equal").build();
    private PluginParameter<Boolean> outNucleotides = new PluginParameter.Builder<Boolean>("outNuc", true, Boolean.class).description("replace missing values with flanking values if equal").build();
    private PluginParameter<Boolean> outIUPAC = new PluginParameter.Builder<Boolean>("outIUPAC", true, Boolean.class).description("use IUPAC ambiguity codes for output").build();

    public FSFHapImputationPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    public String getCitation() {
        return "Swarts K, Li H, Romero Navarro JA, Romay-Alvarez MC, Hearne S, Acharya C, Glaubitz JC, Mitchell S, Elshire RJ, Buckler ES, Bradbury PJ (2014) FSFHap (Full-Sib Family Haplotype Imputation) and FILLIN (Fast, Inbred Line Library ImputatioN) optimize genotypic imputation for low-coverage, next-generation sequence data in crop plants. Plant Genome (in review)";
    }

    @Override
    public String pluginDescription() {
        return "The FSFHapImputation Plugin infers parental haplotypes for a full sib family then uses those haplotypes in an HMM to impute variants. It is effective at correctly imputing heterzygotes in GBS data.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSet processData(DataSet input) {
        try {
            CallParentAllelesPlugin cpa = new CallParentAllelesPlugin(null);
            cpa.setPedfileName(this.pedigreeFilename.value());
            cpa.setLogFile(this.logFilename.value());
            cpa.setUseClusterAlgorithm(this.useClusterAlgorithm.value());
            cpa.setUseWindowLD(this.useWindowLD.value());
            cpa.setUseBCFilter(this.useBCFilter.value());
            cpa.setUseMultipleBCFilter(this.useMultipleBCFilter.value());
            cpa.setMinMinorAlleleFrequency(this.minMinorAlleleFreq.value());
            cpa.setWindowSize(this.windowSize.value());
            cpa.setMinRforSnps(this.minRforSnps.value());
            cpa.setMaxMissing(this.maxMissing.value());
            cpa.setUseHets(this.noHets.value() == false);
            cpa.setMaxDifference(this.maxDifference.value());
            cpa.setMinUsedClusterSize(this.minHaplotypeCluster.value());
            cpa.setOverlap(this.overlap.value());
            this.fireProgress(10);
            DataSet cpaResult = cpa.performFunction(input);
            this.fireProgress(30);
            ViterbiAlgorithmPlugin vap = new ViterbiAlgorithmPlugin(null);
            vap.setFillGapsInAlignment(this.fillgaps.value());
            vap.setProbHeterozygous(this.probHeterozygous.value());
            DataSet vapResult = vap.performFunction(cpaResult);
            this.fireProgress(60);
            WritePopulationAlignmentPlugin writePap = new WritePopulationAlignmentPlugin(null);
            writePap.setMergeAlignments(this.mergeAlignments.value());
            writePap.setWriteParentCalls(this.outParentCalls.value());
            writePap.setWriteNucleotides(this.outNucleotides.value());
            writePap.setOutputDiploid(this.outIUPAC.value() == false);
            DataSet writeResult = writePap.performFunction(vapResult);
            this.fireProgress(90);
            DataSet dataSet = writeResult;
            return dataSet;
        }
        finally {
            this.fireProgress(100);
        }
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return "Impute By FSFHap";
    }

    @Override
    public String getToolTipText() {
        return "Impute variants in full sib families";
    }

    public GenotypeTable runPlugin(DataSet input) {
        return (GenotypeTable)this.performFunction(input).getData(0).getData();
    }

    public String pedigrees() {
        return this.pedigreeFilename.value();
    }

    public FSFHapImputationPlugin pedigrees(String value) {
        this.pedigreeFilename = new PluginParameter<String>(this.pedigreeFilename, value);
        return this;
    }

    public Boolean cluster() {
        return this.useClusterAlgorithm.value();
    }

    public FSFHapImputationPlugin cluster(Boolean value) {
        this.useClusterAlgorithm = new PluginParameter<Boolean>(this.useClusterAlgorithm, value);
        return this;
    }

    public Boolean windowLD() {
        return this.useWindowLD.value();
    }

    public FSFHapImputationPlugin windowLD(Boolean value) {
        this.useWindowLD = new PluginParameter<Boolean>(this.useWindowLD, value);
        return this;
    }

    public Boolean bc() {
        return this.useBCFilter.value();
    }

    public FSFHapImputationPlugin bc(Boolean value) {
        this.useBCFilter = new PluginParameter<Boolean>(this.useBCFilter, value);
        return this;
    }

    public Boolean multbc() {
        return this.useMultipleBCFilter.value();
    }

    public FSFHapImputationPlugin multbc(Boolean value) {
        this.useMultipleBCFilter = new PluginParameter<Boolean>(this.useMultipleBCFilter, value);
        return this;
    }

    public Double minMaf() {
        return this.minMinorAlleleFreq.value();
    }

    public FSFHapImputationPlugin minMaf(Double value) {
        this.minMinorAlleleFreq = new PluginParameter<Double>(this.minMinorAlleleFreq, value);
        return this;
    }

    public Integer window() {
        return this.windowSize.value();
    }

    public FSFHapImputationPlugin window(Integer value) {
        this.windowSize = new PluginParameter<Integer>(this.windowSize, value);
        return this;
    }

    public Double minR() {
        return this.minRforSnps.value();
    }

    public FSFHapImputationPlugin minR(Double value) {
        this.minRforSnps = new PluginParameter<Double>(this.minRforSnps, value);
        return this;
    }

    public Double maxMissing() {
        return this.maxMissing.value();
    }

    public FSFHapImputationPlugin maxMissing(Double value) {
        this.maxMissing = new PluginParameter<Double>(this.maxMissing, value);
        return this;
    }

    public Boolean nohets() {
        return this.noHets.value();
    }

    public FSFHapImputationPlugin nohets(Boolean value) {
        this.noHets = new PluginParameter<Boolean>(this.noHets, value);
        return this;
    }

    public Integer maxDiff() {
        return this.maxDifference.value();
    }

    public FSFHapImputationPlugin maxDiff(Integer value) {
        this.maxDifference = new PluginParameter<Integer>(this.maxDifference, value);
        return this;
    }

    public Integer minHap() {
        return this.minHaplotypeCluster.value();
    }

    public FSFHapImputationPlugin minHap(Integer value) {
        this.minHaplotypeCluster = new PluginParameter<Integer>(this.minHaplotypeCluster, value);
        return this;
    }

    public Integer overlap() {
        return this.overlap.value();
    }

    public FSFHapImputationPlugin overlap(Integer value) {
        this.overlap = new PluginParameter<Integer>(this.overlap, value);
        return this;
    }

    public Boolean fillgaps() {
        return this.fillgaps.value();
    }

    public FSFHapImputationPlugin fillgaps(Boolean value) {
        this.fillgaps = new PluginParameter<Boolean>(this.fillgaps, value);
        return this;
    }

    public Double phet() {
        return this.probHeterozygous.value();
    }

    public FSFHapImputationPlugin phet(Double value) {
        this.probHeterozygous = new PluginParameter<Double>(this.probHeterozygous, value);
        return this;
    }

    public Boolean merge() {
        return this.mergeAlignments.value();
    }

    public FSFHapImputationPlugin merge(Boolean value) {
        this.mergeAlignments = new PluginParameter<Boolean>(this.mergeAlignments, value);
        return this;
    }

    public Boolean outParents() {
        return this.outParentCalls.value();
    }

    public FSFHapImputationPlugin outParents(Boolean value) {
        this.outParentCalls = new PluginParameter<Boolean>(this.outParentCalls, value);
        return this;
    }

    public Boolean outNuc() {
        return this.outNucleotides.value();
    }

    public FSFHapImputationPlugin outNuc(Boolean value) {
        this.outNucleotides = new PluginParameter<Boolean>(this.outNucleotides, value);
        return this;
    }

    public Boolean outIUPAC() {
        return this.outIUPAC.value();
    }

    public FSFHapImputationPlugin outIUPAC(Boolean value) {
        this.outIUPAC = new PluginParameter<Boolean>(this.outIUPAC, value);
        return this;
    }
}

