/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.imputation;

import java.awt.Frame;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.imputation.NucleotideImputationUtils;
import net.maizegenetics.analysis.imputation.PopulationData;
import net.maizegenetics.dna.WHICH_ALLELE;
import net.maizegenetics.dna.map.Position;
import net.maizegenetics.dna.snp.CombineGenotypeTable;
import net.maizegenetics.dna.snp.ExportUtils;
import net.maizegenetics.dna.snp.FilterGenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTableBuilder;
import net.maizegenetics.dna.snp.GenotypeTableUtils;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginEvent;
import net.maizegenetics.util.BitSet;
import net.maizegenetics.util.OpenBitSet;
import org.apache.log4j.Logger;

public class WritePopulationAlignmentPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(WritePopulationAlignmentPlugin.class);
    boolean mergeAlignments = false;
    boolean writeParentCalls = true;
    boolean writeNucleotides = true;
    boolean outputDiploid = false;
    double minSnpCoverage = Double.NaN;
    double maxMafForMono = Double.NaN;
    boolean outputAlternateNucleotides = true;
    boolean writeToFile = false;
    String baseFile = "";

    public WritePopulationAlignmentPlugin(Frame parentFrame) {
        super(parentFrame, false);
    }

    @Override
    public DataSet performFunction(DataSet input) {
        List<Datum> theData = input.getDataOfType(PopulationData.class);
        ArrayList<Datum> theResult = new ArrayList<Datum>();
        if (theData.size() > 0) {
            if (this.writeParentCalls) {
                theResult.addAll(this.writeOutput(theData, false));
            }
            if (this.writeNucleotides) {
                theResult.addAll(this.writeOutput(theData, true));
            }
            DataSet resultDataSet = new DataSet(theResult, (Plugin)this);
            this.fireDataSetReturned(new PluginEvent(resultDataSet, this));
            return resultDataSet;
        }
        return null;
    }

    private List<Datum> writeOutput(List<Datum> theData, boolean asNucleotides) {
        ArrayList<Datum> theResult = new ArrayList<Datum>();
        if (this.mergeAlignments) {
            String filepath;
            String myDatumComment;
            String myDatumName;
            GenotypeTable[] allOfTheAlignments = new GenotypeTable[theData.size()];
            int count = 0;
            for (Datum datum : theData) {
                PopulationData family = (PopulationData)datum.getData();
                if (asNucleotides) {
                    allOfTheAlignments[count++] = this.createOutputAlignmentImputingAllNucleotides(family);
                    continue;
                }
                allOfTheAlignments[count++] = this.createOutputAlignment(family, asNucleotides);
            }
            GenotypeTable myImputedGenotypes = CombineGenotypeTable.getInstance(allOfTheAlignments, true);
            if (asNucleotides) {
                myDatumName = "imputed_genotypes";
                myDatumComment = "imputed genotypes, merged";
                filepath = this.baseFile + ".nuc.hmp.txt.gz";
            } else {
                myDatumName = "imputed_parents";
                myDatumComment = "Imputed parents were coded as A and C.\nA and C were assigned at random for each chromosome independently.";
                filepath = this.baseFile + ".parents.hmp.txt.gz";
            }
            Datum myDatum = new Datum(myDatumName, myImputedGenotypes, myDatumComment);
            theResult.add(myDatum);
            if (this.writeToFile) {
                ExportUtils.writeToHapmap(myImputedGenotypes, filepath);
            }
        } else {
            for (Datum datum : theData) {
                StringBuilder myDatumComment;
                StringBuilder myDatumName;
                GenotypeTable myImputedGenotypes;
                PopulationData family = (PopulationData)datum.getData();
                String familyName = family.name.replace('/', '.');
                String chrName = family.original.chromosomeName(0);
                StringBuilder filepath = new StringBuilder(this.baseFile);
                if (asNucleotides) {
                    myImputedGenotypes = this.createOutputAlignmentImputingAllNucleotides(family);
                    myDatumName = new StringBuilder("imputed_genotypes_Chr");
                    myDatumName.append(chrName).append("_").append(familyName);
                    myDatumComment = new StringBuilder("imputed genotypes");
                    myDatumComment.append("\nchromosome ").append(chrName);
                    myDatumComment.append("\nfamily = ").append(familyName);
                    filepath.append(".chr").append(chrName).append(".").append(familyName).append(".nuc.hmp.txt.gz");
                } else {
                    myImputedGenotypes = this.createOutputAlignment(family, asNucleotides);
                    myDatumName = new StringBuilder("imputed_parents_Chr");
                    myDatumName.append(chrName).append("_").append(familyName);
                    myDatumComment = new StringBuilder("imputed parents");
                    myDatumComment.append("\nchromosome ").append(chrName);
                    myDatumComment.append("\nfamily = ").append(familyName);
                    myDatumComment.append("\nImputed parents have been coded as A and C.");
                    myDatumComment.append("\nA and C were assigned to parents at random for each chromosome independently.");
                    filepath.append(".chr").append(chrName).append(".").append(familyName).append(".parents.hmp.txt.gz");
                }
                Datum myDatum = new Datum(myDatumName.toString(), myImputedGenotypes, myDatumComment.toString());
                theResult.add(myDatum);
                if (!this.writeToFile) continue;
                ExportUtils.writeToHapmap(myImputedGenotypes, filepath.toString());
            }
        }
        return theResult;
    }

    private GenotypeTable createOutputAlignment(PopulationData popdata, boolean asNucleotides) {
        GenotypeTable out = null;
        if (!asNucleotides) {
            out = popdata.imputed;
        } else {
            GenotypeTable outPoly = NucleotideImputationUtils.convertParentCallsToNucleotides(popdata);
            if (!Double.isNaN(this.minSnpCoverage) && !Double.isNaN(this.maxMafForMono)) {
                int nsnps = popdata.original.numberOfSites();
                double ngametes = 2 * popdata.original.numberOfTaxa();
                int[] monomorphicSnps = new int[nsnps];
                int snpCount = 0;
                for (int s = 0; s < nsnps; ++s) {
                    double coverage = (double)popdata.original.totalGametesNonMissingForSite(s) / ngametes;
                    if (popdata.snpIndex.fastGet(s) || !(popdata.original.minorAlleleFrequency(s) <= this.maxMafForMono) || !(coverage >= this.minSnpCoverage)) continue;
                    monomorphicSnps[snpCount++] = s;
                }
                FilterGenotypeTable fa = FilterGenotypeTable.getInstance(popdata.original, monomorphicSnps = Arrays.copyOf(monomorphicSnps, snpCount));
                if (fa.numberOfSites() == 0) {
                    out = outPoly;
                } else {
                    GenotypeTableBuilder builder = GenotypeTableBuilder.getSiteIncremental(fa.taxa());
                    nsnps = fa.numberOfSites();
                    int ntaxa = fa.numberOfTaxa();
                    for (int s = 0; s < nsnps; ++s) {
                        byte majorAllele = fa.majorAllele(s);
                        byte major = (byte)(majorAllele << 4 | majorAllele);
                        byte[] snpgeno = new byte[ntaxa];
                        Arrays.fill(snpgeno, major);
                        builder.addSite((Position)fa.positions().get(s), snpgeno);
                    }
                    out = builder.build();
                }
            } else {
                out = outPoly;
            }
        }
        return out;
    }

    private GenotypeTable createOutputAlignmentImputingAllNucleotides(PopulationData family) {
        GenotypeTable filledImputedGenotypes = NucleotideImputationUtils.fillGapsInImputedAlignment(family);
        GenotypeTable filteredOriginalGenotypes = FilterGenotypeTable.getInstance(family.original, filledImputedGenotypes.taxa());
        int nsites = filteredOriginalGenotypes.numberOfSites();
        int nImputedSites = filledImputedGenotypes.numberOfSites();
        int[] imputedPos = filledImputedGenotypes.physicalPositions();
        int[] origPos = filteredOriginalGenotypes.physicalPositions();
        int ntaxa = filteredOriginalGenotypes.numberOfTaxa();
        GenotypeTableBuilder genoBuilder = GenotypeTableBuilder.getSiteIncremental(filteredOriginalGenotypes.taxa());
        for (int s = 0; s < nsites; ++s) {
            byte[] nuc = filteredOriginalGenotypes.alleles(s);
            int nalleles = nuc.length;
            if (nalleles == 0) {
                genoBuilder.addSite((Position)filteredOriginalGenotypes.positions().get(s), filteredOriginalGenotypes.genotypeAllTaxa(s));
                continue;
            }
            if (nalleles <= 0) continue;
            int ndx = Arrays.binarySearch(imputedPos, origPos[s]);
            if (ndx != -1 && ndx > -nImputedSites - 1) {
                OpenBitSet mnImputed;
                OpenBitSet mjImputed;
                if (ndx == -1) {
                    ndx = 0;
                }
                if (-ndx - 1 >= nImputedSites) {
                    ndx = nImputedSites - 1;
                }
                byte[] genotype = new byte[ntaxa];
                if (ndx >= 0) {
                    mjImputed = new OpenBitSet(filledImputedGenotypes.allelePresenceForAllTaxa(ndx, WHICH_ALLELE.Major));
                    mnImputed = new OpenBitSet(filledImputedGenotypes.allelePresenceForAllTaxa(ndx, WHICH_ALLELE.Minor));
                } else {
                    ndx = -ndx - 1;
                    mjImputed = new OpenBitSet(filledImputedGenotypes.allelePresenceForAllTaxa(ndx, WHICH_ALLELE.Major));
                    mnImputed = new OpenBitSet(filledImputedGenotypes.allelePresenceForAllTaxa(ndx, WHICH_ALLELE.Minor));
                    OpenBitSet flankingSame = new OpenBitSet(filledImputedGenotypes.allelePresenceForAllTaxa(ndx, WHICH_ALLELE.Major));
                    flankingSame.notXor(filledImputedGenotypes.allelePresenceForAllTaxa(ndx - 1, WHICH_ALLELE.Major));
                    OpenBitSet mnImputedSame = new OpenBitSet(filledImputedGenotypes.allelePresenceForAllTaxa(ndx, WHICH_ALLELE.Minor));
                    mnImputedSame.notXor(filledImputedGenotypes.allelePresenceForAllTaxa(ndx - 1, WHICH_ALLELE.Minor));
                    flankingSame.and(mnImputedSame);
                    mjImputed.and(flankingSame);
                    mnImputed.and(flankingSame);
                }
                BitSet mjOrig = filteredOriginalGenotypes.allelePresenceForAllTaxa(s, WHICH_ALLELE.Major);
                BitSet mnOrig = filteredOriginalGenotypes.allelePresenceForAllTaxa(s, WHICH_ALLELE.Minor);
                OpenBitSet imj = new OpenBitSet(mjImputed);
                imj.andNot(mnImputed);
                OpenBitSet imn = new OpenBitSet(mnImputed);
                imn.andNot(mjImputed);
                OpenBitSet omj = new OpenBitSet(mjOrig);
                omj.andNot(mnOrig);
                OpenBitSet omn = new OpenBitSet(mnOrig);
                omn.andNot(mjOrig);
                int[][] counts = new int[2][2];
                counts[0][0] = (int)OpenBitSet.intersectionCount(imj, omj);
                counts[0][1] = (int)OpenBitSet.intersectionCount(imj, omn);
                counts[1][0] = (int)OpenBitSet.intersectionCount(imn, omj);
                counts[1][1] = (int)OpenBitSet.intersectionCount(imn, omn);
                byte[] alleles = WritePopulationAlignmentPlugin.getMajorAndMinorAllelesAtSite(counts, nuc);
                byte[] genotypes = filteredOriginalGenotypes.genotypeAllTaxa(s);
                if (alleles != null) {
                    byte major = GenotypeTableUtils.getUnphasedDiploidValue(alleles[0], alleles[0]);
                    byte minor = GenotypeTableUtils.getUnphasedDiploidValue(alleles[1], alleles[1]);
                    int het = alleles[0] == 15 || alleles[1] == 15 ? -1 : (int)GenotypeTableUtils.getUnphasedDiploidValue(alleles[0], alleles[1]);
                    for (int t = 0; t < ntaxa; ++t) {
                        if (mjImputed.fastGet(t)) {
                            if (mnImputed.fastGet(t)) {
                                genotypes[t] = het;
                                continue;
                            }
                            genotypes[t] = major;
                            continue;
                        }
                        if (!mnImputed.fastGet(t)) continue;
                        genotypes[t] = minor;
                    }
                }
                genoBuilder.addSite((Position)filteredOriginalGenotypes.positions().get(s), genotypes);
                continue;
            }
            genoBuilder.addSite((Position)filteredOriginalGenotypes.positions().get(s), filteredOriginalGenotypes.genotypeAllTaxa(s));
        }
        return genoBuilder.build();
    }

    private static byte[] getMajorAndMinorAllelesAtSite(int[][] counts, byte[] OriginalNucleotides) {
        int minratio = 4;
        int minPresent = 7;
        int totalPresent = counts[0][0] + counts[0][1] + counts[1][0] + counts[1][1];
        if (!(counts[0][1] != 0 && counts[0][0] / counts[0][1] < minratio || counts[1][0] != 0 && counts[1][1] / counts[1][0] < minratio)) {
            if (OriginalNucleotides.length == 1) {
                if (totalPresent < minPresent) {
                    return null;
                }
                return new byte[]{OriginalNucleotides[0], 15};
            }
            return OriginalNucleotides;
        }
        if (!(counts[0][0] != 0 && counts[0][1] / counts[0][0] < minratio || counts[1][1] != 0 && counts[1][0] / counts[1][1] < minratio)) {
            if (OriginalNucleotides.length == 1) {
                if (totalPresent < minPresent) {
                    return null;
                }
                return new byte[]{15, OriginalNucleotides[0]};
            }
            return new byte[]{OriginalNucleotides[1], OriginalNucleotides[0]};
        }
        minratio = 10;
        int col0 = counts[0][0] + counts[1][0];
        int col1 = counts[0][1] + counts[1][1];
        int row0 = counts[0][0] + counts[0][1];
        int row1 = counts[1][0] + counts[1][1];
        if (row0 > 1 && row1 > 1) {
            if (col1 <= 1 || col0 / col1 >= minratio) {
                return new byte[]{OriginalNucleotides[0], OriginalNucleotides[0]};
            }
            if (col0 <= 1 || col1 / col0 >= minratio) {
                return new byte[]{OriginalNucleotides[1], OriginalNucleotides[1]};
            }
        } else {
            if (row0 <= 1 && totalPresent >= minPresent) {
                return new byte[]{15, OriginalNucleotides[0]};
            }
            if (row1 <= 1 && totalPresent >= minPresent) {
                return new byte[]{OriginalNucleotides[0], 15};
            }
        }
        return null;
    }

    @Override
    public void setParameters(String[] args) {
        if (args == null || args.length == 0) {
            myLogger.info((Object)this.getUsage());
            return;
        }
        int narg = args.length;
        for (int i = 0; i < narg; ++i) {
            String val;
            if (args[i].equals("-m") || args[i].equalsIgnoreCase("-merge")) {
                if ((val = args[++i]).toUpperCase().startsWith("T")) {
                    this.mergeAlignments = true;
                    continue;
                }
                this.mergeAlignments = false;
                continue;
            }
            if (args[i].equals("-f") || args[i].equalsIgnoreCase("-file")) {
                this.setBaseFile(args[++i]);
                continue;
            }
            if (args[i].equals("-p") || args[i].equalsIgnoreCase("-parentCalls")) {
                if ((val = args[++i]).toUpperCase().startsWith("T")) {
                    this.writeParentCalls = true;
                    this.writeNucleotides = false;
                    continue;
                }
                this.writeParentCalls = false;
                this.writeNucleotides = true;
                continue;
            }
            if (args[i].equals("-o") || args[i].equalsIgnoreCase("-outputType")) {
                if ((val = args[++i]).toUpperCase().startsWith("P")) {
                    this.writeParentCalls = true;
                    this.writeNucleotides = false;
                    continue;
                }
                if (val.toUpperCase().startsWith("N")) {
                    this.writeParentCalls = false;
                    this.writeNucleotides = true;
                    continue;
                }
                if (val.toUpperCase().startsWith("B")) {
                    this.writeParentCalls = true;
                    this.writeNucleotides = true;
                    continue;
                }
                this.writeParentCalls = true;
                this.writeNucleotides = false;
                continue;
            }
            if (args[i].equals("-d") || args[i].equalsIgnoreCase("-diploid")) {
                if ((val = args[++i]).toUpperCase().startsWith("T")) {
                    this.outputDiploid = true;
                    continue;
                }
                this.outputDiploid = false;
                continue;
            }
            if (args[i].equals("-c") || args[i].equalsIgnoreCase("-minCoverage")) {
                this.minSnpCoverage = Double.parseDouble(args[++i]);
                continue;
            }
            if (args[i].equals("-x") || args[i].equalsIgnoreCase("-maxMono")) {
                this.maxMafForMono = Double.parseDouble(args[++i]);
                continue;
            }
            if (!args[i].equals("?")) continue;
            myLogger.info((Object)this.getUsage());
        }
    }

    public void setMergeAlignments(boolean mergeAlignments) {
        this.mergeAlignments = mergeAlignments;
    }

    public void setWriteParentCalls(boolean writeParentCalls) {
        this.writeParentCalls = writeParentCalls;
    }

    public void setOutputDiploid(boolean outputDiploid) {
        this.outputDiploid = outputDiploid;
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return "Write Populations";
    }

    @Override
    public String getToolTipText() {
        return null;
    }

    @Override
    public String getUsage() {
        StringBuilder usage = new StringBuilder("The WritePopulationAlignmentPlugin can take the following parameters:\n");
        usage.append("-f or -file : the base file name and path to which output will be written");
        usage.append("-m or -merge : if true families are merged into a data set, if false each family is output to a separate data set (default = false)\n");
        usage.append("-o or -outputType : parents = output parent calls, nucleotides = output nucleotides, both = output both (the default)\n");
        usage.append("if -c or -x equals NaN and merge is true, then missing values at monomorphic sites (within a family) will be left missing\n");
        usage.append("? : print the parameter list.\n");
        return usage.toString();
    }

    public void setWriteNucleotides(boolean writeNucleotides) {
        this.writeNucleotides = writeNucleotides;
    }

    public void setMinSnpCoverage(double minSnpCoverage) {
        this.minSnpCoverage = minSnpCoverage;
    }

    public void setMaxMafForMono(double maxMafForMono) {
        this.maxMafForMono = maxMafForMono;
    }

    public void setBaseFile(String baseFile) {
        this.baseFile = baseFile;
        this.writeToFile = true;
    }
}

