/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.popgen;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import net.maizegenetics.analysis.distance.IBSDistanceMatrix;
import net.maizegenetics.analysis.popgen.DiversityResults;
import net.maizegenetics.analysis.popgen.PolymorphismDistribution;
import net.maizegenetics.dna.map.Chromosome;
import net.maizegenetics.dna.snp.FilterGenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.util.AbstractTableReport;
import net.maizegenetics.util.TableReport;

public class DiversityAnalyses
extends AbstractTableReport
implements TableReport,
Serializable {
    private static final int NUM_OF_COLUMNS = 14;
    int startSite;
    int endSite;
    int step;
    int window;
    int currNumSites;
    boolean slideWindow = false;
    GenotypeTable theAAlignment;
    List<DiversityResults> diversityResultsVector = new ArrayList<DiversityResults>();
    PolymorphismDistribution thePolymorphismDistribution = null;

    public DiversityAnalyses(GenotypeTable aa, boolean slidingWindow, int start, int end, int window, int step, PolymorphismDistribution thePolymorphismDistribution) {
        this.startSite = start;
        this.endSite = end;
        this.step = step;
        this.window = window;
        this.slideWindow = slidingWindow;
        this.theAAlignment = aa;
        this.thePolymorphismDistribution = thePolymorphismDistribution;
        this.runAnalyses();
    }

    public DiversityAnalyses(GenotypeTable aa, boolean slidingWindow, int start, int end, int window, int step) {
        this(aa, slidingWindow, start, end, window, step, null);
    }

    private void runAnalyses() {
        if (!this.slideWindow) {
            this.runAnalysisForRegion(this.startSite, this.endSite);
            return;
        }
        for (int i = this.startSite; i < this.endSite - this.window; i += this.step) {
            this.runAnalysisForRegion(i, i + this.window - 1);
        }
    }

    private void runAnalysisForRegion(int start, int end) {
        Chromosome locus = this.theAAlignment.chromosome(start);
        int chromosome = -1;
        try {
            chromosome = Integer.parseInt(locus.getName());
        }
        catch (Exception e) {
            // empty catch block
        }
        double startChrPosition = this.theAAlignment.chromosomalPosition(start);
        double endChrPosition = this.theAAlignment.chromosomalPosition(end);
        FilterGenotypeTable theFilteredAlignment = FilterGenotypeTable.getInstance(this.theAAlignment, start, end);
        IBSDistanceMatrix adm = new IBSDistanceMatrix(theFilteredAlignment);
        this.diversityResultsVector.add(this.evaluate(theFilteredAlignment, adm, start, end, chromosome, startChrPosition, endChrPosition));
        if (this.thePolymorphismDistribution != null) {
            this.thePolymorphismDistribution.addDistribution("ALLs" + start + "-e" + end, theFilteredAlignment, true);
        }
    }

    DiversityResults evaluate(GenotypeTable theAlignment, IBSDistanceMatrix dm, int start, int end, int chromosome, double startChrPosition, double endChrPosition) {
        int sites = end - start + 1;
        DiversityResults theDiversityResults = new DiversityResults(start, end, chromosome, startChrPosition, endChrPosition);
        if (dm == null) {
            theDiversityResults.totalSites = 0.0;
            theDiversityResults.pipbp = Double.NaN;
            theDiversityResults.thetapbp = Double.NaN;
            theDiversityResults.segregatingSites = 0;
            return theDiversityResults;
        }
        double pipbp = dm.meanDistance();
        int segSites = this.countSegregatingSites(theAlignment);
        int taxa = theAlignment.numberOfTaxa();
        theDiversityResults.pipbp = pipbp;
        theDiversityResults.avgSiteCoverage = dm.getAverageTotalSites();
        theDiversityResults.totalSites = sites;
        theDiversityResults.segregatingSites = segSites;
        theDiversityResults.thetapbp = DiversityAnalyses.estimateThetaPerbp(segSites, sites, theDiversityResults.avgSiteCoverage, taxa);
        theDiversityResults.tajimaD = DiversityAnalyses.estimateTajimaD(segSites, theDiversityResults.totalSites, theDiversityResults.avgSiteCoverage, theAlignment.numberOfTaxa(), theDiversityResults.pipbp, theDiversityResults.thetapbp);
        return theDiversityResults;
    }

    public static double estimateTheta(int segSites, int totalSites, double averageSiteCoverage, int taxa) {
        double a = 0.0;
        double n = (double)taxa * averageSiteCoverage / (double)totalSites;
        for (double i = 1.0; i < n; i += 1.0) {
            a += 1.0 / i;
        }
        return (double)segSites / a;
    }

    public static double estimateThetaPerbp(int segSites, int totalSites, double averageSiteCoverage, int taxa) {
        return DiversityAnalyses.estimateTheta(segSites, totalSites, averageSiteCoverage, taxa) / (double)totalSites;
    }

    public static double estimatePi(int totalSites, double avgPairwiseDivergence, double averageSiteCoverage) {
        return (double)totalSites * avgPairwiseDivergence / averageSiteCoverage;
    }

    public static double estimatePiPerbp(int totalSites, double avgPairwiseDivergence, double averageSiteCoverage) {
        return DiversityAnalyses.estimatePi(totalSites, avgPairwiseDivergence, averageSiteCoverage) / averageSiteCoverage;
    }

    public static double estimateTajimaD(int segSites, double totalSites, double averageSiteCoverage, double taxa, double pipbp, double thetapbp) {
        double a1 = 0.0;
        double a2 = 0.0;
        double n = taxa * averageSiteCoverage / totalSites;
        for (double i = 1.0; i < n; i += 1.0) {
            a1 += 1.0 / i;
            a2 += 1.0 / (i * i);
        }
        double b1 = (n + 1.0) / (3.0 * (n - 1.0));
        double b2 = 2.0 * (n * n + n + 3.0) / (9.0 * n * (n - 1.0));
        double c1 = b1 - 1.0 / a1;
        double c2 = b2 - (n + 2.0) / (a1 * n) + a2 / (a1 * a1);
        double e1 = c1 / a1;
        double e2 = c2 / (a1 * a1 + a2);
        double D = (pipbp - thetapbp) / (Math.sqrt(e1 * (double)segSites + e2 * (double)segSites * (double)(segSites - 1)) / totalSites);
        return D;
    }

    int countSegregatingSites(GenotypeTable theAlignment) {
        int total = 0;
        if (theAlignment.isAllPolymorphic()) {
            return theAlignment.numberOfSites();
        }
        for (int i = 0; i < theAlignment.numberOfSites(); ++i) {
            if (!theAlignment.isPolymorphic(i)) continue;
            ++total;
        }
        return total;
    }

    @Override
    public Object[] getTableColumnNames() {
        Object[] basicLabels = new String[]{"Site_Type", "Chromosome", "StartChrPosition", "EndChrPosition", "StartSite", "EndSite", "MidSite", "SiteCount", "AvgSiteCount", "SegSites", "PiPerBP", "ThetaPerBP", "Haplotypes", "TajimaD"};
        return basicLabels;
    }

    @Override
    public Object[] getRow(long row) {
        DecimalFormat nf = new DecimalFormat();
        ((NumberFormat)nf).setMaximumFractionDigits(5);
        DecimalFormat nf2 = new DecimalFormat();
        ((NumberFormat)nf2).setMaximumFractionDigits(1);
        Object[] data = new String[14];
        DiversityResults theDiversityResults = this.diversityResultsVector.get((int)row);
        int labelOffset = 0;
        data[labelOffset++] = "ALL";
        data[labelOffset++] = "" + theDiversityResults.chromosome;
        data[labelOffset++] = "" + nf2.format(theDiversityResults.startChrPosition);
        data[labelOffset++] = "" + nf2.format(theDiversityResults.endChrPosition);
        data[labelOffset++] = "" + theDiversityResults.startSite;
        data[labelOffset++] = "" + theDiversityResults.endSite;
        data[labelOffset++] = "" + (theDiversityResults.startSite + theDiversityResults.endSite) / 2;
        data[labelOffset++] = "" + theDiversityResults.totalSites;
        data[labelOffset++] = "" + nf.format(theDiversityResults.avgSiteCoverage);
        data[labelOffset++] = "" + theDiversityResults.segregatingSites;
        data[labelOffset++] = "" + nf.format(theDiversityResults.pipbp);
        data[labelOffset++] = "" + nf.format(theDiversityResults.thetapbp);
        data[labelOffset++] = "NotAvail";
        data[labelOffset++] = "" + nf.format(theDiversityResults.tajimaD);
        return data;
    }

    @Override
    public String getTableTitle() {
        return "Diversity estimates";
    }

    public String toString() {
        int i;
        if (this.diversityResultsVector.size() == 0) {
            return "Needs to be run";
        }
        StringBuffer cs = new StringBuffer();
        Object[] header = this.getTableColumnNames();
        for (i = 0; i < header.length; ++i) {
            cs.append(header[i]);
        }
        cs.append("\n");
        i = 0;
        while ((long)i < this.getRowCount()) {
            Object[] data = this.getRow(i);
            for (int j = 0; j < this.getColumnCount(); ++j) {
                cs.append(data[j]);
            }
            cs.append("\n");
            ++i;
        }
        return cs.toString();
    }

    @Override
    public long getRowCount() {
        return this.diversityResultsVector.size();
    }

    @Override
    public long getElementCount() {
        return this.getRowCount() * (long)this.getColumnCount();
    }

    @Override
    public int getColumnCount() {
        return 14;
    }

    void testCode() {
        int n = 10;
        int sites = 41;
        int segSites = 16;
        double pi = 3.88;
        double theta = DiversityAnalyses.estimateTheta(segSites, sites, sites, n);
        double pipbp = pi / (double)sites;
        double td = DiversityAnalyses.estimateTajimaD(segSites, sites, sites, n, pipbp, theta);
    }
}

