/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.map;

import cern.colt.GenericSorting;
import cern.colt.Swapper;
import cern.colt.function.IntComparator;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import net.maizegenetics.dna.BaseEncoder;
import net.maizegenetics.dna.map.Chromosome;
import net.maizegenetics.dna.map.TOPMInterface;
import net.maizegenetics.dna.snp.GenotypeTableUtils;
import net.maizegenetics.dna.snp.NucleotideAlignmentConstants;
import net.maizegenetics.dna.tag.AbstractTags;

public abstract class AbstractTagsOnPhysicalMap
extends AbstractTags
implements TOPMInterface {
    protected int[] bestChr;
    protected int[] indicesOfSortByPosition;
    protected int myMaxVariants = 8;
    protected byte[] multimaps;
    protected int[] bestStartPos;
    protected byte[] bestStrand;
    protected int myNumTags = 0;
    protected byte[][] variantDefs;
    protected byte[][] variantOffsets;
    protected int[] myChromosomes = null;
    protected int[][] myUniquePositions = null;

    @Override
    public int getMaxNumVariants() {
        return this.myMaxVariants;
    }

    @Override
    public byte getMultiMaps(int index) {
        return this.multimaps[index];
    }

    @Override
    public int getChromosome(int index) {
        return this.bestChr[index];
    }

    @Override
    public int getSize() {
        return this.myNumTags;
    }

    @Override
    public int getStartPosition(int index) {
        return this.bestStartPos[index];
    }

    @Override
    public byte getStrand(int tagIndex) {
        return this.bestStrand[tagIndex];
    }

    @Override
    public byte[][] getVariantDef() {
        byte[][] result = new byte[this.getTagCount()][this.myMaxVariants];
        for (int i = 0; i < this.getTagCount(); ++i) {
            for (int j = 0; j < this.myMaxVariants; ++j) {
                result[i][j] = this.getVariantDef(i, j);
            }
        }
        return result;
    }

    protected byte[][] getVariantDefByReference() {
        return this.variantDefs;
    }

    protected byte[][] getVariantOffByReference() {
        return this.variantOffsets;
    }

    @Override
    public byte getVariantDef(int tagIndex, int variantIndex) {
        if (this.variantDefs[tagIndex] == null || this.variantDefs[tagIndex].length <= variantIndex) {
            return -128;
        }
        return this.variantDefs[tagIndex][variantIndex];
    }

    @Override
    public byte[] getVariantDefArray(int tagIndex) {
        return this.variantDefs[tagIndex];
    }

    @Override
    public byte[][] getVariantOff() {
        byte[][] result = new byte[this.getTagCount()][this.myMaxVariants];
        for (int i = 0; i < this.getTagCount(); ++i) {
            for (int j = 0; j < this.myMaxVariants; ++j) {
                result[i][j] = this.getVariantPosOff(i, j);
            }
        }
        return result;
    }

    @Override
    public byte getVariantPosOff(int tagIndex, int variantIndex) {
        if (this.variantOffsets[tagIndex] == null || this.variantOffsets[tagIndex].length <= variantIndex) {
            return -128;
        }
        return this.variantOffsets[tagIndex][variantIndex];
    }

    @Override
    public byte[] getVariantPosOffArray(int tagIndex) {
        return this.variantOffsets[tagIndex];
    }

    public String printRow(int row) {
        StringBuilder sb = new StringBuilder();
        sb.append((CharSequence)sb);
        sb.append(BaseEncoder.getSequenceFromLong(this.getTag(row)) + "\t");
        sb.append(AbstractTagsOnPhysicalMap.printWithMissing(this.tagLength[row]));
        sb.append("\t");
        sb.append(AbstractTagsOnPhysicalMap.printWithMissing(this.multimaps[row]) + "\t");
        sb.append(AbstractTagsOnPhysicalMap.printWithMissing(this.bestChr[row]) + "\t");
        sb.append(AbstractTagsOnPhysicalMap.printWithMissing(this.bestStrand[row]) + "\t");
        sb.append(AbstractTagsOnPhysicalMap.printWithMissing(this.bestStartPos[row]) + "\t");
        sb.append(AbstractTagsOnPhysicalMap.printWithMissing(this.getEndPosition(row)) + "\t");
        sb.append(AbstractTagsOnPhysicalMap.printWithMissing(this.getDivergence(row)) + "\t");
        for (int j = 0; j < this.myMaxVariants; ++j) {
            sb.append(AbstractTagsOnPhysicalMap.printWithMissing(this.getVariantPosOff(row, j)) + "\t");
            byte vd = this.getVariantDef(row, j);
            if (vd == -128) {
                sb.append(AbstractTagsOnPhysicalMap.printWithMissing(vd) + "\t");
                continue;
            }
            byte genotype = GenotypeTableUtils.getDiploidValue(vd, vd);
            sb.append(NucleotideAlignmentConstants.getNucleotideIUPAC(genotype) + "\t");
        }
        sb.append(AbstractTagsOnPhysicalMap.printWithMissing(this.getDcoP(row)) + "\t");
        sb.append(AbstractTagsOnPhysicalMap.printWithMissing(this.getMapP(row)) + "\t");
        return sb.toString();
    }

    public static String printWithMissing(byte b) {
        if (b == -128) {
            return "*";
        }
        return Byte.toString(b);
    }

    public static String printWithMissing(int i) {
        if (i == Integer.MIN_VALUE) {
            return "*";
        }
        return Integer.toString(i);
    }

    @Override
    public void writeTextFile(File outfile) {
        try {
            DataOutputStream fw = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(outfile), 65536));
            fw.writeBytes(this.myNumTags + "\t" + this.tagLengthInLong + "\t" + this.myMaxVariants + "\n");
            for (int row = 0; row < this.myNumTags; ++row) {
                fw.writeBytes(this.printRow(row) + "\n");
            }
            fw.flush();
            fw.close();
        }
        catch (Exception e) {
            System.out.println("Catch in writeTextFile file e=" + e);
            e.printStackTrace();
        }
        System.out.println("Number of tags in file:" + this.myNumTags);
    }

    @Override
    public int[] getChromosomes() {
        if (this.myChromosomes == null) {
            this.populateChrAndVarPositions();
        }
        return this.myChromosomes;
    }

    @Override
    public int getChromosomeIndex(int intChrName) {
        for (int chrIndex = 0; chrIndex < this.myChromosomes.length; ++chrIndex) {
            if (this.myChromosomes[chrIndex] != intChrName) continue;
            return chrIndex;
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public int[] getUniquePositions(int chromosome) {
        if (this.myUniquePositions == null) {
            this.populateChrAndVarPositions();
        }
        return this.myUniquePositions[chromosome];
    }

    protected void populateChrAndVarPositions() {
        long chrSum = 0L;
        System.out.println("chrSum" + chrSum);
        TreeMap theChrs = new TreeMap();
        for (int i = 0; i < this.myNumTags; ++i) {
            int chr = this.getChromosome(i);
            if (chr == Integer.MIN_VALUE) continue;
            if (!theChrs.containsKey(chr)) {
                theChrs.put(chr, new TreeSet());
            }
            TreeSet thePos = (TreeSet)theChrs.get(chr);
            int startPos = this.getStartPosition(i);
            byte[] varOffs = this.getVariantPosOffArray(i);
            if (varOffs == null) continue;
            for (byte b : varOffs) {
                thePos.add(startPos + b);
            }
        }
        this.myChromosomes = new int[theChrs.size()];
        this.myUniquePositions = new int[theChrs.size()][];
        int cnt = 0;
        for (Map.Entry aChr : theChrs.entrySet()) {
            this.myUniquePositions[cnt] = new int[((TreeSet)aChr.getValue()).size()];
            int p = 0;
            Iterator iterator = ((TreeSet)aChr.getValue()).iterator();
            while (iterator.hasNext()) {
                int ls = (Integer)iterator.next();
                this.myUniquePositions[cnt][p++] = ls;
            }
            this.myChromosomes[cnt++] = (Integer)aChr.getKey();
        }
    }

    @Override
    public Chromosome[] getLoci() {
        int[] chrs = this.getChromosomes();
        Chromosome[] result = new Chromosome[chrs.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new Chromosome(chrs[i] + "");
        }
        return result;
    }

    @Override
    public Chromosome getLocus(int tagIndex) {
        if (this.bestChr[tagIndex] == Integer.MIN_VALUE) {
            return null;
        }
        return new Chromosome(this.bestChr[tagIndex] + "");
    }

    void initPhysicalSort() {
        System.out.println("initPhysicalSort");
        this.indicesOfSortByPosition = new int[this.myNumTags];
        for (int i = 0; i < this.indicesOfSortByPosition.length; ++i) {
            this.indicesOfSortByPosition[i] = i;
        }
        Swapper swapperPos = new Swapper(){

            public void swap(int a, int b) {
                int t1 = AbstractTagsOnPhysicalMap.this.indicesOfSortByPosition[a];
                AbstractTagsOnPhysicalMap.this.indicesOfSortByPosition[a] = AbstractTagsOnPhysicalMap.this.indicesOfSortByPosition[b];
                AbstractTagsOnPhysicalMap.this.indicesOfSortByPosition[b] = t1;
            }
        };
        IntComparator compPos = new IntComparator(){

            public int compare(int a, int b) {
                int index1 = AbstractTagsOnPhysicalMap.this.indicesOfSortByPosition[a];
                int index2 = AbstractTagsOnPhysicalMap.this.indicesOfSortByPosition[b];
                if (AbstractTagsOnPhysicalMap.this.bestChr[index1] < AbstractTagsOnPhysicalMap.this.bestChr[index2]) {
                    return -1;
                }
                if (AbstractTagsOnPhysicalMap.this.bestChr[index1] > AbstractTagsOnPhysicalMap.this.bestChr[index2]) {
                    return 1;
                }
                if (AbstractTagsOnPhysicalMap.this.bestStartPos[index1] < AbstractTagsOnPhysicalMap.this.bestStartPos[index2]) {
                    return -1;
                }
                if (AbstractTagsOnPhysicalMap.this.bestStartPos[index1] > AbstractTagsOnPhysicalMap.this.bestStartPos[index2]) {
                    return 1;
                }
                if (AbstractTagsOnPhysicalMap.this.bestStrand[index1] < AbstractTagsOnPhysicalMap.this.bestStrand[index2]) {
                    return -1;
                }
                if (AbstractTagsOnPhysicalMap.this.bestStrand[index1] > AbstractTagsOnPhysicalMap.this.bestStrand[index2]) {
                    return 1;
                }
                for (int i = 0; i < AbstractTagsOnPhysicalMap.this.tagLengthInLong; ++i) {
                    if (AbstractTagsOnPhysicalMap.this.tags[i][index1] < AbstractTagsOnPhysicalMap.this.tags[i][index2]) {
                        return -1;
                    }
                    if (AbstractTagsOnPhysicalMap.this.tags[i][index1] <= AbstractTagsOnPhysicalMap.this.tags[i][index2]) continue;
                    return 1;
                }
                return 0;
            }
        };
        System.out.println("Position index sort begin.");
        GenericSorting.quickSort((int)0, (int)this.indicesOfSortByPosition.length, (IntComparator)compPos, (Swapper)swapperPos);
        System.out.println("Position index sort end.");
    }

    public void writeBinaryFile(File outFile) {
        this.writeBinaryFile(outFile, Integer.MAX_VALUE, false, false, Float.NaN, true);
    }

    protected void writeBinaryFile(File outFile, boolean binary) {
        this.writeBinaryFile(outFile, Integer.MAX_VALUE, false, false, Float.NaN, binary);
    }

    public void writeBinaryFile(File outFile, int minResolution, boolean requirePhysPosition, boolean requireDCOMap, float minDCOP, boolean binary) {
        int hapsOutput = 0;
        try {
            DataOutputStream fw = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(outFile), 4000000));
            if (requirePhysPosition) {
                fw.writeInt(this.mappedTags()[0]);
            } else {
                fw.writeInt(this.myNumTags);
            }
            fw.writeInt(this.tagLengthInLong);
            fw.writeInt(this.myMaxVariants);
            for (int row = 0; row < this.myNumTags; ++row) {
                int j;
                if (requirePhysPosition && this.bestChr[row] == Integer.MIN_VALUE) continue;
                for (j = 0; j < this.tagLengthInLong; ++j) {
                    fw.writeLong(this.tags[j][row]);
                }
                fw.writeByte(this.tagLength[row]);
                fw.writeByte(this.multimaps[row]);
                fw.writeInt(this.bestChr[row]);
                fw.writeByte(this.bestStrand[row]);
                fw.writeInt(this.bestStartPos[row]);
                fw.writeInt(this.getEndPosition(row));
                fw.writeByte(this.getDivergence(row));
                for (j = 0; j < this.myMaxVariants; ++j) {
                    fw.writeByte(this.getVariantPosOff(row, j));
                    fw.writeByte(this.getVariantDef(row, j));
                }
                fw.writeByte(this.getDcoP(row));
                fw.writeByte(this.getMapP(row));
                ++hapsOutput;
            }
            fw.flush();
            fw.close();
            System.out.println("Tag positions written to:" + outFile.toString());
            System.out.println("Number of tags in file:" + hapsOutput);
        }
        catch (Exception e) {
            System.err.println("Catch in writing output file e=" + e);
        }
    }

    public void writeBinaryFileForChromosomalRegion(File outFile, int targetChr, int minPos, int maxPos) {
        int nTagsInRegion = 0;
        for (int tag = 0; tag < this.myNumTags; ++tag) {
            if (this.bestChr[tag] != targetChr || this.bestStartPos[tag] < minPos || this.bestStartPos[tag] > maxPos) continue;
            ++nTagsInRegion;
        }
        int tagsOutput = 0;
        try {
            DataOutputStream fw = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(outFile), 4000000));
            fw.writeInt(nTagsInRegion);
            fw.writeInt(this.tagLengthInLong);
            fw.writeInt(this.myMaxVariants);
            for (int row = 0; row < this.myNumTags; ++row) {
                int j;
                if (this.bestChr[row] != targetChr || this.bestStartPos[row] < minPos || this.bestStartPos[row] > maxPos) continue;
                for (j = 0; j < this.tagLengthInLong; ++j) {
                    fw.writeLong(this.tags[j][row]);
                }
                fw.writeByte(this.tagLength[row]);
                fw.writeByte(this.multimaps[row]);
                fw.writeInt(this.bestChr[row]);
                fw.writeByte(this.bestStrand[row]);
                fw.writeInt(this.bestStartPos[row]);
                fw.writeInt(this.getEndPosition(row));
                fw.writeByte(this.getDivergence(row));
                for (j = 0; j < this.myMaxVariants; ++j) {
                    fw.writeByte(this.getVariantPosOff(row, j));
                    fw.writeByte(this.getVariantDef(row, j));
                }
                fw.writeByte(this.getDcoP(row));
                fw.writeByte(this.getMapP(row));
                ++tagsOutput;
            }
            fw.flush();
            fw.close();
            System.out.println("Tag positions written to:" + outFile.toString());
            System.out.println("Number of tags in file:" + tagsOutput);
        }
        catch (Exception e) {
            System.err.println("Catch in writing output file e=" + e);
        }
    }

    public int[] mappedTags() {
        int[] result = new int[]{0, 0};
        int unique = 0;
        int multi = 1;
        for (int row = 0; row < this.myNumTags; ++row) {
            if (this.bestChr[row] == Integer.MIN_VALUE) {
                if (this.multimaps[row] <= 0) continue;
                int n = multi;
                result[n] = result[n] + 1;
                continue;
            }
            int n = unique;
            result[n] = result[n] + 1;
        }
        return result;
    }

    public void printRows(int numRows) {
        for (int i = 0; i < numRows; ++i) {
            System.out.println(this.printRow(i));
        }
    }

    public String printRow(int row, boolean byPosition) {
        if (byPosition) {
            return this.printRow(this.indicesOfSortByPosition[row]);
        }
        return this.printRow(row);
    }

    public void printRows(int numRows, boolean requirePhysPosition, boolean byPosition) {
        int outCount = 0;
        int i = 0;
        while (outCount < numRows) {
            int r;
            int n = r = byPosition ? this.indicesOfSortByPosition[i] : i;
            if (!requirePhysPosition || this.bestChr[r] >= 1) {
                System.out.println(this.printRow(r));
                ++outCount;
            }
            ++i;
        }
    }

    public void printRows(int numRows, boolean requirePhysPosition, int printChr) {
        int outCount = 0;
        boolean byPosition = true;
        int i = 0;
        while (outCount < numRows) {
            int r;
            int n = r = byPosition ? this.indicesOfSortByPosition[i] : i;
            if (!requirePhysPosition || this.bestChr[r] == printChr) {
                System.out.println(this.printRow(r));
                ++outCount;
            }
            ++i;
        }
    }

    protected long[][] getTagsArray() {
        return this.tags;
    }

    protected byte[] getTagLengthArray() {
        return this.tagLength;
    }
}

