/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.map;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.SetMultimap;
import java.text.NumberFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.maizegenetics.dna.WHICH_ALLELE;
import net.maizegenetics.dna.map.Chromosome;
import net.maizegenetics.dna.map.Position;
import net.maizegenetics.dna.snp.NucleotideAlignmentConstants;
import net.maizegenetics.util.GeneralAnnotationUtils;

public final class GeneralPosition
implements Position {
    private final Chromosome myChromosome;
    private final int myPosition;
    private final byte myStrand;
    private final float myCM;
    private final boolean isNucleotide;
    private final boolean isIndel;
    private final float myMAF;
    private final float mySiteCoverage;
    private final long myAlleleValue;
    private final byte[] mySNPIDAsBytes;
    private final Map.Entry<String, String>[] myVariantsAndAnno;
    private final int hashCode;
    private static final ConcurrentMap<Map.Entry<String, String>, Map.Entry<String, String>> ANNO_HASH = new ConcurrentHashMap<Map.Entry<String, String>, Map.Entry<String, String>>(100000);

    public static Map.Entry<String, String> getCanonicalAnnotation(String key, String value) {
        AbstractMap.SimpleImmutableEntry<String, String> str;
        Map.Entry canon;
        if (ANNO_HASH.size() > 100000) {
            ANNO_HASH.clear();
        }
        return (canon = (Map.Entry)ANNO_HASH.putIfAbsent(str = new AbstractMap.SimpleImmutableEntry<String, String>(key, value), str)) == null ? str : canon;
    }

    private GeneralPosition(Builder builder) {
        this.myChromosome = builder.myChromosome;
        this.myPosition = builder.myPosition;
        this.myStrand = builder.myStrand;
        this.myCM = builder.myCM;
        this.mySNPIDAsBytes = (byte[])(builder.mySNPID == null ? null : builder.mySNPID.getBytes());
        this.isNucleotide = builder.isNucleotide;
        this.isIndel = builder.isIndel;
        this.myVariantsAndAnno = new Map.Entry[1 + builder.myAnnotations.size()];
        this.myVariantsAndAnno[0] = builder.myKnownVariants;
        for (int i = 0; i < builder.myAnnotations.size(); ++i) {
            this.myVariantsAndAnno[i + 1] = (Map.Entry)builder.myAnnotations.get(i);
        }
        this.hashCode = this.calcHashCode();
        this.myMAF = builder.myMAF;
        this.mySiteCoverage = builder.mySiteCoverage;
        this.myAlleleValue = builder.myAllelesAsLong;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Position)) {
            return false;
        }
        Position o = (Position)obj;
        int result = ComparisonChain.start().compare(this.myPosition, o.getPosition()).compare((Comparable)this.myChromosome, (Comparable)o.getChromosome()).compare(this.myCM, o.getCM()).compare((int)this.myStrand, (int)o.getStrand()).result();
        if (result != 0) {
            return false;
        }
        return this.getSNPID().equals(o.getSNPID());
    }

    @Override
    public int compareTo(Position o) {
        int result = ComparisonChain.start().compare((Comparable)this.myChromosome, (Comparable)o.getChromosome()).compare(this.myPosition, o.getPosition()).compare(this.myCM, o.getCM()).compare((int)this.myStrand, (int)o.getStrand()).result();
        if (result != 0) {
            return result;
        }
        return this.getSNPID().compareTo(o.getSNPID());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Position");
        sb.append("\tChr:").append(this.getChromosome().getName());
        sb.append("\tPos:").append(this.getPosition());
        sb.append("\tName:").append(this.getSNPID());
        if (this.myVariantsAndAnno != null && this.myVariantsAndAnno[0] != null) {
            sb.append("\tVariants:").append(this.myVariantsAndAnno[0].getValue());
        }
        sb.append("\tMAF:").append(this.getGlobalMAF());
        sb.append("\tRef:").append(NucleotideAlignmentConstants.getHaplotypeNucleotide(this.getAllele(WHICH_ALLELE.Reference)));
        return sb.toString();
    }

    private int calcHashCode() {
        int hash = 7;
        hash = 37 * hash + this.myChromosome.hashCode();
        hash = 37 * hash + this.myPosition;
        hash = 37 * hash + this.myStrand;
        hash = 37 * hash + Float.floatToIntBits(this.myCM);
        if (this.mySNPIDAsBytes != null) {
            hash = 37 * hash + this.mySNPIDAsBytes.hashCode();
        }
        return hash;
    }

    @Override
    public float getGlobalMAF() {
        return this.myMAF;
    }

    @Override
    public float getGlobalSiteCoverage() {
        return this.mySiteCoverage;
    }

    @Override
    public byte getAllele(WHICH_ALLELE alleleType) {
        return (byte)(this.myAlleleValue >> alleleType.index() * 4 & 0xFL);
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public Chromosome getChromosome() {
        return this.myChromosome;
    }

    @Override
    public int getPosition() {
        return this.myPosition;
    }

    @Override
    public byte getStrand() {
        return this.myStrand;
    }

    @Override
    public float getCM() {
        return this.myCM;
    }

    @Override
    public String getSNPID() {
        if (this.mySNPIDAsBytes == null) {
            return "S" + this.getChromosome().getName() + "_" + this.myPosition;
        }
        return new String(this.mySNPIDAsBytes);
    }

    @Override
    public boolean isNucleotide() {
        return this.isNucleotide;
    }

    @Override
    public boolean isIndel() {
        return this.isIndel;
    }

    @Override
    public String[] getKnownVariants() {
        if (this.myVariantsAndAnno == null || this.myVariantsAndAnno[0] == null) {
            return new String[0];
        }
        if (this.myVariantsAndAnno[0].getValue().isEmpty()) {
            return new String[0];
        }
        return this.myVariantsAndAnno[0].getValue().replace("[", "").replace("]", "").split("/");
    }

    @Override
    public Object[] getAnnotation(String annoName) {
        return GeneralAnnotationUtils.getAnnotation(this.myVariantsAndAnno, annoName);
    }

    @Override
    public String[] getTextAnnotation(String annoName) {
        return GeneralAnnotationUtils.getTextAnnotation(this.myVariantsAndAnno, annoName);
    }

    @Override
    public double[] getQuantAnnotation(String annoName) {
        return GeneralAnnotationUtils.getQuantAnnotation(this.myVariantsAndAnno, annoName);
    }

    @Override
    public String getConsensusAnnotation(String annoName) {
        return GeneralAnnotationUtils.getConsensusAnnotation(this.myVariantsAndAnno, annoName);
    }

    @Override
    public double getAverageAnnotation(String annoName) {
        return GeneralAnnotationUtils.getAverageAnnotation(this.myVariantsAndAnno, annoName);
    }

    @Override
    public Map.Entry<String, String>[] getAllAnnotationEntries() {
        return Arrays.copyOf(this.myVariantsAndAnno, this.myVariantsAndAnno.length);
    }

    @Override
    public SetMultimap<String, String> getAnnotationAsMap() {
        ImmutableSetMultimap.Builder result = new ImmutableSetMultimap.Builder().orderKeysBy((Comparator)Ordering.natural()).orderValuesBy((Comparator)Ordering.natural());
        for (Map.Entry<String, String> en : this.myVariantsAndAnno) {
            result.put((Object)en.getKey(), (Object)en.getValue());
        }
        return result.build();
    }

    @Override
    public boolean isAnnotatedWithValue(String annoName, String annoValue) {
        return GeneralAnnotationUtils.isAnnotatedWithValue(this.myVariantsAndAnno, annoName, annoValue);
    }

    public static class Builder {
        private Chromosome myChromosome;
        private int myPosition;
        private byte myStrand = 1;
        private float myCM = Float.NaN;
        private String mySNPID = null;
        private boolean isNucleotide = true;
        private boolean isIndel = false;
        private NumberFormat nf = NumberFormat.getInstance();
        private Map.Entry<String, String> myKnownVariants = null;
        private Map.Entry<String, String>[] myVariantsAndAnno;
        private float myMAF = Float.NaN;
        private float mySiteCoverage = Float.NaN;
        private byte[] myAlleles = new byte[WHICH_ALLELE.COUNT];
        private long myAllelesAsLong;
        private ArrayList<Map.Entry<String, String>> myAnnotations = new ArrayList(0);

        public Builder(Chromosome chr, int position) {
            this.myChromosome = Chromosome.getCanonicalChromosome(chr);
            this.myPosition = position;
            Arrays.fill(this.myAlleles, (byte)15);
            this.myKnownVariants = GeneralPosition.getCanonicalAnnotation("VARIANT", "");
        }

        public Builder(Position aCorePosition) {
            this(aCorePosition.getChromosome(), aCorePosition.getPosition());
            this.myStrand = aCorePosition.getStrand();
            this.myCM = aCorePosition.getCM();
            this.mySNPID = aCorePosition.getSNPID();
            this.isNucleotide = aCorePosition.isNucleotide();
            this.isIndel = aCorePosition.isIndel();
            this.myMAF = aCorePosition.getGlobalMAF();
            this.mySiteCoverage = aCorePosition.getGlobalSiteCoverage();
            for (WHICH_ALLELE wHICH_ALLELE : WHICH_ALLELE.values()) {
                this.myAlleles[wHICH_ALLELE.index()] = aCorePosition.getAllele(wHICH_ALLELE);
            }
            for (Map.Entry<String, String> entry : aCorePosition.getAllAnnotationEntries()) {
                this.myAnnotations.add(entry);
            }
        }

        public Builder chromosome(Chromosome val) {
            this.myChromosome = val;
            return this;
        }

        public Builder position(int val) {
            this.myPosition = val;
            return this;
        }

        public Builder strand(byte val) {
            this.myStrand = val;
            return this;
        }

        public Builder cM(float val) {
            this.myCM = val;
            return this;
        }

        public Builder snpName(String val) {
            this.mySNPID = val;
            return this;
        }

        public Builder nucleotide(boolean val) {
            this.isNucleotide = val;
            return this;
        }

        public Builder indel(boolean val) {
            this.isIndel = val;
            return this;
        }

        public Builder knownVariants(String[] val) {
            StringBuilder sb = new StringBuilder();
            for (String s : val) {
                sb.append(s).append("/");
            }
            sb.setLength(sb.length() - 1);
            Map.Entry<String, String> ent = GeneralPosition.getCanonicalAnnotation("VARIANT", sb.toString());
            this.myKnownVariants = ent;
            return this;
        }

        public Builder knownVariants(String val) {
            Map.Entry<String, String> ent = GeneralPosition.getCanonicalAnnotation("VARIANT", val);
            this.myKnownVariants = ent;
            return this;
        }

        public Builder maf(float val) {
            this.myMAF = val;
            return this;
        }

        public Builder siteCoverage(float val) {
            this.mySiteCoverage = val;
            return this;
        }

        public Builder allele(WHICH_ALLELE aT, byte val) {
            this.myAlleles[aT.index()] = val;
            return this;
        }

        public Builder addAnno(String key, String value) {
            Map.Entry<String, String> ent = GeneralPosition.getCanonicalAnnotation(key, value);
            this.myAnnotations.add(ent);
            return this;
        }

        public Builder addAnno(String key, Number value) {
            Map.Entry<String, String> ent = GeneralPosition.getCanonicalAnnotation(key, value.toString());
            this.myAnnotations.add(ent);
            return this;
        }

        public Builder addAnno(String keyValue) {
            String[] sub = keyValue.split("=");
            if (sub.length == 1) {
                return this.addAnno(keyValue, "TRUE");
            }
            return this.addAnno(sub[0], sub[1]);
        }

        public GeneralPosition build() {
            String defaultS;
            for (int i = this.myAlleles.length - 1; i >= 0; --i) {
                this.myAllelesAsLong = this.myAllelesAsLong << 4 | (long)this.myAlleles[i];
            }
            if (this.mySNPID != null && (defaultS = "S" + this.myChromosome.getName() + "_" + this.myPosition).equals(this.mySNPID)) {
                this.mySNPID = null;
            }
            return new GeneralPosition(this);
        }
    }
}

