/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.map;

import java.util.HashMap;

public class GenomeFeature {
    private int start;
    private int stop;
    private HashMap<String, String> annotations;

    GenomeFeature(HashMap<String, String> myannotations) {
        this.annotations = myannotations;
        this.start = this.assignPosition("start");
        this.stop = this.assignPosition("stop");
    }

    private int assignPosition(String key) {
        String value = this.getAnnotation(key);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public String id() {
        return this.getAnnotation("id");
    }

    public String type() {
        return this.getAnnotation("type");
    }

    public String parentId() {
        return this.getAnnotation("parent_id");
    }

    public String chromosome() {
        return this.getAnnotation("chromosome");
    }

    public int start() {
        return this.start;
    }

    public String startAsString() {
        return this.getAnnotation("start");
    }

    public int stop() {
        return this.stop;
    }

    public String stopAsString() {
        return this.getAnnotation("stop");
    }

    public String getAnnotation(String key) {
        if (this.annotations.containsKey(key)) {
            return this.annotations.get(key);
        }
        return "NA";
    }

    public HashMap<String, String> annotations() {
        HashMap<String, String> annotationsCopy = new HashMap<String, String>(this.annotations);
        return annotationsCopy;
    }
}

