/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.map;

import java.util.HashMap;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.maizegenetics.dna.map.Chromosome;
import net.maizegenetics.dna.map.GenomeFeature;
import org.apache.log4j.Logger;
import org.json.simple.JSONObject;

public class GenomeFeatureBuilder {
    private static final Logger myLogger = Logger.getLogger(GenomeFeatureBuilder.class);
    private HashMap<String, String> myannotations = null;

    public GenomeFeatureBuilder() {
        this.myannotations = new HashMap();
    }

    public GenomeFeatureBuilder(GenomeFeature feature) {
        this.myannotations = feature.annotations();
    }

    public GenomeFeature build() {
        this.validateData();
        return new GenomeFeature(this.myannotations);
    }

    private void validateData() {
        if (!this.myannotations.containsKey("id") || this.myannotations.get("id") == "NA") {
            throw new UnsupportedOperationException("GenomeFeatureBuilder: Cannot build a feature without a personal identifier (field 'id')");
        }
        if (this.myannotations.containsKey("start") && this.myannotations.containsKey("stop")) {
            int mystart = Integer.parseInt(this.myannotations.get("start"));
            int mystop = Integer.parseInt(this.myannotations.get("stop"));
            if (mystart < 0) {
                throw new UnsupportedOperationException("GenomeFeatureBuilder: Start coordinate is negative for " + this.myannotations.get("id") + ": " + mystart + " (possibly unassigned?)");
            }
            if (mystop < 0) {
                throw new UnsupportedOperationException("GenomeFeatureBuilder: Stop coordinate is negative for " + this.myannotations.get("id") + ": " + mystop + " (possibly unassigned?)");
            }
            if (mystart > mystop) {
                throw new UnsupportedOperationException("GenomeFeatureBuilder: Start coordinate is greater than stop coordinate for " + this.myannotations.get("id") + ": " + mystart + " vs " + mystop);
            }
        }
    }

    public GenomeFeatureBuilder id(String id) {
        return this.addAnnotation("id", id);
    }

    public GenomeFeatureBuilder type(String type) {
        return this.addAnnotation("type", type);
    }

    public GenomeFeatureBuilder parentId(String parentId) {
        return this.addAnnotation("parent_id", parentId);
    }

    public GenomeFeatureBuilder chromosome(Chromosome chr) {
        return this.addAnnotation("chromosome", chr.getName());
    }

    public GenomeFeatureBuilder chromosome(String chr) {
        return this.addAnnotation("chromosome", chr);
    }

    public GenomeFeatureBuilder chromosome(int chr) {
        return this.addAnnotation("chromosome", "" + chr);
    }

    public GenomeFeatureBuilder start(int start) {
        return this.addAnnotation("start", "" + start);
    }

    public GenomeFeatureBuilder start(String start) {
        return this.addAnnotation("start", start);
    }

    public GenomeFeatureBuilder stop(int stop) {
        return this.addAnnotation("stop", "" + stop);
    }

    public GenomeFeatureBuilder stop(String stop) {
        return this.addAnnotation("stop", stop);
    }

    public GenomeFeatureBuilder position(String position) {
        return this.addAnnotation("position", position);
    }

    public GenomeFeatureBuilder position(int position) {
        return this.addAnnotation("position", "" + position);
    }

    public GenomeFeatureBuilder addAnnotation(String key, String value) {
        key = GenomeFeatureBuilder.synonymizeKeys(key);
        if ("".equals(value)) {
            value = "NA";
        }
        this.myannotations.put(key, value);
        if (key == "position") {
            this.start(value);
            this.stop(value);
        }
        return this;
    }

    public static String synonymizeKeys(String key) {
        switch (key = key.toLowerCase(Locale.ENGLISH)) {
            case "name": 
            case "id": {
                return "id";
            }
            case "chr": 
            case "chrom": 
            case "chromosome": {
                return "chromosome";
            }
            case "end": 
            case "stop": {
                return "stop";
            }
            case "parent": 
            case "parentid": 
            case "parent_id": {
                return "parent_id";
            }
            case "pos": 
            case "position": {
                return "position";
            }
        }
        return key;
    }

    public GenomeFeatureBuilder loadAll(HashMap<String, String> newAnnotations) {
        for (String key : newAnnotations.keySet()) {
            this.addAnnotation(key, newAnnotations.get(key));
        }
        return this;
    }

    public GenomeFeatureBuilder parseGffLine(String line) {
        int gffSeq = 0;
        boolean gffSource = true;
        int gffFeatureType = 2;
        int gffStart = 3;
        int gffStop = 4;
        int gffScore = 5;
        int gffStrand = 6;
        int gffFrame = 7;
        int gffAttributes = 8;
        String[] tokens = line.split("\t");
        this.chromosome(tokens[gffSeq].trim());
        this.type(tokens[gffFeatureType].trim());
        this.start(tokens[gffStart]);
        this.stop(tokens[gffStop]);
        this.addAnnotation("strand", tokens[gffStrand].trim());
        String parentID = GenomeFeatureBuilder.getParentFromGffAttributes(tokens[gffAttributes]);
        this.parentId(parentID);
        String myID = GenomeFeatureBuilder.getFeatureIdFromGffAttributes(tokens[gffAttributes]);
        if (myID == null) {
            myID = this.myannotations.get("type") + "_" + this.myannotations.get("chromosome") + "_" + this.myannotations.get("start") + "_" + this.myannotations.get("stop");
        }
        this.id(myID);
        return this;
    }

    public static String getParentFromGffAttributes(String attributes) {
        Matcher matcher = Pattern.compile("parent_id \"(\\w+)\"").matcher(attributes);
        if (matcher.find()) {
            return matcher.group(1);
        }
        matcher = Pattern.compile("Parent=(\\w+:){0,1}(\\w+)").matcher(attributes);
        if (matcher.find()) {
            return matcher.group(2);
        }
        matcher = Pattern.compile("transcript_id \"(\\w+)\"").matcher(attributes);
        if (matcher.find()) {
            return matcher.group(1);
        }
        matcher = Pattern.compile("gene_id \"(\\w+)\"").matcher(attributes);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "";
    }

    public static String getFeatureIdFromGffAttributes(String attributes) {
        Matcher matcher = Pattern.compile("(Name|ID)=(\\w+:){0,1}(\\w+)").matcher(attributes);
        if (matcher.find()) {
            return matcher.group(3);
        }
        return null;
    }

    public GenomeFeatureBuilder parseJsonObject(JSONObject featureData) {
        HashMap jsonHash = new HashMap();
        for (String key : featureData.keySet()) {
            this.addAnnotation(key, featureData.get((Object)key).toString());
        }
        return this;
    }
}

