/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.map;

import java.util.ArrayList;
import net.maizegenetics.dna.map.Position;
import net.maizegenetics.dna.map.PositionList;
import net.maizegenetics.util.TableReport;

public class PositionListTableReport
implements TableReport {
    private static final String[] DEFAULT_COLUMN_HEADINGS = new String[]{"Site", "Name", "Chromosome", "Position"};
    private final PositionList myPositionList;
    private final String[] myColumnHeadings;

    public PositionListTableReport(PositionList positionList) {
        this.myPositionList = positionList;
        ArrayList<String> annotationColumns = new ArrayList<String>();
        for (Position current : this.myPositionList) {
            for (String key : current.getAnnotationAsMap().keySet()) {
                if (annotationColumns.contains(key)) continue;
                annotationColumns.add(key);
            }
        }
        int totalHeadings = DEFAULT_COLUMN_HEADINGS.length + annotationColumns.size();
        this.myColumnHeadings = new String[totalHeadings];
        for (int i = 0; i < DEFAULT_COLUMN_HEADINGS.length; ++i) {
            this.myColumnHeadings[i] = DEFAULT_COLUMN_HEADINGS[i];
        }
        for (int j = DEFAULT_COLUMN_HEADINGS.length; j < totalHeadings; ++j) {
            this.myColumnHeadings[j] = (String)annotationColumns.get(j - DEFAULT_COLUMN_HEADINGS.length);
        }
    }

    @Override
    public Object[] getTableColumnNames() {
        return this.myColumnHeadings;
    }

    @Override
    public String getTableTitle() {
        return "Position List";
    }

    @Override
    public int getColumnCount() {
        return this.myColumnHeadings.length;
    }

    @Override
    public long getRowCount() {
        return this.myPositionList.numberOfSites();
    }

    @Override
    public long getElementCount() {
        return (long)this.getColumnCount() * this.getRowCount();
    }

    @Override
    public Object[] getRow(long row) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public Object getValueAt(long rowLong, int col) {
        int row = (int)rowLong;
        switch (col) {
            case 0: {
                return row;
            }
            case 1: {
                return ((Position)this.myPositionList.get(row)).getSNPID();
            }
            case 2: {
                return ((Position)this.myPositionList.get(row)).getChromosome();
            }
            case 3: {
                return ((Position)this.myPositionList.get(row)).getPosition();
            }
        }
        String[] annotations = ((Position)this.myPositionList.get(row)).getTextAnnotation(this.myColumnHeadings[col]);
        if (annotations != null) {
            return annotations[0];
        }
        return null;
    }
}

