/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.map;

import ch.systemsx.cisd.hdf5.HDF5CompoundType;
import ch.systemsx.cisd.hdf5.HDF5Factory;
import ch.systemsx.cisd.hdf5.IHDF5WriterConfigurator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import net.maizegenetics.dna.BaseEncoder;
import net.maizegenetics.dna.map.TagGWASMapInfo;
import net.maizegenetics.dna.map.TagMappingInfoV3;
import net.maizegenetics.dna.map.TagsOnPhysicalMapV3;
import net.maizegenetics.dna.tag.AbstractTagsHDF5;
import net.maizegenetics.dna.tag.TagCounts;
import net.maizegenetics.dna.tag.TagsByTaxa;

public class TagGWASMap
extends AbstractTagsHDF5 {
    HDF5CompoundType<TagGWASMapInfo> tgType = null;
    TagGWASMapInfo[] mapInfo;

    public TagGWASMap(String tagGWASMapFileS) {
        this.readHDF5(tagGWASMapFileS);
    }

    public TagGWASMap(String gwasMappingResultFileS, String tagCountFileS, String tagGWASMapFileS) {
        this.creatFile(gwasMappingResultFileS, tagCountFileS, tagGWASMapFileS);
    }

    public TagGWASMap(String gwasMappingFileS, String topmFileS, String tagCountFileS, String tagGWASMapFileS) {
        this.creatFile(gwasMappingFileS, topmFileS, tagCountFileS, tagGWASMapFileS);
    }

    private void creatFile(String gwasMappingResultFileS, String tagCountFileS, String tagGWASMapFileS) {
        try {
            BufferedReader br = new BufferedReader(new FileReader(gwasMappingResultFileS), 65536);
            String temp = null;
            int tagCount = -1;
            this.tagLengthInLong = 0;
            while ((temp = br.readLine()) != null) {
                if (tagCount == 0) {
                    String[] tem = temp.split("\t");
                    this.tagLengthInLong = tem[0].length() / 32;
                }
                ++tagCount;
            }
            this.initializeMatrix(tagCount, this.tagLengthInLong);
            TagCounts tc = new TagCounts(tagCountFileS, TagsByTaxa.FilePacking.Byte);
            br = new BufferedReader(new FileReader(gwasMappingResultFileS), 65536);
            br.readLine();
            int rLen = this.tagLengthInLong * 32;
            long[] t = new long[this.tagLengthInLong];
            for (int i = 0; i < this.getTagCount(); ++i) {
                temp = br.readLine().substring(0, rLen);
                t = BaseEncoder.getLongArrayFromSeq(temp);
                int tagIndex = tc.getTagIndex(t);
                for (int j = 0; j < this.tagLengthInLong; ++j) {
                    this.tags[j][i] = t[j];
                }
                this.tagLength[i] = (byte)tc.getTagLength(tagIndex);
            }
            this.initializeHDF5(tagGWASMapFileS);
            br = new BufferedReader(new FileReader(gwasMappingResultFileS), 65536);
            br.readLine();
            for (int i = 0; i < this.getBlockNum(); ++i) {
                this.populateBlock(i);
                int cnt = 0;
                for (int j = 0; j < this.getBlockSize() && i * this.getBlockSize() + j < this.getTagCount(); ++j) {
                    for (int k = 0; k < this.getTagSizeInLong(); ++k) {
                        t[k] = this.tags[k][cnt];
                    }
                    String[] tem = br.readLine().split("\t");
                    int readCount = Integer.valueOf(tem[1]);
                    int gChr = Integer.valueOf(tem[5]);
                    int gPos = Integer.valueOf(tem[7]);
                    double gwasPValue = Double.valueOf(tem[8]);
                    int numSigSite = Integer.valueOf(tem[9]);
                    int tagTaxaCount = Integer.valueOf(tem[10]);
                    int numSigChr = Integer.valueOf(tem[11]);
                    double lRatioSB = Double.valueOf(tem[12]);
                    if (lRatioSB == Double.POSITIVE_INFINITY) {
                        lRatioSB = 305.0;
                    } else if (lRatioSB == Double.NEGATIVE_INFINITY || lRatioSB == 0.0) {
                        lRatioSB = 1.0E-7;
                    }
                    double lRatioMB = Double.valueOf(tem[13]);
                    if (lRatioMB == Double.POSITIVE_INFINITY) {
                        lRatioMB = 305.0;
                    } else if (lRatioMB == Double.NEGATIVE_INFINITY || lRatioMB == 0.0) {
                        lRatioMB = 1.0E-7;
                    }
                    int numSiteOnBestChrThanSecondBest = Integer.valueOf(tem[14]);
                    int sigSiteStart = Integer.valueOf(tem[15]);
                    int sigSiteEnd = Integer.valueOf(tem[16]);
                    this.mapInfo[cnt] = new TagGWASMapInfo(readCount, gChr, gPos, gwasPValue, numSigSite, tagTaxaCount, numSigChr, lRatioSB, lRatioMB, numSiteOnBestChrThanSecondBest, sigSiteStart, sigSiteEnd);
                    ++cnt;
                }
                this.writeBlock(i);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void creatFile(String gwasMappingFileS, String topmFileS, String tagCountFileS, String tagGWASMapFileS) {
        TagMappingInfoV3.Aligner software = TagMappingInfoV3.Aligner.Bowtie2;
        try {
            int tagIndex;
            BufferedReader br = new BufferedReader(new FileReader(gwasMappingFileS), 65536);
            String temp = null;
            int tagCount = -1;
            int tagLengthInLong = 0;
            while ((temp = br.readLine()) != null) {
                if (tagCount == 0) {
                    String[] tem = temp.split("\t");
                    tagLengthInLong = tem[0].length() / 32;
                }
                ++tagCount;
            }
            this.initializeMatrix(tagCount, tagLengthInLong);
            TagCounts tc = new TagCounts(tagCountFileS, TagsByTaxa.FilePacking.Byte);
            br = new BufferedReader(new FileReader(gwasMappingFileS), 65536);
            br.readLine();
            int rLen = tagLengthInLong * 32;
            long[] t = new long[tagLengthInLong];
            for (int i = 0; i < this.getTagCount(); ++i) {
                temp = br.readLine().substring(0, rLen);
                t = BaseEncoder.getLongArrayFromSeq(temp);
                tagIndex = tc.getTagIndex(t);
                for (int j = 0; j < tagLengthInLong; ++j) {
                    this.tags[j][i] = t[j];
                }
                this.tagLength[i] = (byte)tc.getTagLength(tagIndex);
            }
            this.initializeHDF5(tagGWASMapFileS);
            br = new BufferedReader(new FileReader(gwasMappingFileS), 65536);
            br.readLine();
            TagsOnPhysicalMapV3 topm = new TagsOnPhysicalMapV3(topmFileS);
            int[] mapIndices = topm.getMappingIndicesOfAligner(software);
            TagMappingInfoV3[] pMaps = new TagMappingInfoV3[mapIndices.length];
            int cnt = 0;
            for (int i = 0; i < this.getBlockNum(); ++i) {
                this.populateBlock(i);
                for (int j = 0; j < this.getBlockSize() && i * this.getBlockSize() + j < this.getTagCount(); ++j) {
                    int k;
                    boolean ifMap = false;
                    boolean ifRef = false;
                    boolean ifUnique = false;
                    for (k = 0; k < this.getTagSizeInLong(); ++k) {
                        t[k] = this.tags[k][cnt];
                    }
                    tagIndex = topm.getTagIndex(t);
                    for (k = 0; k < pMaps.length; ++k) {
                        pMaps[k] = topm.getMappingInfo(tagIndex, mapIndices[k]);
                    }
                    if (pMaps[0].chromosome != Integer.MIN_VALUE) {
                        ifMap = true;
                        if (pMaps[0].perfectMatch == 1) {
                            ifRef = true;
                        }
                        if (pMaps[1].chromosome == Integer.MIN_VALUE) {
                            ifUnique = true;
                        }
                    }
                    String[] tem = br.readLine().split("\t");
                    int readCount = Integer.valueOf(tem[1]);
                    int pChr = pMaps[0].chromosome;
                    int pPos = pMaps[0].startPosition;
                    int gChr = Integer.valueOf(tem[5]);
                    int gPos = Integer.valueOf(tem[7]);
                    double gwasPValue = Double.valueOf(tem[8]);
                    int numSigSite = Integer.valueOf(tem[9]);
                    int tagTaxaCount = Integer.valueOf(tem[10]);
                    int numSigChr = Integer.valueOf(tem[11]);
                    double lRatioSB = Double.valueOf(tem[12]);
                    if (lRatioSB == Double.POSITIVE_INFINITY) {
                        lRatioSB = 305.0;
                    } else if (lRatioSB == Double.NEGATIVE_INFINITY) {
                        lRatioSB = -305.0;
                    }
                    double lRatioMB = Double.valueOf(tem[13]);
                    if (lRatioMB == Double.POSITIVE_INFINITY) {
                        lRatioMB = 305.0;
                    } else if (lRatioMB == Double.NEGATIVE_INFINITY) {
                        lRatioMB = -305.0;
                    }
                    int numSiteOnBestChrThanSecondBest = Integer.valueOf(tem[14]);
                    int sigSiteStart = Integer.valueOf(tem[15]);
                    int sigSiteEnd = Integer.valueOf(tem[16]);
                    this.mapInfo[cnt] = new TagGWASMapInfo(readCount, pChr, pPos, ifMap, ifRef, ifUnique, gChr, gPos, gwasPValue, numSigSite, tagTaxaCount, numSigChr, lRatioSB, lRatioMB, numSiteOnBestChrThanSecondBest, sigSiteStart, sigSiteEnd);
                    ++cnt;
                }
                this.writeBlock(i);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addAlignment(TagsOnPhysicalMapV3 topm) {
        TagMappingInfoV3.Aligner software = TagMappingInfoV3.Aligner.Bowtie2;
        int[] mapIndices = topm.getMappingIndicesOfAligner(software);
        TagMappingInfoV3[] pMaps = new TagMappingInfoV3[mapIndices.length];
        for (int i = 0; i < this.getTagCount(); ++i) {
            boolean ifMap = false;
            boolean ifRef = false;
            boolean ifUnique = false;
            long[] t = new long[this.getTagSizeInLong()];
            for (int j = 0; j < this.getTagSizeInLong(); ++j) {
                t[j] = this.tags[j][i];
            }
            int tagIndex = topm.getTagIndex(t);
            for (int j = 0; j < pMaps.length; ++j) {
                pMaps[j] = topm.getMappingInfo(tagIndex, mapIndices[j]);
            }
            int pChr = pMaps[0].chromosome;
            int pPos = pMaps[0].startPosition;
            if (pMaps[0].chromosome != Integer.MIN_VALUE) {
                ifMap = true;
                if (pMaps[0].perfectMatch == 1) {
                    ifRef = true;
                }
                if (pMaps[1].chromosome == Integer.MIN_VALUE) {
                    ifUnique = true;
                }
            }
            this.getTagGWASMapInfo(i).setAlignment(pChr, pPos, ifMap, ifRef, ifUnique);
            if ((i + 1) % this.getBlockSize() != 0) continue;
            this.writeBlock(this.getCurrentBlockIndex());
            System.out.println("Added alignment to " + String.valueOf(i + 1) + " tags");
        }
        this.writeBlock(this.getCurrentBlockIndex());
        System.out.println("Added alignment to " + String.valueOf(this.getTagCount()) + " tags");
        System.out.println("Adding alignment is completed");
    }

    @Override
    public void initializeHDF5(String tagGWASMapFileS) {
        IHDF5WriterConfigurator config = HDF5Factory.configure((File)new File(tagGWASMapFileS));
        config.overwrite();
        config.useUTF8CharacterEncoding();
        this.h5 = config.writer();
        this.h5.setIntAttribute("/", "tagLengthInLong", this.tagLengthInLong);
        this.h5.setIntAttribute("/", "tagCount", this.getTagCount());
        this.h5.createLongMatrix("tags", (long)this.getTagSizeInLong(), (long)this.getTagCount(), this.getTagSizeInLong(), this.getTagCount(), this.getIntStorageFeatures());
        this.h5.writeLongMatrix("tags", this.tags, this.getIntStorageFeatures());
        System.out.println("...Tags written");
        this.h5.createByteArray("tagLength", this.getTagCount(), this.getIntStorageFeatures());
        this.h5.writeByteArray("tagLength", this.tagLength, this.getIntStorageFeatures());
        System.out.println("...Tags lengths written");
        this.tgType = this.h5.compounds().getInferredType(TagGWASMapInfo.class);
        this.h5.compounds().createArray("map", this.tgType, (long)(this.getBlockSize() * this.getBlockNum()), this.getBlockSize(), this.getGenericStorageFeatures());
        System.out.println("...MapInfo created");
    }

    @Override
    public void readHDF5(String hdf5FileS) {
        this.h5 = HDF5Factory.open((String)hdf5FileS);
        this.tgType = this.h5.compounds().getInferredType(TagGWASMapInfo.class);
        this.tagLengthInLong = this.h5.getIntAttribute("/", "tagLengthInLong");
        int tagCount = this.h5.getIntAttribute("/", "tagCount");
        this.tags = this.h5.readLongMatrix("tags");
        this.tagLength = this.h5.readByteArray("tagLength");
        this.getTagGWASMapInfo(0);
    }

    @Override
    public void populateBlock(int blockIndex) {
        this.mapInfo = new TagGWASMapInfo[this.getBlockSize()];
        for (int i = 0; i < this.getBlockSize(); ++i) {
            this.mapInfo[i] = new TagGWASMapInfo();
        }
        this.currentBlockIndex = blockIndex;
    }

    @Override
    public void readBlock(int blockIndex) {
        this.mapInfo = (TagGWASMapInfo[])this.h5.compounds().readArrayBlock("map", this.tgType, this.getBlockSize(), (long)blockIndex);
        this.currentBlockIndex = blockIndex;
    }

    @Override
    public void writeBlock(int blockIndex) {
        this.h5.compounds().writeArrayBlock("map", this.tgType, (Object[])this.mapInfo, (long)blockIndex);
    }

    public TagGWASMapInfo getTagGWASMapInfo(int tagIndex) {
        if (this.isInCurrentBlock(tagIndex)) {
            this.currentIndex = tagIndex;
        } else {
            this.readBlock(this.getBlockIndex(tagIndex));
            this.currentIndex = tagIndex;
        }
        return this.mapInfo[this.getCurrentIndexWithinBlock()];
    }
}

