/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.map;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import net.maizegenetics.dna.BaseEncoder;
import net.maizegenetics.dna.tag.AbstractTags;
import net.maizegenetics.dna.tag.TagsByTaxa;

public class TagsOnGeneticMap
extends AbstractTags {
    protected int[] gChr;
    protected int[] gPos;
    protected byte[] ifPAV;
    protected float[] prediction;

    public TagsOnGeneticMap(String infileS, TagsByTaxa.FilePacking format) {
        this.readDistFile(infileS, format);
    }

    public int getGChr(int index) {
        return this.gChr[index];
    }

    public int getGPos(int index) {
        return this.gPos[index];
    }

    public byte getIfPAV(int index) {
        return this.ifPAV[index];
    }

    public float getPrediction(int index) {
        return this.prediction[index];
    }

    public void readDistFile(String infileS, TagsByTaxa.FilePacking format) {
        System.out.println("Reading TOGM file from " + infileS);
        File infile = new File(infileS);
        switch (format) {
            case Text: {
                this.readTextTOGMFile(infile);
                break;
            }
            default: {
                this.readBinaryTOGMFile(infile);
            }
        }
        System.out.println("TOGM file read. Tatol: " + this.getTagCount() + " Tags");
    }

    private void readTextTOGMFile(File infile) {
        try {
            BufferedReader br = new BufferedReader(new FileReader(infile), 65536);
            br.readLine();
            this.tagLengthInLong = br.readLine().split("\t")[0].length() / 32;
            int tagNum = 1;
            while (br.readLine() != null) {
                ++tagNum;
            }
            this.iniMatrix(this.tagLengthInLong, tagNum);
            br = new BufferedReader(new FileReader(infile), 65536);
            br.readLine();
            for (int i = 0; i < tagNum; ++i) {
                String[] temp = br.readLine().split("\t");
                long[] t = BaseEncoder.getLongArrayFromSeq(temp[0]);
                for (int j = 0; j < this.tagLengthInLong; ++j) {
                    this.tags[j][i] = t[j];
                }
                this.tagLength[i] = Byte.parseByte(temp[1]);
                this.gChr[i] = Integer.parseInt(temp[2]);
                this.gPos[i] = Integer.parseInt(temp[3]);
                this.ifPAV[i] = Byte.parseByte(temp[4]);
                this.prediction[i] = Float.parseFloat(temp[5]);
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void readBinaryTOGMFile(File infile) {
        try {
            DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(infile), 65536));
            this.tagLengthInLong = dis.readInt();
            int tagNum = (int)(infile.length() / (long)(8 * this.tagLengthInLong) + 1L + 4L + 4L + 1L + 4L);
            this.iniMatrix(this.tagLengthInLong, tagNum);
            for (int i = 0; i < this.getTagCount(); ++i) {
                for (int j = 0; j < this.tagLengthInLong; ++j) {
                    this.tags[j][i] = dis.readLong();
                }
                this.tagLength[i] = dis.readByte();
                this.gChr[i] = dis.readInt();
                this.gPos[i] = dis.readInt();
                this.ifPAV[i] = dis.readByte();
                this.prediction[i] = dis.readFloat();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void iniMatrix(int tagLengthInLong, int tagNum) {
        this.tags = new long[tagLengthInLong][tagNum];
        this.tagLength = new byte[tagNum];
        this.gChr = new int[tagNum];
        this.gPos = new int[tagNum];
        this.ifPAV = new byte[tagNum];
        this.prediction = new float[tagNum];
    }

    public void writeDistFile(String outfileS, TagsByTaxa.FilePacking format) {
        System.out.println("Writing TOGM file to " + outfileS);
        switch (format) {
            case Text: {
                this.writeTextTOGMFile(outfileS);
                break;
            }
            default: {
                this.writeBinaryTOGMFile(outfileS);
            }
        }
        System.out.println("TOGM file written");
    }

    private void writeTextTOGMFile(String outfileS) {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(outfileS), 65536);
            bw.write("Tag\tTagLength\tGChr\tGPos\tIfPAV\tPredictedDistance");
            bw.newLine();
            long[] temp = new long[this.tagLengthInLong];
            for (int i = 0; i < this.getTagCount(); ++i) {
                for (int j = 0; j < temp.length; ++j) {
                    temp[j] = this.tags[j][i];
                }
                bw.write(BaseEncoder.getSequenceFromLong(temp) + "\t" + String.valueOf(this.getTagLength(i)) + "\t");
                bw.write(String.valueOf(this.gChr[i]) + "\t" + String.valueOf(this.gPos[i]) + "\t" + String.valueOf(this.ifPAV[i]) + "\t" + String.valueOf(this.prediction[i]));
                bw.newLine();
            }
            bw.flush();
            bw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void writeBinaryTOGMFile(String outfileS) {
        try {
            DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(outfileS), 65536));
            dos.writeInt(this.tagLengthInLong);
            for (int i = 0; i < this.getTagCount(); ++i) {
                for (int j = 0; j < this.tagLengthInLong; ++j) {
                    dos.writeLong(this.tags[j][i]);
                }
                dos.writeByte(this.getTagLength(i));
                dos.writeInt(this.getGChr(i));
                dos.writeInt(this.getGPos(i));
                dos.writeByte(this.getIfPAV(i));
                dos.writeFloat(this.getPrediction(i));
            }
            dos.flush();
            dos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeFastQ(String outfileS) {
        String defaultQualityS = null;
        for (int i = 0; i < this.getTagSizeInLong() * 32; ++i) {
            defaultQualityS = defaultQualityS + "f";
        }
        long[] t = new long[this.getTagSizeInLong()];
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(outfileS), 65536);
            for (int i = 0; i < this.getTagCount(); ++i) {
                bw.write("@" + String.valueOf(i));
                bw.newLine();
                for (int j = 0; j < this.getTagSizeInLong(); ++j) {
                    t[j] = this.tags[j][i];
                }
                bw.write(BaseEncoder.getSequenceFromLong(t).substring(0, this.getTagLength(i)));
                bw.newLine();
                bw.write("+");
                bw.newLine();
                bw.write(defaultQualityS.substring(0, this.getTagLength(i)));
                bw.newLine();
            }
            bw.flush();
            bw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

