/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.map;

import cern.colt.GenericSorting;
import cern.colt.Swapper;
import cern.colt.function.IntComparator;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import net.maizegenetics.dna.BaseEncoder;
import net.maizegenetics.dna.map.AbstractTagsOnPhysicalMap;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTableUtils;
import net.maizegenetics.dna.snp.ImportUtils;
import net.maizegenetics.dna.snp.NucleotideAlignmentConstants;
import net.maizegenetics.dna.tag.SAMUtils;
import net.maizegenetics.dna.tag.TagCountMutable;
import net.maizegenetics.dna.tag.Tags;
import net.maizegenetics.util.MultiMemberGZIPInputStream;

public class TagsOnPhysicalMap
extends AbstractTagsOnPhysicalMap {
    int[] endPosition;
    byte[] divergence;
    byte[] dcoP;
    byte[] mapP;
    boolean redundantTags = true;
    private SAMFormat mySAMFormat = SAMFormat.BWA;

    public TagsOnPhysicalMap() {
    }

    public TagsOnPhysicalMap(String inFile, boolean binary) {
        if (binary) {
            this.readBinaryFile(new File(inFile));
        } else {
            this.readTextFile(new File(inFile));
        }
        this.initPhysicalSort();
    }

    public TagsOnPhysicalMap(int rows) {
        this.initMatrices(rows);
    }

    public TagsOnPhysicalMap(int rows, int tagLengthInLong, int maxVariants) {
        this.tagLengthInLong = tagLengthInLong;
        this.myMaxVariants = maxVariants;
        this.initMatrices(rows);
    }

    public TagsOnPhysicalMap(Tags readList) {
        this.tagLengthInLong = readList.getTagSizeInLong();
        this.initMatrices(readList.getTagCount());
        for (int i = 0; i < readList.getTagCount(); ++i) {
            for (int j = 0; j < this.tagLengthInLong; ++j) {
                this.tags[j][i] = readList.getTag(i)[j];
            }
            this.tagLength[i] = (byte)readList.getTagLength(i);
        }
    }

    public TagsOnPhysicalMap(TagsOnPhysicalMap oldTOPM, boolean filterDuplicates) {
        int i;
        this.tagLengthInLong = oldTOPM.tagLengthInLong;
        this.myMaxVariants = oldTOPM.myMaxVariants;
        oldTOPM.sortTable(true);
        int uniqueCnt = 1;
        for (i = 1; i < oldTOPM.getSize(); ++i) {
            if (Arrays.equals(oldTOPM.getTag(i - 1), oldTOPM.getTag(i))) continue;
            ++uniqueCnt;
        }
        System.out.println("The Physical Map File has UniqueTags:" + uniqueCnt + " TotalLocations:" + oldTOPM.getSize());
        this.initMatrices(uniqueCnt);
        this.myNumTags = uniqueCnt;
        uniqueCnt = 0;
        this.copyTagMapRow(oldTOPM, 0, 0, filterDuplicates);
        for (i = 1; i < oldTOPM.getTagCount(); ++i) {
            if (!Arrays.equals(this.getTag(uniqueCnt), oldTOPM.getTag(i))) {
                ++uniqueCnt;
            }
            this.copyTagMapRow(oldTOPM, i, uniqueCnt, filterDuplicates);
        }
        this.initPhysicalSort();
    }

    void initMatrices(int rows) {
        this.tags = new long[this.tagLengthInLong][rows];
        this.tagLength = new byte[rows];
        this.multimaps = new byte[rows];
        this.bestChr = new int[rows];
        this.bestStrand = new byte[rows];
        this.bestStartPos = new int[rows];
        this.endPosition = new int[rows];
        this.divergence = new byte[rows];
        this.variantOffsets = new byte[rows][];
        this.variantDefs = new byte[rows][];
        this.dcoP = new byte[rows];
        this.mapP = new byte[rows];
        this.myNumTags = rows;
    }

    public void expandMaxVariants(int newMaxVariants) {
        if (newMaxVariants <= this.myMaxVariants) {
            System.out.println("TagsOnPhysicalMap.expandMaxVariants(" + newMaxVariants + ") not performed because newMaxVariants (" + newMaxVariants + ") <= current maxVariants (" + this.myMaxVariants + ")");
            return;
        }
        int oldMaxVariants = this.myMaxVariants;
        byte[][] newVariantPosOff = new byte[this.myNumTags][newMaxVariants];
        byte[][] newVariantDef = new byte[this.myNumTags][newMaxVariants];
        for (int t = 0; t < this.myNumTags; ++t) {
            int v;
            for (v = 0; v < this.myMaxVariants; ++v) {
                newVariantPosOff[t][v] = this.variantOffsets[t][v];
                newVariantDef[t][v] = this.variantDefs[t][v];
            }
            for (v = this.myMaxVariants; v < newMaxVariants; ++v) {
                newVariantPosOff[t][v] = -128;
                newVariantDef[t][v] = -128;
            }
        }
        this.myMaxVariants = newMaxVariants;
        this.variantOffsets = newVariantPosOff;
        this.variantDefs = newVariantDef;
        System.out.println("TagsOnPhysicalMap maxVariants expanded from " + oldMaxVariants + " to " + newMaxVariants);
    }

    public void copyTagMapRow(TagsOnPhysicalMap sourceTOPM, int sourceRow, int destRow, boolean merge) {
        boolean overwrite = true;
        long[] ctag = sourceTOPM.getTag(sourceRow);
        if (Arrays.equals(ctag, this.getTag(destRow)) && merge) {
            overwrite = false;
        }
        for (int i = 0; i < this.tagLengthInLong; ++i) {
            this.tags[i][destRow] = ctag[i];
        }
        if (overwrite) {
            this.tagLength[destRow] = sourceTOPM.tagLength[sourceRow];
            this.multimaps[destRow] = sourceTOPM.multimaps[sourceRow];
            this.bestChr[destRow] = sourceTOPM.bestChr[sourceRow];
            this.bestStrand[destRow] = sourceTOPM.bestStrand[sourceRow];
            this.bestStartPos[destRow] = sourceTOPM.bestStartPos[sourceRow];
            this.endPosition[destRow] = sourceTOPM.endPosition[sourceRow];
            this.divergence[destRow] = sourceTOPM.divergence[sourceRow];
            for (int j = 0; j < this.myMaxVariants; ++j) {
                this.variantOffsets[destRow][j] = sourceTOPM.variantOffsets[sourceRow][j];
                this.variantDefs[destRow][j] = sourceTOPM.variantOffsets[sourceRow][j];
            }
            this.dcoP[destRow] = sourceTOPM.dcoP[sourceRow];
            this.mapP[destRow] = sourceTOPM.mapP[sourceRow];
        } else if (this.bestChr[destRow] != sourceTOPM.bestChr[sourceRow] || this.bestStrand[destRow] != sourceTOPM.bestStrand[sourceRow] || this.bestStartPos[destRow] != sourceTOPM.bestStartPos[sourceRow] || this.endPosition[destRow] != sourceTOPM.endPosition[sourceRow]) {
            int n = destRow;
            this.multimaps[n] = (byte)(this.multimaps[n] + sourceTOPM.multimaps[sourceRow]);
            this.bestStrand[destRow] = -128;
            this.bestChr[destRow] = -128;
            this.endPosition[destRow] = Integer.MIN_VALUE;
            this.bestStartPos[destRow] = Integer.MIN_VALUE;
        }
    }

    public long sortTable(boolean byHaplotype) {
        System.out.print("Starting Read Table Sort ...");
        if (!byHaplotype) {
            System.out.print("ERROR:  Position sorting has been eliminated ...");
            return -1L;
        }
        long time = System.currentTimeMillis();
        GenericSorting.quickSort((int)0, (int)this.tags[0].length, (IntComparator)this, (Swapper)this);
        long totalTime = System.currentTimeMillis() - time;
        System.out.println("Done in " + totalTime + "ms");
        this.initPhysicalSort();
        return totalTime;
    }

    protected void readBinaryFile(File currentFile) {
        int tagsInput = 0;
        try {
            DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(currentFile), 65536));
            System.out.println("File = " + currentFile);
            this.myNumTags = dis.readInt();
            this.tagLengthInLong = dis.readInt();
            this.myMaxVariants = dis.readInt();
            this.initMatrices(this.myNumTags);
            for (int row = 0; row < this.myNumTags; ++row) {
                for (int j = 0; j < this.tagLengthInLong; ++j) {
                    this.tags[j][row] = dis.readLong();
                }
                this.tagLength[row] = dis.readByte();
                this.multimaps[row] = dis.readByte();
                this.bestChr[row] = dis.readInt();
                this.bestStrand[row] = dis.readByte();
                this.bestStartPos[row] = dis.readInt();
                this.endPosition[row] = dis.readInt();
                this.divergence[row] = dis.readByte();
                byte[] currVD = new byte[this.myMaxVariants];
                byte[] currVO = new byte[this.myMaxVariants];
                int numWithData = 0;
                for (int j = 0; j < this.myMaxVariants; ++j) {
                    currVO[j] = dis.readByte();
                    currVD[j] = dis.readByte();
                    if (currVD[j] > 15 && GenotypeTableUtils.isHeterozygous(currVD[j])) {
                        currVD[j] = NucleotideAlignmentConstants.getNucleotideAlleleByte(String.valueOf((char)currVD[j]));
                    }
                    if (currVO[j] == -128) continue;
                    ++numWithData;
                }
                if (numWithData > 0) {
                    this.variantDefs[row] = Arrays.copyOf(currVD, numWithData);
                    this.variantOffsets[row] = Arrays.copyOf(currVO, numWithData);
                }
                this.dcoP[row] = dis.readByte();
                this.mapP[row] = dis.readByte();
                ++tagsInput;
                if (row % 1000000 != 0) continue;
                System.out.println("TagMapFile Row Read:" + row);
            }
            dis.close();
        }
        catch (Exception e) {
            System.out.println("Error tagsInput=" + tagsInput + " e=" + e);
        }
        System.out.println("Count of Tags=" + tagsInput);
    }

    public boolean variantsDefined(int tagIndex) {
        for (int i = 0; i < this.myMaxVariants; ++i) {
            if (this.variantOffsets[tagIndex][i] == -128 || this.variantDefs[tagIndex][i] == -128) continue;
            return true;
        }
        return false;
    }

    public void readTextFile(File inFile) {
        System.out.println("Reading tag alignment from:" + inFile.toString());
        Object[] inputLine = new String[]{"NotRead"};
        try {
            BufferedReader br = new BufferedReader(new FileReader(inFile), 65536);
            inputLine = br.readLine().split("\t");
            this.myNumTags = Integer.parseInt(inputLine[0]);
            this.tagLengthInLong = Integer.parseInt((String)inputLine[1]);
            this.myMaxVariants = Integer.parseInt((String)inputLine[2]);
            this.initMatrices(this.myNumTags);
            for (int row = 0; row < this.myNumTags; ++row) {
                inputLine = br.readLine().split("\t");
                int c = 0;
                long[] tt = BaseEncoder.getLongArrayFromSeq((String)inputLine[c++]);
                for (int j = 0; j < tt.length; ++j) {
                    this.tags[j][row] = tt[j];
                }
                this.tagLength[row] = TagsOnPhysicalMap.parseByteWMissing((String)inputLine[c++]);
                this.multimaps[row] = TagsOnPhysicalMap.parseByteWMissing((String)inputLine[c++]);
                this.bestChr[row] = TagsOnPhysicalMap.parseIntWMissing((String)inputLine[c++]);
                this.bestStrand[row] = TagsOnPhysicalMap.parseByteWMissing((String)inputLine[c++]);
                this.bestStartPos[row] = TagsOnPhysicalMap.parseIntWMissing((String)inputLine[c++]);
                this.endPosition[row] = TagsOnPhysicalMap.parseIntWMissing((String)inputLine[c++]);
                this.divergence[row] = TagsOnPhysicalMap.parseByteWMissing((String)inputLine[c++]);
                byte[] currVD = new byte[this.myMaxVariants];
                byte[] currVO = new byte[this.myMaxVariants];
                int numWithData = 0;
                for (int j = 0; j < this.myMaxVariants; ++j) {
                    currVO[j] = TagsOnPhysicalMap.parseByteWMissing((String)inputLine[c++]);
                    currVD[j] = TagsOnPhysicalMap.parseCharWMissing((String)inputLine[c++]);
                    if (currVO[j] == -128) continue;
                    ++numWithData;
                }
                this.variantDefs[row] = Arrays.copyOf(currVD, numWithData);
                this.variantOffsets[row] = Arrays.copyOf(currVO, numWithData);
                this.dcoP[row] = TagsOnPhysicalMap.parseByteWMissing((String)inputLine[c++]);
                this.mapP[row] = TagsOnPhysicalMap.parseByteWMissing((String)inputLine[c++]);
                if (row % 1000000 != 0) continue;
                System.out.println("Row Read:" + row);
            }
        }
        catch (Exception e) {
            System.out.println("Catch in reading TagOnPhysicalMap file e=" + e);
            e.printStackTrace();
            System.out.println("Line:" + Arrays.toString(inputLine));
        }
        System.out.println("Number of tags in file:" + this.myNumTags);
    }

    @Override
    public int getReadIndexForPositionIndex(int posIndex) {
        return this.indicesOfSortByPosition[posIndex];
    }

    @Override
    public int[] getPositionArray(int index) {
        int[] r = new int[]{this.bestChr[index], this.bestStrand[index], this.bestStartPos[index]};
        return r;
    }

    public static byte parseCharWMissing(String s) {
        if (s.equals("*")) {
            return -128;
        }
        try {
            byte r = NucleotideAlignmentConstants.getNucleotideAlleleByte(s);
            return r;
        }
        catch (IllegalArgumentException e) {
            int i = Integer.parseInt(s);
            if (i > 127) {
                return 127;
            }
            byte r = NucleotideAlignmentConstants.getNucleotideAlleleByte(String.valueOf((char)i));
            return r;
        }
    }

    public static byte parseByteWMissing(String s) {
        if (s.equals("*")) {
            return -128;
        }
        try {
            int i = Integer.parseInt(s);
            if (i > 127) {
                return 127;
            }
            return (byte)i;
        }
        catch (NumberFormatException nf) {
            return -128;
        }
    }

    public static int parseIntWMissing(String s) {
        if (s.equals("*")) {
            return Integer.MIN_VALUE;
        }
        try {
            int i = Integer.parseInt(s);
            return i;
        }
        catch (NumberFormatException nf) {
            return Integer.MIN_VALUE;
        }
    }

    @Override
    public byte getMultiMaps(int index) {
        return this.multimaps[index];
    }

    @Override
    public int getEndPosition(int index) {
        return this.endPosition[index];
    }

    @Override
    public byte getDivergence(int index) {
        return this.divergence[index];
    }

    @Override
    public byte getMapP(int index) {
        return this.mapP[index];
    }

    @Override
    public byte getDcoP(int index) {
        return this.dcoP[index];
    }

    @Override
    public void setChromoPosition(int index, int chromosome, byte strand, int positionMin, int positionMax) {
        this.bestChr[index] = chromosome;
        this.bestStrand[index] = strand;
        this.bestStartPos[index] = positionMin;
        this.endPosition[index] = positionMax;
    }

    @Override
    public void setDivergence(int index, byte divergence) {
        this.divergence[index] = divergence;
    }

    @Override
    public void setMapP(int index, byte mapP) {
        this.mapP[index] = mapP;
    }

    public void setDcoP(int index, byte dcoP) {
        this.dcoP[index] = dcoP;
    }

    public void setMultimaps(int index, byte multimaps) {
        this.multimaps[index] = multimaps;
    }

    @Override
    public void setMapP(int index, double mapP) {
        if (Double.isInfinite(mapP)) {
            this.mapP[index] = 127;
            return;
        }
        if (Double.isNaN(mapP) || mapP < 0.0 || mapP > 1.0) {
            this.mapP[index] = -128;
            return;
        }
        if (mapP < 1.0E-126) {
            this.mapP[index] = 127;
            return;
        }
        this.mapP[index] = (byte)(-Math.round(Math.log10(mapP)));
    }

    @Override
    public int addVariant(int tagIndex, byte offset, byte base) {
        if (this.variantOffsets[tagIndex] == null) {
            this.variantOffsets[tagIndex] = new byte[]{offset};
            this.variantDefs[tagIndex] = new byte[]{base};
            return 0;
        }
        if (this.variantOffsets[tagIndex].length == this.myMaxVariants) {
            return -1;
        }
        this.variantOffsets[tagIndex] = Arrays.copyOf(this.variantOffsets[tagIndex], this.variantOffsets[tagIndex].length + 1);
        this.variantOffsets[tagIndex][this.variantOffsets[tagIndex].length - 1] = offset;
        this.variantDefs[tagIndex] = Arrays.copyOf(this.variantDefs[tagIndex], this.variantDefs[tagIndex].length + 1);
        this.variantDefs[tagIndex][this.variantDefs[tagIndex].length - 1] = base;
        return this.variantDefs.length - 1;
    }

    private boolean flagSet(int code, int flag) {
        int flagValue = 1 << flag;
        return (code & flagValue) == flagValue;
    }

    public void readSAMFile(String inputFileName, int tagLengthInLong) {
        System.out.println("Reading SAM format tag alignment from: " + inputFileName);
        this.tagLengthInLong = tagLengthInLong;
        String inputStr = "Nothing has been read from the file yet";
        int nHeaderLines = this.countTagsInSAMfile(inputFileName);
        int tagIndex = Integer.MIN_VALUE;
        try {
            BufferedReader br = inputFileName.endsWith(".gz") ? new BufferedReader(new InputStreamReader(new MultiMemberGZIPInputStream(new FileInputStream(new File(inputFileName))))) : new BufferedReader(new FileReader(new File(inputFileName)), 65536);
            for (int i = 0; i < nHeaderLines; ++i) {
                br.readLine();
            }
            for (tagIndex = 0; tagIndex < this.myNumTags; ++tagIndex) {
                inputStr = br.readLine();
                this.parseSAMAlignment(inputStr, tagIndex);
                if (tagIndex % 1000000 != 0) continue;
                System.out.println("Read " + tagIndex + " tags.");
            }
            br.close();
        }
        catch (Exception e) {
            System.out.println("\n\nCatch in reading SAM alignment file at tag " + tagIndex + ":\n\t" + inputStr + "\nError: " + e + "\n\n");
            e.printStackTrace();
            System.exit(1);
        }
    }

    private int countTagsInSAMfile(String inputFileName) {
        this.mySAMFormat = SAMFormat.BWA;
        this.myNumTags = 0;
        int nHeaderLines = 0;
        String currLine = null;
        try {
            ArrayList<String> chrNames = new ArrayList<String>();
            BufferedReader br = inputFileName.endsWith(".gz") ? new BufferedReader(new InputStreamReader(new MultiMemberGZIPInputStream(new FileInputStream(new File(inputFileName))))) : new BufferedReader(new FileReader(new File(inputFileName)), 65536);
            while ((currLine = br.readLine()) != null) {
                String[] inputLine = currLine.split("\\s");
                if (inputLine[0].contains("@")) {
                    if (inputLine[1].contains("bowtie2")) {
                        this.mySAMFormat = SAMFormat.BOWTIE2;
                    }
                    ++nHeaderLines;
                    continue;
                }
                String chr = inputLine[2];
                if (!chrNames.contains(chr)) {
                    chrNames.add(chr);
                }
                ++this.myNumTags;
                if (this.myNumTags % 1000000 != 0) continue;
                System.out.println("Counted " + this.myNumTags + " tags.");
            }
            br.close();
            System.out.println("Found " + this.myNumTags + " tags in SAM file.  Assuming " + (Object)((Object)this.mySAMFormat) + " file format.");
        }
        catch (Exception e) {
            System.out.println("Catch in counting lines of alignment file at line " + currLine + ": " + e);
            e.printStackTrace();
            System.exit(1);
        }
        this.initMatrices(this.myNumTags);
        return nHeaderLines;
    }

    private void parseSAMAlignment(String inputStr, int tagIndex) {
        byte currStrand;
        String[] inputLine = inputStr.split("\t");
        int name = 0;
        int flag = 1;
        int chr = 2;
        int pos = 3;
        int cigar = 5;
        int tagS = 9;
        String nullS = this.getNullTag();
        byte by = currStrand = (Integer.parseInt(inputLine[flag]) & 0x10) == 16 ? (byte)-1 : 1;
        if ((Integer.parseInt(inputLine[flag]) & 4) == 4) {
            this.recordLackOfSAMAlign(tagIndex, inputLine[tagS], inputLine[name], nullS, currStrand);
        } else {
            HashMap<String, Integer> SAMFields = this.parseOptionalFieldsFromSAMAlignment(inputLine);
            byte bestHits = (byte)Math.min(SAMFields.get("nBestHits"), 127);
            byte editDist = (byte)Math.min(SAMFields.get("editDist"), 127);
            this.recordSAMAlign(tagIndex, inputLine[tagS], inputLine[name], nullS, bestHits, inputLine[chr], currStrand, Integer.parseInt(inputLine[pos]), inputLine[cigar], editDist);
        }
    }

    private HashMap<String, Integer> parseOptionalFieldsFromSAMAlignment(String[] inputLine) {
        HashMap<String, Integer> SAMFields = new HashMap<String, Integer>();
        if (this.mySAMFormat == SAMFormat.BWA) {
            for (int field = 11; field < inputLine.length; ++field) {
                if (inputLine[field].regionMatches(0, "X0", 0, 2)) {
                    SAMFields.put("nBestHits", Integer.parseInt(inputLine[field].split(":")[2]));
                    continue;
                }
                if (!inputLine[field].regionMatches(0, "NM", 0, 2)) continue;
                SAMFields.put("editDist", Integer.parseInt(inputLine[field].split(":")[2]));
            }
        } else {
            for (int field = 11; field < inputLine.length; ++field) {
                if (inputLine[field].regionMatches(0, "AS", 0, 2)) {
                    SAMFields.put("bestScore", Integer.parseInt(inputLine[field].split(":")[2]));
                    continue;
                }
                if (inputLine[field].regionMatches(0, "XS", 0, 2)) {
                    SAMFields.put("nextScore", Integer.parseInt(inputLine[field].split(":")[2]));
                    continue;
                }
                if (!inputLine[field].regionMatches(0, "NM", 0, 2)) continue;
                SAMFields.put("editDist", Integer.parseInt(inputLine[field].split(":")[2]));
            }
            if (SAMFields.containsKey("bestScore")) {
                if (SAMFields.containsKey("nextScore")) {
                    if (SAMFields.get("bestScore") > SAMFields.get("nextScore")) {
                        SAMFields.put("nBestHits", 1);
                    } else {
                        SAMFields.put("nBestHits", 99);
                    }
                } else {
                    SAMFields.put("nBestHits", 1);
                }
            }
        }
        return SAMFields;
    }

    private void recordLackOfSAMAlign(int tagIndex, String tagS, String tagName, String nullS, byte strand) {
        this.recordTagFromSAMAlignment(tagIndex, tagS, tagName, nullS, strand);
        this.multimaps[tagIndex] = 0;
        this.bestChr[tagIndex] = Integer.MIN_VALUE;
        this.bestStrand[tagIndex] = -128;
        this.bestStartPos[tagIndex] = Integer.MIN_VALUE;
        this.endPosition[tagIndex] = Integer.MIN_VALUE;
        this.divergence[tagIndex] = -128;
        this.dcoP[tagIndex] = -128;
        this.mapP[tagIndex] = -128;
    }

    private void recordSAMAlign(int tagIndex, String tagS, String tagName, String nullS, byte nBestHits, String chrS, byte strand, int pos, String cigar, byte editDist) {
        this.recordTagFromSAMAlignment(tagIndex, tagS, tagName, nullS, strand);
        this.multimaps[tagIndex] = nBestHits;
        if (nBestHits == 1) {
            this.bestChr[tagIndex] = this.parseChrString(chrS);
            this.bestStrand[tagIndex] = strand;
            this.recordStartEndPostionFromSAMAlign(tagIndex, strand, pos, cigar);
        } else {
            this.bestChr[tagIndex] = Integer.MIN_VALUE;
            this.bestStrand[tagIndex] = -128;
            this.bestStartPos[tagIndex] = Integer.MIN_VALUE;
            this.endPosition[tagIndex] = Integer.MIN_VALUE;
        }
        this.divergence[tagIndex] = editDist;
        this.dcoP[tagIndex] = -128;
        this.mapP[tagIndex] = -128;
    }

    private void recordTagFromSAMAlignment(int tagIndex, String tagS, String tagName, String nullS, byte strand) {
        if (strand == -1) {
            tagS = BaseEncoder.getReverseComplement(tagS);
        }
        if (tagS.length() < this.tagLengthInLong * 32) {
            tagS = tagS + nullS;
            tagS = tagS.substring(0, this.tagLengthInLong * 32);
        }
        long[] tagSequence = BaseEncoder.getLongArrayFromSeq(tagS);
        for (int chunk = 0; chunk < this.tagLengthInLong; ++chunk) {
            this.tags[chunk][tagIndex] = tagSequence[chunk];
        }
        tagName = tagName.replaceFirst("count=[0-9]+", "");
        tagName = tagName.replaceFirst("length=", "");
        this.tagLength[tagIndex] = Byte.parseByte(tagName);
    }

    private int parseChrString(String chrS) {
        int chr = Integer.MIN_VALUE;
        chrS = chrS.replace("chr", "");
        try {
            chr = Integer.parseInt(chrS);
        }
        catch (NumberFormatException e) {
            System.out.println("\n\nSAMConverterPlugin detected a non-numeric chromosome name: " + chrS + "\n\nPlease change the FASTA headers in your reference genome sequence to integers " + "(>1, >2, >3, etc.) OR to 'chr' followed by an integer (>chr1, >chr2, >chr3, etc.)\n\n");
            System.exit(1);
        }
        return chr;
    }

    private void recordStartEndPostionFromSAMAlign(int tagIndex, byte strand, int pos, String cigar) {
        block4: {
            int[] alignSpan = SAMUtils.adjustCoordinates(cigar, pos);
            try {
                if (strand == 1) {
                    this.bestStartPos[tagIndex] = alignSpan[0];
                    this.endPosition[tagIndex] = alignSpan[1];
                    break block4;
                }
                if (strand == -1) {
                    this.bestStartPos[tagIndex] = alignSpan[1];
                    this.endPosition[tagIndex] = alignSpan[0];
                    break block4;
                }
                throw new Exception("Unexpected value for strand: " + strand + "(expect 1 or -1)");
            }
            catch (Exception e) {
                System.out.println("Error in recordStartEndPostionFromSAMAlign: " + e);
                e.printStackTrace();
                System.exit(1);
            }
        }
    }

    @Override
    public void swap(int index1, int index2) {
        for (int i = 0; i < this.tagLengthInLong; ++i) {
            long tl = this.tags[i][index1];
            this.tags[i][index1] = this.tags[i][index2];
            this.tags[i][index2] = tl;
        }
        int tb = this.tagLength[index1];
        this.tagLength[index1] = this.tagLength[index2];
        this.tagLength[index2] = (byte)tb;
        tb = this.multimaps[index1];
        this.multimaps[index1] = this.multimaps[index2];
        this.multimaps[index2] = (byte)tb;
        tb = this.bestChr[index1];
        this.bestChr[index1] = this.bestChr[index2];
        this.bestChr[index2] = tb;
        tb = this.bestStrand[index1];
        this.bestStrand[index1] = this.bestStrand[index2];
        this.bestStrand[index2] = (byte)tb;
        int ti = this.bestStartPos[index1];
        this.bestStartPos[index1] = this.bestStartPos[index2];
        this.bestStartPos[index2] = ti;
        ti = this.endPosition[index1];
        this.endPosition[index1] = this.endPosition[index2];
        this.endPosition[index2] = ti;
        tb = this.divergence[index1];
        this.divergence[index1] = this.divergence[index2];
        this.divergence[index2] = (byte)tb;
        byte[] tba = this.variantOffsets[index1];
        this.variantOffsets[index1] = this.variantOffsets[index2];
        this.variantOffsets[index2] = tba;
        tba = this.variantDefs[index1];
        this.variantDefs[index1] = this.variantDefs[index2];
        this.variantDefs[index2] = tba;
        tb = this.dcoP[index1];
        this.dcoP[index1] = this.dcoP[index2];
        this.dcoP[index2] = (byte)tb;
        tb = this.mapP[index1];
        this.mapP[index1] = this.mapP[index2];
        this.mapP[index2] = (byte)tb;
    }

    @Override
    public int compare(int index1, int index2) {
        for (int i = 0; i < this.tagLengthInLong; ++i) {
            if (this.tags[i][index1] < this.tags[i][index2]) {
                return -1;
            }
            if (this.tags[i][index1] <= this.tags[i][index2]) continue;
            return 1;
        }
        if (this.bestChr[index1] < this.bestChr[index2]) {
            return -1;
        }
        if (this.bestChr[index1] > this.bestChr[index2]) {
            return 1;
        }
        if (this.bestStartPos[index1] < this.bestStartPos[index2]) {
            return -1;
        }
        if (this.bestStartPos[index1] > this.bestStartPos[index2]) {
            return 1;
        }
        if (this.bestStrand[index1] < this.bestStrand[index2]) {
            return -1;
        }
        if (this.bestStrand[index1] > this.bestStrand[index2]) {
            return 1;
        }
        return 0;
    }

    @Override
    public void setVariantDef(int tagIndex, int variantIndex, byte def) {
        if (this.variantDefs[tagIndex] == null || this.variantDefs[tagIndex].length <= variantIndex) {
            if (variantIndex == 0) {
                this.variantDefs[tagIndex] = new byte[]{def};
            } else {
                byte[] newVariantDefs = new byte[variantIndex + 1];
                for (int v = 0; v < newVariantDefs.length; ++v) {
                    newVariantDefs[v] = this.variantDefs[tagIndex] != null && v < this.variantDefs[tagIndex].length ? this.variantDefs[tagIndex][v] : (v < variantIndex ? -128 : def);
                }
                this.variantDefs[tagIndex] = Arrays.copyOf(newVariantDefs, newVariantDefs.length);
            }
        } else {
            this.variantDefs[tagIndex][variantIndex] = def;
        }
    }

    @Override
    public void setVariantPosOff(int tagIndex, int variantIndex, byte offset) {
        if (this.variantOffsets[tagIndex] == null || this.variantOffsets[tagIndex].length <= variantIndex) {
            if (variantIndex == 0) {
                this.variantOffsets[tagIndex] = new byte[]{offset};
            } else {
                byte[] newVariantOffs = new byte[variantIndex + 1];
                for (int v = 0; v < newVariantOffs.length; ++v) {
                    newVariantOffs[v] = this.variantOffsets[tagIndex] != null && v < this.variantOffsets[tagIndex].length ? this.variantOffsets[tagIndex][v] : (v < variantIndex ? -128 : offset);
                }
                this.variantOffsets[tagIndex] = Arrays.copyOf(newVariantOffs, newVariantOffs.length);
            }
        } else {
            this.variantOffsets[tagIndex][variantIndex] = offset;
        }
    }

    @Override
    public int getMaxNumVariants() {
        return this.myMaxVariants;
    }

    private static TagsOnPhysicalMap uniqueTags(String[] filenames) {
        int tagLengthInLong = 0;
        int maxVariants = 0;
        int tagNum = 0;
        for (String name : filenames) {
            TagsOnPhysicalMap file = new TagsOnPhysicalMap(name, true);
            tagNum += file.myNumTags;
            if (file.myMaxVariants > maxVariants) {
                maxVariants = file.myMaxVariants;
            }
            if (file.getTagSizeInLong() <= tagLengthInLong) continue;
            tagLengthInLong = file.getTagSizeInLong();
        }
        TagCountMutable tc = new TagCountMutable(tagLengthInLong, tagNum);
        for (String name : filenames) {
            TagsOnPhysicalMap file = new TagsOnPhysicalMap(name, true);
            for (int i = 0; i < file.myNumTags; ++i) {
                tc.addReadCount(file.getTag(i), file.getTagLength(i), 1);
            }
        }
        tc.collapseCounts();
        tc.shrinkToCurrentRows();
        TagsOnPhysicalMap result = new TagsOnPhysicalMap(tc);
        result.expandMaxVariants(maxVariants);
        result.clearVariants();
        return result;
    }

    public static TagsOnPhysicalMap merge(String[] filenames) {
        TagsOnPhysicalMap output = TagsOnPhysicalMap.uniqueTags(filenames);
        System.out.println("Output file will contain " + output.myNumTags + " unique tags, " + output.getTagSizeInLong() + " longs/tag, " + output.myMaxVariants + " variants. ");
        for (String name : filenames) {
            TagsOnPhysicalMap file = new TagsOnPhysicalMap(name, true);
            int varsAdded = 0;
            int varsSkipped = 0;
            for (int inTag = 0; inTag < file.myNumTags; ++inTag) {
                int outTag = output.getTagIndex(file.getTag(inTag));
                TagsOnPhysicalMap.copyTagAttributes(file, inTag, output, outTag);
                block2: for (int outVar = 0; outVar < output.myMaxVariants; ++outVar) {
                    byte outOff = output.getVariantPosOff(outTag, outVar);
                    if (outOff != -128) {
                        ++varsSkipped;
                        continue;
                    }
                    for (int inVar = 0; inVar < file.myMaxVariants; ++inVar) {
                        byte offset = file.getVariantPosOff(inTag, outVar);
                        byte def = file.getVariantDef(inTag, outVar);
                        if (offset == -128) continue;
                        ++varsAdded;
                        output.setVariantPosOff(outTag, outVar, offset);
                        output.setVariantDef(outTag, outVar, def);
                        file.setVariantPosOff(inTag, inVar, (byte)-128);
                        continue block2;
                    }
                }
            }
            System.out.println(varsAdded + " variants added.");
            System.out.println(varsSkipped + " variants skipped.");
        }
        return output;
    }

    private static void copyTagAttributes(TagsOnPhysicalMap input, int inTag, TagsOnPhysicalMap output, int outTag) {
        output.tagLength[outTag] = input.tagLength[inTag];
        output.multimaps[outTag] = input.multimaps[inTag];
        output.bestChr[outTag] = input.bestChr[inTag];
        output.bestStrand[outTag] = input.bestStrand[inTag];
        output.bestStartPos[outTag] = input.bestStartPos[inTag];
        output.endPosition[outTag] = input.endPosition[inTag];
        output.divergence[outTag] = input.divergence[inTag];
        output.dcoP[outTag] = input.dcoP[inTag];
        output.mapP[outTag] = input.mapP[inTag];
    }

    @Override
    public void clearVariants() {
        for (int i = 0; i < this.getTagCount(); ++i) {
            this.variantDefs[i] = null;
            this.variantOffsets[i] = null;
        }
    }

    private void clearVariant(int tag, int variant) {
        byte[] newDefs = new byte[this.variantDefs[tag].length - 1];
        byte[] newOffs = new byte[this.variantOffsets[tag].length - 1];
        int var = 0;
        for (int v = 0; v < this.variantDefs[tag].length; ++v) {
            if (v == variant) continue;
            newDefs[var++] = this.variantDefs[tag][v];
            newOffs[var++] = this.variantOffsets[tag][v];
        }
        this.variantDefs[tag] = Arrays.copyOf(newDefs, newDefs.length);
        this.variantOffsets[tag] = Arrays.copyOf(newOffs, newOffs.length);
    }

    public void filter(String[] filenames) {
        HashMap<String, Integer> hapmapSites = new HashMap<String, Integer>();
        for (String filename : filenames) {
            System.out.println("Filtering out sites from " + filename + ".");
            hapmapSites.putAll(TagsOnPhysicalMap.hapmapSites(ImportUtils.readFromHapmap(filename, null)));
        }
        System.out.println("There are " + hapmapSites.size() + " sites in the hapmap files.");
        HashMap<String, Integer> topmSites = this.uniqueSites();
        System.out.println("Found " + topmSites.size() + " unique sites in " + this.myNumTags + " tags in TOPM.");
        if (topmSites.size() < hapmapSites.size()) {
            System.out.println("Warning: more unique sites exist in hapmap file.");
        }
        HashSet<Integer> fullSites = this.fullTagPositions();
        ArrayList<String> insertedSites = new ArrayList<String>();
        ArrayList<String> skippedSites = new ArrayList<String>();
        int basePerTag = this.tagLengthInLong * 32;
        for (String hapmapSNP : hapmapSites.keySet().toArray(new String[hapmapSites.size()])) {
            int chr = Integer.parseInt(hapmapSNP.split("\\t")[0]);
            int pos = Integer.parseInt(hapmapSNP.split("\\t")[1]);
            if (topmSites.get(hapmapSNP) != null) continue;
            boolean inRange = false;
            for (int i = -basePerTag; i < basePerTag; ++i) {
                if (!fullSites.contains(i + pos)) continue;
                inRange = true;
                break;
            }
            if (inRange) {
                skippedSites.add(hapmapSNP);
            } else {
                insertedSites.add(hapmapSNP);
                System.out.println();
            }
            hapmapSites.remove(hapmapSNP);
        }
        System.out.println("The following SNPs were not in the TOPM, but are within range of a tag with the max. number of variants:");
        for (String site : skippedSites) {
            System.out.println(site);
        }
        System.out.println("The following SNPs were not in the TOPM, and do not correspond to any known tag:");
        for (String site : insertedSites) {
            System.out.println(site);
        }
        int removedSites = 0;
        for (int tag = 0; tag < this.myNumTags; ++tag) {
            int chr = this.getChromosome(tag);
            int pos = this.getStartPosition(tag);
            for (int variant = 0; variant < this.myMaxVariants; ++variant) {
                byte off = this.getVariantPosOff(tag, variant);
                String site = chr + "\t" + (pos + off);
                if (hapmapSites.containsKey(site)) continue;
                this.clearVariant(tag, variant);
                ++removedSites;
            }
        }
        topmSites = this.uniqueSites();
        System.out.println("Removed " + removedSites + " TOPM sites not present in alignment and ignored " + insertedSites.size() + " alignment sites not present in TOPM.");
        System.out.println("There are " + topmSites.size() + " sites in the TOPM now, as compared to " + hapmapSites.size() + " sites in the alignment.");
        if (topmSites.size() != hapmapSites.size()) {
            System.out.println("Warning: number of filtered sites does not match number of alignment sites.");
        }
    }

    public HashSet<Integer> fullTagPositions() {
        HashSet<Integer> result = new HashSet<Integer>();
        for (int i = 0; i < this.myNumTags; ++i) {
            boolean variantsFull = true;
            for (int j = 0; j < this.myMaxVariants; ++j) {
                byte off = this.getVariantPosOff(i, j);
                if (off != -128) continue;
                variantsFull = false;
                break;
            }
            if (!variantsFull) continue;
            result.add(this.getStartPosition(i));
        }
        return result;
    }

    public HashMap<String, Integer> uniqueSites() {
        HashMap<String, Integer> snps = new HashMap<String, Integer>();
        for (int tag = 0; tag < this.myNumTags; ++tag) {
            for (int variant = 0; variant < this.myMaxVariants; ++variant) {
                byte off = this.getVariantPosOff(tag, variant);
                if (off == -128) continue;
                int a = this.getStartPosition(tag);
                byte b = this.getVariantPosOff(tag, variant);
                int c = a + b;
                String pos = this.getChromosome(tag) + "\t" + c;
                snps.put(pos, tag);
            }
        }
        return snps;
    }

    public static HashMap<String, Integer> hapmapSites(GenotypeTable file) {
        HashMap<String, Integer> snps = new HashMap<String, Integer>();
        for (int site = 0; site < file.numberOfSites(); ++site) {
            String pos = file.chromosomeName(site) + "\t" + file.chromosomalPosition(site);
            if (file.chromosomalPosition(site) > 2000000000) {
                System.out.println(pos);
            }
            snps.put(pos, site);
        }
        return snps;
    }

    public int[] mappingDistribution() {
        int[] result = new int[128];
        for (int i = 0; i < this.myNumTags; ++i) {
            if (this.multimaps[i] > result.length - 1) {
                result[127] = result[127] + 1;
            }
            if (this.multimaps[i] == -128) {
                result[0] = result[0] + 1;
                continue;
            }
            byte by = this.multimaps[i];
            result[by] = result[by] + 1;
        }
        return result;
    }

    public static enum SAMFormat {
        BWA,
        BOWTIE2;

    }
}

