/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.read;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.zip.GZIPOutputStream;
import net.maizegenetics.dna.read.Read;
import net.maizegenetics.dna.read.ReadUtils;
import net.maizegenetics.util.MultiMemberGZIPInputStream;

public class FastqChunk {
    private int minStartIndex = 100000;
    private int maxReadNum = 100000;
    Read[] reads = null;

    public FastqChunk(String fastqFileS, ReadUtils.ReadFormat format, int startIndex, int readNum) {
        if (startIndex < this.minStartIndex) {
            startIndex = this.minStartIndex;
            System.out.println("Start index of read was set to " + String.valueOf(startIndex));
        }
        if (readNum > this.maxReadNum) {
            readNum = this.maxReadNum;
            System.out.println("Number of read was set to " + String.valueOf(readNum));
        }
        this.readFastq(fastqFileS, format, startIndex, readNum);
    }

    public FastqChunk(String fastqFileS, ReadUtils.ReadFormat format) {
        this.readFastq(fastqFileS, format);
    }

    public FastqChunk(Read[] reads) {
        this.reads = reads;
    }

    private void readFastq(String fastqFileS, ReadUtils.ReadFormat format) {
        System.out.println("Reading fastq file from " + fastqFileS);
        BufferedReader br = null;
        int cnt = 0;
        try {
            if (format == ReadUtils.ReadFormat.FastqText) {
                String temp;
                br = new BufferedReader(new FileReader(fastqFileS), 65536);
                while ((temp = br.readLine()) != null) {
                    ++cnt;
                }
                br = new BufferedReader(new FileReader(fastqFileS), 65536);
            } else if (format == ReadUtils.ReadFormat.FastqGzip) {
                String temp;
                br = new BufferedReader(new InputStreamReader(new MultiMemberGZIPInputStream(new FileInputStream(fastqFileS))));
                while ((temp = br.readLine()) != null) {
                    ++cnt;
                }
                br = new BufferedReader(new InputStreamReader(new MultiMemberGZIPInputStream(new FileInputStream(fastqFileS))));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.readFastq(br, 0, cnt / 4);
    }

    private void readFastq(String fastqFileS, ReadUtils.ReadFormat format, int startIndex, int readNum) {
        if (readNum <= 0) {
            return;
        }
        BufferedReader br = null;
        try {
            if (format == ReadUtils.ReadFormat.FastqText) {
                br = new BufferedReader(new FileReader(fastqFileS), 65536);
            } else if (format == ReadUtils.ReadFormat.FastqGzip) {
                br = new BufferedReader(new InputStreamReader(new MultiMemberGZIPInputStream(new FileInputStream(fastqFileS))));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("Reading fastq file from " + fastqFileS);
        this.readFastq(br, startIndex, readNum);
    }

    private void readFastq(BufferedReader br, int startIndex, int readNum) {
        this.reads = new Read[readNum];
        try {
            String temp;
            Read r = null;
            int index = 0;
            int readCount = 0;
            while ((temp = br.readLine()) != null) {
                if (index >= startIndex) {
                    this.reads[readCount] = r = new Read(temp, br.readLine(), br.readLine(), br.readLine());
                    if (++readCount == readNum) break;
                }
                ++index;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println(String.valueOf(readNum) + " reads imported");
    }

    public void writeFastq(String outputFileS, ReadUtils.ReadFormat format) {
        BufferedWriter bw = null;
        try {
            if (format == ReadUtils.ReadFormat.FastqText) {
                bw = new BufferedWriter(new FileWriter(outputFileS), 65536);
            } else if (format == ReadUtils.ReadFormat.FastqGzip) {
                bw = new BufferedWriter(new OutputStreamWriter(new GZIPOutputStream((OutputStream)new FileOutputStream(outputFileS), 65536)), 65536);
            }
            for (int i = 0; i < this.getReadNum(); ++i) {
                bw.write(this.reads[i].getID());
                bw.newLine();
                bw.write(this.reads[i].getSeq());
                bw.newLine();
                bw.write(this.reads[i].getDescription());
                bw.newLine();
                bw.write(this.reads[i].getQual());
                bw.newLine();
            }
            bw.flush();
            bw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("Fastq file written to " + outputFileS);
    }

    public Read getRead(int index) {
        return this.reads[index];
    }

    public int getReadNum() {
        if (this.reads == null) {
            return 0;
        }
        return this.reads.length;
    }
}

