/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.read;

import java.util.ArrayList;
import net.maizegenetics.dna.read.FastqChunk;
import net.maizegenetics.dna.read.PERead;
import net.maizegenetics.dna.read.Read;
import net.maizegenetics.dna.read.ReadUtils;

public class PEFastqChunk {
    PERead[] peReads = null;

    public PEFastqChunk(String fastqR1FileS, String fastqR2FileS, ReadUtils.ReadFormat format, int startIndex, int readNum) {
        FastqChunk r1c = new FastqChunk(fastqR1FileS, format, startIndex, readNum);
        FastqChunk r2c = new FastqChunk(fastqR2FileS, format, startIndex, readNum);
        this.convert(r1c, r2c);
    }

    public PEFastqChunk(String fastqR1FileS, String fastqR2FileS, ReadUtils.ReadFormat format) {
        FastqChunk r1c = new FastqChunk(fastqR1FileS, format);
        FastqChunk r2c = new FastqChunk(fastqR2FileS, format);
        this.convert(r1c, r2c);
    }

    private void convert(FastqChunk r1c, FastqChunk r2c) {
        if (r1c.getReadNum() == 0) {
            return;
        }
        this.peReads = new PERead[r1c.getReadNum()];
        for (int i = 0; i < r1c.getReadNum(); ++i) {
            this.peReads[i] = new PERead(r1c.getRead(i), r2c.getRead(i));
        }
        System.out.println("PEFastqChunk built");
    }

    public PERead getPERead(int index) {
        return this.peReads[index];
    }

    public int getPEReadNum() {
        if (this.peReads == null) {
            return 0;
        }
        return this.peReads.length;
    }

    public void merge(boolean ifPrintAlignment) {
        System.out.println("Merging PE reads");
        int cnt = 0;
        for (int i = 0; i < this.getPEReadNum(); ++i) {
            if (!this.peReads[i].merge(ifPrintAlignment)) continue;
            ++cnt;
        }
        System.out.println(String.valueOf(cnt) + " out of " + String.valueOf(this.getPEReadNum()) + " (" + String.valueOf((double)cnt / (double)this.getPEReadNum()) + ") PE reads are merged");
    }

    public void writePEFastq(String fastqR1FileS, String fastqR2FileS, ReadUtils.ReadFormat format) {
        Read[] readsR1 = new Read[this.getPEReadNum()];
        Read[] readsR2 = new Read[this.getPEReadNum()];
        for (int i = 0; i < this.getPEReadNum(); ++i) {
            readsR1[i] = this.getPERead(i).getForwardRead();
            readsR2[i] = this.getPERead(i).getBackwardRead();
        }
        new FastqChunk(readsR1).writeFastq(fastqR1FileS, format);
        new FastqChunk(readsR2).writeFastq(fastqR2FileS, format);
    }

    public void writeMergedPEFastq(String fastqR1FileS, String fastqR2FileS, String fastqContigFileS, ReadUtils.ReadFormat format) {
        ArrayList<Read> r1List = new ArrayList<Read>();
        ArrayList<Read> r2List = new ArrayList<Read>();
        ArrayList<Read> contigList = new ArrayList<Read>();
        for (int i = 0; i < this.getPEReadNum(); ++i) {
            if (this.getPERead(i).getPContig() == null) {
                r1List.add(this.getPERead(i).getForwardRead());
                r2List.add(this.getPERead(i).getBackwardRead());
                continue;
            }
            contigList.add(this.getPERead(i).getPContig());
        }
        new FastqChunk(r1List.toArray(new Read[r1List.size()])).writeFastq(fastqR1FileS, format);
        new FastqChunk(r2List.toArray(new Read[r2List.size()])).writeFastq(fastqR2FileS, format);
        new FastqChunk(contigList.toArray(new Read[contigList.size()])).writeFastq(fastqContigFileS, format);
    }
}

