/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.read;

import java.util.Arrays;
import net.maizegenetics.dna.read.ReadUtils;

public class Read {
    String ID;
    String seq;
    String des;
    String qual;
    byte[] qualValue = null;
    byte[] sortedQualValue = null;

    public Read(String ID, String seq, String des, String qual) {
        this.ID = ID;
        this.seq = seq;
        this.des = des;
        this.qual = qual;
    }

    public byte returnAverageQuality() {
        double aver = 0.0;
        if (this.qualValue == null) {
            this.buildQualByteArray();
        }
        for (int i = 0; i < this.qualValue.length; ++i) {
            aver += (double)this.qualValue[i];
        }
        return (byte)(aver / (double)this.getReadLength());
    }

    public byte getMedianQuality() {
        if (this.qualValue == null) {
            this.buildQualByteArray();
        }
        if (this.sortedQualValue == null) {
            System.arraycopy(this.qualValue, 0, this.sortedQualValue, 0, this.seq.length());
            Arrays.sort(this.sortedQualValue);
        }
        return this.sortedQualValue[this.sortedQualValue.length / 2];
    }

    public int getReadLength() {
        return this.seq.length();
    }

    public byte getBaseQuality(int index) {
        if (this.qualValue == null) {
            this.buildQualByteArray();
        }
        return this.qualValue[index];
    }

    private void buildQualByteArray() {
        this.qualValue = this.qual.getBytes();
    }

    public String getDescription() {
        return this.des;
    }

    public String getID() {
        return this.ID;
    }

    public String getSeq() {
        return this.seq;
    }

    public String getReverseQual() {
        return new StringBuilder(this.qual).reverse().toString();
    }

    public String getQual() {
        return this.qual;
    }

    public String getQual(int startIndex, int endIndex) {
        return this.qual.substring(startIndex, endIndex);
    }

    public String getSeq(int startIndex, int endIndex) {
        return this.seq.substring(startIndex, endIndex);
    }

    public String getReverseComplementarySeq() {
        return this.getReverseComplementarySeq(0, this.seq.length());
    }

    public String getReverseComplementarySeq(int startIndex, int endIndex) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < endIndex - startIndex; ++i) {
            sb.append(ReadUtils.baseCompleMap.get(String.valueOf(this.seq.charAt(i + startIndex))));
        }
        return sb.reverse().toString();
    }
}

