/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp;

import java.util.List;
import net.maizegenetics.dna.snp.FilterGenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTableUtils;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListBuilder;
import net.maizegenetics.taxa.Taxon;

public class FilterGenotypeTableBuilder {
    private final GenotypeTable myBaseGenotypeTable;
    private double myMinFreqForSite = 0.0;
    private double myMaxFreqForSite = 1.0;
    private int myMinCountForSite = 0;
    private int[] mySitesToKeep = null;
    private List<String> mySiteNamesToKeep = null;
    private List<String> mySiteNamesToRemove = null;
    private TaxaList myTaxaToKeep = null;
    private TaxaList myTaxaToRemove = null;
    private double myMinHeterozygousForTaxon = 0.0;
    private double myMaxHeterozygousForTaxon = 1.0;
    private int myMinNotMissingForTaxon = 0;

    private FilterGenotypeTableBuilder(GenotypeTable baseGenotypeTable) {
        this.myBaseGenotypeTable = baseGenotypeTable;
    }

    public static FilterGenotypeTableBuilder getInstance(GenotypeTable baseGenotypeTable) {
        return new FilterGenotypeTableBuilder(baseGenotypeTable);
    }

    public FilterGenotypeTableBuilder minorAlleleFreqForSite(double minFreq, double maxFreq) {
        if (minFreq < 0.0 || minFreq > 1.0) {
            throw new IllegalArgumentException("FilterGenotypeTableBuilder: minorAlleleFreqForSite: Min Value must be between 0.0 and 1.0: " + minFreq);
        }
        if (maxFreq < 0.0 || maxFreq > 1.0) {
            throw new IllegalArgumentException("FilterGenotypeTableBuilder: minorAlleleFreqForSite: Max Value must be between 0.0 and 1.0: " + maxFreq);
        }
        this.myMinFreqForSite = minFreq;
        this.myMaxFreqForSite = maxFreq;
        return this;
    }

    public FilterGenotypeTableBuilder minCountForSite(int count) {
        this.myMinCountForSite = count;
        return this;
    }

    public void sitesToKeep(int[] sitesToKeep) {
        this.mySitesToKeep = sitesToKeep;
    }

    public void siteNamesToKeep(List<String> sitesToKeep) {
        this.mySiteNamesToKeep = sitesToKeep;
    }

    public void siteNamesToRemove(List<String> sitesToRemove) {
        this.mySiteNamesToRemove = sitesToRemove;
    }

    public FilterGenotypeTableBuilder taxaToKeep(TaxaList taxaToKeep) {
        this.myTaxaToKeep = taxaToKeep;
        return this;
    }

    public FilterGenotypeTableBuilder taxaToRemove(TaxaList taxaToRemove) {
        this.myTaxaToRemove = taxaToRemove;
        return this;
    }

    public FilterGenotypeTableBuilder minNotMissingForTaxon(int minNotMissing) {
        if ((double)minNotMissing < 0.0 || (double)minNotMissing > 1.0) {
            throw new IllegalArgumentException("FilterGenotypeTableBuilder: setMinNotMissingForTaxon: Value must be between 0.0 and 1.0: " + minNotMissing);
        }
        this.myMinNotMissingForTaxon = minNotMissing;
        return this;
    }

    public FilterGenotypeTableBuilder minHeterozygousForTaxon(double minHeterozygous) {
        if (minHeterozygous < 0.0 || minHeterozygous > 1.0) {
            throw new IllegalArgumentException("FilterGenotypeTableBuilder: setMinHeterozygousForTaxon: Value must be between 0.0 and 1.0: " + minHeterozygous);
        }
        this.myMinHeterozygousForTaxon = minHeterozygous;
        return this;
    }

    public FilterGenotypeTableBuilder maxHeterozygousForTaxon(double maxHeterozygous) {
        if (maxHeterozygous < 0.0 || maxHeterozygous > 1.0) {
            throw new IllegalArgumentException("FilterGenotypeTableBuilder: setMaxHeterozygousForTaxon: Value must be between 0.0 and 1.0: " + maxHeterozygous);
        }
        this.myMaxHeterozygousForTaxon = maxHeterozygous;
        return this;
    }

    private GenotypeTable getFilteredAlignment(GenotypeTable genotypeTable) {
        int numSites = genotypeTable.numberOfSites();
        int numTaxa = genotypeTable.numberOfTaxa();
        TaxaList ids = genotypeTable.taxa();
        TaxaListBuilder keepTaxaList = new TaxaListBuilder();
        for (int t = 0; t < numTaxa; ++t) {
            int totalSitesNotMissing;
            int numHeterozygous;
            double percentHets;
            int totalNotMissing;
            double percentNotMissing;
            if ((double)this.myMinNotMissingForTaxon != 0.0 && (percentNotMissing = (double)(totalNotMissing = genotypeTable.totalNonMissingForTaxon(t)) / (double)numSites) < (double)this.myMinNotMissingForTaxon || (this.myMinHeterozygousForTaxon != 0.0 || this.myMaxHeterozygousForTaxon != 1.0) && ((percentHets = (double)(numHeterozygous = genotypeTable.heterozygousCountForTaxon(t)) / (double)(totalSitesNotMissing = genotypeTable.totalNonMissingForTaxon(t))) < this.myMinHeterozygousForTaxon || percentHets > this.myMaxHeterozygousForTaxon)) continue;
            keepTaxaList.add((Taxon)ids.get(t));
        }
        return FilterGenotypeTable.getInstance(genotypeTable, keepTaxaList.build(), false);
    }

    public GenotypeTable build() {
        GenotypeTable result = this.myBaseGenotypeTable;
        if (this.myTaxaToKeep != null && this.myTaxaToRemove != null) {
            throw new IllegalStateException("FilterGenotypeTableBuilder: build: Taxa list to keep and list to remove defined.");
        }
        if (this.myTaxaToKeep != null) {
            result = FilterGenotypeTable.getInstance(result, this.myTaxaToKeep, false);
        } else if (this.myTaxaToRemove != null) {
            result = FilterGenotypeTable.getInstanceRemoveIDs(result, this.myTaxaToRemove);
        }
        if (this.myMinHeterozygousForTaxon != 0.0 || this.myMaxHeterozygousForTaxon != 1.0 || this.myMinNotMissingForTaxon != 0) {
            result = this.getFilteredAlignment(result);
        }
        int count = 0;
        if (this.mySitesToKeep != null && this.mySitesToKeep.length != 0) {
            ++count;
        }
        if (this.mySiteNamesToKeep != null && !this.mySiteNamesToKeep.isEmpty()) {
            ++count;
        }
        if (this.mySiteNamesToRemove != null && !this.mySiteNamesToRemove.isEmpty()) {
            ++count;
        }
        if (count > 1) {
            throw new IllegalStateException("FilterGenotypeTableBuilder: build: Can only set one of the following: sites to keep, site names to keep, or site names to remove.");
        }
        if (this.mySitesToKeep != null && this.mySitesToKeep.length != 0) {
            result = FilterGenotypeTable.getInstance(result, this.mySitesToKeep);
        } else if (this.mySiteNamesToKeep != null && !this.mySiteNamesToKeep.isEmpty()) {
            result = FilterGenotypeTable.getInstance(result, this.mySiteNamesToKeep);
        } else if (this.mySiteNamesToRemove != null && !this.mySiteNamesToRemove.isEmpty()) {
            result = FilterGenotypeTable.getInstanceRemoveSiteNames(result, this.mySiteNamesToRemove);
        }
        if (this.myMinFreqForSite != 0.0 || this.myMaxFreqForSite != 1.0 || this.myMinCountForSite != 0) {
            int[] sitesToInclude = GenotypeTableUtils.getIncludedSitesBasedOnFreqIgnoreMissing(result, this.myMinFreqForSite, this.myMaxFreqForSite, this.myMinCountForSite);
            result = FilterGenotypeTable.getInstance(result, sitesToInclude);
        }
        return result;
    }
}

